/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwta.BaseLocation;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.AttackRegroupSolution;
import com.tyr.tasks.SolutionItem;
import com.tyr.tasks.Task;
import java.util.ArrayList;

public class SalesmenMarinesSolution
extends SolutionItem {
    private AttackRegroupSolution attackSolution;
    private int currentPos;
    private int currentDir = 1;
    private Position target;
    private ArrayList<Position> orderedExpands;

    public SalesmenMarinesSolution(Task task, int direction) {
        super(task);
        this.currentDir = direction;
        this.determineTarget();
        this.attackSolution = new AttackRegroupSolution(task, this.target);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.determineTarget()) {
            this.attackSolution.setTarget(this.target);
        }
        this.attackSolution.onFrame(game, self, bot);
    }

    @Override
    public void add(Agent agent) {
        this.attackSolution.add(agent);
    }

    private boolean determineTarget() {
        boolean result = false;
        this.initializeOrderedExpands();
        if (this.orderedExpands == null) {
            return false;
        }
        if (this.target != null) {
            Tyr.drawCircle(this.target, Color.Red);
        }
        if (this.target == null) {
            this.currentPos = EnemyManager.getManager().getSelfPos();
            if (this.currentPos != -1) {
                this.target = this.orderedExpands.get(this.currentPos);
                result = true;
            }
        } else {
            for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                if (p.pos.getX() != this.target.getX() || p.pos.getY() != this.target.getY()) continue;
                return false;
            }
        }
        if (this.currentPos >= 0) {
            for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                if (p.distanceSq(this.orderedExpands.get(this.currentPos)) > 250000) continue;
                this.target = p.pos;
                return true;
            }
        }
        int i = 0;
        while (i < 2 * this.orderedExpands.size()) {
            boolean isIsland = false;
            for (BaseLocation loc : Tyr.bot.expands) {
                if (!loc.isIsland() || !(loc.getDistance(this.target) <= 128.0)) continue;
                isIsland = true;
            }
            if (!isIsland && this.target != null && (!Tyr.game.isVisible(Tyr.positionToTile(this.target)) || i > 0)) break;
            this.nextTarget();
            result = true;
            ++i;
        }
        return result;
    }

    private void nextTarget() {
        this.initializeOrderedExpands();
        if (this.orderedExpands == null) {
            return;
        }
        this.currentPos = (this.currentPos + this.currentDir + this.orderedExpands.size()) % this.orderedExpands.size();
        this.target = this.orderedExpands.get(this.currentPos);
    }

    private void initializeOrderedExpands() {
        if (this.orderedExpands == null) {
            this.orderedExpands = EnemyManager.getManager().getOrderedExpands();
            if (this.orderedExpands == null) {
                return;
            }
            this.orderedExpands = (ArrayList)this.orderedExpands.clone();
            if (Tyr.bot.suspectedEnemy.size() == 1) {
                this.orderedExpands.add(Tyr.bot.suspectedEnemy.get(0).getPosition());
            }
        }
    }

    @Override
    public boolean done() {
        return this.attackSolution.done();
    }

    @Override
    public int size() {
        return this.attackSolution.size();
    }

    @Override
    public void clear() {
    }
}

