/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.WeaponType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.tasks.RunbyTask;
import com.tyr.tasks.SolutionItem;
import com.tyr.tasks.Task;
import java.util.ArrayList;
import java.util.List;

public class RunbySolution
extends SolutionItem {
    private List<Agent> agents;
    private int state = 0;
    private static final int RUNBY = 0;
    private static final int HARASS = 1;
    private static int smallRange = 300;
    private static int largeRange = 500;

    public RunbySolution(Task task, List<Agent> agents) {
        super(task);
        this.agents = agents;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("RunbySolution onFrame.");
        int i = this.agents.size() - 1;
        while (i >= 0) {
            if (this.agents.get(i) == null || this.agents.get(i).isDead()) {
                this.agents.remove(i);
            }
            --i;
        }
        if (this.agents.size() == 0) {
            return;
        }
        if (RunbyTask.completed) {
            for (Agent agent : this.agents) {
                bot.hobos.add(agent);
            }
            this.agents = new ArrayList<Agent>();
            return;
        }
        Position attackTarget = bot.suspectedEnemy.get(0).getPosition();
        Tyr.drawCircle(attackTarget, Color.Red, 64);
        for (Agent agent : this.agents) {
            agent.drawCircle(Color.Orange);
        }
        if (this.state == 0) {
            DebugMessages.addMessage("Performing Runby.");
            for (Agent agent : this.agents) {
                agent.unit.move(attackTarget);
            }
            for (Agent agent : this.agents) {
                if (agent.distanceSquared(attackTarget) > smallRange * smallRange) continue;
                this.state = 1;
                break;
            }
        } else if (this.state == 1) {
            boolean targetExists = false;
            DebugMessages.addMessage("Performing Harass.");
            for (Agent agent : this.agents) {
                if (agent.distanceSquared(attackTarget) >= largeRange * largeRange) {
                    agent.order(new None(agent));
                    agent.unit.move(attackTarget);
                    continue;
                }
                Unit killTarget = null;
                double distance = Double.MAX_VALUE;
                int priority = 0;
                for (Unit enemy : EnemyManager.getEnemyUnits()) {
                    double newDistance;
                    if (!agent.unit.canAttack(enemy) || (enemy.getType().isFlyer() || enemy.isLifted()) && (agent.unit.getType().airWeapon() == WeaponType.None || agent.unit.getType().airWeapon() == null) || enemy.getDistance(attackTarget) >= largeRange - 64) continue;
                    int newPriority = 0;
                    newPriority = enemy.getType().isBuilding() ? (enemy.getType().groundWeapon() != null && enemy.getType().groundWeapon() != WeaponType.None ? 2 : 1) : (enemy.getType().isWorker() ? 3 : (enemy.getType().groundWeapon() != null && enemy.getType().groundWeapon() != WeaponType.None ? 4 : 0));
                    if (newPriority < priority || newPriority == 0 || (newDistance = (double)agent.distanceSquared(enemy)) >= (double)(smallRange * smallRange) || newPriority == priority && newDistance >= distance) continue;
                    killTarget = enemy;
                    distance = newDistance;
                    priority = newPriority;
                }
                if (killTarget != null) {
                    targetExists = true;
                    if (agent.unit.isInWeaponRange(killTarget)) {
                        agent.attack(killTarget);
                        continue;
                    }
                    agent.order(new None(agent));
                    agent.unit.move(killTarget.getPosition());
                    continue;
                }
                agent.order(new None(agent));
                agent.unit.move(attackTarget);
            }
            if (!targetExists) {
                RunbyTask.completed = true;
            }
        }
    }

    @Override
    public boolean done() {
        return this.agents.size() == 0;
    }

    @Override
    public void add(Agent agent) {
        this.agents.add(agent);
    }

    @Override
    public void clear() {
        this.agents = new ArrayList<Agent>();
    }

    @Override
    public int size() {
        return this.agents.size();
    }
}

