/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TilePosition;
import bwta.BaseLocation;
import bwta.Region;
import com.tyr.BWTAProxy;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.agents.PlaceMine;
import com.tyr.agents.VultureAgent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import java.util.ArrayList;
import java.util.Comparator;

public class MineGridSolution
extends Solution {
    VultureAgent vulture;
    ArrayList<Position> potentialMinePlacements = new ArrayList();

    public MineGridSolution(Task task) {
        super(task);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.vulture != null && this.vulture.isDead()) {
            this.vulture = null;
        }
        if (this.vulture != null && this.vulture.isBlocked) {
            return;
        }
        if (this.potentialMinePlacements.size() == 0) {
            this.initializeMinePlacements();
        }
        if (this.vulture == null) {
            return;
        }
        this.vulture.drawCircle(Color.Blue);
        if (this.vulture.getCommand() instanceof PlaceMine) {
            return;
        }
        this.potentialMinePlacements.sort(new MineDistanceComparator());
        int i = this.potentialMinePlacements.size() - 1;
        while (i >= 0) {
            Position placement = this.potentialMinePlacements.get(i);
            this.potentialMinePlacements.remove(i);
            TilePosition tilePos = Tyr.positionToTile(placement);
            if (Tyr.bot.spaceManager.isFree(tilePos) && game.isWalkable(tilePos.getX(), tilePos.getY())) {
                this.vulture.placeMine(this.vulture.unit.getPosition());
                break;
            }
            --i;
        }
    }

    public void setVulture(VultureAgent vulture) {
        this.vulture = vulture;
    }

    public Agent pop() {
        VultureAgent result = this.vulture;
        this.vulture = null;
        if (result != null) {
            result.order(new None(result));
        }
        return result;
    }

    public boolean vultureNeeded() {
        return this.vulture == null || this.vulture.unit.getSpiderMineCount() == 0 || this.vulture.isBlocked;
    }

    public void initializeMinePlacements() {
        if (!BWTAProxy.initialized) {
            return;
        }
        Region startRegion = BWTAProxy.getRegion(Tyr.self.getStartLocation());
        int maxDist = 1536;
        int minDist = 512;
        int clearExpandDist = 256;
        Position startLocation = Tyr.tileToPosition(Tyr.self.getStartLocation());
        int x = Math.min(startLocation.getX() - maxDist, 32);
        while (x <= startLocation.getX() + maxDist && x < Tyr.game.mapWidth() * 32 - 32) {
            int y = Math.min(startLocation.getY() - maxDist, 32);
            while (y <= startLocation.getY() + maxDist && y < Tyr.game.mapHeight() * 32 - 32) {
                int dy;
                int dx;
                int distSq;
                if (BWTAProxy.getRegion(new Position(x, y)) != startRegion && (distSq = (dx = x - startLocation.getX()) * dx + (dy = y - startLocation.getY()) * dy) <= maxDist * maxDist && distSq >= minDist * minDist) {
                    boolean expandTooClose = false;
                    if (Tyr.bot.expands != null) {
                        for (BaseLocation expand : Tyr.bot.expands) {
                            Position expandPos = expand.getPosition();
                            dx = x - expandPos.getX();
                            int expandDistSq = dx * dx + (dy = y - expandPos.getY()) * dy;
                            if (expandDistSq > clearExpandDist * clearExpandDist) continue;
                            expandTooClose = true;
                            break;
                        }
                    }
                    if (!expandTooClose) {
                        this.potentialMinePlacements.add(new Position(x, y));
                    }
                }
                y += 64;
            }
            x += 64;
        }
        this.potentialMinePlacements.sort(new MineDistanceComparator());
    }

    public class MineDistanceComparator
    implements Comparator<Position> {
        @Override
        public int compare(Position a, Position b) {
            return (int)Math.signum(this.getDistance(b) - this.getDistance(a));
        }

        private int getDistance(Position pos) {
            int result = Integer.MAX_VALUE;
            if (Tyr.bot.defensiveStructures != null && Tyr.bot.defensiveStructures.size() > 0) {
                for (DefensiveStructures defenses : Tyr.bot.defensiveStructures) {
                    Position defensePos = defenses.getDefensePos();
                    int dx = pos.getX() - defensePos.getX();
                    int dy = pos.getY() - defensePos.getY();
                    result = Math.min(result, dx * dx + dy * dy);
                }
            } else {
                Position defensePos = Tyr.tileToPosition(Tyr.self.getStartLocation());
                int dx = pos.getX() - defensePos.getX();
                int dy = pos.getY() - defensePos.getY();
                return dx * dx + dy * dy;
            }
            return result;
        }
    }
}

