/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.EnemyManager;
import com.tyr.OrderedExpands;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.AttackGroup;

public class DragoonSquadSolution
extends Solution {
    private OrderedExpands cwExpands = new OrderedExpands(false, false, false, true);
    private AttackGroup attackGroup;
    private Agent observer;

    public DragoonSquadSolution(Task task) {
        super(task);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Position target = this.getTarget();
        if (target == null) {
            return;
        }
        if (this.attackGroup == null) {
            this.attackGroup = new AttackGroup(target);
        }
        this.attackGroup.setTarget(target);
        this.attackGroup.cleanup();
        this.attackGroup.onFrame(game, self, bot);
        if (this.observer != null && this.observer.isDead()) {
            this.observer = null;
        }
        if (this.observer != null) {
            Position observerPos = null;
            int dist = Integer.MAX_VALUE;
            for (Agent agent : this.attackGroup.units) {
                int newDist = agent.distanceSquared(target);
                if (newDist >= dist) continue;
                dist = newDist;
                observerPos = agent.unit.getPosition();
            }
            if (observerPos != null) {
                this.observer.move(observerPos);
                game.drawLineMap(observerPos, this.observer.unit.getPosition(), Color.Green);
            }
        }
    }

    public void add(Agent agent) {
        if (this.attackGroup == null) {
            this.attackGroup = new AttackGroup(null);
        }
        if (agent.unit.getType() == UnitType.Protoss_Observer) {
            if (this.observer == null || this.observer.isDead()) {
                this.observer = agent;
            } else {
                Tyr.bot.hobos.add(agent);
            }
        } else {
            this.attackGroup.add(agent);
        }
    }

    private Position getTarget() {
        if (!this.cwExpands.tryInitialize()) {
            return null;
        }
        Position current = this.cwExpands.getPos();
        if (current == null) {
            this.cwExpands.next();
        } else {
            if (!Tyr.game.isVisible(Tyr.positionToTile(current))) {
                return current;
            }
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (!unit.getType().isWorker() && !unit.getType().isResourceDepot() || PositionUtil.distanceSq(unit, current) > 40000) continue;
                return current;
            }
            this.cwExpands.next();
        }
        return this.cwExpands.getPos();
    }

    public int count() {
        if (this.attackGroup == null) {
            return 0;
        }
        return this.attackGroup.units.size();
    }
}

