/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.EnemyManager;
import com.tyr.OrderedExpands;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;

public class ClearMinesSolution
extends Solution {
    private Agent observer;
    private Agent scout;
    private OrderedExpands cwExpands = new OrderedExpands(true, false, true, true);

    public ClearMinesSolution(Task task) {
        super(task);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.observer != null && this.observer.isDead()) {
            this.observer = null;
        }
        if (this.scout != null && this.scout.isDead()) {
            this.scout = null;
        }
        Position cwPos = null;
        if (this.scout != null) {
            cwPos = this.getTarget();
        }
        if (cwPos != null) {
            if (this.scout != null) {
                for (Unit enemy : EnemyManager.getEnemyUnits()) {
                    if (enemy.getType() != UnitType.Terran_Wraith || this.scout.distanceSquared(enemy) > 90000) continue;
                    this.scout.attack(enemy);
                    game.drawLineMap(this.scout.unit.getX(), this.scout.unit.getY(), cwPos.getX(), cwPos.getY(), Color.Red);
                    break;
                }
                boolean mine = false;
                if (cwPos != null) {
                    for (Unit enemy : EnemyManager.getEnemyUnits()) {
                        if (enemy.getType() != UnitType.Terran_Vulture_Spider_Mine || PositionUtil.distanceSq(enemy, cwPos) > 40000) continue;
                        this.scout.attack(enemy);
                        mine = true;
                        game.drawLineMap(this.scout.unit.getX(), this.scout.unit.getY(), cwPos.getX(), cwPos.getY(), Color.Red);
                        break;
                    }
                }
                if (!mine) {
                    this.scout.unit.move(cwPos);
                    game.drawLineMap(this.scout.unit.getX(), this.scout.unit.getY(), cwPos.getX(), cwPos.getY(), Color.Green);
                }
            }
            if (this.observer != null) {
                this.observer.unit.move(cwPos);
                game.drawLineMap(this.observer.unit.getX(), this.observer.unit.getY(), cwPos.getX(), cwPos.getY(), Color.Green);
            }
        }
    }

    public void add(Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_Observer) {
            this.observer = agent;
        } else if (agent.unit.getType() == UnitType.Protoss_Scout) {
            this.scout = agent;
        }
    }

    private Position getTarget() {
        if (!this.cwExpands.tryInitialize()) {
            return null;
        }
        Position current = this.cwExpands.getPos();
        boolean mine = false;
        if (current != null) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.getType() != UnitType.Terran_Vulture_Spider_Mine || PositionUtil.distanceSq(enemy, current) > 40000) continue;
                mine = true;
                break;
            }
        }
        if (current == null || !mine && this.observer != null && this.observer.distanceSquared(current) <= 10000) {
            this.cwExpands.next();
        }
        return this.cwExpands.getPos();
    }

    public boolean needsObserver() {
        return this.observer == null && this.scout != null;
    }

    public boolean needsScout() {
        return this.scout == null;
    }
}

