/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.MineralWorkers;
import java.util.ArrayList;
import java.util.List;

public class ClearExpandsSolution
extends Solution {
    List<Agent> units = new ArrayList<Agent>();
    private ArrayList<Position> orderedExpands;
    private int currentPos;
    private boolean fullAssault = false;
    private boolean attackingCannon;
    private int targetChangedFrame = -10000;

    public ClearExpandsSolution(Task task) {
        super(task);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        int i = this.units.size() - 1;
        while (i >= 0) {
            if (this.units.get(i) == null || this.units.get(i).isDead()) {
                this.units.remove(i);
            }
            --i;
        }
        if (this.units.size() == 0) {
            this.targetChangedFrame = game.getFrameCount();
        }
        Position target = this.getTarget();
        int atCannons = 0;
        block1: for (Agent agent : this.units) {
            for (EnemyPosition enemy : EnemyManager.getManager().enemyDefensiveStructures) {
                if (agent.distanceSquared(enemy.pos) > 202500) continue;
                agent.drawCircle(Color.Orange, 16);
                ++atCannons;
                this.fullAssault = true;
                this.targetChangedFrame = game.getFrameCount();
                continue block1;
            }
        }
        if (atCannons > 0) {
            DebugMessages.addMessage("At cannons: " + atCannons);
        }
        boolean bl = this.attackingCannon = atCannons >= (this.attackingCannon ? 2 : 4);
        if (target != null) {
            for (Agent agent : this.units) {
                if (!this.attackingCannon) {
                    boolean retreat = false;
                    for (EnemyPosition enemyPosition : EnemyManager.getManager().enemyDefensiveStructures) {
                        if (agent.distanceSquared(enemyPosition.pos) > 160000) continue;
                        retreat = true;
                    }
                    if (retreat) {
                        agent.unit.move(Tyr.tileToPosition(self.getStartLocation()));
                        agent.drawCircle(Color.Green, 6);
                        continue;
                    }
                }
                if (agent.unit.getType() == UnitType.Protoss_Dark_Templar) {
                    boolean retreat = false;
                    for (Unit unit : EnemyManager.getEnemyUnits()) {
                        if (!unit.getType().isDetector() || agent.distanceSquared(unit) > 160000) continue;
                        retreat = true;
                    }
                    if (retreat) {
                        agent.move(Tyr.getStartLocation());
                        continue;
                    }
                }
                agent.attack(target);
                game.drawLineMap(agent.unit.getX(), agent.unit.getY(), target.getX(), target.getY(), Color.Red);
            }
        }
    }

    public void add(Agent agent) {
        this.units.add(agent);
    }

    public int size() {
        return this.units.size();
    }

    public boolean done() {
        return this.size() == 0;
    }

    private Position getTarget() {
        if (this.orderedExpands == null && Tyr.bot.suspectedEnemy.size() == 1) {
            this.orderedExpands = EnemyManager.getManager().getOrderedExpands();
            if (this.orderedExpands == null) {
                return null;
            }
            Position enemyNatural = SpaceManager.getEnemyNatural().getPosition();
            int enemyNat = 0;
            while (enemyNat < this.orderedExpands.size() - 1) {
                if (PositionUtil.distanceSq(enemyNatural, this.orderedExpands.get(enemyNat)) <= 10000) break;
                ++enemyNat;
            }
            this.orderedExpands.remove(enemyNat);
            this.currentPos = EnemyManager.getManager().getSelfPos();
            this.targetChangedFrame = Tyr.game.getFrameCount();
        }
        if (this.orderedExpands == null || this.orderedExpands.size() == 0) {
            return null;
        }
        Position curTarget = this.orderedExpands.get(this.currentPos);
        boolean isIsland = true;
        int i = 0;
        while (i <= 30 && isIsland) {
            for (BaseLocation loc : Tyr.bot.suspectedEnemy) {
                if (!loc.isIsland() || PositionUtil.distanceSq(curTarget, loc.getPosition()) > 10000) continue;
                this.currentPos = (this.currentPos + 1 + this.orderedExpands.size()) % this.orderedExpands.size();
                this.targetChangedFrame = Tyr.game.getFrameCount();
                curTarget = this.orderedExpands.get(this.currentPos);
                break;
            }
            ++i;
        }
        for (MineralWorkers base : Tyr.bot.workForce.mineralWorkers) {
            if (base.resourceDepot == null || PositionUtil.distanceSq(base.resourceDepot.getPosition(), curTarget) > 10000) continue;
            this.currentPos = (this.currentPos + 1 + this.orderedExpands.size()) % this.orderedExpands.size();
            this.targetChangedFrame = Tyr.game.getFrameCount();
            curTarget = this.orderedExpands.get(this.currentPos);
            break;
        }
        if (Tyr.game.getFrameCount() - this.targetChangedFrame >= 750) {
            this.currentPos = (this.currentPos + 1 + this.orderedExpands.size()) % this.orderedExpands.size();
            this.targetChangedFrame = Tyr.game.getFrameCount();
            curTarget = this.orderedExpands.get(this.currentPos);
        }
        this.fullAssault = false;
        for (EnemyPosition pos : EnemyManager.getManager().enemyBuildingMemory) {
            if (PositionUtil.distanceSq(pos.pos, curTarget) > 250000) continue;
            this.fullAssault = true;
            this.targetChangedFrame = Tyr.game.getFrameCount();
            return pos.pos;
        }
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            if (enemy.getType() == UnitType.Protoss_Observer || enemy.getType() == UnitType.Protoss_Dark_Templar || PositionUtil.distanceSq(enemy, curTarget) > 160000) continue;
            this.fullAssault = true;
            this.targetChangedFrame = Tyr.game.getFrameCount();
            return enemy.getPosition();
        }
        if (Tyr.game.isVisible(Tyr.positionToTile(curTarget))) {
            this.currentPos = (this.currentPos + 1 + this.orderedExpands.size()) % this.orderedExpands.size();
            this.targetChangedFrame = Tyr.game.getFrameCount();
        }
        return this.orderedExpands.get(this.currentPos);
    }

    public boolean fullAssault() {
        return this.fullAssault;
    }

    public void clear(ArrayList<Agent> newGroup) {
        boolean gotZealot = false;
        int i = this.units.size() - 1;
        while (i >= 0) {
            if (!gotZealot && this.units.get((int)i).unit.getType() == UnitType.Protoss_Zealot) {
                gotZealot = true;
            } else {
                newGroup.add(this.units.get(i));
                this.units.remove(i);
            }
            --i;
        }
    }
}

