/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.Region;
import com.tyr.BWTAProxy;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.PositionUtil;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.SendTroopsSolution;
import com.tyr.tasks.Task;

public class CannonDefenseTask
extends Task {
    private Unit invader;
    private Position target;
    private Region homeRegion = null;
    boolean proxied;
    boolean cannonsBuilt;
    boolean workerRush = false;

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        return game.enemy().getRace() == Race.Protoss;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        if (game.getFrameCount() >= 200 && this.homeRegion == null && BWTAProxy.initialized) {
            this.homeRegion = BWTAProxy.getRegion(self.getStartLocation());
        }
        if (this.homeRegion == null) {
            return;
        }
        if (!this.workerRush) {
            int count = 0;
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (!unit.getType().isWorker() || PositionUtil.distanceSq(unit, Tyr.tileToPosition(self.getStartLocation())) > Settings.getLargeInvasionDist() * Settings.getLargeInvasionDist()) continue;
                ++count;
            }
            if (count >= 3) {
                this.workerRush = true;
                if (this.solution != null) {
                    ((SendTroopsSolution)this.solution).done(bot.hobos);
                }
            }
        }
        if (this.workerRush) {
            return;
        }
        this.proxied = false;
        for (EnemyPosition pos : EnemyManager.getManager().enemyBuildingMemory) {
            if (pos.pos == null || game.getFrameCount() < 200 || !BWTAProxy.initialized || BWTAProxy.getRegion(pos.pos) != this.homeRegion) continue;
            this.proxied = true;
            if (pos.type != UnitType.Protoss_Photon_Cannon) continue;
            this.cannonsBuilt = true;
        }
        if (!this.cannonsBuilt && this.proxied) {
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType() != UnitType.Protoss_Photon_Cannon || !unit.isCompleted() || !unit.isPowered() || BWTAProxy.getRegion(unit.getPosition()) != this.homeRegion) continue;
                this.proxied = true;
                break;
            }
        }
        if (this.proxied || EnemyManager.getManager().getInvader() != null && !EnemyManager.getManager().getInvader().getType().isWorker()) {
            if (!this.cannonsBuilt) {
                if (this.invader != null && this.invader.getType() == UnitType.Protoss_Probe) {
                    this.invader = null;
                    this.target = null;
                }
                if (this.invader == null) {
                    for (EnemyPosition pos : EnemyManager.getManager().enemyBuildingMemory) {
                        if (BWTAProxy.getRegion(pos.pos) != this.homeRegion) continue;
                        this.invader = null;
                        this.target = pos.pos;
                        break;
                    }
                }
            }
            if (this.target != null) {
                Agent agent = bot.workForce.pop();
                while (agent != null) {
                    ((SendTroopsSolution)this.solution).add(agent);
                    agent = bot.workForce.pop();
                }
                ((SendTroopsSolution)this.solution).setTarget(this.target);
                super.solve(game, self, bot);
                return;
            }
            ((SendTroopsSolution)this.solution).done(bot.hobos);
            this.invader = null;
            this.target = null;
            return;
        }
        if (this.invader == null) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (!enemy.getType().isWorker() || BWTAProxy.getRegion(enemy.getPosition()) != this.homeRegion) continue;
                this.invader = enemy;
                break;
            }
        }
        if (this.invader == null) {
            this.target = null;
            ((SendTroopsSolution)this.solution).done(bot.hobos);
            return;
        }
        Position newTarget = EnemyManager.getManager().getLastPosition(this.invader);
        if (newTarget != null) {
            this.target = newTarget;
        } else if (this.target != null && ((SendTroopsSolution)this.solution).getCount() > 0 && ((SendTroopsSolution)this.solution).distanceSq(this.target) <= 1024) {
            this.invader = null;
            this.target = null;
            ((SendTroopsSolution)this.solution).done(bot.hobos);
            return;
        }
        if (this.target != null && BWTAProxy.initialized && BWTAProxy.getRegion(this.target) != this.homeRegion) {
            this.invader = null;
            this.target = null;
            ((SendTroopsSolution)this.solution).done(bot.hobos);
            return;
        }
        Tyr.drawCircle(this.target, Color.Red);
        if (((SendTroopsSolution)this.solution).getCount() == 0) {
            Agent agent = bot.workForce.pop(this.target);
            if (agent == null) {
                return;
            }
            ((SendTroopsSolution)this.solution).add(agent);
        }
        ((SendTroopsSolution)this.solution).setTarget(this.target);
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        this.solution = new SendTroopsSolution(this, this.target);
    }
}

