/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.tasks.BoomerangSolution;
import com.tyr.tasks.Task;
import java.util.ArrayList;

public class BoomerangTask
extends Task {
    private int defendingVultures = 2;
    private int defendingTanks = 2;
    private int minimumVultures = 2;
    private int minimumTanks = 2;

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        if (this.solution != null) {
            if (((BoomerangSolution)this.solution).size() == 0) {
                this.solution = null;
            } else {
                return true;
            }
        }
        if (EnemyManager.getManager().getOrderedExpands() == null) {
            return false;
        }
        if (UnitTracker.count(UnitType.Terran_Command_Center) < 2) {
            return false;
        }
        int vultureCount = 0;
        int tankCount = 0;
        for (Agent agent : bot.homeGroup.units) {
            if (agent.unit.getType() == UnitType.Terran_Vulture) {
                ++vultureCount;
            } else if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
                ++tankCount;
            }
            if (vultureCount < this.minimumVultures + this.defendingVultures || tankCount < this.minimumTanks + this.defendingTanks) continue;
            return true;
        }
        return false;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
        int pos = (EnemyManager.getManager().getSelfPos() + 2) % orderedExpands.size();
        if (orderedExpands == null || orderedExpands.size() == 0 || orderedExpands.get(pos) == null) {
            DebugMessages.addMessage("orderedExpands is null!");
            return;
        }
        this.solution = new BoomerangSolution(this, orderedExpands.get(pos));
        int vultureCount = 0;
        int tankCount = 0;
        int i = bot.homeGroup.units.size() - 1;
        while (i >= 0) {
            Agent agent = (Agent)bot.homeGroup.units.get(i);
            if (agent.unit.getType() == UnitType.Terran_Vulture) {
                if (++vultureCount > this.defendingVultures) {
                    ((BoomerangSolution)this.solution).add(agent);
                    bot.homeGroup.units.remove(i);
                }
            } else if ((agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) && ++tankCount > this.defendingTanks) {
                ((BoomerangSolution)this.solution).add(agent);
                bot.homeGroup.units.remove(i);
            }
            --i;
        }
    }
}

