/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.tasks.AttackTask;
import com.tyr.tasks.LayMinesTask;
import com.tyr.tasks.SalesmenMarinesTask;

public class TeamMech
extends CompositeBuildOrder {
    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(201);
        Settings.setMaximumSize(201);
        Settings.setWorkersPerGas(3);
        ExpandPart.maximumCcs = 2;
        this.add(new SupplyDepotPart());
        this.add(new ExpandPart());
        bot.taskManager.disableScanner();
        bot.taskManager.potentialTasks.add(new LayMinesTask());
        bot.taskManager.potentialTasks.add(new SalesmenMarinesTask());
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Team game. Going mech.");
        StopWatch watch = new StopWatch();
        watch.start();
        int i = bot.suspectedEnemy.size() - 1;
        while (i >= 1) {
            bot.expands.add(bot.suspectedEnemy.get(i));
            bot.suspectedEnemy.remove(i);
            --i;
        }
        if (ExpandPart.maximumCcs == 2 && UnitTracker.count(UnitType.Terran_Factory) >= 5 && (bot.homeGroup.units.size() >= 20 || AttackTask.getAttackSent())) {
            ExpandPart.maximumCcs = 100;
        }
        super.onFrame(game, self, bot);
        if (UnitTracker.count(UnitType.Terran_Factory) < 1 && (bot.getAvailableGas() >= 100 || bot.getAvailableMinerals() < 100)) {
            Settings.setWorkersPerGas(1);
        } else if (!(UnitTracker.count(UnitType.Terran_Factory) > 2 && bot.getAvailableGas() < 300 || bot.getAvailableGas() < 100 && bot.getAvailableMinerals() >= 150)) {
            Settings.setWorkersPerGas(2);
        } else {
            Settings.setWorkersPerGas(3);
        }
        long time = watch.time();
        if (time > 55L) {
            DebugMessages.addMessage("Mech super time: " + time);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Refinery) > 0 && (bot.getAvailableMinerals() >= 150 || UnitTracker.getCcCount() > 1) && UnitTracker.count(UnitType.Terran_Barracks) == 0) {
            bot.spaceManager.build(UnitType.Terran_Barracks);
        }
        if (UnitTracker.count(UnitType.Terran_Refinery) < UnitTracker.count(UnitType.Terran_Command_Center) && (UnitTracker.count(UnitType.Terran_Refinery) == 0 || UnitTracker.count(UnitType.Terran_Factory) >= 1) && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if (bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Factory) < Math.min(9, 3 * UnitTracker.count(UnitType.Terran_Command_Center)) && (UnitTracker.count(UnitType.Terran_Factory) == 0 || bot.getAvailableMinerals() >= 350 && bot.getAvailableGas() >= 200)) {
            bot.spaceManager.build(UnitType.Terran_Factory);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Mech tier 1 time: " + time);
        }
        time = watch.time();
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0 && UnitTracker.count(UnitType.Terran_Academy) == 0 && (bot.homeGroup.units.size() >= 10 || UnitTracker.count(UnitType.Terran_Vulture) >= 6)) {
            bot.spaceManager.build(UnitType.Terran_Academy);
        }
        if (UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) >= 4 && UnitTracker.count(UnitType.Terran_Armory) < 2 && bot.getAvailableGas() >= 50 && bot.getAvailableMinerals() >= 100) {
            bot.spaceManager.build(UnitType.Terran_Armory);
        }
        if (UnitTracker.count(UnitType.Terran_Armory) >= 2 && self.completedUnitCount(UnitType.Terran_Factory) >= 4 && UnitTracker.count(UnitType.Terran_Starport) == 0 && bot.getAvailableGas() >= 100 && bot.getAvailableMinerals() >= 150) {
            bot.spaceManager.build(UnitType.Terran_Starport);
        }
        if (UnitTracker.count(UnitType.Terran_Armory) >= 2 && UnitTracker.count(UnitType.Terran_Science_Facility) < 1 && self.completedUnitCount(UnitType.Terran_Starport) > 0 && bot.getAvailableGas() >= 150 && bot.getAvailableMinerals() >= 100) {
            bot.spaceManager.build(UnitType.Terran_Science_Facility);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Mech tier 2 time: " + time);
        }
        if (bot.getAvailableMinerals() >= 50 && (bot.getAvailableMinerals() >= 100 || UnitTracker.count(UnitType.Terran_Factory) > 1) && UnitTracker.count(UnitType.Terran_Factory) >= 1 && self.completedUnitCount(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Bunker) < 2) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                int count = structures.getUnitCount(UnitType.Terran_Bunker);
                if (count >= 1) continue;
                if (bot.defensiveStructures.size() > 1 && structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 200.0) {
                    if (UnitTracker.count(UnitType.Terran_Bunker) != 0) break;
                    continue;
                }
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Mech bunker time: " + time);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks && (UnitTracker.count(UnitType.Terran_Factory) == 0 || UnitTracker.count(UnitType.Terran_Marine) >= Math.max(4, UnitTracker.count(UnitType.Terran_Bunker) * 4))) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Starport) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Factory) {
            boolean addonWanted;
            if (agent.unit.getAddon() != null) {
                if (UnitTracker.count(UnitType.Terran_Factory) <= 1 && UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) >= 2) {
                    return false;
                }
                return !self.isResearching(TechType.Tank_Siege_Mode) && !self.hasResearched(TechType.Tank_Siege_Mode);
            }
            boolean bl = addonWanted = UnitTracker.usableAddOns(UnitType.Terran_Machine_Shop) * 4 + 1 < self.completedUnitCount(UnitType.Terran_Factory) || self.completedUnitCount(UnitType.Terran_Factory) <= 1;
            if (UnitTracker.count(UnitType.Terran_Armory) >= 1 && !agent.unit.isTraining() && UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) >= 5 + UnitTracker.count(UnitType.Terran_Goliath) / 2 && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 50) {
                agent.unit.train(UnitType.Terran_Goliath);
                return true;
            }
            if (bot.getAvailableMinerals() >= 75 && !agent.unit.isTraining() && UnitTracker.count(UnitType.Terran_Vulture) <= 2 * (UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode)) - 1) {
                agent.unit.train(UnitType.Terran_Vulture);
                return true;
            }
            return !addonWanted;
        }
        if (agent.unit.getType() == UnitType.Terran_Armory) {
            if (bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Terran_Vehicle_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Plating.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Plating.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Terran_Vehicle_Plating);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Engineering_Bay) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Machine_Shop) {
            if (!agent.unit.isResearching() && self.hasResearched(TechType.Tank_Siege_Mode) && !self.hasResearched(TechType.Spider_Mines) && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 100) {
                agent.unit.research(TechType.Spider_Mines);
            } else if (!agent.unit.isResearching() && self.hasResearched(TechType.Spider_Mines) && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 100) {
                agent.unit.upgrade(UpgradeType.Charon_Boosters);
            }
        }
        return false;
    }
}

