/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.builds.BuildOrder;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.SupplyDepotPart;

public class TFastExpand
extends CompositeBuildOrder {
    BuildOrder contained;
    boolean expanded = false;
    boolean takeGasNext = true;

    public TFastExpand(BuildOrder contained) {
        this.contained = contained;
    }

    public TFastExpand(BuildOrder contained, boolean takeGasNext) {
        this.contained = contained;
        this.takeGasNext = takeGasNext;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        if (this.contained != null) {
            this.contained.initialize(game, self, bot);
        }
        super.add(new SupplyDepotPart());
        super.add(new ExpandPart(this.takeGasNext));
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.expanded) {
            this.contained.onFrame(game, self, bot);
            return;
        }
        DebugMessages.addMessage("Going for early expand.");
        super.onFrame(game, self, bot);
        if (UnitTracker.getCcCount() >= 2) {
            this.expanded = true;
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (this.expanded) {
            return this.contained.overrideStructureOrder(game, self, bot, agent);
        }
        return super.overrideStructureOrder(game, self, bot, agent);
    }
}

