/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.ConjRequirement;
import com.tyr.requirements.CostRequirement;
import com.tyr.requirements.Requirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.BuildAtLocationSolution;
import com.tyr.tasks.BuildAtLocationTask;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.unitgroups.WallAttackGroup;
import com.tyr.unitgroups.WorkerGroup;

public class PvIron
extends CompositeBuildOrder {
    private ConstantPushTask constantPushTask;
    public boolean attackStarted;
    private int armySize = 15;
    private int retreatSize = 10;
    private boolean upgradeLegSpeed;
    private boolean detectionNeeded = false;
    private boolean firstAttackDone = false;
    private boolean proxyPylonInitialized = true;
    private boolean dtTransition = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(60);
        Settings.setSmallInvasionDist(480);
        Settings.setLargeInvasionDist(768);
        Settings.setWorkersPerGas(3);
        Attack.dontWaitAtCannon = true;
        this.add(new ExpandPart(true));
        if (game.mapFileName().contains("Alchemist")) {
            this.add(new WorkerScoutPart(100));
        } else {
            this.add(new WorkerScoutPart(1600));
        }
        ExpandPart.maximumCcs = 3;
        bot.taskManager.potentialTasks.add(new ConstantPushTask(DARK_TEMPLAR, 1));
        this.constantPushTask = new ConstantPushTask(null, 4);
        this.constantPushTask.stop = true;
        bot.taskManager.potentialTasks.add(this.constantPushTask);
        ConstantPushTask.prioritizeExpands = true;
        BuildAtLocationSolution.removeExcess = false;
        WallAttackGroup.fearBarracks = true;
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Performing PvT build.");
        super.onFrame(game, self, bot);
        boolean bl = WorkerGroup.evacuateThreatenedBases = game.getFrameCount() >= 12000;
        if (PvIron.gas() >= 400) {
            Settings.setWorkersPerGas(2);
        } else if (PvIron.gas() < 250 && PvIron.count(GATEWAY) >= 12 || PvIron.gas() + 400 < PvIron.minerals()) {
            Settings.setWorkersPerGas(3);
        }
        if (this.constantPushTask != null && PvIron.completed(ZEALOT) + PvIron.completed(DRAGOON) <= this.retreatSize) {
            this.constantPushTask.stop = true;
        }
        if (this.constantPushTask != null && PvIron.completed(ZEALOT) + PvIron.completed(DRAGOON) >= this.armySize) {
            this.constantPushTask.stop = false;
            this.attackStarted = true;
        }
        if (PvIron.count(ZEALOT) + PvIron.count(DRAGOON) >= 10 && PvIron.count(NEXUS) >= 2) {
            this.detectionNeeded = true;
        }
        if (!this.firstAttackDone && PvIron.completed(ZEALOT) + PvIron.completed(DRAGOON) >= 3) {
            this.constantPushTask.stop = false;
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= PvIron.count(GATEWAY) * 3 + UnitTracker.getCcCount() * 3 && PvIron.minerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            bot.spaceManager.build(PYLON);
        }
        if (PvIron.minerals() >= 150 && PvIron.count(GATEWAY) < 2 && PvIron.completed(PYLON) > 0) {
            bot.spaceManager.build(GATEWAY);
        }
        if (!this.pauseProduction()) {
            if (PvIron.minerals() >= 150 && PvIron.count(GATEWAY) < 3 && PvIron.count(CYBERNETICS_CORE) > 0) {
                bot.spaceManager.build(GATEWAY);
            }
            if (PvIron.count(NEXUS) >= 2 && PvIron.minerals() >= 250 && PvIron.count(CYBERNETICS_CORE) > 0 && PvIron.count(GATEWAY) < 8) {
                bot.spaceManager.build(GATEWAY);
            }
            if (PvIron.count(NEXUS) >= 2 && PvIron.minerals() >= 150 && PvIron.completed(GATEWAY) >= 8 && PvIron.count(GATEWAY) < 12) {
                bot.spaceManager.build(GATEWAY);
            }
        }
        if (PvIron.minerals() >= 100 && UnitTracker.getGeyserCount() > 0 && PvIron.count(GATEWAY) > 0 && (PvIron.count(ZEALOT) >= 4 || this.dtTransition) && PvIron.count(ASSIMILATOR) == 0 || this.attackStarted || this.dtTransition) {
            bot.spaceManager.build(ASSIMILATOR);
        }
        if (PvIron.minerals() >= 200 && PvIron.count(CYBERNETICS_CORE) < 1 && PvIron.completed(GATEWAY) > 0 && PvIron.count(ZEALOT) >= 4) {
            bot.spaceManager.build(CYBERNETICS_CORE);
        }
        if (!(PvIron.minerals() < 150 || PvIron.gas() < 100 || PvIron.count(CITADEL) != 0 || PvIron.completed(CYBERNETICS_CORE) <= 0 || PvIron.count(NEXUS) < 2 && !this.dtTransition || PvIron.count(DRAGOON) + PvIron.count(ZEALOT) < 20 && !this.dtTransition || PvIron.completed(SHUTTLE) <= 0 && !this.dtTransition)) {
            bot.spaceManager.build(CITADEL);
        }
        if (PvIron.minerals() >= 150 && PvIron.gas() >= 200 && PvIron.count(TEMPLAR_ARCHIVES) < 1 && PvIron.completed(CITADEL) > 0 && (PvIron.count(NEXUS) >= 3 || this.dtTransition) && (PvIron.count(DRAGOON) + PvIron.count(ZEALOT) >= 25 || this.dtTransition)) {
            PvIron.build(TEMPLAR_ARCHIVES);
        }
        if (PvIron.gas() >= 200 && PvIron.minerals() >= 200 && (this.detectionNeeded || PvIron.count(DRAGOON) + PvIron.count(ZEALOT) >= 10) && PvIron.count(ROBOTICS_FACILITY) == 0 && PvIron.count(DRAGOON) >= 5 && (this.detectionNeeded || PvIron.count(NEXUS) >= 2)) {
            bot.spaceManager.build(ROBOTICS_FACILITY);
        }
        if (PvIron.gas() >= 50 && PvIron.minerals() >= 100 && PvIron.completed(ROBOTICS_FACILITY) > 0 && PvIron.count(OBSERVATORY) == 0 && this.detectionNeeded) {
            bot.spaceManager.build(OBSERVATORY);
        }
        if (!this.proxyPylonInitialized && PvIron.count(ZEALOT) >= 5 && game.getFrameCount() >= 100 && bot.suspectedEnemy.size() == 1) {
            this.proxyPylonInitialized = true;
            final PvIron build = this;
            Position offensivePosition = SpaceManager.getEnemyNatural().getPosition();
            BuildAtLocationTask buildTask = new BuildAtLocationTask(offensivePosition, true);
            buildTask.addBuilding(UnitType.Protoss_Pylon, new ConjRequirement().addRequirement(new CostRequirement(50, 0)).addRequirement(new Requirement(){

                @Override
                public boolean met() {
                    return !build.firstAttackDone;
                }
            }));
            buildTask.addBuilding(UnitType.Protoss_Forge, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Pylon, 1, true)).addRequirement(new CostRequirement(100, 0)).addRequirement(new Requirement(){

                @Override
                public boolean met() {
                    return !build.firstAttackDone;
                }
            }));
            int i = 0;
            while (i < 4) {
                ConjRequirement requirements = new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Forge, 1, true)).addRequirement(new CostRequirement(150, 0)).addRequirement(new Requirement(){

                    @Override
                    public boolean met() {
                        return !build.firstAttackDone;
                    }
                });
                buildTask.addBuilding(UnitType.Protoss_Photon_Cannon, requirements);
                ++i;
            }
            bot.taskManager.potentialTasks.add(buildTask);
        }
    }

    private boolean pauseProduction() {
        if (PvIron.gas() > 250 && PvIron.minerals() > 400) {
            return false;
        }
        if (this.upgradeLegSpeed && PvIron.count(CITADEL) == 0 && (PvIron.completed(SHUTTLE) > 0 || this.dtTransition)) {
            return true;
        }
        if (PvIron.count(NEXUS) < 2 && PvIron.count(DRAGOON) >= 3) {
            return true;
        }
        if (PvIron.count(NEXUS) < 3 && PvIron.count(DRAGOON) + PvIron.count(ZEALOT) >= 10) {
            return true;
        }
        if (PvIron.count(CITADEL) == 0 && this.dtTransition) {
            return true;
        }
        if (PvIron.completed(CITADEL) > 0 && !Tyr.self.isUpgrading(UpgradeType.Leg_Enhancements) && Tyr.self.getUpgradeLevel(UpgradeType.Leg_Enhancements) == 0) {
            return true;
        }
        if (PvIron.completed(CITADEL) > 0 && PvIron.count(TEMPLAR_ARCHIVES) == 0) {
            return true;
        }
        if (this.detectionNeeded && PvIron.count(DRAGOON) >= 5 && PvIron.completed(ROBOTICS_FACILITY) == 1 && PvIron.count(OBSERVATORY) == 0) {
            return true;
        }
        if (this.detectionNeeded && PvIron.count(DRAGOON) >= 5 && PvIron.completed(OBSERVATORY) == 1 && PvIron.count(OBSERVER) == 0) {
            return true;
        }
        if (this.detectionNeeded && PvIron.count(DRAGOON) >= 5 && PvIron.count(ROBOTICS_FACILITY) == 0) {
            return true;
        }
        return this.attackStarted && PvIron.count(NEXUS) < 3;
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == NEXUS) {
            if (PvIron.count(GATEWAY) < 2 && PvIron.count(PROBE) >= 10) {
                return true;
            }
            if (PvIron.count(ZEALOT) <= 2 && PvIron.count(PROBE) >= 13) {
                return true;
            }
        } else {
            if (agent.unit.getType() == GATEWAY && !agent.unit.isTraining()) {
                if (this.dtTransition && PvIron.completed(CYBERNETICS_CORE) > 0 && PvIron.count(DRAGOON) == 0) {
                    agent.unit.build(DRAGOON);
                }
                if (this.dtTransition && PvIron.gas() >= 75 && PvIron.count(TEMPLAR_ARCHIVES) > 0 && PvIron.count(DARK_TEMPLAR) < 2) {
                    agent.unit.build(DARK_TEMPLAR);
                }
                boolean pause = this.pauseProduction();
                if (this.dtTransition && pause) {
                    return true;
                }
                if (PvIron.count(ZEALOT) < 4) {
                    agent.unit.build(ZEALOT);
                }
                if (pause && PvIron.minerals() >= 600) {
                    agent.unit.build(ZEALOT);
                } else if (!(PvIron.count(ZEALOT) >= PvIron.count(DRAGOON) - 2 || PvIron.minerals() < 100 || PvIron.minerals() < 400 && pause)) {
                    agent.unit.build(ZEALOT);
                } else if (PvIron.minerals() >= 125 && PvIron.gas() >= 50) {
                    agent.unit.build(DRAGOON);
                }
                return true;
            }
            if (agent.unit.getType() == FORGE && !agent.unit.isUpgrading()) {
                if (this.pauseProduction()) {
                    return true;
                }
                if (PvIron.minerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && PvIron.gas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                    agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
                }
                if (PvIron.minerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && PvIron.gas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                    agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
                }
            } else if (agent.unit.getType() == CYBERNETICS_CORE && !agent.unit.isUpgrading()) {
                if (PvIron.minerals() >= UpgradeType.Singularity_Charge.mineralPrice() && PvIron.gas() >= UpgradeType.Singularity_Charge.gasPrice() && PvIron.count(DRAGOON) > 5) {
                    agent.unit.upgrade(UpgradeType.Singularity_Charge);
                }
            } else {
                if (agent.unit.getType() == ROBOTICS_FACILITY) {
                    if (PvIron.count(OBSERVER) < 2 && PvIron.completed(OBSERVATORY) > 0 && PvIron.minerals() >= 25 && PvIron.gas() >= 75 && !agent.unit.isTraining()) {
                        agent.unit.build(OBSERVER);
                    } else if (PvIron.count(SHUTTLE) < 4 && PvIron.minerals() >= 200 && !agent.unit.isTraining()) {
                        agent.unit.build(SHUTTLE);
                    }
                    return true;
                }
                if (agent.unit.getType() == CITADEL && !agent.unit.isUpgrading()) {
                    if (PvIron.gas() >= UpgradeType.Leg_Enhancements.gasPrice() && PvIron.minerals() >= UpgradeType.Leg_Enhancements.mineralPrice()) {
                        agent.unit.upgrade(UpgradeType.Leg_Enhancements);
                    }
                } else if ((agent.unit.getType() != TEMPLAR_ARCHIVES || agent.unit.isResearching()) && agent.unit.getType() == STARGATE) {
                    if (PvIron.completed(ARBITER_TRIBUNAL) > 0 && PvIron.minerals() >= 100 && PvIron.gas() >= 350 && !agent.unit.isTraining()) {
                        agent.unit.train(ARBITER);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

