/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.Unit;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.builds.BuildOrder;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.DragoonPush;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.unitgroups.AttackGroup;

public class GatewayPush
extends CompositeBuildOrder {
    private Race opponentRace = Race.Unknown;
    private BuildOrder buildOrder;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(40);
        Settings.setSmallInvasionDist(480);
        Settings.setLargeInvasionDist(768);
        Settings.setWorkersPerGas(2);
        this.add(new WorkerScoutPart(100));
        AttackGroup.hunting = true;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.opponentRace == Race.Unknown) {
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType().getRace() == Race.Zerg) {
                    this.opponentRace = Race.Zerg;
                } else if (unit.getType().getRace() == Race.Terran) {
                    this.opponentRace = Race.Terran;
                } else if (unit.getType().getRace() == Race.Protoss) {
                    this.opponentRace = Race.Protoss;
                }
                if (this.opponentRace != Race.Unknown) break;
            }
        }
        if (this.buildOrder == null && this.opponentRace != Race.Unknown) {
            if (this.opponentRace == Race.Protoss) {
                this.buildOrder = new DragoonPush(25, false, true, false, false, true, false, false);
            } else if (this.opponentRace == Race.Terran) {
                this.buildOrder = new DragoonPush(30, 15, false, false, false, false, false, false, true);
            } else if (this.opponentRace == Race.Zerg) {
                this.buildOrder = new DragoonPush(25, false, true, true, false, true, false, false);
            }
            this.buildOrder.initialize(game, self, bot);
        }
        if (this.buildOrder != null) {
            this.buildOrder.onFrame(game, self, bot);
            return;
        }
        super.onFrame(game, self, bot);
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= GatewayPush.count(GATEWAY) * 3 + UnitTracker.getCcCount() * 3 && GatewayPush.minerals() >= 100) {
            bot.spaceManager.build(PYLON);
        }
        if (GatewayPush.minerals() >= 150 && GatewayPush.count(GATEWAY) < 1 && GatewayPush.completed(PYLON) > 0) {
            bot.spaceManager.build(GATEWAY);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (this.buildOrder != null) {
            return this.buildOrder.overrideStructureOrder(game, self, bot, agent);
        }
        return super.overrideStructureOrder(game, self, bot, agent);
    }
}

