/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwta.BWTA;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.ConjRequirement;
import com.tyr.requirements.CostRequirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.BuildAtLocationSolution;
import com.tyr.tasks.BuildAtLocationTask;
import com.tyr.tasks.ClearExpandsTask;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.LocalDefenseTask;

public class DTHarass
extends CompositeBuildOrder {
    private ConstantPushTask constantPushTask;
    private LocalDefenseTask localDefenseTask;
    private LocalDefenseTask thirdDefenseTask;
    private ClearExpandsTask dtHarassTask;
    public boolean attackStarted;
    private int armySize = 25;
    private int retreatSize = 20;
    private boolean detectionNeeded = false;
    private boolean localDefense = false;
    private boolean counterZealotRush = false;
    private boolean zealotEncountered = false;
    private boolean counterDragoonRush = false;
    private boolean defensesInitialized;
    private boolean buildingCannons = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(60);
        Settings.setSmallInvasionDist(480);
        Settings.setLargeInvasionDist(768);
        Settings.setWorkersPerGas(2);
        Attack.dontWaitAtCannon = true;
        this.add(new ExpandPart(true));
        if (game.mapFileName().contains("Alchemist")) {
            this.add(new WorkerScoutPart(100));
        } else {
            this.add(new WorkerScoutPart(1600));
        }
        ExpandPart.maximumCcs = 2;
        this.localDefenseTask = new LocalDefenseTask(BWTA.getRegion(self.getStartLocation()), 0);
        bot.taskManager.potentialTasks.add(this.localDefenseTask);
        this.thirdDefenseTask = new LocalDefenseTask(null, 0);
        bot.taskManager.potentialTasks.add(this.thirdDefenseTask);
        this.constantPushTask = new ConstantPushTask(null, 0);
        this.constantPushTask.stop = true;
        bot.taskManager.potentialTasks.add(this.constantPushTask);
        ConstantPushTask.prioritizeExpands = true;
        this.dtHarassTask = new ClearExpandsTask(true);
        this.dtHarassTask.setActive(true);
        bot.taskManager.potentialTasks.add(this.dtHarassTask);
        ClearExpandsTask.allowFullAssault = false;
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        int max = 0;
        for (Unit unit : self.getUnits()) {
            game.drawTextMap(unit.getPosition(), String.valueOf(unit.getID()));
            max = Math.max(max, unit.getID());
        }
        DebugMessages.addMessage("Max ID: " + max);
        DebugMessages.addMessage("Performing PvT build.");
        super.onFrame(game, self, bot);
        if (DTHarass.gas() >= 400) {
            Settings.setWorkersPerGas(2);
        } else if (DTHarass.gas() < 250 && DTHarass.count(GATEWAY) >= 12 || DTHarass.gas() + 400 < DTHarass.minerals() || DTHarass.count(CITADEL) > 0) {
            Settings.setWorkersPerGas(3);
        }
        if (game.getFrameCount() > 8000) {
            this.counterZealotRush = false;
        } else if (EnemyManager.getManager().getAllCount(ZEALOT) >= 4) {
            this.counterZealotRush = true;
        }
        if (EnemyManager.getManager().getAllCount(DARK_TEMPLAR) + EnemyManager.getManager().getAllCount(CITADEL) + EnemyManager.getManager().getAllCount(TEMPLAR_ARCHIVES) > 0) {
            this.detectionNeeded = true;
        }
        if (game.getFrameCount() >= 7500 && EnemyManager.getManager().getAllCount(DARK_TEMPLAR) + EnemyManager.getManager().getAllCount(TEMPLAR_ARCHIVES) > 0) {
            this.armySize = 15;
            this.retreatSize = 10;
            this.buildingCannons = true;
        }
        if (DTHarass.completed(CANNON) >= 2 && DTHarass.completed(OBSERVER) > 0) {
            this.armySize = 25;
            this.retreatSize = 20;
        }
        if (EnemyManager.getManager().getAllCount(ZEALOT) > 0) {
            this.zealotEncountered = true;
        }
        boolean bl = this.counterDragoonRush = !this.zealotEncountered && EnemyManager.getManager().getAllCount(DRAGOON) + EnemyManager.getManager().getAllCount(CYBERNETICS_CORE) > 0;
        if (this.constantPushTask != null && DTHarass.completed(ZEALOT) + DTHarass.completed(DRAGOON) <= this.retreatSize) {
            this.constantPushTask.stop = true;
        }
        if (this.constantPushTask != null && DTHarass.completed(ZEALOT) + DTHarass.completed(DRAGOON) >= this.armySize) {
            ExpandPart.maximumCcs = 100;
            this.constantPushTask.stop = false;
            this.attackStarted = true;
            if (this.localDefense) {
                this.localDefenseTask.setDefendersNeeded(3);
            }
            if (EnemyManager.getManager().getAllCount(DARK_TEMPLAR) + EnemyManager.getManager().getAllCount(TEMPLAR_ARCHIVES) == 0) {
                this.armySize = Math.max(this.armySize, 30);
            }
            this.detectionNeeded = true;
        }
        if (!this.defensesInitialized && this.buildingCannons && !Tyr.game.mapFileName().contains("Alchemist")) {
            this.defensesInitialized = true;
            Position startLocation = Tyr.tileToPosition(Tyr.self.getStartLocation());
            Position mainExit = SpaceManager.getMainExit();
            Position defensivePosition = new Position((startLocation.getX() + mainExit.getX() * 3) / 4, (startLocation.getY() + mainExit.getY() * 3) / 4);
            BuildAtLocationTask buildTask = new BuildAtLocationTask(defensivePosition, true);
            BuildAtLocationSolution.buildingDistance = 300;
            buildTask.addBuilding(UnitType.Protoss_Pylon, new UnitRequirement(UnitType.Protoss_Probe, 7));
            int i = 0;
            while (i < 2) {
                ConjRequirement requirements = new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Forge, 1, true)).addRequirement(new CostRequirement(50, 0));
                buildTask.addBuilding(UnitType.Protoss_Photon_Cannon, requirements);
                ++i;
            }
            bot.taskManager.potentialTasks.add(buildTask);
        }
        if (this.localDefense && this.thirdDefenseTask.getDefendersNeeded() == 0 && Tyr.bot.workForce.mineralWorkers.size() >= 3) {
            this.thirdDefenseTask.setDefendersNeeded(3);
            this.thirdDefenseTask.setDefendedPosition(Tyr.bot.workForce.mineralWorkers.get((int)2).resourceDepot.getPosition());
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= DTHarass.count(GATEWAY) * 3 + UnitTracker.getCcCount() * 3 && DTHarass.minerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            bot.spaceManager.build(PYLON);
        }
        if (DTHarass.count(NEXUS) >= 2 && DTHarass.minerals() >= 150 && DTHarass.count(GATEWAY) == 0 && DTHarass.completed(PYLON) > 0 && DTHarass.count(PYLON) > 0) {
            bot.spaceManager.build(GATEWAY);
        }
        if (DTHarass.count(NEXUS) >= 2 && DTHarass.minerals() >= 150 && DTHarass.count(GATEWAY) < 2 && DTHarass.count(CYBERNETICS_CORE) > 0) {
            bot.spaceManager.build(GATEWAY);
        }
        if (DTHarass.minerals() >= 150 && DTHarass.count(GATEWAY) < 2) {
            bot.spaceManager.build(GATEWAY);
        }
        if (!this.pauseProduction()) {
            if (DTHarass.count(NEXUS) >= 2 && DTHarass.minerals() >= 150 && DTHarass.count(GATEWAY) < 5 && DTHarass.count(CYBERNETICS_CORE) > 0) {
                bot.spaceManager.build(GATEWAY);
            }
            if (DTHarass.count(NEXUS) >= 2 && DTHarass.minerals() >= 250 && DTHarass.count(CYBERNETICS_CORE) > 0 && DTHarass.count(GATEWAY) < 8) {
                bot.spaceManager.build(GATEWAY);
            }
            if (DTHarass.count(NEXUS) >= 2 && DTHarass.minerals() >= 150 && DTHarass.completed(GATEWAY) >= 8 && DTHarass.count(GATEWAY) < 12) {
                bot.spaceManager.build(GATEWAY);
            }
        }
        if (!(DTHarass.minerals() < 100 || UnitTracker.getGeyserCount() <= 0 || DTHarass.count(GATEWAY) <= 0 || DTHarass.count(NEXUS) < 2 || this.counterZealotRush && DTHarass.count(ZEALOT) < 6)) {
            bot.spaceManager.build(ASSIMILATOR);
        }
        if (!(DTHarass.minerals() < 200 || DTHarass.count(CYBERNETICS_CORE) >= 1 || DTHarass.completed(GATEWAY) <= 0 || DTHarass.count(NEXUS) < 2 || this.counterZealotRush && DTHarass.count(ZEALOT) < 6 || this.buildingCannons && DTHarass.count(CANNON) < 2)) {
            bot.spaceManager.build(CYBERNETICS_CORE);
        }
        if (!(DTHarass.minerals() < 150 || DTHarass.count(FORGE) >= 1 || DTHarass.count(DRAGOON) < 2 && !this.buildingCannons || this.counterZealotRush && DTHarass.count(ZEALOT) < 6 && !this.buildingCannons || this.counterDragoonRush && DTHarass.count(DRAGOON) <= 15 && !this.buildingCannons)) {
            bot.spaceManager.build(FORGE);
        }
        if (!(DTHarass.minerals() < 150 || DTHarass.gas() < 100 || DTHarass.count(CITADEL) != 0 || DTHarass.completed(CYBERNETICS_CORE) <= 0 || DTHarass.count(NEXUS) < 2 || this.counterDragoonRush && DTHarass.count(DRAGOON) <= 15 || this.buildingCannons && DTHarass.count(CANNON) < 2)) {
            bot.spaceManager.build(CITADEL);
        }
        if (!(DTHarass.minerals() < 150 || DTHarass.gas() < 200 || DTHarass.count(TEMPLAR_ARCHIVES) >= 1 || DTHarass.completed(CITADEL) <= 0 || DTHarass.count(NEXUS) < 2 || this.buildingCannons && DTHarass.count(CANNON) < 2)) {
            DTHarass.build(TEMPLAR_ARCHIVES);
        }
        if (DTHarass.gas() >= 200 && DTHarass.minerals() >= 200 && this.detectionNeeded && DTHarass.count(ROBOTICS_FACILITY) == 0 && (!this.buildingCannons || DTHarass.count(CANNON) >= 2)) {
            bot.spaceManager.build(ROBOTICS_FACILITY);
        }
        if (DTHarass.gas() >= 50 && DTHarass.minerals() >= 100 && DTHarass.completed(ROBOTICS_FACILITY) > 0 && DTHarass.count(OBSERVATORY) == 0 && this.detectionNeeded && (!this.buildingCannons || DTHarass.count(CANNON) >= 2)) {
            bot.spaceManager.build(OBSERVATORY);
        }
    }

    private boolean pauseProduction() {
        if (DTHarass.gas() > 250 && DTHarass.minerals() > 400) {
            return false;
        }
        if (this.counterZealotRush && DTHarass.count(ZEALOT) < 6) {
            return false;
        }
        if (this.buildingCannons && DTHarass.count(FORGE) == 0) {
            return true;
        }
        if (this.buildingCannons && DTHarass.completed(FORGE) > 0 && DTHarass.count(CANNON) < 2 && DTHarass.minerals() < 200) {
            return true;
        }
        if (!(DTHarass.count(DRAGOON) + DTHarass.count(ZEALOT) < 10 || DTHarass.count(CITADEL) != 0 || this.counterDragoonRush && DTHarass.count(DRAGOON) <= 15)) {
            return true;
        }
        if (!(DTHarass.completed(CITADEL) <= 0 || DTHarass.count(TEMPLAR_ARCHIVES) != 0 || this.counterDragoonRush && DTHarass.count(DRAGOON) <= 15)) {
            return true;
        }
        if (this.detectionNeeded && DTHarass.count(DRAGOON) >= 5 && DTHarass.completed(ROBOTICS_FACILITY) == 1 && DTHarass.count(OBSERVATORY) == 0) {
            return true;
        }
        if (this.detectionNeeded && DTHarass.count(DRAGOON) >= 5 && DTHarass.completed(OBSERVATORY) == 1 && DTHarass.count(OBSERVER) == 0) {
            return true;
        }
        if (this.detectionNeeded && DTHarass.count(ROBOTICS_FACILITY) == 0) {
            return true;
        }
        return this.attackStarted && DTHarass.count(NEXUS) < 3;
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == GATEWAY && !agent.unit.isTraining()) {
            boolean pause = this.pauseProduction();
            if (DTHarass.count(ZEALOT) < (this.counterZealotRush ? 6 : 4) && DTHarass.minerals() >= 100 && !this.counterDragoonRush) {
                agent.unit.build(ZEALOT);
            }
            if (pause && DTHarass.minerals() >= 600) {
                agent.unit.build(ZEALOT);
            } else if (self.completedUnitCount(UnitType.Protoss_Templar_Archives) > 0 && DTHarass.count(DARK_TEMPLAR) < 3 && DTHarass.minerals() >= 125 && DTHarass.gas() >= 100) {
                agent.unit.train(UnitType.Protoss_Dark_Templar);
            } else {
                if (!(DTHarass.completed(TEMPLAR_ARCHIVES) <= 0 || DTHarass.count(DARK_TEMPLAR) != 0 || this.counterDragoonRush && DTHarass.count(DRAGOON) <= 15)) {
                    return true;
                }
                if (!(DTHarass.count(ZEALOT) >= DTHarass.count(DRAGOON) - 5 || DTHarass.minerals() < 100 || DTHarass.minerals() < 400 && pause || this.counterDragoonRush && DTHarass.count(DRAGOON) <= 15)) {
                    agent.unit.build(ZEALOT);
                } else if (DTHarass.minerals() >= 125 && DTHarass.gas() >= 50 && (DTHarass.minerals() >= 400 && DTHarass.gas() > 200 || !pause)) {
                    agent.unit.build(DRAGOON);
                }
            }
            return true;
        }
        if (agent.unit.getType() == FORGE && !agent.unit.isUpgrading()) {
            if (this.pauseProduction()) {
                return true;
            }
            if (this.buildingCannons && DTHarass.count(CANNON) < 2) {
                return true;
            }
            if (DTHarass.minerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && DTHarass.gas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (DTHarass.minerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && DTHarass.gas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else if (agent.unit.getType() == CYBERNETICS_CORE && !agent.unit.isUpgrading()) {
            if (DTHarass.minerals() >= UpgradeType.Singularity_Charge.mineralPrice() && DTHarass.gas() >= UpgradeType.Singularity_Charge.gasPrice() && DTHarass.count(DRAGOON) > 5) {
                agent.unit.upgrade(UpgradeType.Singularity_Charge);
            }
        } else {
            if (agent.unit.getType() == ROBOTICS_FACILITY) {
                if (DTHarass.count(OBSERVER) < 2 && DTHarass.completed(OBSERVATORY) > 0 && DTHarass.minerals() >= 25 && DTHarass.gas() >= 75 && !agent.unit.isTraining()) {
                    agent.unit.build(OBSERVER);
                }
                return true;
            }
            if (agent.unit.getType() == CITADEL && !agent.unit.isUpgrading()) {
                if (DTHarass.gas() >= UpgradeType.Leg_Enhancements.gasPrice() && DTHarass.minerals() >= UpgradeType.Leg_Enhancements.mineralPrice() && DTHarass.count(TEMPLAR_ARCHIVES) > 0 && (DTHarass.completed(TEMPLAR_ARCHIVES) == 0 || DTHarass.count(DARK_TEMPLAR) > 0)) {
                    agent.unit.upgrade(UpgradeType.Leg_Enhancements);
                }
            } else {
                if (agent.unit.getType() == TEMPLAR_ARCHIVES && !agent.unit.isResearching()) {
                    return true;
                }
                if (agent.unit.getType() == STARGATE) {
                    if (DTHarass.completed(ARBITER_TRIBUNAL) > 0 && DTHarass.minerals() >= 100 && DTHarass.gas() >= 350 && !agent.unit.isTraining()) {
                        agent.unit.train(ARBITER);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

