/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.GenericPartFactory;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.CostRequirement;
import com.tyr.requirements.DisjRequirement;
import com.tyr.requirements.LinearMax;
import com.tyr.requirements.TechRequirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.AssignScience;
import com.tyr.tasks.AttackTask;
import com.tyr.tasks.CorsairHarassTask;
import com.tyr.unitgroups.AttackGroup;

public class AntiKill
extends CompositeBuildOrder {
    private int minimumArmySize = 8;
    private int maximumArmySize = 30;
    private boolean delayMarines = false;

    public AntiKill(boolean delayMarines) {
        this.delayMarines = delayMarines;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setWorkersPerGas(1);
        AttackTask.useAntiLurker = true;
        AttackGroup.fearLurkers = true;
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1600));
        this.add(new ExpandPart(true));
        ExpandPart.maximumCcs = 2;
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setCost(100, 0).add(new UnitRequirement(UnitType.Terran_Refinery)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setMax(4).setCost(250, 0).add(new UnitRequirement(UnitType.Terran_Science_Vessel)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Factory).setMax(1).setCost(150, 75).add(new UnitRequirement(UnitType.Terran_Barracks, 1, true)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Factory).setMax(2).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Starport).add(new UnitRequirement(UnitType.Terran_Factory, 1, true)).add(new TechRequirement(TechType.Tank_Siege_Mode, true)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Academy).add(new UnitRequirement(UnitType.Terran_Factory)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Engineering_Bay).add(new UnitRequirement(UnitType.Terran_Factory)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Science_Facility).add(new UnitRequirement(UnitType.Terran_Starport, 1, true)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Armory).add(new UnitRequirement(UnitType.Terran_Siege_Tank_Tank_Mode, 4)).create());
        bot.taskManager.potentialTasks.add(new AssignScience());
        bot.taskManager.potentialTasks.add(new CorsairHarassTask());
        Tyr.bot.groups.remove(Tyr.bot.swarm);
        super.initialize(game, self, bot);
    }

    public void initializeOld(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(this.minimumArmySize);
        Settings.setMaximumSize(this.maximumArmySize);
        Settings.setWorkersPerGas(3);
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1600));
        this.add(new ExpandPart(true));
        ExpandPart.maximumCcs = 2;
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setCost(100, 0).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).create());
        GenericPartFactory barracks2Factory = new GenericPartFactory(UnitType.Terran_Barracks).setMax(2).add(new UnitRequirement(UnitType.Terran_Factory)).setCost(100, 0);
        if (this.delayMarines) {
            barracks2Factory.add(new DisjRequirement().addRequirement(new UnitRequirement(UnitType.Terran_Siege_Tank_Tank_Mode)).addRequirement(new UnitRequirement(UnitType.Terran_Siege_Tank_Siege_Mode))).add(new TechRequirement(TechType.Tank_Siege_Mode, false));
        }
        this.add(barracks2Factory.create());
        GenericPartFactory barracksFactory = new GenericPartFactory(UnitType.Terran_Barracks).setMax(4).setCost(150, 0).add(new LinearMax(UnitType.Terran_Command_Center, UnitType.Terran_Barracks, 3, 0, false)).add(new UnitRequirement(UnitType.Terran_Academy)).add(new UnitRequirement(UnitType.Terran_Factory)).add(new DisjRequirement().addRequirement(new UnitRequirement(UnitType.Terran_Science_Vessel)).addRequirement(new CostRequirement(400, 0)));
        if (this.delayMarines) {
            barracks2Factory.add(new DisjRequirement().addRequirement(new UnitRequirement(UnitType.Terran_Siege_Tank_Tank_Mode)).addRequirement(new UnitRequirement(UnitType.Terran_Siege_Tank_Siege_Mode))).add(new TechRequirement(TechType.Tank_Siege_Mode, false));
        }
        this.add(barracksFactory.create());
        GenericPartFactory academyFactory = new GenericPartFactory(UnitType.Terran_Academy).add(new UnitRequirement(UnitType.Terran_Barracks)).add(new UnitRequirement(UnitType.Terran_Science_Vessel)).add(new UnitRequirement(UnitType.Terran_Refinery)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2));
        this.add(academyFactory.create());
        this.add(new GenericPartFactory(UnitType.Terran_Engineering_Bay).add(new UnitRequirement(UnitType.Terran_Factory)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Factory).setMax(2).setCost(150, 75).add(new UnitRequirement(UnitType.Terran_Barracks, 1, true)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Starport).add(new UnitRequirement(UnitType.Terran_Barracks, 2)).add(new UnitRequirement(UnitType.Terran_Engineering_Bay)).add(new UnitRequirement(UnitType.Terran_Factory, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Science_Facility).add(new UnitRequirement(UnitType.Terran_Barracks, 2)).add(new UnitRequirement(UnitType.Terran_Engineering_Bay)).add(new UnitRequirement(UnitType.Terran_Starport, 1, true)).create());
        bot.taskManager.potentialTasks.add(new AssignScience());
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        int count;
        long time;
        DebugMessages.addMessage("Going bio.");
        StopWatch watch = new StopWatch();
        watch.start();
        super.onFrame(game, self, bot);
        if (UnitTracker.count(UnitType.Terran_Marine) >= 15) {
            Settings.getRequiredSize();
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio super time: " + time);
        }
        if (UnitTracker.count(UnitType.Terran_Starport) > 0 && bot.getAvailableGas() < 400) {
            Settings.setWorkersPerGas(3);
        } else if (UnitTracker.count(UnitType.Terran_Factory) > 0 || UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0) {
            Settings.setWorkersPerGas(2);
        }
        time = watch.time();
        if (time > 55L) {
            DebugMessages.addMessage("Bio tier 1 time: " + time);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Terran_Command_Center) >= 2 && (UnitTracker.count(UnitType.Terran_Refinery) == 0 || UnitTracker.count(UnitType.Terran_Factory) > 0)) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio refinery: " + time + " geyserCount: " + UnitTracker.getGeyserCount());
        }
        if (!(bot.getAvailableMinerals() < 50 || bot.getAvailableMinerals() < 100 && UnitTracker.count(UnitType.Terran_Factory) <= 1 || UnitTracker.count(UnitType.Terran_Factory) < 1 || self.completedUnitCount(UnitType.Terran_Barracks) < 1 || UnitTracker.count(UnitType.Terran_Bunker) >= 2 || UnitTracker.count(UnitType.Terran_Bunker) != 0 && UnitTracker.countTanks() <= 0)) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                count = structures.getUnitCount(UnitType.Terran_Bunker);
                if (count >= 2 || structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 200.0) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio bunker time: " + time);
        }
        if (UnitTracker.count(UnitType.Terran_Engineering_Bay) >= 1 && bot.getAvailableMinerals() >= 75) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                count = structures.getUnitCount(UnitType.Terran_Missile_Turret);
                if (count >= 2 || structures.defences.size() <= 0) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Missile_Turret, structures);
                break;
            }
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio turrets time: " + time);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks) {
            if (UnitTracker.count(UnitType.Terran_Command_Center) < 2 && bot.getAvailableMinerals() < 400) {
                return true;
            }
            if (!(UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) != 0 && (self.isResearching(TechType.Tank_Siege_Mode) || self.hasResearched(TechType.Tank_Siege_Mode)) || bot.getAvailableMinerals() >= 200 || UnitTracker.count(UnitType.Terran_Marine) < (this.delayMarines ? 2 : 5) && bot.getAvailableMinerals() < 300)) {
                return true;
            }
            if (!agent.unit.isTraining() && Tyr.bot.getAvailableGas() >= 25 && Tyr.bot.getAvailableMinerals() >= 50 && self.completedUnitCount(UnitType.Terran_Academy) > 0 && UnitTracker.count(UnitType.Terran_Medic) * 4 < UnitTracker.count(UnitType.Terran_Marine) - 4 * UnitTracker.count(UnitType.Terran_Bunker)) {
                agent.unit.train(UnitType.Terran_Medic);
                return true;
            }
        } else {
            if (agent.unit.getType() == UnitType.Terran_Academy) {
                if (bot.getAvailableGas() >= 150 && bot.getAvailableMinerals() >= 150 && !agent.unit.isResearching()) {
                    agent.unit.upgrade(UpgradeType.U_238_Shells);
                }
                return true;
            }
            if (agent.unit.getType() == UnitType.Terran_Starport) {
                if (UnitTracker.count(UnitType.Terran_Command_Center) < 2 && bot.getAvailableMinerals() < 400) {
                    return true;
                }
                if (UnitTracker.count(UnitType.Terran_Science_Vessel) >= 2 && UnitTracker.countTanks() >= 4 && UnitTracker.count(UnitType.Terran_Armory) == 0) {
                    return true;
                }
                if (agent.unit.getAddon() != null) {
                    if (UnitTracker.count(UnitType.Terran_Science_Vessel) > 0) {
                        if (agent.unit.getAddon() == null && bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50) {
                            agent.unit.buildAddon(UnitType.Terran_Control_Tower);
                        } else if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 400 && bot.getAvailableGas() >= 300 && UnitTracker.count(UnitType.Terran_Physics_Lab) >= 1) {
                            agent.unit.train(UnitType.Terran_Battlecruiser);
                        }
                    } else if (!agent.unit.isTraining() && UnitTracker.count(UnitType.Terran_Science_Facility) > 0 && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 225) {
                        agent.unit.train(UnitType.Terran_Science_Vessel);
                    }
                    return true;
                }
                if (UnitTracker.count(UnitType.Terran_Control_Tower) == 0) {
                    if (UnitTracker.count(UnitType.Terran_Science_Facility) > 0 && bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50) {
                        agent.unit.buildAddon(UnitType.Terran_Control_Tower);
                    }
                    return true;
                }
                return UnitTracker.count(UnitType.Terran_Science_Vessel) == 0;
            }
            if (agent.unit.getType() == UnitType.Terran_Factory) {
                if (UnitTracker.count(UnitType.Terran_Command_Center) < 2 && bot.getAvailableMinerals() < 400) {
                    return true;
                }
                if (UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) < 2) {
                    return false;
                }
                if (!self.hasResearched(TechType.Irradiate) && bot.getAvailableGas() < 350 && UnitTracker.countTanks() >= 4) {
                    return true;
                }
                return UnitTracker.countTanks() >= 4;
            }
            if (agent.unit.getType() == UnitType.Terran_Science_Facility) {
                if (!self.hasResearched(TechType.Irradiate) && bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 200 && UnitTracker.count(UnitType.Terran_Science_Vessel) > 0) {
                    agent.unit.research(TechType.Irradiate);
                    return true;
                }
                if (self.hasResearched(TechType.Irradiate)) {
                    if (!agent.unit.isResearching() && agent.unit.getAddon() == null && bot.getAvailableGas() >= 50 && bot.getAvailableMinerals() >= 50) {
                        agent.unit.buildAddon(UnitType.Terran_Physics_Lab);
                    }
                    return true;
                }
                return false;
            }
            if (agent.unit.getType() == UnitType.Terran_Engineering_Bay) {
                return UnitTracker.count(UnitType.Terran_Science_Vessel) == 0;
            }
        }
        return false;
    }
}

