/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.buildingplacement;

import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.Region;
import com.tyr.BWTAProxy;
import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.BuildSiteLocator;
import com.tyr.buildingplacement.SpaceManager;

public class PylonBuildSite
extends BuildSiteLocator {
    private static final int stopDist = 40;

    @Override
    public TilePosition findPlacement(UnitType building, TilePosition preferredTile, Agent worker) {
        if (building != UnitType.Protoss_Pylon) {
            return null;
        }
        if (preferredTile == null) {
            preferredTile = Tyr.game.isVisible(Tyr.self.getStartLocation()) ? Tyr.self.getStartLocation() : (Tyr.bot.workForce.mineralWorkers.size() > 0 ? Tyr.bot.workForce.mineralWorkers.get((int)0).resourceDepot.getTilePosition() : worker.unit.getTilePosition());
        }
        if (!Tyr.game.isVisible(preferredTile)) {
            return preferredTile;
        }
        return this.getBuildTile(worker.unit, building, preferredTile);
    }

    public TilePosition getBuildTile(Unit builder, UnitType buildingType, TilePosition aroundTile) {
        Region homeRegion = BWTAProxy.getRegion(Tyr.self.getStartLocation());
        int maxDist = 1;
        while (maxDist < 40) {
            int i = aroundTile.getX() - maxDist;
            while (i <= aroundTile.getX() + maxDist) {
                if (i > 3 && i < Tyr.game.mapWidth() - 3) {
                    int j = aroundTile.getY() - maxDist;
                    while (j <= aroundTile.getY() + maxDist) {
                        if ((!BWTAProxy.initialized || BWTAProxy.getRegion(new TilePosition(i, j)) == homeRegion) && j > 3 && j < Tyr.game.mapHeight() - 3 && SpaceManager.canBuildHere(builder, i, j, buildingType, true, true, true)) {
                            return new TilePosition(i, j);
                        }
                        j += 7;
                    }
                }
                i += 8;
            }
            maxDist += 10;
        }
        DebugMessages.addMessage("No placement found for " + buildingType + ".");
        return null;
    }
}

