/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.agents;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Command;
import com.tyr.agents.None;
import com.tyr.agents.VultureAgent;

public class PlaceMine
extends Command {
    private Position target;
    private boolean ordered = false;

    public PlaceMine(Agent agent, Position target) {
        super(agent);
        this.target = target;
    }

    @Override
    public void execute(Game game, Player self, Tyr bot) {
        VultureAgent vulture = (VultureAgent)this.agent;
        if (vulture.isBlocked) {
            this.agent.order(new None(this.agent));
            return;
        }
        game.drawLineMap(vulture.unit.getX(), vulture.unit.getY(), this.target.getX(), this.target.getY(), Color.Orange);
        Tyr.drawCircle(this.target, Color.Orange);
        game.drawTextMap(vulture.unit.getX(), vulture.unit.getY() + 8, vulture.unit.getOrder().toString());
        if (!this.ordered) {
            vulture.placeMine(this.target);
            this.ordered = true;
            return;
        }
        if (vulture.unit.isIdle()) {
            if (vulture.getPlaceMineOrders() >= 10) {
                vulture.isBlocked = true;
            }
            vulture.blockedTimer = -1L;
            vulture.order(new None(vulture));
            return;
        }
    }

    @Override
    public boolean replace(Command command) {
        return true;
    }
}

