/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Color;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyPosition;
import com.tyr.Force;
import com.tyr.ForceTracker;
import com.tyr.Tyr;
import com.tyr.buildingplacement.BuildCommand;
import com.tyr.unitgroups.MineralWorkers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UnitTracker {
    private static HashMap<UnitType, Integer> unitCounts = new HashMap();
    private static HashMap<UnitType, Integer> usableAddOns = new HashMap();
    private static int geyserCount;
    private static int ccCount;
    private static int supplyConstructing;
    private static ArrayList<EnemyPosition> neutralStructures;
    private static int updatedFrame;

    static {
        updatedFrame = -1;
    }

    public static int count(UnitType type) {
        UnitTracker.update();
        if (!unitCounts.containsKey(type)) {
            return 0;
        }
        return unitCounts.get(type);
    }

    public static int usableAddOns(UnitType type) {
        UnitTracker.update();
        if (!usableAddOns.containsKey(type)) {
            return 0;
        }
        return usableAddOns.get(type);
    }

    public static int getCcCount() {
        UnitTracker.update();
        return ccCount;
    }

    public static int getGeyserCount() {
        UnitTracker.update();
        return geyserCount;
    }

    public static int getSupplyConstructing() {
        UnitTracker.update();
        return supplyConstructing;
    }

    public static ArrayList<EnemyPosition> getNeutralStructures() {
        return neutralStructures;
    }

    private static void update() {
        if (Tyr.game.getFrameCount() == updatedFrame) {
            return;
        }
        updatedFrame = Tyr.game.getFrameCount();
        ForceTracker.update();
        for (Force f : ForceTracker.forces) {
            if (f.disabled()) continue;
            Tyr.drawCircle(f.getCenter(), Color.Red, 16);
        }
        if (neutralStructures == null) {
            neutralStructures = new ArrayList();
            for (Unit unit : Tyr.game.getNeutralUnits()) {
                neutralStructures.add(new EnemyPosition(unit.getID(), unit.getType(), unit.getPosition(), true));
            }
        }
        unitCounts = new HashMap();
        usableAddOns = new HashMap();
        ccCount = 0;
        supplyConstructing = 0;
        geyserCount = 0;
        List<Unit> myUnits = Tyr.self.getUnits();
        for (MineralWorkers base : Tyr.bot.workForce.mineralWorkers) {
            if (base.gasWorkers == null || base.resourceDepot.isBeingConstructed() || base.gasWorkers.geyser.getType() != UnitType.Resource_Vespene_Geyser) continue;
            ++geyserCount;
        }
        for (BuildCommand command : Tyr.bot.buildCommands) {
            if (!command.building.isRefinery()) continue;
            --geyserCount;
        }
        if (myUnits == null) {
            DebugMessages.addMessage("Whoops, getUnits is null!");
        } else {
            for (Unit myUnit : myUnits) {
                Unit addOn;
                if (!unitCounts.containsKey(myUnit.getType())) {
                    unitCounts.put(myUnit.getType(), 1);
                } else {
                    unitCounts.put(myUnit.getType(), unitCounts.get(myUnit.getType()) + 1);
                }
                if (myUnit.getType().isResourceDepot()) {
                    ++ccCount;
                }
                if (myUnit.isBeingConstructed() && !myUnit.getType().isResourceDepot()) {
                    supplyConstructing += myUnit.getType().supplyProvided();
                }
                if (myUnit.isMorphing() && myUnit.getBuildType() == UnitType.Zerg_Overlord) {
                    supplyConstructing += UnitType.Zerg_Overlord.supplyProvided();
                }
                if ((addOn = myUnit.getAddon()) == null) continue;
                if (!usableAddOns.containsKey(addOn.getType())) {
                    usableAddOns.put(addOn.getType(), 1);
                    continue;
                }
                usableAddOns.put(addOn.getType(), usableAddOns.get(addOn.getType()) + 1);
            }
        }
        for (BuildCommand command : Tyr.bot.buildCommands) {
            if (!unitCounts.containsKey(command.building)) {
                unitCounts.put(command.building, 1);
            } else {
                unitCounts.put(command.building, unitCounts.get(command.building) + 1);
            }
            if (command.building.isResourceDepot()) {
                ++ccCount;
            }
            if (command.building.isResourceDepot()) continue;
            supplyConstructing += command.building.supplyProvided();
        }
        if (Tyr.bot.wallOff != null) {
            for (BuildCommand command : Tyr.bot.wallOff.underConstruction) {
                if (!unitCounts.containsKey(command.building)) {
                    unitCounts.put(command.building, 1);
                } else {
                    unitCounts.put(command.building, unitCounts.get(command.building) + 1);
                }
                if (command.building.isResourceDepot()) {
                    ++ccCount;
                }
                if (command.building.isResourceDepot()) continue;
                supplyConstructing += command.building.supplyProvided();
            }
        }
    }

    public static int countTanks() {
        return UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode);
    }

    public static void addAddOn(UnitType addOn) {
        if (!usableAddOns.containsKey(addOn)) {
            usableAddOns.put(addOn, 0);
        }
        usableAddOns.put(addOn, usableAddOns.get(addOn) + 1);
    }
}

