/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Position;
import bwta.BaseLocation;
import com.tyr.EnemyManager;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.buildingplacement.SpaceManager;
import java.util.ArrayList;

public class OrderedExpands {
    private ArrayList<Position> orderedExpands;
    private int currentPos;
    private int dir;
    boolean includeIslands;
    boolean includeEnemyMain;
    boolean includeEnemyNatural;

    public OrderedExpands(boolean includeIslands, boolean includeEnemyMain, boolean includeEnemyNatural, boolean clockwise) {
        this.includeIslands = includeIslands;
        this.includeEnemyMain = includeEnemyMain;
        this.includeEnemyNatural = includeEnemyNatural;
        this.dir = clockwise ? -1 : 1;
    }

    public boolean tryInitialize() {
        if (this.orderedExpands != null && this.orderedExpands.size() > 0) {
            return true;
        }
        if (Tyr.bot.suspectedEnemy.size() != 1 && (!this.includeEnemyNatural || this.includeEnemyMain)) {
            return false;
        }
        ArrayList<Position> newOrderedExpands = EnemyManager.getManager().getOrderedExpands();
        if (newOrderedExpands == null || newOrderedExpands.size() == 0) {
            return false;
        }
        this.orderedExpands = new ArrayList();
        for (Position pos : newOrderedExpands) {
            if (!this.includeIslands) {
                boolean isIsland = false;
                for (BaseLocation b : Tyr.bot.expands) {
                    if (!b.isIsland() || PositionUtil.distanceSq(b.getPosition(), pos) > 10000) continue;
                    isIsland = true;
                    break;
                }
                if (isIsland) continue;
            }
            this.orderedExpands.add(pos);
        }
        if (!this.includeEnemyNatural) {
            Position enemyNatural = SpaceManager.getEnemyNatural().getPosition();
            int enemyNat = 0;
            while (enemyNat < this.orderedExpands.size() - 1) {
                if (PositionUtil.distanceSq(enemyNatural, this.orderedExpands.get(enemyNat)) <= 10000) break;
                ++enemyNat;
            }
            this.orderedExpands.remove(enemyNat);
        }
        if (this.includeEnemyMain) {
            this.orderedExpands.add(Tyr.bot.suspectedEnemy.get(0).getPosition());
        }
        int pos = 0;
        while (pos < this.orderedExpands.size()) {
            if (this.orderedExpands.get(pos).getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) <= 100.0) {
                this.currentPos = pos;
                break;
            }
            ++pos;
        }
        return true;
    }

    public Position getPos() {
        return this.orderedExpands.get(this.currentPos);
    }

    public void next() {
        this.currentPos = (this.currentPos + this.dir + this.orderedExpands.size()) % this.orderedExpands.size();
    }

    public void reverseDir() {
        this.dir = -this.dir;
    }
}

