/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import java.awt.Point;
import java.util.ArrayList;
import javabot.JNIBWAPI;
import javabot.JavaBot;
import javabot.managers.BaseManager;
import javabot.managers.BroodlingManager;
import javabot.managers.BuildingManager;
import javabot.managers.BwapiCallsManager;
import javabot.managers.CreepColonyManager;
import javabot.managers.DevourerManager;
import javabot.managers.DroneManager;
import javabot.managers.EnemyBuildingManager;
import javabot.managers.EnemyUnitManager;
import javabot.managers.EvoChamberManager;
import javabot.managers.GreatSpireManager;
import javabot.managers.GuardianManager;
import javabot.managers.HatcheryManager;
import javabot.managers.HydraDenManager;
import javabot.managers.HydraliskManager;
import javabot.managers.LairManager;
import javabot.managers.LarvaManager;
import javabot.managers.MutaliskManager;
import javabot.managers.QueenManager;
import javabot.managers.QueenNestManager;
import javabot.managers.SpawningPoolManager;
import javabot.managers.SpireManager;
import javabot.managers.ZerglingManager;
import javabot.model.Unit;
import javabot.operators.Operators;
import javabot.types.UnitType;

public class UnitManager {
    public Unit unit;
    public int posX;
    public int posY;
    public int typeID;
    JNIBWAPI bwapi;
    int typeBeingConstructed;
    boolean dead;
    public boolean follow;
    public boolean explore;
    public boolean authorizeAttack;
    boolean isABuilding;
    BaseManager base;
    public int count;
    public int countResetAction;
    public int countMaxResetAction;
    public int countDontAct;
    public int nbNemesis = 0;
    public int hp;
    public int radiusDetection = 260;
    public int safeMarge = 0;
    public ArrayList<UnitManager> nearestUnits;
    public ArrayList<EnemyUnitManager> nearestEnemyUnits;
    public boolean attacking;
    public Point retreatPoint;

    public UnitManager(Unit u) {
        this.unit = u;
        this.typeID = u.getTypeID();
        this.bwapi = JavaBot.bwapi;
        this.posX = this.unit.getX();
        this.posY = this.unit.getY();
        this.dead = false;
        this.explore = false;
        this.authorizeAttack = true;
        this.isABuilding = false;
        this.base = null;
        this.follow = true;
        this.count = 0;
        this.countResetAction = 0;
        this.countMaxResetAction = (int)(Math.random() * 200.0 + 1100.0);
        this.countDontAct = 0;
        this.nearestUnits = new ArrayList();
        this.nearestEnemyUnits = new ArrayList();
        this.attacking = false;
        this.retreatPoint = new Point(this.posX, this.posY);
        int distMax = Integer.MAX_VALUE;
        BaseManager bestBase = null;
        for (BaseManager manager : JavaBot.bases) {
            int dist = (int)Math.sqrt((manager.posX - this.posX) * (manager.posX - this.posX) + (manager.posY - this.posY) * (manager.posY - this.posY));
            if (dist >= distMax) continue;
            distMax = dist;
            bestBase = manager;
        }
        this.base = bestBase;
    }

    public void update() {
        this.posX = this.unit.getX();
        this.posY = this.unit.getY();
        this.hp = this.unit.getHitPoints();
        if (!(this.dead || this.unit.isExists() && this.typeID == this.unit.getTypeID())) {
            if (!this.isABuilding) {
                JavaBot.UnitsMap.remove(this.unit.getID());
            } else {
                if (this.base != null) {
                    this.base.buildings.remove(this.unit);
                }
                JavaBot.BuildingsMap.remove(this.unit.getID());
            }
            this.dead = true;
        }
        if (this.count > 0) {
            --this.count;
        }
        if (this.countDontAct > 0) {
            --this.countDontAct;
        }
        if (this.unit.isIdle()) {
            this.count = 0;
        }
        if (!this.dead && !this.isABuilding) {
            JavaBot.unitsExisting.add(this);
        }
    }

    public void drawDebug() {
        this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 8, "DefaultUnit", false);
    }

    public static UnitManager chooseCorrectManager(Unit u) {
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Larva.ordinal()) {
            return new LarvaManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Drone.ordinal()) {
            return new DroneManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Zergling.ordinal()) {
            return new ZerglingManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Hydralisk.ordinal()) {
            return new HydraliskManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Queen.ordinal()) {
            return new QueenManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Mutalisk.ordinal()) {
            return new MutaliskManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Broodling.ordinal()) {
            return new BroodlingManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Guardian.ordinal()) {
            return new GuardianManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Devourer.ordinal()) {
            return new DevourerManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Overlord.ordinal()) {
            return new UnitManager(u);
        }
        return new UnitManager(u);
    }

    public static BuildingManager chooseCorrectBuildingManager(Unit u) {
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Hatchery.ordinal()) {
            JavaBot.repartition.reduceExpandMinerals(300);
            return new HatcheryManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Spawning_Pool.ordinal()) {
            JavaBot.repartition.reduceTechMinerals(200);
            return new SpawningPoolManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Extractor.ordinal()) {
            JavaBot.repartition.reduceTechMinerals(50);
            return new BuildingManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Hydralisk_Den.ordinal()) {
            JavaBot.repartition.reduceTechMinerals(100);
            return new HydraDenManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Lair.ordinal()) {
            JavaBot.repartition.reduceTechMinerals(150);
            return new LairManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Creep_Colony.ordinal()) {
            JavaBot.repartition.reduceCreepMinerals(75);
            return new CreepColonyManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Sunken_Colony.ordinal()) {
            JavaBot.repartition.reduceSunkenMinerals(50);
            return new BuildingManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Spore_Colony.ordinal()) {
            JavaBot.repartition.reduceSunkenMinerals(50);
            return new BuildingManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Queens_Nest.ordinal()) {
            JavaBot.repartition.reduceTechMinerals(150);
            return new QueenNestManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Spire.ordinal()) {
            JavaBot.repartition.reduceTechMinerals(200);
            return new SpireManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Greater_Spire.ordinal()) {
            JavaBot.repartition.reduceTechMinerals(100);
            return new GreatSpireManager(u);
        }
        if (u.getTypeID() == UnitType.UnitTypes.Zerg_Evolution_Chamber.ordinal()) {
            JavaBot.repartition.reduceTechMinerals(75);
            return new EvoChamberManager(u);
        }
        return new BuildingManager(u);
    }

    public void attackRandom() {
        ++this.countResetAction;
        if (!this.authorizeAttack && this.countDontAct >= 5) {
            this.authorizeAttack = true;
            this.countDontAct = 0;
        }
        if (!this.authorizeAttack && this.countDontAct < 5) {
            ++this.countDontAct;
        }
        if (this.authorizeAttack) {
            if (this.countResetAction > this.countMaxResetAction) {
                if (BwapiCallsManager.stop(this.unit.getID())) {
                    this.countResetAction = 0;
                    this.authorizeAttack = false;
                    this.explore = false;
                    this.countDontAct = 0;
                }
            } else if ((this.explore || this.unit.isIdle()) && JavaBot.enemyBuildingsManager.size() > 0) {
                int iterBuilding = (int)(Math.random() * (double)JavaBot.enemyBuildingsManager.size());
                if (iterBuilding >= JavaBot.enemyBuildingsManager.size()) {
                    --iterBuilding;
                }
                if (iterBuilding < 0) {
                    iterBuilding = 0;
                }
                EnemyBuildingManager buildingToAttack = JavaBot.enemyBuildingsManager.get(iterBuilding);
                if (BwapiCallsManager.attack(this.unit.getID(), buildingToAttack.posX, buildingToAttack.posY)) {
                    this.explore = false;
                    this.countResetAction = 0;
                    this.authorizeAttack = false;
                    this.countDontAct = 0;
                }
            } else if (this.unit.isIdle()) {
                if (Math.random() < 0.5) {
                    for (BaseManager baseM : JavaBot.bases) {
                        if (baseM.state == BaseManager.BaseState.FRIENDLY || !baseM.baseLocation.isStartLocation() || !(Math.random() < 0.3)) continue;
                        if (BwapiCallsManager.attack(this.unit.getID(), baseM.posX, baseM.posY)) {
                            this.explore = true;
                            this.countResetAction = 0;
                            this.authorizeAttack = false;
                            this.countDontAct = 0;
                        }
                        break;
                    }
                } else {
                    int randX = (int)(Math.random() * ((double)this.bwapi.getMap().getWidth() * 32.0));
                    int randY = (int)(Math.random() * ((double)this.bwapi.getMap().getHeight() * 32.0));
                    if (BwapiCallsManager.attack(this.unit.getID(), randX, randY)) {
                        this.explore = true;
                        this.countResetAction = 0;
                        this.authorizeAttack = false;
                        this.countDontAct = 0;
                    }
                }
            }
        }
    }

    public boolean nearbyDetector() {
        for (EnemyUnitManager enemy : JavaBot.enemyUnitsDetectorManager) {
            if (Operators.distance(this.posX, this.posY, enemy.posX, enemy.posY) >= enemy.range) continue;
            return true;
        }
        for (EnemyBuildingManager enemyB : JavaBot.enemyBuildingsDetectorManager) {
            if (Operators.distance(this.posX, this.posY, enemyB.posX, enemyB.posY) >= enemyB.range) continue;
            return true;
        }
        return false;
    }

    public boolean nearbyGroundEnemy(int safeMarge) {
        for (EnemyUnitManager enemy : JavaBot.enemyUnitsGroundManager) {
            if (Operators.distance(this.posX, this.posY, enemy.posX, enemy.posY) >= enemy.range + safeMarge) continue;
            return true;
        }
        for (EnemyBuildingManager enemyB : JavaBot.enemyBuildingsGroundManager) {
            if (Operators.distance(this.posX, this.posY, enemyB.posX, enemyB.posY) >= enemyB.range + safeMarge) continue;
            return true;
        }
        return false;
    }

    public boolean nearbyAirEnemy() {
        for (EnemyUnitManager enemy : JavaBot.enemyUnitsAirManager) {
            if (Operators.distance(this.posX, this.posY, enemy.posX, enemy.posY) >= enemy.range) continue;
            return true;
        }
        for (EnemyBuildingManager enemyB : JavaBot.enemyBuildingsAirManager) {
            if (Operators.distance(this.posX, this.posY, enemyB.posX, enemyB.posY) >= enemyB.range) continue;
            return true;
        }
        return false;
    }

    public static EnemyBuildingManager existsBuilding(int x, int y, ArrayList<EnemyBuildingManager> enemyBuildingsManager) {
        for (EnemyBuildingManager building : enemyBuildingsManager) {
            if (building.posX != x || building.posY != y) continue;
            return building;
        }
        return null;
    }

    public static enum UPGRADE_STATES {
        NONE,
        EVOLVING,
        FINISHED;

    }
}

