/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import javabot.JavaBot;
import javabot.managers.BwapiCallsManager;
import javabot.managers.ControlTower;
import javabot.managers.EnemyBuildingManager;
import javabot.managers.EnemyUnitManager;
import javabot.managers.UnitManager;
import javabot.model.Unit;
import javabot.operators.Operators;

public class DevourerManager
extends UnitManager {
    public boolean occupied = false;

    public DevourerManager(Unit u) {
        super(u);
        this.explore = true;
    }

    @Override
    public void update() {
        super.update();
        this.safeMarge = (250 - this.hp) / 2;
        if (this.unit.isIdle() && this.occupied) {
            this.occupied = false;
        }
        ControlTower.devourers.add(this);
        if (this.unit.isIdle() && this.countDontAct == 0) {
            if (Math.random() < 0.7 && JavaBot.enemyBuildingsAirTargetManager.size() > 0) {
                int iterUnit = (int)(Math.random() * (double)JavaBot.enemyBuildingsAirTargetManager.size());
                if (iterUnit >= JavaBot.enemyBuildingsAirTargetManager.size()) {
                    --iterUnit;
                }
                if (iterUnit < 0) {
                    iterUnit = 0;
                }
                EnemyBuildingManager unitToAttack = JavaBot.enemyBuildingsAirTargetManager.get(iterUnit);
                if (BwapiCallsManager.attack(this.unit.getID(), unitToAttack.posX, unitToAttack.posY)) {
                    this.countDontAct = 1;
                }
            } else if (Math.random() < 0.9 && JavaBot.enemyUnitsAirTargetManager.size() > 0) {
                int iterUnit = (int)(Math.random() * (double)JavaBot.enemyUnitsAirTargetManager.size());
                if (iterUnit >= JavaBot.enemyUnitsAirTargetManager.size()) {
                    --iterUnit;
                }
                if (iterUnit < 0) {
                    iterUnit = 0;
                }
                EnemyUnitManager unitToAttack = JavaBot.enemyUnitsAirTargetManager.get(iterUnit);
                if (BwapiCallsManager.attack(this.unit.getID(), unitToAttack.posX, unitToAttack.posY)) {
                    this.countDontAct = 1;
                }
            } else if (Math.random() < 0.5 && ControlTower.posX != -1 && Operators.distance(this.posX, this.posY, ControlTower.posX, ControlTower.posY) > ControlTower.radius + 100) {
                if (BwapiCallsManager.attack(this.unit.getID(), ControlTower.posX + (int)(Math.random() * 100.0) - 50, ControlTower.posY + (int)(Math.random() * 100.0) - 50)) {
                    this.countDontAct = 1;
                }
            } else {
                int randX = (int)(Math.random() * ((double)this.bwapi.getMap().getWidth() * 32.0));
                int randY = (int)(Math.random() * ((double)this.bwapi.getMap().getHeight() * 32.0));
                if (BwapiCallsManager.attack(this.unit.getID(), randX, randY)) {
                    this.countDontAct = 1;
                }
            }
        }
        if (this.countDontAct == 0) {
            this.dodgeEnemies();
        }
    }

    private void dodgeEnemies() {
        int posYtoGo;
        int posXtoGo;
        int dy;
        int dx;
        for (EnemyUnitManager enemyUnitManager : JavaBot.enemyUnitsAirManager) {
            if (enemyUnitManager.isAir || Operators.distance(this.posX, this.posY, enemyUnitManager.posX, enemyUnitManager.posY) >= enemyUnitManager.range + this.safeMarge) continue;
            dx = this.posX - enemyUnitManager.posX;
            dy = this.posY - enemyUnitManager.posY;
            if (dx > 60) {
                dx = 60;
            }
            if (dx < -60) {
                dx = -60;
            }
            if (dy > 60) {
                dy = 60;
            }
            if (dy < -60) {
                dy = -60;
            }
            posXtoGo = this.posX + dx;
            posYtoGo = this.posY + dy;
            if (!BwapiCallsManager.move(this.unit.getID(), posXtoGo, posYtoGo)) break;
            this.countDontAct = 8;
            break;
        }
        if (this.countDontAct == 0) {
            for (EnemyBuildingManager enemyBuildingManager : JavaBot.enemyBuildingsAirManager) {
                if (Operators.distance(this.posX, this.posY, enemyBuildingManager.posX, enemyBuildingManager.posY) >= enemyBuildingManager.range + this.safeMarge) continue;
                dx = this.posX - enemyBuildingManager.posX;
                dy = this.posY - enemyBuildingManager.posY;
                if (dx > 60) {
                    dx = 60;
                }
                if (dx < -60) {
                    dx = -60;
                }
                if (dy > 60) {
                    dy = 60;
                }
                if (dy < -60) {
                    dy = -60;
                }
                posXtoGo = this.posX + dx;
                posYtoGo = this.posY + dy;
                if (!BwapiCallsManager.move(this.unit.getID(), posXtoGo, posYtoGo)) break;
                this.countDontAct = 8;
                break;
            }
        }
    }

    @Override
    public void drawDebug() {
    }
}

