/*
 * Decompiled with CFR 0.152.
 */
package javabot.knowledge;

import java.awt.Point;
import javabot.JNIBWAPI;
import javabot.JavaBot;
import javabot.knowledge.Tech;
import javabot.model.Unit;
import javabot.operators.Operators;
import javabot.types.UnitType;

public class GlobalKnowledge {
    String[] unitNames;
    public int[] currentUnits;
    public int[] warpingUnits;
    public int[] requestedUnits;
    String[] buildingNames;
    public int[] currentBuildings;
    public int[] warpingBuildings;
    public int[] requestedBuildings;
    public int realMinerals;
    public int realGas;
    public int minerals;
    public int gas;
    public int supplyUsed;
    public int supplyMax;
    public int timerTryExpand;
    public int timerTryMacro;
    public int timerTryPool;
    public int timerTryExtractor;
    public int timerTryHydra;
    public int timerTryQueenNest;
    public int timerTrySpire;
    public int timerMorphMutalisk;
    public int timerTryEvo;
    public boolean requestMacro;
    public boolean okExtractors;
    int nbUnits = 10;
    int nbBuildings = 13;
    JNIBWAPI bwapi = JavaBot.bwapi;

    public GlobalKnowledge() {
        this.unitNames = new String[this.nbUnits];
        this.currentUnits = new int[this.nbUnits];
        this.warpingUnits = new int[this.nbUnits];
        this.requestedUnits = new int[this.nbUnits];
        this.buildingNames = new String[this.nbBuildings];
        this.currentBuildings = new int[this.nbBuildings];
        this.warpingBuildings = new int[this.nbBuildings];
        this.requestedBuildings = new int[this.nbBuildings];
        int i = 0;
        while (i < this.nbUnits) {
            this.unitNames[i] = Operators.stringFromType(Operators.unitTypeFromIter(i));
            this.currentUnits[i] = 0;
            this.warpingUnits[i] = 0;
            this.requestedUnits[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.nbBuildings) {
            this.buildingNames[i] = Operators.stringFromType(Operators.buildingTypeFromIter(i));
            this.currentBuildings[i] = 0;
            this.warpingBuildings[i] = 0;
            this.requestedBuildings[i] = 0;
            ++i;
        }
        this.realMinerals = 0;
        this.realGas = 0;
        this.minerals = 0;
        this.gas = 0;
        this.supplyUsed = 0;
        this.supplyMax = 0;
        this.timerTryExpand = 10;
        this.timerTryMacro = 10;
        this.timerTryPool = 10;
        this.timerTryExtractor = 10;
        this.timerTryHydra = 10;
        this.timerTryQueenNest = 10;
        this.timerTrySpire = 10;
        this.timerTryEvo = 10;
        this.timerMorphMutalisk = 1;
        this.requestMacro = false;
        this.okExtractors = false;
    }

    public void update() {
        this.realMinerals = this.bwapi.getSelf().getMinerals();
        this.realGas = this.bwapi.getSelf().getGas();
        this.minerals = this.realMinerals;
        this.gas = this.realGas;
        this.supplyUsed = this.bwapi.getSelf().getSupplyUsed();
        this.supplyMax = this.bwapi.getSelf().getSupplyTotal();
        if (this.timerTryExpand > 0) {
            --this.timerTryExpand;
        }
        if (this.timerTryMacro > 0) {
            --this.timerTryMacro;
        }
        if (this.timerTryPool > 0) {
            --this.timerTryPool;
        }
        if (this.timerTryExtractor > 0) {
            --this.timerTryExtractor;
        }
        if (this.timerTryHydra > 0) {
            --this.timerTryHydra;
        }
        if (this.timerTryQueenNest > 0) {
            --this.timerTryQueenNest;
        }
        if (this.timerTrySpire > 0) {
            --this.timerTrySpire;
        }
        if (this.timerMorphMutalisk > 0) {
            --this.timerMorphMutalisk;
        }
        if (this.timerTryEvo > 0) {
            --this.timerTryEvo;
        }
        int i = 0;
        while (i < this.nbUnits) {
            this.currentUnits[i] = 0;
            this.warpingUnits[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.nbBuildings) {
            this.currentBuildings[i] = 0;
            this.warpingBuildings[i] = 0;
            ++i;
        }
        if (!(this.okExtractors || JavaBot.currFrame < 3400 && JavaBot.strategy.nbHatcheryTotal < 2)) {
            this.okExtractors = true;
        }
    }

    public void debug() {
        this.bwapi.drawText(new Point(5, 53), "Units      Current  Warping  Requested", true);
        int i = 0;
        while (i < this.nbUnits) {
            this.bwapi.drawText(5, 61 + i * 8, this.unitNames[i], true);
            this.bwapi.drawText(new Point(70, 61 + i * 8), "" + this.currentUnits[i], true);
            this.bwapi.drawText(new Point(115, 61 + i * 8), "" + this.warpingUnits[i], true);
            this.bwapi.drawText(new Point(170, 61 + i * 8), "" + this.requestedUnits[i], true);
            ++i;
        }
        this.bwapi.drawText(new Point(5, 142), "Buildings  Current  Warping  Requested", true);
        i = 0;
        while (i < this.nbBuildings) {
            this.bwapi.drawText(5, 150 + i * 8, this.buildingNames[i], true);
            this.bwapi.drawText(new Point(70, 150 + i * 8), "" + this.currentBuildings[i], true);
            this.bwapi.drawText(new Point(115, 150 + i * 8), "" + this.warpingBuildings[i], true);
            this.bwapi.drawText(new Point(170, 150 + i * 8), "" + this.requestedBuildings[i], true);
            ++i;
        }
        this.bwapi.drawText(new Point(220, 5), "Minerals: " + this.minerals, true);
        this.bwapi.drawText(new Point(220, 15), "Gas: " + this.gas, true);
        this.bwapi.drawText(new Point(220, 25), "Supply: " + this.supplyUsed + "/" + this.supplyMax, true);
        this.bwapi.drawText(new Point(220, 80), "Try expand: " + this.timerTryExpand, true);
        this.bwapi.drawText(new Point(220, 90), "Try Evo: " + this.timerTryEvo, true);
        this.bwapi.drawText(new Point(220, 100), "Macro asked: " + this.requestMacro, true);
        Tech.debug(70);
    }

    public void addUnit(Unit unit) {
        int TypeId = unit.getTypeID();
        if (Operators.isAbuilding(TypeId)) {
            if (unit.getRemainingBuildTimer() > 0) {
                int n = Operators.buildingIterFromType(TypeId);
                this.warpingBuildings[n] = this.warpingBuildings[n] + 1;
            } else {
                int n = Operators.buildingIterFromType(TypeId);
                this.currentBuildings[n] = this.currentBuildings[n] + 1;
            }
        } else if (unit.getTypeID() == UnitType.UnitTypes.Zerg_Egg.ordinal() || unit.getTypeID() == UnitType.UnitTypes.Zerg_Cocoon.ordinal()) {
            int n = Operators.unitIterFromType(unit.getBuildTypeID());
            this.warpingUnits[n] = this.warpingUnits[n] + 1;
        } else if (unit.getRemainingBuildTimer() > 0) {
            int n = Operators.unitIterFromType(TypeId);
            this.warpingUnits[n] = this.warpingUnits[n] + 1;
        } else {
            int n = Operators.unitIterFromType(TypeId);
            this.currentUnits[n] = this.currentUnits[n] + 1;
        }
    }

    public int enoughMineralsforZerglings() {
        if (JavaBot.strategy.nbZerglingsTotal < 1) {
            return JavaBot.repartition.unitsMinerals + JavaBot.repartition.techMinerals;
        }
        return JavaBot.repartition.unitsMinerals;
    }

    public int enoughMineralsforHydralisks() {
        if (JavaBot.strategy.nbHydralisksTotal < 1) {
            return JavaBot.repartition.unitsMinerals + JavaBot.repartition.techMinerals;
        }
        return JavaBot.repartition.unitsMinerals;
    }

    public int enoughGasforHydralisks() {
        if (JavaBot.strategy.nbHydralisksTotal < JavaBot.strategy.idealNbHydras / 4) {
            return JavaBot.repartition.unitsGas + JavaBot.repartition.techGas;
        }
        return JavaBot.repartition.unitsGas;
    }

    public int enoughMineralsforMutalisks() {
        if (JavaBot.strategy.nbMutalisksTotal + JavaBot.strategy.nbGuardiansTotal + JavaBot.strategy.nbDevourersTotal < (JavaBot.strategy.idealNbMutalisks + JavaBot.strategy.idealNbGuardians + JavaBot.strategy.idealNbDevourers) / 5 + 1) {
            return JavaBot.repartition.unitsMinerals + JavaBot.repartition.techMinerals + JavaBot.repartition.expandMinerals;
        }
        return JavaBot.repartition.unitsMinerals;
    }

    public int enoughGasforMutalisks() {
        if (JavaBot.strategy.nbMutalisksTotal + JavaBot.strategy.nbGuardiansTotal + JavaBot.strategy.nbDevourersTotal < (JavaBot.strategy.idealNbMutalisks + JavaBot.strategy.idealNbGuardians + JavaBot.strategy.idealNbDevourers) / 4 || Tech.blockGroundAttackUpgrade > 0 || Tech.blockGroundDefenseUpgrade > 0 || Tech.blockGroundMissileUpgrade > 0) {
            return JavaBot.repartition.unitsGas + JavaBot.repartition.techGas;
        }
        return JavaBot.repartition.unitsGas;
    }

    public int enoughMineralsforQueens() {
        if (JavaBot.strategy.nbQueensTotal < JavaBot.strategy.idealNbQueens / 4 + 1) {
            return JavaBot.repartition.unitsMinerals + JavaBot.repartition.techMinerals + JavaBot.repartition.expandMinerals;
        }
        return JavaBot.repartition.unitsMinerals;
    }

    public int enoughGasforQueens() {
        if (JavaBot.strategy.nbQueensTotal < JavaBot.strategy.idealNbQueens / 4 || Tech.blockGroundAttackUpgrade > 0 || Tech.blockGroundDefenseUpgrade > 0 || Tech.blockGroundMissileUpgrade > 0) {
            return JavaBot.repartition.unitsGas + JavaBot.repartition.techGas;
        }
        return JavaBot.repartition.unitsGas;
    }
}

