/*
 * Decompiled with CFR 0.152.
 */
package javabot.knowledge;

import java.util.HashMap;
import javabot.JavaBot;
import javabot.managers.EnemyUnitManager;
import javabot.types.UnitType;

public class ArmyComposition {
    private HashMap<Integer, int[]> compositionReaction = new HashMap();
    double Z;
    int Z2;
    double H;
    int H2;
    double Q;
    int Q2;
    double M;
    int M2;
    double G;
    int G2;
    double D;
    int D2;
    int F;
    int F2;
    int U;
    int U2;
    int S;
    int S2;
    int L;
    int L2;
    double nbZsupp;
    double nbHsupp;
    double nbQsupp;
    double nbMsupp;
    double nbGsupp;
    double nbDsupp;
    double nbFsupp;
    double nbUsupp;
    double nbSsupp;
    double nbLsupp;
    public int coefficient;
    public int coefficient2;

    public ArmyComposition() {
        int[] nArray = new int[10];
        nArray[0] = 10;
        nArray[1] = 15;
        nArray[3] = 5;
        nArray[4] = 70;
        this.compositionReaction.put(UnitType.UnitTypes.Terran_Marine.ordinal(), nArray);
        int[] nArray2 = new int[10];
        nArray2[1] = 40;
        nArray2[3] = 40;
        nArray2[4] = 20;
        this.compositionReaction.put(UnitType.UnitTypes.Terran_Firebat.ordinal(), nArray2);
        int[] nArray3 = new int[10];
        nArray3[1] = 10;
        nArray3[2] = 40;
        nArray3[4] = 50;
        this.compositionReaction.put(UnitType.UnitTypes.Terran_Medic.ordinal(), nArray3);
        int[] nArray4 = new int[10];
        nArray4[1] = 50;
        nArray4[2] = 40;
        nArray4[4] = 10;
        this.compositionReaction.put(UnitType.UnitTypes.Terran_Ghost.ordinal(), nArray4);
        int[] nArray5 = new int[10];
        nArray5[1] = 40;
        nArray5[2] = 5;
        nArray5[3] = 40;
        nArray5[4] = 15;
        this.compositionReaction.put(UnitType.UnitTypes.Terran_Vulture.ordinal(), nArray5);
        int[] nArray6 = new int[10];
        nArray6[0] = 5;
        nArray6[1] = 20;
        nArray6[2] = 70;
        nArray6[4] = 5;
        this.compositionReaction.put(UnitType.UnitTypes.Terran_Goliath.ordinal(), nArray6);
        int[] nArray7 = new int[10];
        nArray7[2] = 80;
        nArray7[3] = 10;
        nArray7[4] = 10;
        this.compositionReaction.put(UnitType.UnitTypes.Terran_Siege_Tank_Siege_Mode.ordinal(), nArray7);
        int[] nArray8 = new int[10];
        nArray8[2] = 80;
        nArray8[3] = 10;
        nArray8[4] = 10;
        this.compositionReaction.put(UnitType.UnitTypes.Terran_Siege_Tank_Tank_Mode.ordinal(), nArray8);
        int[] nArray9 = new int[10];
        nArray9[1] = 50;
        nArray9[3] = 10;
        nArray9[5] = 40;
        this.compositionReaction.put(UnitType.UnitTypes.Terran_Wraith.ordinal(), nArray9);
        int[] nArray10 = new int[10];
        nArray10[1] = 80;
        nArray10[5] = 20;
        this.compositionReaction.put(UnitType.UnitTypes.Terran_Valkyrie.ordinal(), nArray10);
        int[] nArray11 = new int[10];
        nArray11[1] = 50;
        nArray11[5] = 50;
        this.compositionReaction.put(UnitType.UnitTypes.Terran_Science_Vessel.ordinal(), nArray11);
        int[] nArray12 = new int[10];
        nArray12[1] = 60;
        nArray12[5] = 40;
        this.compositionReaction.put(UnitType.UnitTypes.Terran_Battlecruiser.ordinal(), nArray12);
        int[] nArray13 = new int[10];
        nArray13[3] = 90;
        nArray13[4] = 10;
        this.compositionReaction.put(UnitType.UnitTypes.Zerg_Zergling.ordinal(), nArray13);
        int[] nArray14 = new int[10];
        nArray14[0] = 40;
        nArray14[1] = 10;
        nArray14[2] = 5;
        nArray14[3] = 30;
        nArray14[4] = 15;
        this.compositionReaction.put(UnitType.UnitTypes.Zerg_Hydralisk.ordinal(), nArray14);
        int[] nArray15 = new int[10];
        nArray15[1] = 20;
        nArray15[3] = 40;
        nArray15[5] = 40;
        this.compositionReaction.put(UnitType.UnitTypes.Zerg_Mutalisk.ordinal(), nArray15);
        int[] nArray16 = new int[10];
        nArray16[1] = 100;
        this.compositionReaction.put(UnitType.UnitTypes.Zerg_Scourge.ordinal(), nArray16);
        int[] nArray17 = new int[10];
        nArray17[1] = 10;
        nArray17[3] = 70;
        nArray17[5] = 20;
        this.compositionReaction.put(UnitType.UnitTypes.Zerg_Queen.ordinal(), nArray17);
        int[] nArray18 = new int[10];
        nArray18[2] = 90;
        nArray18[3] = 5;
        nArray18[4] = 5;
        this.compositionReaction.put(UnitType.UnitTypes.Zerg_Ultralisk.ordinal(), nArray18);
        int[] nArray19 = new int[10];
        nArray19[0] = 60;
        nArray19[2] = 40;
        this.compositionReaction.put(UnitType.UnitTypes.Zerg_Defiler.ordinal(), nArray19);
        int[] nArray20 = new int[10];
        nArray20[1] = 10;
        nArray20[3] = 80;
        nArray20[5] = 10;
        this.compositionReaction.put(UnitType.UnitTypes.Zerg_Guardian.ordinal(), nArray20);
        int[] nArray21 = new int[10];
        nArray21[1] = 90;
        nArray21[5] = 10;
        this.compositionReaction.put(UnitType.UnitTypes.Zerg_Devourer.ordinal(), nArray21);
        int[] nArray22 = new int[10];
        nArray22[2] = 70;
        nArray22[3] = 15;
        nArray22[4] = 15;
        this.compositionReaction.put(UnitType.UnitTypes.Zerg_Lurker.ordinal(), nArray22);
        int[] nArray23 = new int[10];
        nArray23[3] = 80;
        nArray23[4] = 20;
        this.compositionReaction.put(UnitType.UnitTypes.Protoss_Zealot.ordinal(), nArray23);
        int[] nArray24 = new int[10];
        nArray24[0] = 15;
        nArray24[1] = 15;
        nArray24[2] = 60;
        nArray24[3] = 5;
        nArray24[4] = 5;
        this.compositionReaction.put(UnitType.UnitTypes.Protoss_Dragoon.ordinal(), nArray24);
        int[] nArray25 = new int[10];
        nArray25[2] = 80;
        nArray25[4] = 20;
        this.compositionReaction.put(UnitType.UnitTypes.Protoss_High_Templar.ordinal(), nArray25);
        int[] nArray26 = new int[10];
        nArray26[2] = 50;
        nArray26[3] = 30;
        nArray26[4] = 20;
        this.compositionReaction.put(UnitType.UnitTypes.Protoss_Dark_Templar.ordinal(), nArray26);
        int[] nArray27 = new int[10];
        nArray27[1] = 80;
        nArray27[4] = 20;
        this.compositionReaction.put(UnitType.UnitTypes.Protoss_Archon.ordinal(), nArray27);
        int[] nArray28 = new int[10];
        nArray28[0] = 45;
        nArray28[1] = 45;
        nArray28[4] = 10;
        this.compositionReaction.put(UnitType.UnitTypes.Protoss_Dark_Archon.ordinal(), nArray28);
        int[] nArray29 = new int[10];
        nArray29[3] = 80;
        nArray29[4] = 20;
        this.compositionReaction.put(UnitType.UnitTypes.Protoss_Reaver.ordinal(), nArray29);
        int[] nArray30 = new int[10];
        nArray30[1] = 80;
        nArray30[3] = 10;
        nArray30[5] = 10;
        this.compositionReaction.put(UnitType.UnitTypes.Protoss_Scout.ordinal(), nArray30);
        int[] nArray31 = new int[10];
        nArray31[1] = 70;
        nArray31[5] = 30;
        this.compositionReaction.put(UnitType.UnitTypes.Protoss_Corsair.ordinal(), nArray31);
        int[] nArray32 = new int[10];
        nArray32[1] = 60;
        nArray32[3] = 10;
        nArray32[5] = 30;
        this.compositionReaction.put(UnitType.UnitTypes.Protoss_Arbiter.ordinal(), nArray32);
        int[] nArray33 = new int[10];
        nArray33[1] = 90;
        nArray33[5] = 10;
        this.compositionReaction.put(UnitType.UnitTypes.Protoss_Carrier.ordinal(), nArray33);
    }

    public void update() {
        if (this.coefficient > 0 && JavaBot.currFrame % 100 == 0) {
            --this.coefficient;
        }
        this.computeTotal();
    }

    public void add(int z, int h, int q, int m, int g, int d, int f, int u, int s, int l) {
        this.Z2 += z;
        this.H2 += h;
        this.Q2 += q;
        this.M2 += m;
        this.G2 += g;
        this.D2 += d;
        this.F2 += f;
        this.U2 += u;
        this.S2 += s;
        this.L2 += l;
        ++this.coefficient2;
    }

    public void computeTotal() {
        if (this.coefficient == 0 && this.coefficient2 == 0) {
            this.coefficient = 1;
            this.nbZsupp = 40.0;
            this.nbHsupp = 40.0;
            this.nbQsupp = 10.0;
            this.nbMsupp = 18.0;
            this.nbGsupp = 12.0;
            this.nbDsupp = 4.0;
            this.nbFsupp = 0.0;
            this.nbUsupp = 0.0;
            this.nbSsupp = 0.0;
            this.nbLsupp = 0.0;
        } else if (this.coefficient2 != 0) {
            this.Z = (this.Z * (double)this.coefficient + (double)this.Z2) / (double)(this.coefficient + this.coefficient2);
            this.H = (this.H * (double)this.coefficient + (double)this.H2) / (double)(this.coefficient + this.coefficient2);
            this.Q = (this.Q * (double)this.coefficient + (double)this.Q2) / (double)(this.coefficient + this.coefficient2);
            this.M = (this.M * (double)this.coefficient + (double)this.M2) / (double)(this.coefficient + this.coefficient2);
            this.G = (this.G * (double)this.coefficient + (double)this.G2) / (double)(this.coefficient + this.coefficient2);
            this.D = (this.D * (double)this.coefficient + (double)this.D2) / (double)(this.coefficient + this.coefficient2);
            this.nbZsupp = 1.24 * this.Z;
            this.nbHsupp = 1.24 * this.H;
            this.nbQsupp = 1.24 * this.Q;
            this.nbMsupp = 1.24 * this.M;
            this.nbGsupp = 1.24 * this.G;
            this.nbDsupp = 1.24 * this.D;
            this.nbFsupp = 1.24 * (double)this.F;
            this.nbUsupp = 1.24 * (double)this.U;
            this.nbSsupp = 1.24 * (double)this.S;
            this.nbLsupp = 1.24 * (double)this.L;
            if (this.coefficient2 > this.coefficient) {
                this.coefficient = this.coefficient2;
            }
        }
        this.newComposition();
    }

    public void newComposition() {
        boolean goUp;
        int nbDsuppInt;
        int nbGsuppInt;
        int nbMsuppInt;
        int nbQsuppInt;
        int nbHsuppInt;
        int nbZsuppInt;
        double totalPop = this.nbZsupp + this.nbHsupp + this.nbQsupp + this.nbMsupp + this.nbGsupp + this.nbDsupp;
        if (totalPop > 124.0) {
            nbZsuppInt = (int)Math.floor(this.nbZsupp);
            nbHsuppInt = (int)Math.floor(this.nbHsupp);
            nbQsuppInt = (int)Math.floor(this.nbQsupp);
            nbMsuppInt = (int)Math.floor(this.nbMsupp);
            nbGsuppInt = (int)Math.floor(this.nbGsupp);
            nbDsuppInt = (int)Math.floor(this.nbDsupp);
        } else {
            nbZsuppInt = (int)Math.ceil(this.nbZsupp);
            nbHsuppInt = (int)Math.ceil(this.nbHsupp);
            nbQsuppInt = (int)Math.ceil(this.nbQsupp);
            nbMsuppInt = (int)Math.ceil(this.nbMsupp);
            nbGsuppInt = (int)Math.ceil(this.nbGsupp);
            nbDsuppInt = (int)Math.ceil(this.nbDsupp);
        }
        int totalPopInt = nbZsuppInt + nbHsuppInt + nbQsuppInt + nbMsuppInt + nbGsuppInt + nbDsuppInt;
        boolean bl = goUp = totalPopInt < 124;
        if (nbQsuppInt % 2 == 1) {
            nbQsuppInt = goUp ? ++nbQsuppInt : --nbQsuppInt;
        }
        boolean bl2 = goUp = (totalPopInt = nbZsuppInt + nbHsuppInt + nbQsuppInt + nbMsuppInt + nbGsuppInt + nbDsuppInt) < 124;
        if (nbMsuppInt % 2 == 1) {
            nbMsuppInt = goUp ? ++nbMsuppInt : --nbMsuppInt;
        }
        boolean bl3 = goUp = (totalPopInt = nbZsuppInt + nbHsuppInt + nbQsuppInt + nbMsuppInt + nbGsuppInt + nbDsuppInt) < 124;
        if (nbGsuppInt % 2 == 1) {
            nbGsuppInt = goUp ? ++nbGsuppInt : --nbGsuppInt;
        }
        boolean bl4 = goUp = (totalPopInt = nbZsuppInt + nbHsuppInt + nbQsuppInt + nbMsuppInt + nbGsuppInt + nbDsuppInt) < 124;
        if (nbDsuppInt % 2 == 1) {
            nbDsuppInt = goUp ? ++nbDsuppInt : --nbDsuppInt;
        }
        totalPopInt = nbZsuppInt + nbHsuppInt + nbQsuppInt + nbMsuppInt + nbGsuppInt + nbDsuppInt;
        JavaBot.strategy.idealPopZerglings = 5 + nbZsuppInt;
        JavaBot.strategy.idealPopHydras = 5 + (nbHsuppInt -= totalPopInt - 124);
        JavaBot.strategy.idealPopQueens = 2 + nbQsuppInt;
        JavaBot.strategy.idealPopMutalisks = 2 + nbMsuppInt;
        JavaBot.strategy.idealPopGuardians = 2 + nbGsuppInt;
        JavaBot.strategy.idealPopDevourers = 0 + nbDsuppInt;
        JavaBot.strategy.idealNbZerglings = JavaBot.strategy.idealPopZerglings * 2;
        JavaBot.strategy.idealNbHydras = JavaBot.strategy.idealPopHydras;
        JavaBot.strategy.idealNbQueens = JavaBot.strategy.idealPopQueens / 2;
        JavaBot.strategy.idealNbMutalisks = JavaBot.strategy.idealPopMutalisks / 2;
        JavaBot.strategy.idealNbGuardians = JavaBot.strategy.idealPopGuardians / 2;
        JavaBot.strategy.idealNbDevourers = JavaBot.strategy.idealPopDevourers / 2;
    }

    public void setAdaptComposition(EnemyUnitManager enemyUnitManager) {
        int[] data = this.compositionReaction.get(enemyUnitManager.unit.getTypeID());
        if (data != null) {
            enemyUnitManager.valZ = data[0];
            enemyUnitManager.valH = data[1];
            enemyUnitManager.valQ = data[2];
            enemyUnitManager.valM = data[3];
            enemyUnitManager.valG = data[4];
            enemyUnitManager.valD = data[5];
        }
    }

    public void reset() {
        this.coefficient2 = 0;
        this.Z2 = 0;
        this.H2 = 0;
        this.Q2 = 0;
        this.M2 = 0;
        this.G2 = 0;
        this.D2 = 0;
        this.F2 = 0;
        this.U2 = 0;
        this.S2 = 0;
        this.L2 = 0;
    }
}

