/*
 * Decompiled with CFR 0.152.
 */
package javabot;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import javabot.BWAPIEventListener;
import javabot.JNIBWAPI;
import javabot.knowledge.ArmyComposition;
import javabot.knowledge.GlobalKnowledge;
import javabot.knowledge.Repartition;
import javabot.knowledge.RequestsManager;
import javabot.knowledge.Strategy;
import javabot.knowledge.Tech;
import javabot.knowledge.TileGraph;
import javabot.managers.BaseManager;
import javabot.managers.BuildingManager;
import javabot.managers.BwapiCallsManager;
import javabot.managers.ControlTower;
import javabot.managers.EnemyBuildingManager;
import javabot.managers.EnemyUnitManager;
import javabot.managers.LarvaManager;
import javabot.managers.NeutralUnitManager;
import javabot.managers.UnitManager;
import javabot.model.BaseLocation;
import javabot.model.Player;
import javabot.model.Unit;
import javabot.operators.Operators;
import javabot.types.UnitType;

public class JavaBot
implements BWAPIEventListener {
    public static int homePositionX = -1;
    public static int homePositionY = -1;
    public static int currFrame = 0;
    public static final boolean RELEASE = true;
    public static boolean canExpand = true;
    public static boolean newAdapt = false;
    public static HashMap<Integer, UnitManager> UnitsMap;
    public static HashMap<Integer, BuildingManager> BuildingsMap;
    public static HashMap<Integer, NeutralUnitManager> neutralUnitsMap;
    public static HashMap<Integer, NeutralUnitManager> neutralUnitsMapExists;
    public static ArrayList<UnitManager> units;
    public static ArrayList<UnitManager> unitsExisting;
    public static ArrayList<BuildingManager> buildings;
    public static ArrayList<BuildingManager> buildingsExisting;
    public static ArrayList<EnemyBuildingManager> enemyBuildingsManager;
    public static ArrayList<EnemyBuildingManager> enemyBuildingsManagerExisting;
    public static ArrayList<EnemyUnitManager> enemyUnitsManager;
    public static ArrayList<EnemyUnitManager> enemyUnitsManagerExisting;
    public static ArrayList<EnemyBuildingManager> enemyBuildingsGroundManager;
    public static ArrayList<EnemyBuildingManager> enemyBuildingsAirManager;
    public static ArrayList<EnemyBuildingManager> enemyBuildingsDetectorManager;
    public static ArrayList<EnemyBuildingManager> enemyBuildingsAirTargetManager;
    public static ArrayList<EnemyUnitManager> enemyUnitsGroundManager;
    public static ArrayList<EnemyUnitManager> enemyUnitsAirManager;
    public static ArrayList<EnemyUnitManager> enemyUnitsAirTargetManager;
    public static ArrayList<EnemyUnitManager> enemyUnitsGroundTargetManager;
    public static ArrayList<EnemyUnitManager> enemyUnitsDetectorManager;
    public static ArrayList<EnemyUnitManager> enemyUnitsBroodlingManager;
    public static HashMap<Integer, EnemyUnitManager> enemyUnitsManagerMap;
    public static ArrayList<BaseManager> bases;
    public static RequestsManager requestsManager;
    public static Strategy strategy;
    public static ArmyComposition armyComposition;
    public static JNIBWAPI bwapi;
    public static GlobalKnowledge knowledge;
    public static Repartition repartition;
    long updateUnitsTime;
    long updateBasesTime;
    long updateEnemyUnitsTime;
    long timeBefore = 0L;
    long timeAfter = 0L;
    long totalTime = 0L;
    String perf = "";

    public static void main(String[] args) {
        new JavaBot();
    }

    public JavaBot() {
        bwapi = new JNIBWAPI(this);
        bwapi.start();
    }

    @Override
    public void connected() {
        bwapi.loadTypeData();
    }

    @Override
    public void gameStarted() {
        BwapiCallsManager.init();
        bwapi.enableUserInput();
        bwapi.setGameSpeed(20);
        bwapi.loadMapData(true);
        int hatchery = this.getNearestUnit(UnitType.UnitTypes.Zerg_Hatchery.ordinal(), 0, 0);
        if (hatchery != -1) {
            homePositionX = bwapi.getUnit(hatchery).getX();
            homePositionY = bwapi.getUnit(hatchery).getY();
        }
        Operators.init();
        knowledge = new GlobalKnowledge();
        requestsManager = new RequestsManager();
        strategy = new Strategy();
        armyComposition = new ArmyComposition();
        TileGraph.init(bwapi, homePositionX, homePositionY);
        repartition = new Repartition();
        units = new ArrayList();
        unitsExisting = new ArrayList();
        buildings = new ArrayList();
        buildingsExisting = new ArrayList();
        UnitsMap = new HashMap();
        BuildingsMap = new HashMap();
        neutralUnitsMap = new HashMap();
        neutralUnitsMapExists = new HashMap();
        bases = new ArrayList();
        enemyBuildingsManager = new ArrayList();
        enemyBuildingsManagerExisting = new ArrayList();
        enemyUnitsManager = new ArrayList();
        enemyUnitsManagerExisting = new ArrayList();
        enemyUnitsManagerMap = new HashMap();
        enemyBuildingsGroundManager = new ArrayList();
        enemyBuildingsAirManager = new ArrayList();
        enemyBuildingsAirTargetManager = new ArrayList();
        enemyBuildingsDetectorManager = new ArrayList();
        enemyUnitsGroundManager = new ArrayList();
        enemyUnitsAirManager = new ArrayList();
        enemyUnitsAirTargetManager = new ArrayList();
        enemyUnitsGroundTargetManager = new ArrayList();
        enemyUnitsDetectorManager = new ArrayList();
        enemyUnitsBroodlingManager = new ArrayList();
        ArrayList<BaseLocation> locations = bwapi.getMap().getBaseLocations();
        for (BaseLocation base : locations) {
            bases.add(new BaseManager(base));
        }
        if (bwapi.getMap().getName().equals("TestsUnitaires.scx")) {
            Tech.burrow = 2;
        }
        BaseManager.setScoresExpand(bases, locations, homePositionX, homePositionY, bwapi);
        ControlTower.bwapi = bwapi;
        JavaBot.strategy.enemyRace = Strategy.RaceType.Terran;
        for (Player p : bwapi.getEnemies()) {
            if (p.getRaceID() == 0) {
                JavaBot.strategy.enemyRace = Strategy.RaceType.Zerg;
            }
            if (p.getRaceID() == 1) {
                JavaBot.strategy.enemyRace = Strategy.RaceType.Terran;
            }
            if (p.getRaceID() == 2) {
                JavaBot.strategy.enemyRace = Strategy.RaceType.Protoss;
            }
            if (p.getRaceID() != 6) continue;
        }
        strategy.adaptArmyComposition();
    }

    @Override
    public void gameUpdate() {
        try {
            Object newManager;
            currFrame = bwapi.getFrameCount();
            if (currFrame == 0) {
                this.firstFrame();
                return;
            }
            newAdapt = false;
            if (currFrame % 20 == 0) {
                newAdapt = true;
                armyComposition.reset();
            }
            if (LarvaManager.blockMorph > 0) {
                --LarvaManager.blockMorph;
            }
            repartition.update();
            knowledge.update();
            for (Unit unit : bwapi.getMyUnits()) {
                knowledge.addUnit(unit);
                if (Operators.isAbuilding(unit.getTypeID())) {
                    if (BuildingsMap.containsKey(unit.getID())) continue;
                    newManager = UnitManager.chooseCorrectBuildingManager(unit);
                    BuildingsMap.put(((BuildingManager)newManager).unit.getID(), (BuildingManager)newManager);
                    buildings.add((BuildingManager)newManager);
                    continue;
                }
                if (UnitsMap.containsKey(unit.getID())) continue;
                newManager = UnitManager.chooseCorrectManager(unit);
                UnitsMap.put(((UnitManager)newManager).unit.getID(), (UnitManager)newManager);
                units.add((UnitManager)newManager);
            }
            enemyBuildingsGroundManager.clear();
            enemyBuildingsAirManager.clear();
            enemyBuildingsAirTargetManager.clear();
            enemyBuildingsDetectorManager.clear();
            enemyBuildingsManagerExisting = new ArrayList();
            for (EnemyBuildingManager enemyBuildingManager : enemyBuildingsManager) {
                enemyBuildingManager.update();
            }
            enemyBuildingsManager = enemyBuildingsManagerExisting;
            for (Unit unit : bwapi.getEnemyUnits()) {
                if (Operators.isAbuildingAll(unit.getTypeID())) {
                    EnemyBuildingManager exists = BuildingManager.existsBuilding(unit.getX(), unit.getY(), enemyBuildingsManager);
                    if (exists != null) {
                        exists.timerDestroy = 20;
                        continue;
                    }
                    if (unit.getTypeID() == UnitType.UnitTypes.Zerg_Creep_Colony.ordinal()) continue;
                    enemyBuildingsManager.add(new EnemyBuildingManager(unit));
                    continue;
                }
                if (enemyUnitsManagerMap.containsKey(unit.getID())) continue;
                EnemyUnitManager enemy = new EnemyUnitManager(unit);
                enemyUnitsManagerMap.put(unit.getID(), enemy);
                enemyUnitsManager.add(enemy);
            }
            for (Unit unit : bwapi.getNeutralUnits()) {
                if (!Operators.isCritter(unit.getTypeID()) || unit.isParasited() || neutralUnitsMap.containsKey(unit.getID())) continue;
                newManager = new NeutralUnitManager(unit);
                neutralUnitsMap.put(((NeutralUnitManager)newManager).unit.getID(), (NeutralUnitManager)newManager);
            }
            ControlTower.reset();
            buildingsExisting = new ArrayList();
            for (BuildingManager buildingManager : buildings) {
                buildingManager.update();
            }
            buildings = buildingsExisting;
            JavaBot.strategy.mineralsPerMinute = 0;
            JavaBot.strategy.gasPerMinute = 0;
            unitsExisting = new ArrayList();
            for (UnitManager unitManager : units) {
                unitManager.update();
            }
            units = unitsExisting;
            strategy.ratioGas();
            neutralUnitsMapExists = new HashMap();
            for (NeutralUnitManager neutralUnitManager : neutralUnitsMap.values()) {
                neutralUnitManager.update();
            }
            neutralUnitsMap = neutralUnitsMapExists;
            for (BaseManager baseManager : bases) {
                baseManager.update();
            }
            TileGraph.update();
            for (EnemyBuildingManager enemyBuildingManager : enemyBuildingsManager) {
                enemyBuildingManager.fillGraph();
            }
            enemyUnitsGroundManager.clear();
            enemyUnitsAirManager.clear();
            enemyUnitsAirTargetManager.clear();
            enemyUnitsGroundTargetManager.clear();
            enemyUnitsDetectorManager.clear();
            enemyUnitsBroodlingManager.clear();
            enemyUnitsManagerExisting = new ArrayList();
            for (EnemyUnitManager enemyUnitManager : enemyUnitsManager) {
                enemyUnitManager.update();
            }
            enemyUnitsManager = enemyUnitsManagerExisting;
            if (newAdapt) {
                armyComposition.update();
            }
            requestsManager.update();
            strategy.update(knowledge);
            ControlTower.update();
            BwapiCallsManager.processFrame();
            this.drawDebugInfo();
            BwapiCallsManager.resetFrame();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void firstFrame() {
        int first = -1;
        int second = -1;
        int third = -1;
        for (Unit u : bwapi.getMyUnits()) {
            if (u.getTypeID() == UnitType.UnitTypes.Zerg_Drone.ordinal()) {
                int minDist = Integer.MAX_VALUE;
                Unit bestMineral = null;
                for (Unit neu : bwapi.getNeutralUnits()) {
                    int distTest;
                    int id;
                    if (neu.getTypeID() != UnitType.UnitTypes.Resource_Mineral_Field.ordinal() || (id = neu.getID()) == first || id == second || id == third || (distTest = Operators.distance(u, neu)) >= minDist) continue;
                    minDist = distTest;
                    bestMineral = neu;
                }
                if (bestMineral == null) continue;
                bwapi.rightClick(u.getID(), bestMineral.getID());
                if (first == -1) {
                    first = bestMineral.getID();
                    continue;
                }
                if (second == -1) {
                    second = bestMineral.getID();
                    continue;
                }
                if (third != -1) continue;
                third = bestMineral.getID();
                continue;
            }
            if (u.getTypeID() != UnitType.UnitTypes.Zerg_Larva.ordinal()) continue;
            bwapi.morph(u.getID(), UnitType.UnitTypes.Zerg_Drone.ordinal());
        }
    }

    @Override
    public void gameEnded() {
    }

    @Override
    public void matchEnded(boolean winner) {
    }

    @Override
    public void nukeDetect(int x, int y) {
    }

    @Override
    public void nukeDetect() {
    }

    @Override
    public void playerLeft(int id) {
    }

    @Override
    public void unitCreate(int unitID) {
    }

    @Override
    public void unitDestroy(int unitID) {
    }

    @Override
    public void unitDiscover(int unitID) {
    }

    @Override
    public void unitEvade(int unitID) {
    }

    @Override
    public void unitHide(int unitID) {
    }

    @Override
    public void unitMorph(int unitID) {
    }

    @Override
    public void unitShow(int unitID) {
    }

    @Override
    public void keyPressed(int keyCode) {
    }

    public int getNearestUnit(int unitTypeID, int x, int y) {
        int nearestID = -1;
        double nearestDist = 9999999.0;
        for (Unit unit : bwapi.getMyUnits()) {
            if (unit.getTypeID() != unitTypeID || !unit.isCompleted()) continue;
            double dist = Math.sqrt(Math.pow(unit.getX() - x, 2.0) + Math.pow(unit.getY() - y, 2.0));
            if (nearestID != -1 && !(dist < nearestDist)) continue;
            nearestID = unit.getID();
            nearestDist = dist;
        }
        return nearestID;
    }

    /*
     * Unable to fully structure code
     */
    public static Point getBuildTile(int builderID, int buildingTypeID, int x, int y) {
        ret = new Point(-1, -1);
        maxDist = 4;
        stopDist = 40;
        tileX = x / 32;
        tileY = y / 32;
        if (buildingTypeID != UnitType.UnitTypes.Zerg_Extractor.ordinal()) ** GOTO lbl33
        dist = -1.0;
        for (Unit n : JavaBot.bwapi.getNeutralUnits()) {
            if (n.getTypeID() != UnitType.UnitTypes.Resource_Vespene_Geyser.ordinal() || !((distTest = (double)Operators.distance(n, x, y)) < dist) && dist != -1.0) continue;
            dist = distTest;
            ret = new Point(n.getTileX(), n.getTileY());
        }
        return ret;
lbl-1000:
        // 1 sources

        {
            i = tileX - maxDist;
            while (i <= tileX + maxDist) {
                j = tileY - maxDist;
                while (j <= tileY + maxDist) {
                    if (JavaBot.bwapi.canBuildHere(builderID, i, j, buildingTypeID, false)) {
                        unitsInWay = false;
                        for (Unit u : JavaBot.bwapi.getAllUnits()) {
                            if (u.getID() == builderID || Math.abs(u.getTileX() - i) >= 4 || Math.abs(u.getTileY() - j) >= 4) continue;
                            unitsInWay = true;
                        }
                        if (!unitsInWay) {
                            ret.x = i;
                            ret.y = j;
                            return ret;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            maxDist += 2;
lbl33:
            // 2 sources

            ** while (maxDist < stopDist && ret.x == -1)
        }
lbl34:
        // 1 sources

        return ret;
    }

    public boolean weAreBuilding(int buildingTypeID) {
        for (Unit unit : bwapi.getMyUnits()) {
            if (unit.getTypeID() == buildingTypeID && !unit.isCompleted()) {
                return true;
            }
            if (!bwapi.getUnitType(unit.getTypeID()).isWorker() || unit.getConstructingTypeID() != buildingTypeID) continue;
            return true;
        }
        return false;
    }

    public void drawDebugInfo() {
        bwapi.drawText(new Point(5, 0), "HomePosition: " + String.valueOf(homePositionX) + "," + String.valueOf(homePositionY), true);
        bwapi.drawText(new Point(5, 9), "Units: " + units.size(), true);
        bwapi.drawText(new Point(5, 19), "Buildings: " + buildings.size(), true);
        bwapi.drawText(new Point(5, 29), "Enemy Buildings: " + enemyBuildingsManager.size() + "  ----  Enemy Units: " + enemyUnitsManager.size(), true);
        for (BaseManager manager : bases) {
            manager.drawDebug();
        }
    }
}

