/*
 * Decompiled with CFR 0.152.
 */
package javabot;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javabot.BWAPIEventListener;
import javabot.model.BaseLocation;
import javabot.model.ChokePoint;
import javabot.model.Map;
import javabot.model.Player;
import javabot.model.Region;
import javabot.model.Unit;
import javabot.types.BulletType;
import javabot.types.DamageType;
import javabot.types.ExplosionType;
import javabot.types.OrderType;
import javabot.types.TechType;
import javabot.types.UnitCommandType;
import javabot.types.UnitSizeType;
import javabot.types.UnitType;
import javabot.types.UpgradeType;
import javabot.types.WeaponType;

public class JNIBWAPI {
    private BWAPIEventListener listener;
    private int gameFrame = 0;
    private Map map;
    private HashMap<Integer, Unit> units = new HashMap();
    private ArrayList<Unit> playerUnits = new ArrayList();
    private ArrayList<Unit> alliedUnits = new ArrayList();
    private ArrayList<Unit> enemyUnits = new ArrayList();
    private ArrayList<Unit> neutralUnits = new ArrayList();
    private Player self;
    private HashSet<Integer> allyIDs = new HashSet();
    private HashSet<Integer> enemyIDs = new HashSet();
    private HashMap<Integer, Player> players = new HashMap();
    private ArrayList<Player> allies = new ArrayList();
    private ArrayList<Player> enemies = new ArrayList();
    private HashMap<Integer, UnitType> unitTypes = new HashMap();
    private HashMap<Integer, TechType> techTypes = new HashMap();
    private HashMap<Integer, UpgradeType> upgradeTypes = new HashMap();
    private HashMap<Integer, WeaponType> weaponTypes = new HashMap();
    private HashMap<Integer, UnitSizeType> unitSizeTypes = new HashMap();
    private HashMap<Integer, BulletType> bulletTypes = new HashMap();
    private HashMap<Integer, DamageType> damageTypes = new HashMap();
    private HashMap<Integer, ExplosionType> explosionTypes = new HashMap();
    private HashMap<Integer, UnitCommandType> unitCommandTypes = new HashMap();
    private HashMap<Integer, OrderType> orderTypes = new HashMap();

    static {
        try {
            System.loadLibrary("client-bridge-1_4-x86");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Native code library failed to load.\n" + e);
        }
    }

    private native void startClient(JNIBWAPI var1);

    private native int getGameFrame();

    private native int[] getPlayerInfo();

    private native int[] getPlayerUpdate(int var1);

    private native int[] getResearchStatus(int var1);

    private native int[] getUpgradeStatus(int var1);

    private native int[] getUnits();

    private native int[] getUnitTypes();

    private native String getUnitTypeName(int var1);

    private native int[] getTechTypes();

    private native String getTechTypeName(int var1);

    private native int[] getUpgradeTypes();

    private native String getUpgradeTypeName(int var1);

    private native int[] getWeaponTypes();

    private native String getWeaponTypeName(int var1);

    private native int[] getUnitSizeTypes();

    private native String getUnitSizeTypeName(int var1);

    private native int[] getBulletTypes();

    private native String getBulletTypeName(int var1);

    private native int[] getDamageTypes();

    private native String getDamageTypeName(int var1);

    private native int[] getExplosionTypes();

    private native String getExplosionTypeName(int var1);

    private native int[] getUnitCommandTypes();

    private native String getUnitCommandTypeName(int var1);

    private native int[] getOrderTypes();

    private native String getOrderTypeName(int var1);

    private native void analyzeTerrain();

    private native int getMapWidth();

    private native int getMapHeight();

    private native String getMapName();

    private native String getMapHash();

    private native int[] getHeightData();

    private native int[] getWalkableData();

    private native int[] getBuildableData();

    private native int[] getChokePoints();

    private native int[] getRegions();

    private native int[] getPolygon(int var1);

    private native int[] getBaseLocations();

    public native void attack(int var1, int var2, int var3);

    public native void attack(int var1, int var2);

    public native void build(int var1, int var2, int var3, int var4);

    public native void buildAddon(int var1, int var2);

    public native void train(int var1, int var2);

    public native void morph(int var1, int var2);

    public native void research(int var1, int var2);

    public native void upgrade(int var1, int var2);

    public native void setRallyPoint(int var1, int var2, int var3);

    public native void setRallyPoint(int var1, int var2);

    public native void move(int var1, int var2, int var3);

    public native void patrol(int var1, int var2, int var3);

    public native void holdPosition(int var1);

    public native void stop(int var1);

    public native void follow(int var1, int var2);

    public native void gather(int var1, int var2);

    public native void returnCargo(int var1);

    public native void repair(int var1, int var2);

    public native void burrow(int var1);

    public native void unburrow(int var1);

    public native void cloak(int var1);

    public native void decloak(int var1);

    public native void siege(int var1);

    public native void unsiege(int var1);

    public native void lift(int var1);

    public native void land(int var1, int var2, int var3);

    public native void load(int var1, int var2);

    public native void unload(int var1, int var2);

    public native void unloadAll(int var1);

    public native void unloadAll(int var1, int var2, int var3);

    public native void rightClick(int var1, int var2, int var3);

    public native void rightClick(int var1, int var2);

    public native void haltConstruction(int var1);

    public native void cancelConstruction(int var1);

    public native void cancelAddon(int var1);

    public native void cancelTrain(int var1, int var2);

    public native void cancelMorph(int var1);

    public native void cancelResearch(int var1);

    public native void cancelUpgrade(int var1);

    public native void useTech(int var1, int var2);

    public native void useTech(int var1, int var2, int var3, int var4);

    public native void useTech(int var1, int var2, int var3);

    public native void drawHealth(boolean var1);

    public native void drawTargets(boolean var1);

    public native void drawIDs(boolean var1);

    public native void enableUserInput();

    public native void enablePerfectInformation();

    public native void setGameSpeed(int var1);

    public native void drawBox(int var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7);

    public native void drawCircle(int var1, int var2, int var3, int var4, boolean var5, boolean var6);

    public native void drawLine(int var1, int var2, int var3, int var4, int var5, boolean var6);

    public void drawLine(Point a, Point b, int color, boolean screenCoords) {
        this.drawLine(a.x, a.y, b.x, b.y, color, screenCoords);
    }

    public native void drawDot(int var1, int var2, int var3, boolean var4);

    public native void drawText(int var1, int var2, String var3, boolean var4);

    public void drawText(Point a, String msg, boolean screenCoords) {
        this.drawText(a.x, a.y, msg, screenCoords);
    }

    public native boolean hasCreep(int var1, int var2);

    public native boolean canBuildHere(int var1, int var2, int var3, int var4, boolean var5);

    public native void printText(String var1);

    public native void sendText(String var1);

    public native void setCommandOptimizationLevel(int var1);

    private native boolean isReplay();

    public UnitType getUnitType(int unitID) {
        return this.unitTypes.get(unitID);
    }

    public TechType getTechType(int techID) {
        return this.techTypes.get(techID);
    }

    public UpgradeType getUpgradeType(int upgradeID) {
        return this.upgradeTypes.get(upgradeID);
    }

    public WeaponType getWeaponType(int weaponID) {
        return this.weaponTypes.get(weaponID);
    }

    public UnitSizeType getUnitSizeType(int sizeID) {
        return this.unitSizeTypes.get(sizeID);
    }

    public BulletType getBulletType(int bulletID) {
        return this.bulletTypes.get(bulletID);
    }

    public DamageType getDamageType(int damageID) {
        return this.damageTypes.get(damageID);
    }

    public ExplosionType getExplosionType(int explosionID) {
        return this.explosionTypes.get(explosionID);
    }

    public UnitCommandType getUnitCommandType(int unitCommandID) {
        return this.unitCommandTypes.get(unitCommandID);
    }

    public OrderType getOrderType(int orderID) {
        return this.orderTypes.get(orderID);
    }

    public Collection<UnitType> unitTypes() {
        return this.unitTypes.values();
    }

    public Collection<TechType> techTypes() {
        return this.techTypes.values();
    }

    public Collection<UpgradeType> upgradeTypes() {
        return this.upgradeTypes.values();
    }

    public Collection<WeaponType> weaponTypes() {
        return this.weaponTypes.values();
    }

    public Collection<UnitSizeType> unitSizeTypes() {
        return this.unitSizeTypes.values();
    }

    public Collection<BulletType> bulletTypes() {
        return this.bulletTypes.values();
    }

    public Collection<DamageType> damageTypes() {
        return this.damageTypes.values();
    }

    public Collection<ExplosionType> explosionTypes() {
        return this.explosionTypes.values();
    }

    public Collection<UnitCommandType> unitCommandTypes() {
        return this.unitCommandTypes.values();
    }

    public Collection<OrderType> orderTypes() {
        return this.orderTypes.values();
    }

    public native boolean isVisible(int var1, int var2);

    public native boolean isExplored(int var1, int var2);

    public native boolean isBuildable(int var1, int var2, boolean var3);

    public boolean isBuildable(int tx, int ty) {
        return this.isBuildable(tx, ty, false);
    }

    public native int getLastError();

    public native boolean hasLoadedUnit(int var1, int var2);

    public native int getRemainingLatencyFrames();

    public int getFrameCount() {
        return this.gameFrame;
    }

    public Player getSelf() {
        return this.self;
    }

    public Player getPlayer(int playerID) {
        return this.players.get(playerID);
    }

    public ArrayList<Player> getAllies() {
        return this.allies;
    }

    public ArrayList<Player> getEnemies() {
        return this.enemies;
    }

    public Unit getUnit(int unitID) {
        return this.units.get(unitID);
    }

    public Collection<Unit> getAllUnits() {
        return this.units.values();
    }

    public ArrayList<Unit> getMyUnits() {
        return this.playerUnits;
    }

    public ArrayList<Unit> getAlliedUnits() {
        return this.alliedUnits;
    }

    public ArrayList<Unit> getEnemyUnits() {
        return this.enemyUnits;
    }

    public ArrayList<Unit> getNeutralUnits() {
        return this.neutralUnits;
    }

    public Map getMap() {
        return this.map;
    }

    public void loadTypeData() {
        int[] unitTypeData = this.getUnitTypes();
        int index = 0;
        while (index < unitTypeData.length) {
            UnitType type = new UnitType(unitTypeData, index);
            type.setName(this.getUnitTypeName(type.getID()));
            this.unitTypes.put(type.getID(), type);
            index += 58;
        }
        int[] techTypeData = this.getTechTypes();
        int index2 = 0;
        while (index2 < techTypeData.length) {
            TechType type = new TechType(techTypeData, index2);
            type.setName(this.getTechTypeName(type.getID()));
            this.techTypes.put(type.getID(), type);
            index2 += 10;
        }
        int[] upgradeTypeData = this.getUpgradeTypes();
        int index3 = 0;
        while (index3 < upgradeTypeData.length) {
            UpgradeType type = new UpgradeType(upgradeTypeData, index3);
            type.setName(this.getUpgradeTypeName(type.getID()));
            this.upgradeTypes.put(type.getID(), type);
            index3 += 10;
        }
        int[] weaponTypeData = this.getWeaponTypes();
        int index4 = 0;
        while (index4 < weaponTypeData.length) {
            WeaponType type = new WeaponType(weaponTypeData, index4);
            type.setName(this.getWeaponTypeName(type.getID()));
            this.weaponTypes.put(type.getID(), type);
            index4 += 24;
        }
        int[] unitSizeTypeData = this.getUnitSizeTypes();
        int index5 = 0;
        while (index5 < unitSizeTypeData.length) {
            UnitSizeType type = new UnitSizeType(unitSizeTypeData, index5);
            type.setName(this.getUnitSizeTypeName(type.getID()));
            this.unitSizeTypes.put(type.getID(), type);
            ++index5;
        }
        int[] bulletTypeData = this.getBulletTypes();
        int index6 = 0;
        while (index6 < bulletTypeData.length) {
            BulletType type = new BulletType(bulletTypeData, index6);
            type.setName(this.getBulletTypeName(type.getID()));
            this.bulletTypes.put(type.getID(), type);
            ++index6;
        }
        int[] damageTypeData = this.getDamageTypes();
        int index7 = 0;
        while (index7 < damageTypeData.length) {
            DamageType type = new DamageType(damageTypeData, index7);
            type.setName(this.getDamageTypeName(type.getID()));
            this.damageTypes.put(type.getID(), type);
            ++index7;
        }
        int[] explosionTypeData = this.getExplosionTypes();
        int index8 = 0;
        while (index8 < explosionTypeData.length) {
            ExplosionType type = new ExplosionType(explosionTypeData, index8);
            type.setName(this.getExplosionTypeName(type.getID()));
            this.explosionTypes.put(type.getID(), type);
            ++index8;
        }
        int[] unitCommandTypeData = this.getUnitCommandTypes();
        int index9 = 0;
        while (index9 < unitCommandTypeData.length) {
            UnitCommandType type = new UnitCommandType(unitCommandTypeData, index9);
            type.setName(this.getUnitCommandTypeName(type.getID()));
            this.unitCommandTypes.put(type.getID(), type);
            ++index9;
        }
        int[] orderTypeData = this.getOrderTypes();
        int index10 = 0;
        while (index10 < orderTypeData.length) {
            OrderType type = new OrderType(orderTypeData, index10);
            type.setName(this.getOrderTypeName(type.getID()));
            this.orderTypes.put(type.getID(), type);
            ++index10;
        }
    }

    public void loadMapData(boolean enableBWTA) {
        this.map = new Map(this.getMapWidth(), this.getMapHeight(), this.getMapName(), this.getMapHash(), this.getHeightData(), this.getBuildableData(), this.getWalkableData());
        if (!enableBWTA) {
            return;
        }
        File bwtaFile = new File(String.valueOf(this.map.getHash()) + ".bwta");
        boolean analyzed = bwtaFile.exists();
        int[] regionData = null;
        int[] chokePointData = null;
        int[] baseLocationData = null;
        HashMap<Integer, int[]> polygons = new HashMap<Integer, int[]>();
        if (!analyzed) {
            this.analyzeTerrain();
            regionData = this.getRegions();
            chokePointData = this.getChokePoints();
            baseLocationData = this.getBaseLocations();
            int index = 0;
            while (index < regionData.length) {
                int id = regionData[index];
                polygons.put(id, this.getPolygon(id));
                index += 3;
            }
            try {
                int val;
                BufferedWriter writer = new BufferedWriter(new FileWriter(bwtaFile));
                boolean first = true;
                int[] nArray = regionData;
                int n = regionData.length;
                int n2 = 0;
                while (n2 < n) {
                    val = nArray[n2];
                    if (first) {
                        first = false;
                        writer.write("" + val);
                    } else {
                        writer.write("," + val);
                    }
                    ++n2;
                }
                writer.write("\n");
                first = true;
                nArray = chokePointData;
                n = chokePointData.length;
                n2 = 0;
                while (n2 < n) {
                    val = nArray[n2];
                    if (first) {
                        first = false;
                        writer.write("" + val);
                    } else {
                        writer.write("," + val);
                    }
                    ++n2;
                }
                writer.write("\n");
                first = true;
                nArray = baseLocationData;
                n = baseLocationData.length;
                n2 = 0;
                while (n2 < n) {
                    val = nArray[n2];
                    if (first) {
                        first = false;
                        writer.write("" + val);
                    } else {
                        writer.write("," + val);
                    }
                    ++n2;
                }
                writer.write("\n");
                Iterator iterator = polygons.keySet().iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    writer.write("" + id);
                    int[] nArray2 = (int[])polygons.get(id);
                    int n3 = nArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int val2 = nArray2[n4];
                        writer.write("," + val2);
                        ++n4;
                    }
                    writer.write("\n");
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(bwtaFile));
                String[] regions = reader.readLine().split(",");
                regionData = new int[regions.length];
                int i = 0;
                while (i < regions.length) {
                    regionData[i] = Integer.parseInt(regions[i]);
                    ++i;
                }
                String[] chokePoints = reader.readLine().split(",");
                if (chokePoints.length > 0 && !chokePoints[0].equals("")) {
                    chokePointData = new int[chokePoints.length];
                    int i2 = 0;
                    while (i2 < chokePoints.length) {
                        chokePointData[i2] = Integer.parseInt(chokePoints[i2]);
                        ++i2;
                    }
                } else {
                    chokePointData = new int[]{};
                }
                String[] baseLocations = reader.readLine().split(",");
                if (baseLocations.length > 0 && !baseLocations[0].equals("")) {
                    baseLocationData = new int[baseLocations.length];
                    int i3 = 0;
                    while (i3 < baseLocations.length) {
                        baseLocationData[i3] = Integer.parseInt(baseLocations[i3]);
                        ++i3;
                    }
                }
                String line = reader.readLine();
                while (line != null) {
                    String[] coordinates = line.split(",");
                    int[] coordinateData = new int[coordinates.length - 1];
                    int i4 = 1;
                    while (i4 < coordinates.length) {
                        coordinateData[i4 - 1] = Integer.parseInt(coordinates[i4]);
                        ++i4;
                    }
                    polygons.put(Integer.parseInt(coordinates[0]), coordinateData);
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        HashMap<Integer, Region> regionMap = new HashMap<Integer, Region>();
        int index = 0;
        while (index < regionData.length) {
            Region region = new Region(regionData, index);
            region.setCoordinates((int[])polygons.get(region.getID()));
            this.map.getRegions().add(region);
            regionMap.put(region.getID(), region);
            index += 3;
        }
        if (chokePointData != null) {
            index = 0;
            while (index < chokePointData.length) {
                ChokePoint chokePoint = new ChokePoint(chokePointData, index);
                chokePoint.setFirstRegion((Region)regionMap.get(chokePoint.getFirstRegionID()));
                chokePoint.setSecondRegion((Region)regionMap.get(chokePoint.getSecondRegionID()));
                this.map.getChokePoints().add(chokePoint);
                index += 9;
            }
        }
        if (baseLocationData != null) {
            index = 0;
            while (index < baseLocationData.length) {
                BaseLocation baseLocation = new BaseLocation(baseLocationData, index);
                this.map.getBaseLocations().add(baseLocation);
                index += 10;
            }
        }
        for (Region region : this.map.getRegions()) {
            for (ChokePoint chokePoint : this.map.getChokePoints()) {
                if (!chokePoint.getFirstRegion().equals(region) && !chokePoint.getSecondRegion().equals(region)) continue;
                region.getChokePoints().add(chokePoint);
                region.getConnectedRegions().add(chokePoint.getOtherRegion(region));
            }
        }
    }

    public JNIBWAPI(BWAPIEventListener listener) {
        this.listener = listener;
    }

    public void start() {
        this.startClient(this);
    }

    public void javaPrint(String msg) {
        try {
            System.out.println("Bridge: " + msg);
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    public void connected() {
        try {
            this.listener.connected();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    public void gameStarted() {
        try {
            this.allies.clear();
            this.allyIDs.clear();
            this.enemies.clear();
            this.enemyIDs.clear();
            this.players.clear();
            int[] playerData = this.getPlayerInfo();
            int index = 0;
            while (index < playerData.length) {
                Player player = new Player(playerData, index);
                this.players.put(player.getID(), player);
                if (player.isSelf()) {
                    this.self = player;
                } else if (player.isAlly()) {
                    this.allies.add(player);
                    this.allyIDs.add(player.getID());
                } else if (player.isEnemy()) {
                    this.enemies.add(player);
                    this.enemyIDs.add(player.getID());
                }
                index += 8;
            }
            this.units.clear();
            this.playerUnits.clear();
            this.alliedUnits.clear();
            this.enemyUnits.clear();
            this.neutralUnits.clear();
            int[] unitData = this.getUnits();
            int index2 = 0;
            while (index2 < unitData.length) {
                int id = unitData[index2];
                Unit unit = new Unit(id);
                unit.update(unitData, index2);
                this.units.put(id, unit);
                if (this.self != null) {
                    if (unit.getPlayerID() == this.self.getID()) {
                        this.playerUnits.add(unit);
                    } else if (this.allyIDs.contains(unit.getPlayerID())) {
                        this.alliedUnits.add(unit);
                    } else if (this.enemyIDs.contains(unit.getPlayerID())) {
                        this.enemyUnits.add(unit);
                    } else {
                        this.neutralUnits.add(unit);
                    }
                } else if (this.allyIDs.contains(unit.getPlayerID())) {
                    this.alliedUnits.add(unit);
                } else if (this.enemyIDs.contains(unit.getPlayerID())) {
                    this.enemyUnits.add(unit);
                } else {
                    this.neutralUnits.add(unit);
                }
                index2 += 114;
            }
            this.listener.gameStarted();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    private void gameUpdate() {
        try {
            this.gameFrame = this.getGameFrame();
            if (!this.isReplay()) {
                this.self.update(this.getPlayerUpdate(this.self.getID()));
                this.self.updateResearch(this.getResearchStatus(this.self.getID()), this.getUpgradeStatus(this.self.getID()));
            } else {
                for (Integer playerID : this.players.keySet()) {
                    this.players.get(playerID).update(this.getPlayerUpdate(playerID));
                    this.players.get(playerID).updateResearch(this.getResearchStatus(playerID), this.getUpgradeStatus(playerID));
                }
            }
            int[] unitData = this.getUnits();
            HashSet<Integer> deadUnits = new HashSet<Integer>(this.units.keySet());
            ArrayList<Unit> playerList = new ArrayList<Unit>();
            ArrayList<Unit> alliedList = new ArrayList<Unit>();
            ArrayList<Unit> enemyList = new ArrayList<Unit>();
            ArrayList<Unit> neutralList = new ArrayList<Unit>();
            int index = 0;
            while (index < unitData.length) {
                int id = unitData[index];
                deadUnits.remove(id);
                Unit unit = this.units.get(id);
                if (unit == null) {
                    unit = new Unit(id);
                    this.units.put(id, unit);
                }
                unit.update(unitData, index);
                if (this.self != null) {
                    if (unit.getPlayerID() == this.self.getID()) {
                        playerList.add(unit);
                    } else if (this.allyIDs.contains(unit.getPlayerID())) {
                        alliedList.add(unit);
                    } else if (this.enemyIDs.contains(unit.getPlayerID())) {
                        enemyList.add(unit);
                    } else {
                        neutralList.add(unit);
                    }
                } else if (this.allyIDs.contains(unit.getPlayerID())) {
                    alliedList.add(unit);
                } else if (this.enemyIDs.contains(unit.getPlayerID())) {
                    enemyList.add(unit);
                } else {
                    neutralList.add(unit);
                }
                index += 114;
            }
            this.playerUnits = playerList;
            this.alliedUnits = alliedList;
            this.enemyUnits = enemyList;
            this.neutralUnits = neutralList;
            for (Integer unitID : deadUnits) {
                this.units.get(unitID).setDestroyed();
                this.units.remove(unitID);
            }
            this.listener.gameUpdate();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    private void gameEnded() {
        try {
            this.listener.gameEnded();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    private void eventOccured(int type, int param1, int param2) {
        try {
            switch (type) {
                case 0: {
                    this.listener.matchEnded(param1 == 1);
                    break;
                }
                case 1: {
                    this.listener.playerLeft(param1);
                    break;
                }
                case 2: {
                    this.listener.nukeDetect(param2, param2);
                    break;
                }
                case 3: {
                    this.listener.nukeDetect();
                    break;
                }
                case 4: {
                    this.listener.unitDiscover(param1);
                    break;
                }
                case 5: {
                    this.listener.unitEvade(param1);
                    break;
                }
                case 6: {
                    this.listener.unitShow(param1);
                    break;
                }
                case 7: {
                    this.listener.unitHide(param1);
                    break;
                }
                case 8: {
                    this.listener.unitCreate(param1);
                    break;
                }
                case 9: {
                    this.listener.unitDestroy(param1);
                    break;
                }
                case 10: {
                    this.listener.unitMorph(param1);
                }
            }
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    public void keyPressed(int keyCode) {
        try {
            this.listener.keyPressed(keyCode);
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }
}

