#include "ZiabotModule.h"
#include <iostream>
#include <fstream>
#include <vector>
#include <boost/foreach.hpp>
#include <string>
#include <stdlib.h>
#include <time.h>

using namespace BWTA;
using namespace BWAPI;
using namespace Filter;
using namespace std;

struct Z3{
	int z3;
	int w;
	int l;
	Z3(){
		z3 = w = l = 0;
	}
	Z3(int a, int b, int c){
		z3 = a; w = b; l = c;
	}
};

struct Z2{
	int z2;
	vector<Z3> z3;
	Z2(){
		z2 = 0;
		z3.clear();
	}
	Z2(int a, int b, int c, int d){
		z2 = a;
		Z3 zz(b, c, d);
		z3.clear();
		z3.push_back(zz);
	}
};

struct Z1{
	int z1;
	vector<Z2> z2;
	Z1(){
		z1 = 0;
		z2.clear();
	}
	Z1(int a, int b, int c, int d, int e){
		z1 = a;
		Z2 zz(b, c, d, e);
		z2.clear();
		z2.push_back(zz);
	}
};

struct MAP{
	string map;
	vector<Z1> z1;
	MAP(){
		z1.clear();
	}
	MAP(string m, int a, int b, int c, int d, int e){
		map = m;
		Z1 zz(a, b, c, d, e);
		z1.clear();
		z1.push_back(zz);
	}
};

struct NAME{
	int race;
	string name;
	vector<MAP> map;
	NAME(){
		race = -1;
		map.clear();
	}
	NAME(int r, string n, string m, int z1, int z2, int z3, int w, int l){
		race = r;
		name = n;
		MAP mm(m, z1, z2, z3, w, l);
		map.clear();
		map.push_back(mm);
	}
};

struct Data{
	vector<NAME> name;
	Data(){
		name.clear();
	}
}Cheers;

int translate(int zia){
	switch (zia){
	case 2: return 3;
	case 3: return 4;
	case 4: return 5;
	case 5: return 6;
	case 6: return 7;
	case 7: return 8;
	case 8: return 10;
	case 9: return 11;
	default: return zia;
	}
}

bool read(){
	Cheers = Data();
	ifstream inn("bwapi-data/write/Zia.txt");
	int Jia;
	int race;
	string name, map;
	int z1, z2, z3, W, L;
	if (inn.is_open()){
		inn >> Jia;
		if (Jia == 20160829){
			while (inn>>race){
				inn >> name >> map >> z1 >> z2 >> z3 >> W >> L;
				// if (0 > race || race > 2 || name.length() < 2) return true;
				z1 = translate(z1);
				z2 = translate(z2);
				z3 = translate(z3);
				bool BREAK = false;
				for (int i = 0; i <= Cheers.name.size() && !BREAK; i++){
					if (i == Cheers.name.size()){
						NAME nn(race, name, map, z1, z2, z3, W, L);
						Cheers.name.push_back(nn);
						BREAK = true;
					}
					else if (race == Cheers.name[i].race && name == Cheers.name[i].name){
						for (int j = 0; j <= Cheers.name[i].map.size() && !BREAK; j++){
							if (j == Cheers.name[i].map.size()){
								MAP mm(map, z1, z2, z3, W, L);
								Cheers.name[i].map.push_back(mm);
								BREAK = true;
							}
							else if (map == Cheers.name[i].map[j].map){
								for (int k = 0; k <= Cheers.name[i].map[j].z1.size() && !BREAK; k++){
									if (k == Cheers.name[i].map[j].z1.size()){
										Z1 zz(z1, z2, z3, W, L);
										Cheers.name[i].map[j].z1.push_back(zz);
										BREAK = true;
									}
									else if (z1 == Cheers.name[i].map[j].z1[k].z1){
										for (int l = 0; l <= Cheers.name[i].map[j].z1[k].z2.size() && !BREAK; l++){
											if (l == Cheers.name[i].map[j].z1[k].z2.size()){
												Z2 zz(z2, z3, W, L);
												Cheers.name[i].map[j].z1[k].z2.push_back(zz);
												BREAK = true;
											}
											else if (z2 == Cheers.name[i].map[j].z1[k].z2[l].z2){
												for (int m = 0; m <= Cheers.name[i].map[j].z1[k].z2[l].z3.size() && !BREAK; m++){
													if (m == Cheers.name[i].map[j].z1[k].z2[l].z3.size()){
														Z3 zz(z3, W, L);
														Cheers.name[i].map[j].z1[k].z2[l].z3.push_back(zz);
														BREAK = true;
													}
													else if (z3 == Cheers.name[i].map[j].z1[k].z2[l].z3[m].z3){
														return true;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			return true;
		}
		else if (Jia != 20160831)
			return false;
		while (inn.good()){
			inn >> race >> name >> map >> z1 >> z2 >> z3 >> W >> L;
			bool BREAK = false;
			for (int i = 0; i <= Cheers.name.size() && !BREAK; i++){
				if (i == Cheers.name.size()){
					NAME nn(race, name, map, z1, z2, z3, W, L);
					Cheers.name.push_back(nn);
					BREAK = true;
				}
				else if (race == Cheers.name[i].race && name == Cheers.name[i].name){
					for (int j = 0; j <= Cheers.name[i].map.size() && !BREAK; j++){
						if (j == Cheers.name[i].map.size()){
							MAP mm(map, z1, z2, z3, W, L);
							Cheers.name[i].map.push_back(mm);
							BREAK = true;
						}
						else if (map == Cheers.name[i].map[j].map){
							for (int k = 0; k <= Cheers.name[i].map[j].z1.size() && !BREAK; k++){
								if (k == Cheers.name[i].map[j].z1.size()){
									Z1 zz(z1, z2, z3, W, L);
									Cheers.name[i].map[j].z1.push_back(zz);
									BREAK = true;
								}
								else if (z1 == Cheers.name[i].map[j].z1[k].z1){
									for (int l = 0; l <= Cheers.name[i].map[j].z1[k].z2.size() && !BREAK; l++){
										if (l == Cheers.name[i].map[j].z1[k].z2.size()){
											Z2 zz(z2, z3, W, L);
											Cheers.name[i].map[j].z1[k].z2.push_back(zz);
											BREAK = true;
										}
										else if (z2 == Cheers.name[i].map[j].z1[k].z2[l].z2){
											for (int m = 0; m <= Cheers.name[i].map[j].z1[k].z2[l].z3.size() && !BREAK; m++){
												if (m == Cheers.name[i].map[j].z1[k].z2[l].z3.size()){
													Z3 zz(z3, W, L);
													Cheers.name[i].map[j].z1[k].z2[l].z3.push_back(zz);
													BREAK = true;
												}
												else if (z3 == Cheers.name[i].map[j].z1[k].z2[l].z3[m].z3){
													return true;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		return true;
	}
	return false;
}


// Strats
enum Strat { Dahyun, Dahye, Dahee, Daeun, Dajung, Dayoung, Jaeeun, Juae, Jungeun, Jung_a, Seohyun, Soyoung };
int Zia; // Strategy Order
int Zia1=-1, Zia2=-1, Zia3=-1;
string Jia;
string Enemy_name;
bool ob = false;      //observing administartion mode
Position ave, ave2;
bool dew = false;
bool defense = false;
bool defensive = false; //check if the enemy is defensive bot
bool ovo = false; // one vs one map
bool cancel = false; // to halt in emergency


bool Youngju(){
	for (int i = 0; i < Cheers.name.size(); i++){
		if (Cheers.name[i].name == Enemy_name){
			int tactics[12][2] = { 0, };
			int I = -1;
			int I2 = -1;
			double top = 50;
			double winnings[12];
			for (int j = 0; j < Cheers.name[i].map.size(); j++){
				for (int k = 0; k < Cheers.name[i].map[j].z1.size(); k++){
					for (int l = 0; l < Cheers.name[i].map[j].z1[k].z2.size(); l++){
						for (int m = 0; m < Cheers.name[i].map[j].z1[k].z2[l].z3.size(); m++){
							tactics[Cheers.name[i].map[j].z1[k].z1][0] += Cheers.name[i].map[j].z1[k].z2[l].z3[m].w;
							tactics[Cheers.name[i].map[j].z1[k].z1][1] += Cheers.name[i].map[j].z1[k].z2[l].z3[m].l;
							if (Cheers.name[i].map[j].z1[k].z2[l].z2 != -1){
								tactics[Cheers.name[i].map[j].z1[k].z2[l].z2][0] += Cheers.name[i].map[j].z1[k].z2[l].z3[m].w;
								tactics[Cheers.name[i].map[j].z1[k].z2[l].z2][1] += Cheers.name[i].map[j].z1[k].z2[l].z3[m].l;
							}
						}
					}
				}
			}
			for (int i = 0; i < 4+(Broodwar->enemy()->getRace() == Races::Zerg); i++){
				if (tactics[i][0] + tactics[i][1] > 0){
					winnings[i] = tactics[i][0] / (tactics[i][0] + tactics[i][1]) * 100;
					if (winnings[i] >= top){
						I = i;
						top = winnings[i];
					}
				}
				else winnings[i] = 0;
			}
			if (I != -1) Zia1 = I;
			top = 49;
			for (int i = 6; i < 9; i++){
				if (tactics[i][0] + tactics[i][1] > 0){
					winnings[i] = tactics[i][0] / (tactics[i][0] + tactics[i][1]) * 100;
					if (winnings[i] >= top){
						I2 = i;
						top = winnings[i];
					}
				}
				else winnings[i] = 0;
			}
			if (I2 != -1) Zia2 = I2;
			return true;
		}
	}
	return false;
}

//Scout
Unit Seowhang;
Unit Chicken;
Unit Special_chicken;
Unit Neo_chicken;
bool Ddangddang = false; // Sunken
bool Neoddang = false; // Sunken
bool Chang = false; // first scouter fight
bool Yerin = false; // first scout
bool Yerim = false; // first scout order
bool Search = false;
static Position *Startings = NULL;
static bool *Startings_check = NULL;
static int nStartings = 0;
static int sStartings = 0;
int hatchery_frame = 0;
int seowhang_frame = 0;
int search_frame = 0;

int Supply_used;

int Unit_larva;
int Unit_drones;
int Unit_hydras;
int Unit_lings;
int Unit_mutals;
int Unit_queens;
int Unit_scourges;

int Building_hatcheries;
int Building_pool;
bool Building_pool2;
int Building_lair;
bool Building_lair2;
int Building_hive;
bool Building_hive2;
int Building_spire;
bool Building_spire2;
int Building_chamber;
int Building_den;
bool Building_den2;
int Building_queen;

//Map depends
Unit Chitang;
Unit Pascal = NULL; // may be special mineral
TilePosition Multi; // First Muitl, maybe

// Unit depends
bool Seul_a = false; // Flying enemy
bool Must_mutal = true;
// \strats

// Map Designer
vector<TilePosition> BASES;
class Designer{ // Designer is for scout order
public:
	int nBase;
	int *Design;
	int *Try;
	TilePosition *Bases;
	TilePosition *tBases;
	Designer(){
		nBase = 0;
		Design = NULL;
		Bases = tBases = NULL;
	}
	void push(TilePosition tp){
		tBases = Bases;
		delete[] Design;
		Design = new int[nBase + 1];
		Bases = new TilePosition[nBase + 1];
		Bases[nBase] = tp;
		for (int i = 0; i < nBase + 1; i++) Design[i] = 0;
		for (int i = 0; i < nBase; i++){
			Bases[i] = tBases[i];
		}nBase++;
		delete[] tBases;
	}
	TilePosition getBase(){
		int least = 100000000;
		TilePosition res;
		int I = -1;
		for (int i = 0; i < nBase; i++){
			if (!Broodwar->isVisible(Bases[i]) && Design[i] < least){
				I = i;
				res = Bases[i];
				least = Design[i];
			}
		}
		if (I != -1){
			Design[I]++;
			return res;
		}
		return Bases[0];
	}
	bool ask(TilePosition tp){
		for (int i = 0; i < nBase; i++){
			if (Bases[i] == tp) return true;
		}return false;
	}
	TilePosition BASES(){
		static int i = 0;
		i = (i + 1) % nBase;
		return Bases[i];
	}
}DESIGNER;
class Enemy{
private:
	int nBuildings;
	Unit *Buildings;
	Unit *tBuildings;
	TilePosition *positions;
	TilePosition *tpositions;
public:
	Enemy(){
		nBuildings = 0;
		Buildings = tBuildings = NULL;
		positions = tpositions = NULL;
	}
	Position Yeram(); // requires N > 0
	Position avE(Unit);
	void Jieun(); // pops when if the unit gone
	bool check(Unit); // returns true when it has the Unit
	bool push(Unit);
	bool pop(Unit);
	int getN(){ return nBuildings; }
}ENEMY;
Position Enemy::Yeram(){
	for (int i = 0; i < nBuildings; i++){
		if (positions[i].isValid()) return (Position)positions[i];
	}
	return (Position) positions[0];
}
void Enemy::Jieun(){
	for (int i = 0; i < nBuildings; i++){
		if (Broodwar->isVisible(positions[i])){
			if (!Buildings[i]->exists()){
				pop(Buildings[i]);
				return;
			}
		}
		if (ob){
			Broodwar->drawCircleMap((Position)positions[i], 10, Colors::White, true);
		}
	}
}
bool Enemy::check(Unit u){
	for (int i = 0; i < nBuildings; i++){
		if (Buildings[i] == u) return true;
	}return false;
}
bool Enemy::push(Unit u){
	if (nBuildings == 0){
		Buildings = new Unit[3];
		Buildings[0] = u;
		positions = new TilePosition[3];
		positions[0] = (TilePosition)u->getPosition();
		nBuildings++;
		return true;
	}
	else{
		if (check(u)) return false;
		tBuildings = Buildings;
		Buildings = new Unit[nBuildings + 1];
		Buildings[nBuildings] = u;
		tpositions = positions;
		positions = new TilePosition[nBuildings + 1];
		positions[nBuildings] = (TilePosition)u->getPosition();
		for (int i = 0; i < nBuildings; i++){
			Buildings[i] = tBuildings[i];
			positions[i] = tpositions[i];
		}
		nBuildings++;
		delete[] tBuildings;
		delete[] tpositions;
		return true;
	}
}
bool Enemy::pop(Unit u){
	if (!check(u) || nBuildings == 0) false;
	int I = 0;
	for (; I < nBuildings; I++){
		if (Buildings[I] == u) break;
	}
	tBuildings = Buildings;
	Buildings = new Unit[nBuildings - 1];
	tpositions = positions;
	positions = new TilePosition[nBuildings - 1];
	for (int i = 0, j = 0; i < nBuildings; i++){
		if (i == I){
			continue;
		}
		positions[j] = tpositions[i];
		Buildings[j++] = tBuildings[i];
	}
	delete[] tBuildings;
	delete[] tpositions;
	nBuildings--;
	return true;
}
Position Enemy::avE(Unit u){ // teach place where to attack
	Position p = ave;
	int d = u->getDistance(ave);
	for (int i = 0; i < nBuildings; i++){
		int dd = u->getDistance((Position)positions[i]);
		if (d > dd){
			d = dd;
			p = (Position)positions[i];
		}
	}
	return p;
}
// \Map Designer

// Hatchery Manager
enum HATCH { Satis, m, nSatis, Sunken, Hatch, M };
class Hatchery{
private:
	int nHatch;
	Unit *Hatch;
	int *M, *m, *Sunken;
	bool *Satis;
	bool fullSat;
public:
	Hatchery(){
		nHatch = 0;
		Hatch = NULL;
		M = m = Sunken = NULL;
		Satis = NULL;
		fullSat = false;
	}
	void clear();
	void push(Unit);
	int getS(Unit, HATCH);
	bool getfull(){ return fullSat; }
	int getN(){ return nHatch; }
	Unit getHFM(Unit); // get Hatchery for Mineral
	Unit getHFD(Unit); // get Hatchery for Drone spawn
	Unit getHHH(Unit); // get Nearest Hatchery
	Unit getDDD(); // get any drone
	void Destination();
}HATCHERY;
void Hatchery::clear(){
	nHatch = 0;
	delete[] Hatch;
	delete[] M;
	delete[] m;
	delete[] Sunken;
	Hatch = NULL;
	M = m = Sunken = NULL;
	fullSat = true;
}
void Hatchery::push(Unit u){
	Unit *tHatch = Hatch;
	int *tM = M, *tm = m, *tSunken = Sunken;
	bool *tSatis = Satis;
	Hatch = new Unit[nHatch + 2];
	M = new int[nHatch + 2];
	m = new int[nHatch + 2];
	Sunken = new int[nHatch + 2];
	Satis = new bool[nHatch + 2];
	for (int i = 0; i < nHatch; i++){
		Hatch[i] = tHatch[i];
		M[i] = tM[i];
		m[i] = tm[i];
		Sunken[i] = tSunken[i];
		Satis[i] = tSatis[i];
	}
	delete[] tHatch;
	delete[] tM;
	delete[] tm;
	delete[] tSunken;
	delete[] tSatis;
	Hatch[nHatch] = u;
	M[nHatch] = m[nHatch] = Sunken[nHatch] = 0;
	Satis[nHatch] = false;
	Broodwar->registerEvent([u](Game*)
	{
		if (ob) Broodwar->drawCircleMap(u->getPosition(), 400, Colors::Blue);
	}, nullptr, Broodwar->getLatencyFrames()+1);
	BOOST_FOREACH(Unit U, u->getUnitsInRadius(400)){
		if ((U->getType() == UnitTypes::Zerg_Sunken_Colony || U->getType() == UnitTypes::Zerg_Creep_Colony) && IsOwned(U)) Sunken[nHatch]++;
		if (U->getType().isMineralField()) M[nHatch]++;
		if (U->getType().isWorker() && U->isGatheringMinerals()) m[nHatch]++;
	}

	if (M[nHatch] * 1.5 <= m[nHatch] && !(u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted())) Satis[nHatch] = true;
	else fullSat = false;

	if (Satis[nHatch]){
		Broodwar->registerEvent([u](Game*)
		{
			if (ob) Broodwar->drawTextMap(u->getPosition(), "   Satisfied");
		}, nullptr, Broodwar->getLatencyFrames()+1 );
	}
	nHatch++;
}
int Hatchery::getS(Unit u, HATCH T){
	int nSat = 0;
	for (int i = 0; i < nHatch; i++){
		nSat += Satis[i];
		if (Hatch[i] == u){
			switch (T){
			case 0: // Satis
				return Satis[i];
				break;
			case 1: // m
				return m[i];
				break;
			case 3: // Sunken
				return Sunken[i];
				break;
			case 4:
				return true;
				break;
			case 5: // M
				return M[i];
				break;
			}
		}
	}
	if (T == nSatis) return nSat;
	return false;
}
Unit Hatchery::getHFM(Unit u){ // finding minable Hatchery
	if (nHatch == 0) return NULL;
	for (int i = 0; i < nHatch; i++){
		if (!Satis[i]) return Hatch[i];
	}
	for (int i = 0; i < nHatch; i++){
		if (M[i] > 0) return Hatch[i];
	}
	return Hatch[0];
}
Unit Hatchery::getHFD(Unit u){ // Finding Closest minable Hatchery
	Unit H = NULL;
	int d = 100000;
	for (int i = 0; i < nHatch; i++){
		if (d > u->getDistance(Hatch[i]) || H == NULL){
			H = Hatch[i];
			d = u->getDistance(Hatch[i]);
		}
	}
	Broodwar->registerEvent([u, H](Game*){
		if (ob && H) Broodwar->drawLineMap(u->getPosition(), H->getPosition(), Broodwar->getFrameCount() % 12);
	}, nullptr, 1);
	return H;
}
Unit Hatchery::getHHH(Unit u){
	Unit HHH = u->getClosestUnit((GetType == UnitTypes::Zerg_Hatchery || GetType == UnitTypes::Zerg_Lair || GetType == UnitTypes::Zerg_Hive) && IsOwned);
	return HHH;
}
Unit Hatchery::getDDD(){
	for (int i = 0; i < nHatch; i++){
		if (m[i] > 0) return Hatch[i]->getClosestUnit(GetType == UnitTypes::Zerg_Drone && IsOwned && !IsCarryingSomething);
	}
	return NULL;
}
// \Hatchery Manager

// Build Manager
class Build{
private:
	int nBuild;
	int *CCC;
	int *tCCC;
	Unit *builder;
	Unit *tbuilder;
	UnitType *building;
	UnitType *tbuilding;
	TilePosition *position;
	TilePosition *tposition;
public:
	Build()
	{
		nBuild = 0; CCC = NULL;
		builder = NULL; building = NULL; position = NULL;
	}
	bool ok(Unit u){ // returns true if the Unit can be builder
		for (int i = 0; i < nBuild; i++){
			if (builder[i] == u) return false;
		}
		return true;
	}
	bool ok(TilePosition p){
		for (auto &bases : BWTA::getBaseLocations()){
			Position P = static_cast<Position> (bases->getTilePosition());
			Position PP = static_cast<Position> (bases->getTilePosition() + Broodwar->self()->getRace().getCenter().tileSize());
			Position Pp = static_cast<Position> (p);
			if (P.x <= Pp.x && P.y <= Pp.y && Pp.x <= PP.x && Pp.y <= PP.y) return false;
			if (p == bases->getTilePosition()) return false;
		}
		for (int i = 0; i < nBuild; i++){
			Position P = static_cast<Position> (position[i]);
			Position PP = static_cast<Position> (position[i] + building[i].tileSize());
			Position Pp = static_cast<Position> (p);
			if (P.x <= Pp.x && P.y <= Pp.y && Pp.x <= PP.x && Pp.y <= PP.y) return false;
			if (p == position[i]) return false;
		}return true;
	}
	bool ok(TilePosition p, UnitType t){
		for (auto &bases : BWTA::getBaseLocations()){
			Position P = static_cast<Position> (bases->getTilePosition());
			Position PP = static_cast<Position> (bases->getTilePosition() + Broodwar->self()->getRace().getCenter().tileSize());
			Position Pp = static_cast<Position> (p);
			if (P.x <= Pp.x && P.y <= Pp.y && Pp.x <= PP.x && Pp.y <= PP.y) return false;
			if (p == bases->getTilePosition()) return false;
		}
		for (int i = 0; i < nBuild; i++){
			Position P = static_cast<Position> (position[i]);
			Position PP = static_cast<Position> (position[i] + building[i].tileSize());
			Position Pp = static_cast<Position> (p);
			if (P.x <= Pp.x && P.y <= Pp.y && Pp.x <= PP.x && Pp.y <= PP.y) return false;
			if (p == position[i]) return false;
		}return true;
	}
	void build(){
		for (int i = nBuild - 1; i >= 0 && nBuild > 0; i--){
			
			if (!builder[i]->exists() || getask(building[i]) > 1 || builder[i] == Chicken || Unit_drones - getN() < 4 ||
				(building[i] == UnitTypes::Zerg_Hatchery && hatchery_frame + 2000 < Broodwar->getFrameCount()))
			{
				pop(builder[i]);
				return;
			}

			if (ob){
				Unit u = builder[i];
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 5, Colors::Blue, true);
				}, nullptr, Broodwar->getLatencyFrames()+1);
			}

			if (CCC[i] >= 10){
				pop(builder[i]);
			}
			else if (builder[i]->isMorphing() || !Broodwar->canBuildHere(position[i], building[i], builder[i])){
				CCC[i]++;
			}
			else {
				Unit Over = builder[i]->getClosestUnit(IsOwned && GetType == UnitTypes::Zerg_Overlord);
				if (Over) Over->move(builder[i]->getPosition());
				CCC[i] = 0;
				if (builder[i]->getDistance((Position)(position[i] + building[i].tileSize() / 2)) > 100) builder[i]->move((Position)(position[i] + building[i].tileSize() / 2));
				else{
					Unit mine = builder[i]->getClosestUnit(GetType == UnitTypes::Terran_Vulture_Spider_Mine);
					if (mine){
						if (mine->getDistance(builder[i]) < 100){
							builder[i]->attack(mine);
							continue;
						}
					}
					builder[i]->build(building[i], position[i]);
				}
			}
		}
	}
	void push(Unit u, UnitType t){

		TilePosition targetBuildLocation = Broodwar->getBuildLocation(t, u->getTilePosition());

		if (u == Chitang || !ok(targetBuildLocation, t)) return;
		if (HATCHERY.getHHH(u)->getDistance((Position)targetBuildLocation) > 400 && t != UnitTypes::Zerg_Hatchery) return;
		
		BUILD.push(u, t, targetBuildLocation);
	}
	void push(Unit u, UnitType t, TilePosition p){
		if (ob){
			Position a, b;
			a = (Position)p;
			b = (Position)(p + t.tileSize());
			Broodwar->registerEvent([a, b](Game*)
			{
				Broodwar->drawBoxMap(a, b, Colors::Blue);
			}, nullptr, 500);
		}
		if (t == UnitTypes::Zerg_Hatchery) hatchery_frame = Broodwar->getFrameCount();
		if (nBuild == 0){
			CCC = new int[2];
			builder = new Unit[2];
			building = new UnitType[2];
			position = new TilePosition[2];
			CCC[0] = 0;
			builder[0] = u;
			building[0] = t;
			position[0] = p;
			nBuild++;
		}
		else{
			tCCC = CCC;
			CCC = new int[nBuild + 2];
			CCC[0] = 0; for (int i = 0; i < nBuild; i++) CCC[i + 1] = tCCC[i]; delete[] tCCC;
			tbuilder = builder;
			builder = new Unit[nBuild + 2];
			builder[0] = u; for (int i = 0; i < nBuild; i++) builder[i + 1] = tbuilder[i]; delete[] tbuilder;
			tbuilding = building;
			building = new UnitType[nBuild + 2];
			building[0] = t; for (int i = 0; i < nBuild; i++) building[i + 1] = tbuilding[i]; delete[] tbuilding;
			tposition = position;
			position = new TilePosition[nBuild + 2];
			position[0] = p; for (int i = 0; i < nBuild; i++) position[i + 1] = tposition[i]; delete[] tposition;
			nBuild++;
		}
	}
	void pop(Unit u){
		int I = 0; bool found = false;
		while (I < nBuild){
			if (builder[I] == u){
				found = true;
				break;
			}
			I++;
		}if (!found) return;

		if (nBuild == 1){
			nBuild = 0;
			delete[] CCC;
			delete[] builder;
			delete[] building;
			delete[] position;
		}
		else{
			tCCC = CCC;
			CCC = new int[nBuild - 1];
			for (int i = 0, j = 0; i < nBuild; i++){
				if (i == I) continue;
				CCC[j++] = tCCC[i];
			} delete[] tCCC;
			tbuilder = builder;
			builder = new Unit[nBuild - 1];
			for (int i = 0, j = 0; i < nBuild; i++){
				if (i == I) continue;
				builder[j++] = tbuilder[i];
			} delete[] tbuilder;
			tbuilding = building;
			building = new UnitType[nBuild - 1];
			for (int i = 0, j = 0; i < nBuild; i++){
				if (i == I) continue;
				building[j++] = tbuilding[i];
			}delete[] tbuilding;
			tposition = position;
			position = new TilePosition[nBuild - 1];
			for (int i = 0, j = 0; i < nBuild; i++){
				if (i == I)continue;
				position[j++] = tposition[i];
			}delete[] tposition;
			nBuild--;
		}
	}
	int getN(){ return nBuild; }
	int getask(UnitType t){
		int k = 0;
		for (int i = 0; i < nBuild; i++){
			if (building[i] == t) k++;
		}
		return k;

	}
}BUILD;
class Overlord{
private:
	int nOver;
	Unit *Over;
public:
	Overlord(){
		nOver = 0;
		Over = NULL;
	}
	void OVER(){
		for (int i = 0; i < nOver; i++){
			bool gogo = false;
			if (!Over[i]->exists()) gogo = true;
			else if (Over[i]->canMove()) gogo = true;
			if (gogo){
				if (nOver == 1){
					delete[] Over;
					nOver = 0;
				}
				else{
					Unit *tOver = Over;
					Over = new Unit[nOver - 1];
					for (int j = 0, k = 0; j < nOver; j++){
						if (j == i) continue;
						Over[k++] = tOver[j];
					}delete[] tOver;
					nOver--;
				}
				i--;
			}
		}
	}
	void push(Unit u){
		if (nOver == 0){
			Over = new Unit[3];
			Over[0] = u;
			nOver++;
		}
		else{
			Unit *tOver = Over;
			Over = new Unit[nOver + 1];
			for (int i = 0; i < nOver; i++){
				Over[i] = tOver[i];
			}delete[] tOver;
			Over[nOver] = u;
			nOver++;
		}
	}
	int getN(){ return nOver; }
}OVERLORD;
// \Bulid Manager

// Squad Manager
int nTroops = 0;
Unit *Troops = NULL;
class Squad {
private:
	UnitType Type; // 0 for grounds   1 for mutals
	int nSquad;
	Unit *squad;
public:
	Squad(UnitType t = 0){
		Type = t;
		nSquad = 0;
		squad = 0;
	}
	UnitType getT(){ return Type; }
	int getN(){ return nSquad; }
	void push(Unit);
	void pop(int);
	void pop(Unit);
	void Action();
	void Defensive();
	void Dew();
	void Protect();
};
void Squad::push(Unit u){
	if (nTroops == 0){
		Troops = new Unit[3];
		Troops[0] = u;
		nTroops++;
	}
	else{
		Unit *tTroops = Troops;
		Troops = new Unit[nTroops + 1];
		for (int i = 0; i < nTroops; i++){
			Troops[i] = tTroops[i];
		}Troops[nTroops++] = u;
		delete[] tTroops;
	}

	if (nSquad == 0){
		squad = new Unit[3];
		squad[0] = u;
		nSquad++;
		return;
	}
	Unit *tsquad = squad;
	squad = new Unit[nSquad + 1];
	for (int i = 0; i < nSquad; i++){
		squad[i] = tsquad[i];
	}squad[nSquad++] = u;
	delete[] tsquad;
	if (u->getType() == UnitTypes::Zerg_Mutalisk && nSquad >= 8 && Must_mutal) Must_mutal = false;
}
void Squad::pop(int I){
	if (nTroops <= 1){
		nTroops = 0;
		delete[] Troops;
		Troops = NULL;
	}
	else{
		for (int i = 0; i < nTroops; i++){
			if (Troops[i] == squad[I]){
				Unit *tTroops = Troops;
				Troops = new Unit[nTroops + 1];
				for (int j = 0, k = 0; j < nTroops; j++){
					if (j == i) continue;
					Troops[k++] = tTroops[j];
				}
				delete[] tTroops;
				nTroops--;
				break;
			}
		}
	}

	if (nSquad <= 1){
		nSquad = 0;
		delete[] squad;
		squad = NULL;
		return;
	}
	Unit *tsquad = squad;
	squad = new Unit[nSquad];
	for (int i = 0, j = 0; i < nSquad; i++){
		if (i == I) continue;
		squad[j++] = tsquad[i];
	}
	delete[] tsquad;
	nSquad--;
}
void Squad::pop(Unit u){
	for (int i = 0; i < nSquad; i++){
		if (squad[i] == u){
			pop(i);
			return;
		}
	}
}

class SquadManager{
private:
	int nSquad;
	Squad *squad;
public:
	SquadManager(){
		nSquad = 0;
		squad = NULL;
	}
	int getN(){ return nSquad; }
	int getM(UnitType); // Mutal squad number
	void push(Unit);
	void pop(int);
	void pop(Unit);
	void action();

	void Dahyun();
	void Dahye();
	void Daeun();
	void Dahee();
	void Dayoung();
	void Dajung();

	void Jaeeun();
	void Juae();
	void Jungeun();
	void Jung_a();

	void Seohyun();
	void Soyoung();
}MANAGER;

int SquadManager::getM(UnitType T){
	int res = 0;
	for (int i = 0; i < nSquad; i++){
		if (squad[i].getT() == T) res++;
	}
	return res;
}
void SquadManager::push(Unit u){
	for (int i = 0; i < nTroops; i++){
		if (u == Troops[i]) return;
	}
	if (nSquad == 0){
		if (u->getType() == UnitTypes::Zerg_Lurker) squad = new Squad(UnitTypes::Zerg_Zergling);
		else squad = new Squad(u->getType());
		squad->push(u);
		nSquad++;
		return;
	}
	for (int i = 0; i < nSquad; i++){
		UnitType T;
		if (u->getType() == UnitTypes::Zerg_Lurker) T = UnitTypes::Zerg_Zergling;
		else T = u->getType();
		if (squad[i].getT() == T && squad[i].getN() < 12){
			squad[i].push(u);
			return;
		}
	}
	UnitType T;
	if (u->getType() == UnitTypes::Zerg_Lurker) T = UnitTypes::Zerg_Zergling;
	else T = u->getType();

	Squad *tsquad = squad;
	Squad newSquad(T);
	squad = new Squad[nSquad + 1];
	for (int i = 0; i < nSquad; i++){
		squad[i] = tsquad[i];
	}squad[nSquad] = newSquad;
	delete[] tsquad;
	squad[nSquad].push(u);
	nSquad++;
}
void SquadManager::pop(int I){
	if (nSquad == 0) return;
	Squad *tsquad = squad;
	squad = new Squad[nSquad - 1];
	for (int i = 0, j = 0; i < nSquad; i++){
		if (i == I) continue;
		squad[j++] = tsquad[i];
	}
	delete[] tsquad;
	nSquad--;
}
void SquadManager::pop(Unit u){
	for (int i = 0; i < nSquad; i++){
		squad[i].pop(u);
	}
}
void SquadManager::action(){
	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		else squad[i].Action();
	}
}

void Squad::Action(){
	Unit target = NULL;
	bool ranged = false; // Sky attackable
	bool rangeD = false; // attackable
	Position ppp; // for Mutal 
	Unit Home = NULL;
	int HP = 100;
	int ranged_dist = 100000;

	Unit egg = NULL;
	int ddd = 100000;

	for (int i = 0; i < nSquad; i++){
		if (!squad[i]->exists()){
			pop(i);
			return;
		}
		if (squad[i]->isIrradiated()){
			Unit ee = squad[i]->getClosestUnit(IsEnemy);
			if (ee) squad[i]->attack(ee->getPosition());
			pop(i);
			return;
		}
		if (squad[i]->getType() != UnitTypes::Zerg_Lurker && squad[i]->canUnburrow()) squad[i]->unburrow();
		Unit u = squad[i];

		if (i == 0){
			Unit Over = squad[i]->getClosestUnit(IsOwned && GetType == UnitTypes::Zerg_Overlord && !IsBlind);
			if (Over) Over->move(squad[i]->getPosition());
		}

		Unit AVE = NULL;
		AVE = squad[i]->getClosestUnit(IsEnemy && IsBuilding);

		if (Search && AVE != NULL){
			Search = false;
			ave = AVE->getPosition();
			ave.makeValid();
			BOOST_FOREACH(Unit ling, Broodwar->self()->getUnits()){
				if (ling->canAttackMove() && !IsWorker(ling))
					ling->attack(ave);
			}
		}

		if (squad[i]->getDistance(ave) <= 150){
			if (ave != (Position)Broodwar->self()->getStartLocation() || (Zia1 == Strat::Dayoung && ave == (Position)Broodwar->self()->getStartLocation())){
				if (AVE != NULL){
					Search = false;
					ave = AVE->getPosition();
					ave.makeValid();
				}
				else if (!Search){
					search_frame = Broodwar->getFrameCount();
					Search = true;
				}
			}
		}
		if (Search && squad[i]->isIdle()){
			if (ENEMY.getN() > 0){
				Position pp = ENEMY.Yeram();
				if (pp.isValid()){
					squad[i]->attack(pp);
					if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), pp, Colors::Red);
					continue;
				}
			}
		}
		if (Search && Type != UnitTypes::Zerg_Mutalisk)
			continue;

		if (Type == UnitTypes::Zerg_Zergling){
			//// Lurker
			if (squad[i]->getType() == UnitTypes::Zerg_Lurker){
				Unit egg;
				int egg2 = 0;
				if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
					egg = squad[i]->getClosestUnit(GetType == UnitTypes::Zerg_Egg && !IsOwned);
					if (squad[i]->isBurrowed() && egg){
						if (squad[i]->isInWeaponRange(egg)){
							squad[i]->attack(egg);
							if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), egg->getPosition(), Colors::Red);
						}
					}
				}
				if (squad[i]->canUnburrow() && Broodwar->getFrameCount() - 300 <= squad[i]->getLastCommandFrame() ) continue;
				if (squad[i]->canBurrow() && Broodwar->getFrameCount() - 5 <= squad[i]->getLastCommandFrame()) continue;
				bool EE = false;
				BOOST_FOREACH(Unit target, squad[i]->getUnitsInRadius(190)){
					if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
						if (!IsEnemy(target) && !IsOwned(target) && target->getType() == UnitTypes::Zerg_Egg){
							egg2++;
							if (egg2 > 1){
								EE = true;
								if (squad[i]->canBurrow()){
									squad[i]->burrow();
									break;
								}
							}
						}
					}
					if (!IsEnemy(target) || !IsVisible(target) || IsFlying(target)) continue;
					EE = true;
					if (squad[i]->canBurrow()){
						squad[i]->burrow();
						break;
					}
				}
				if (!EE && squad[i]->canUnburrow()) squad[i]->unburrow();
				else{
					Position ppE = ENEMY.avE(squad[i]);
					squad[i]->move(ppE);
					if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), ppE, Colors::Red);
				}
				continue;
			}
			//// lings
			if (squad[i]->getLastCommandFrame() + 5 + Unit_lings / 10 > Broodwar->getFrameCount()) continue;

			Unit u = squad[i];
			Unit target = NULL;
			int dist = 0;
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(224)){
				if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
					if (egg == NULL && !IsEnemy(ee) && !IsOwned(ee) && ee->getType() == UnitTypes::Zerg_Egg){
						egg = ee;
						ddd = u->getDistance(ee);
					}
					else if (egg != NULL && !IsEnemy(ee) && !IsOwned(ee) && ee->getType() == UnitTypes::Zerg_Egg && u->getDistance(ee) < ddd){
						egg = ee;
						ddd = u->getDistance(ee);
					}
				}
				if (!IsVisible(ee) || !IsEnemy(ee) || IsFlying(ee)) continue;
				if (ee->getType().groundWeapon().damageAmount() == 0 && !(ee->getType() == UnitTypes::Terran_Bunker && ee->isCompleted())) continue;
				if (ee->getType() == UnitTypes::Terran_Bunker || ee->getType() == UnitTypes::Protoss_Photon_Cannon || ee->getType() == UnitTypes::Zerg_Sunken_Colony){
					if (ee->isCompleted()) defensive = true;
				}
				if (target == NULL){
					target = ee;
					dist = u->getDistance(ee);
				}
				else if (u->getDistance(ee) < dist){
					target = ee;
					dist = target->getDistance(u);
				}
			}
			if (target){
				if (target->getType().groundWeapon().damageAmount() > 0 || target->getType() == UnitTypes::Terran_Bunker){
					u->attack(target);
					if (ob) Broodwar->drawLineMap(u->getPosition(), target->getPosition(), Colors::Red);
					continue;
				}
			}
			else if (egg){
				u->attack(egg);
				if (ob) Broodwar->drawLineMap(u->getPosition(), egg->getPosition(), Colors::Red);
				continue;
			}
			else {
				target = u->getClosestUnit(IsEnemy&&!IsFlying);
				if (target){
					u->attack(target);
					if (ob) Broodwar->drawLineMap(u->getPosition(), target->getPosition(), Colors::Red);
				}
			}
			if (u->isIdle() && !target){
				Position ppE = ENEMY.avE(squad[i]);
				u->attack(ppE);
				if (ob) Broodwar->drawLineMap(u->getPosition(), ppE, Colors::Red);
			}
			continue;
		}
		else if (Type == UnitTypes::Zerg_Mutalisk){
			if (i == 0){ // targeting
				if (squad[i]->getDistance(ave) <= 150 && !dew){
					Unit AVE = NULL;
					AVE = squad[i]->getClosestUnit((IsEnemy&&IsBuilding));
					if (AVE != NULL){
						ave = AVE->getPosition();
						ave.makeValid();
					}
				}
				Home = squad[i]->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Creep_Colony || GetType == UnitTypes::Zerg_Sunken_Colony));
				if (!Home) Home = HATCHERY.getHHH(squad[i]);
				BOOST_FOREACH(Unit ranger, squad[i]->getUnitsInRadius(256)){
					if (!ranger->isVisible(Broodwar->self())) continue;
					if (ranger->getType() == UnitTypes::Zerg_Larva || ranger->getType() == UnitTypes::Zerg_Egg || ranger->getType() == UnitTypes::Zerg_Lurker_Egg) continue;
					if (!IsEnemy(ranger) || !squad[i]->canAttackUnit(ranger) || !squad[i]->canRightClickUnit(ranger))continue;

					//if (ranged && ranger->getType().airWeapon().damageAmount() > 0 && HP > ranger->getHitPoints()){
					if (ranged && ranger->getType().airWeapon().damageAmount() > 0 && ranged_dist > squad[i]->getDistance(ranger)){
						target = ranger;
						//HP = ranger->getHitPoints();
						ranged_dist = squad[i]->getDistance(ranger);
					}
					else if (!ranged && (ranger->getType().airWeapon().damageAmount() > 0 || ranger->getType() == UnitTypes::Terran_Bunker)){
						target = ranger;
						ranged = true;
						//HP = ranger->getHitPoints();
						ranged_dist = squad[i]->getDistance(ranger);
					}
					else if (!ranged && rangeD && HP > ranger->getHitPoints()){
						target = ranger;
						HP = ranger->getHitPoints();
					}
					else if (!ranged && !rangeD && ranger->getType().groundWeapon().damageAmount() > 0){
						target = ranger;
						rangeD = true;
						HP = ranger->getHitPoints();
					}
					else if (target == NULL || (!ranged && !rangeD && HP > ranger->getHitPoints())){
						target = ranger;
						HP = ranger->getHitPoints();
					}
				}
				//if (!target) target = squad[i]->getClosestUnit(IsEnemy);
				if (!target) target = Home;
				if (ranged && target){
					ppp.x = 4 * squad[i]->getPosition().x - 3 * target->getPosition().x;
					ppp.y = 4 * squad[i]->getPosition().y - 3 * target->getPosition().y;
					ppp.makeValid();
				}
			}
			if (squad[i]->getLastCommandFrame() + 5 > Broodwar->getFrameCount() && squad[i]->getLastCommand().getType() == UnitCommandTypes::Move ) continue;
			if (target != Home && target){
				if (!squad[i]->isInWeaponRange(target)) squad[i]->attack(target->getPosition());
				else if (squad[i]->getDistance(target) < 85 && ranged){
					//squad[i]->attack(target);
					squad[i]->patrol(target->getPosition());
					squad[i]->move(ppp);
				}
				else squad[i]->attack(target);
				if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), target->getPosition(), Colors::Red);
			}
			else{
				Position ppE = ENEMY.avE(squad[i]);
				squad[i]->attack(ppE);
				if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), ppE, Colors::Red);
			}
		}
		else if (Type == UnitTypes::Zerg_Hydralisk){
			if (squad[i]->getLastCommandFrame() + 5 + Unit_hydras/10 > Broodwar->getFrameCount()) continue;
			Unit u = squad[i];
			Unit uu = NULL;
			int uud = 100000;
			enum Hydra { Evade, Attack, Chase, Charge };
			int Heil_Hydra = Hydra::Charge;
			BOOST_FOREACH(Unit ee, squad[i]->getUnitsInRadius(256)){
				if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
					if (egg == NULL && !IsEnemy(ee) && !IsOwned(ee) && ee->getType() == UnitTypes::Zerg_Egg){
						egg = ee;
						ddd = u->getDistance(ee);
					}
					else if (egg != NULL && !IsEnemy(ee) && !IsOwned(ee) && ee->getType() == UnitTypes::Zerg_Egg && u->getDistance(ee) < ddd){
						egg = ee;
						ddd = u->getDistance(ee);
					}
				}
				if (!IsEnemy(ee) || !ee->isVisible(Broodwar->self())) continue;
				if (((ee->isFlying() && u->getDistance(ee) <= u->getType().airWeapon().maxRange() * 4 / 10)
					|| (!ee->isFlying() && u->getDistance(ee) <= u->getType().groundWeapon().maxRange() * 4 / 10))
					&& ee->getType().groundWeapon().damageAmount() > 0){
					Position ppp;
					ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
					ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
					ppp.makeValid();
					u->attack(ppp);
					if (ob) Broodwar->drawLineMap(u->getPosition(), ppp, Colors::Red);
					Heil_Hydra = Hydra::Evade;
					break;
				}
				if (ee->getType().groundWeapon().damageAmount() > 0 && u->isInWeaponRange(ee)){
					if (Heil_Hydra == Hydra::Attack){
						if (ee->getHitPoints() < HP){
							target = ee;
							HP = ee->getHitPoints();
						}
					}
					else{
						target = ee;
						HP = ee->getHitPoints();
						Heil_Hydra = Hydra::Attack;
					}
				}
				if (Heil_Hydra == Hydra::Charge && ee->getType().groundWeapon().damageAmount() > 0){
					target = ee;
					Heil_Hydra = Hydra::Chase;
				}
				if (Heil_Hydra == Hydra::Charge && u->isInWeaponRange(ee) && !IsBuilding(ee) && (!uu || uud > u->getDistance(ee))){
					uu = ee;
					uud = u->getDistance(ee);
				}
			}
			switch (Heil_Hydra){
			case Hydra::Attack:
				u->attack(target);
				if (ob) Broodwar->drawLineMap(u->getPosition(), target->getPosition(), Colors::Red);
				break;
			case Hydra::Chase:
				u->attack(target);
				if (ob) Broodwar->drawLineMap(u->getPosition(), target->getPosition(), Colors::Red);
				break;
			case Hydra::Charge:
				Position ppE = ENEMY.avE(squad[i]);
				target = u->getClosestUnit(IsEnemy && IsBuilding);
				if (egg){
					u->attack(egg);
					if (ob) Broodwar->drawLineMap(u->getPosition(), egg->getPosition(), Colors::Red);
				}
				else if (uu){
					u->attack(uu->getPosition());
					if (ob) Broodwar->drawLineMap(u->getPosition(), uu->getPosition(), Colors::Red);
				}
				else if (target){
					u->attack(target);
					if (ob) Broodwar->drawLineMap(u->getPosition(), target->getPosition(), Colors::Red);
				}
				else if(u->isIdle()){
					u->attack(ppE);
					if (ob) Broodwar->drawLineMap(u->getPosition(), ppE, Colors::Red);
				}
				break;
			}
		}
		else if (Type == UnitTypes::Zerg_Scourge){
			Unit ee = squad[i]->getClosestUnit(IsEnemy && IsFlying && !IsBuilding);
			if (ee){
				squad[i]->attack(ee);
				if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), ee->getPosition(), Colors::Red);
			}
			else{
				Unit Home = HATCHERY.getHHH(squad[i]);
				if (Home){
					squad[i]->move(Home->getPosition());
					if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), Home->getPosition(), Colors::Red);
				}
			}
		}
	}
}
void Squad::Defensive(){
	static bool FLY = true;
	Unit Home;
	bool hhh = false;
	Position home;
	for (int i = 0; i < nSquad; i++){
		if (!squad[i]->exists()){
			pop(i);
			return;
		}
		if (squad[i]->getType() == UnitTypes::Zerg_Hydralisk && (Zia == Strat::Jungeun||Zia == Strat::Soyoung)){
			if (squad[i]->canMorph(UnitTypes::Zerg_Lurker)){
				squad[i]->morph(UnitTypes::Zerg_Lurker);
				pop(i);
				return;
			}
		}
		if (squad[i]->getType() == UnitTypes::Zerg_Mutalisk && FLY){
			if (squad[i]->getHitPoints() < 120){
				FLY = false;
				return;
			}
			Unit ee = squad[i]->getClosestUnit(IsEnemy&&IsVisible);
			if (ee){
				squad[i]->attack(ee);
				if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), ee->getPosition(), Colors::Red);
			}
			else{
				Position ppE = ENEMY.avE(squad[i]);
				squad[i]->attack(ppE);
				if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), ppE, Colors::Red);
			}
			continue;
		}
		if (i == 0){ // Captain determines
			Home = squad[i]->getClosestUnit(IsOwned && GetType == UnitTypes::Zerg_Sunken_Colony && IsCompleted);
			if (!Home && BUILD.getN() == 0){
				Unit Pool = squad[i]->getClosestUnit(IsOwned && GetType == UnitTypes::Zerg_Spawning_Pool);
				if (Pool){
					home = BWTA::getNearestChokepoint(Pool->getPosition())->getCenter();
					hhh = true;
				}
			}
			Home = squad[i]->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Creep_Colony || GetType == UnitTypes::Zerg_Sunken_Colony));
			if (!Home) Home = HATCHERY.getHHH(squad[i]);
		}
		if (hhh){
			if (Broodwar->getFrameCount() % 9 != 0) continue;
			if (squad[i]->getType() == UnitTypes::Zerg_Lurker) squad[i]->move(home);
			else squad[i]->attack(home);
			if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), home, Colors::Red);
		}
		else if (Home){
			if (Broodwar->getFrameCount() % 9 != 0) continue;
			if (squad[i]->getDistance(Home) < 100){
				if (squad[i]->getType() == UnitTypes::Zerg_Lurker){
					if (squad[i]->canBurrow()) squad[i]->burrow();
				}
				continue;
			}
			if (squad[i]->getType() == UnitTypes::Zerg_Lurker) squad[i]->move(Home->getPosition());
			else squad[i]->move(Home->getPosition());
			if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), Home->getPosition(), Colors::Red);
		}
	}
}
void Squad::Dew(){
	Unit target = NULL;
	bool ranged = false; // Sky attackable
	bool rangeD = false; // attackable
	Position ppp; // for Mutal 
	Unit Home = NULL;
	int HP = 100;
	int ranged_dist = 100000;

	Unit egg = NULL;
	int ddd = 100000;

	for (int i = 0; i < nSquad; i++){
		if (!squad[i]->exists()){
			pop(i);
			return;
		}
		if (squad[i]->isIrradiated()){
			Unit ee = squad[i]->getClosestUnit(IsEnemy);
			if (ee) squad[i]->attack(ee->getPosition());
			pop(i);
			return;
		}
		if (squad[i]->getType() != UnitTypes::Zerg_Lurker && squad[i]->canUnburrow()) squad[i]->unburrow();
		Unit u = squad[i];

		if (i == 0){
			Unit Over = squad[i]->getClosestUnit(IsOwned && GetType == UnitTypes::Zerg_Overlord);
			if (Over) Over->move(squad[i]->getPosition());
		}
		
		if (Type == UnitTypes::Zerg_Zergling){

			if (squad[i]->getType() == UnitTypes::Zerg_Lurker){
				if (squad[i]->canUnburrow() && Broodwar->getFrameCount() % 300 != 0) continue;
				bool EE = false;
				BOOST_FOREACH(Unit target, squad[i]->getUnitsInRadius(190)){
					if (!IsEnemy(target) || !IsVisible(target) || IsFlying(target)) continue;
					EE = true;
					if (squad[i]->canBurrow()){
						squad[i]->burrow();
						break;
					}
				}
				if (!EE && squad[i]->canUnburrow()) squad[i]->unburrow();
				else{
					target = squad[i]->getClosestUnit(IsEnemy && IsBuilding && !IsFlying);
					if (target){
						squad[i]->move(target->getPosition());
						if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), target->getPosition(), Colors::Red);
					}
					else{
						squad[i]->move(ave2);
						if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), ave2, Colors::Red);
					}
				}
				continue;
			}

			if (squad[i]->getLastCommandFrame() + 5 > Broodwar->getFrameCount()) continue;

			Unit u = squad[i];
			Unit target = NULL;
			int dist = 0;
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(224)){
				if (!IsVisible(ee) || !IsEnemy(ee) || IsFlying(ee)) continue;
				if (ee->getType().groundWeapon().damageAmount() == 0 && ee->getType() != UnitTypes::Terran_Bunker) continue;
				if (ee->getType() == UnitTypes::Terran_Bunker || ee->getType() == UnitTypes::Protoss_Photon_Cannon || ee->getType() == UnitTypes::Zerg_Sunken_Colony){
					if (ee->isCompleted()) defensive = true;
				}
				if (target == NULL){
					target = ee;
					dist = u->getDistance(ee);
				}
				else if (u->getDistance(ee) < dist){
					target = ee;
					dist = target->getDistance(u);
				}
			}
			if (target){
				if (target->getType().groundWeapon().damageAmount() > 0){
					u->attack(target);
					if (ob) Broodwar->drawLineMap(u->getPosition(), target->getPosition(), Colors::Red);
					continue;
				}
			}
			if (u->isIdle() || Broodwar->getFrameCount() % 10 == 0){
				u->attack(ave2);
				if (ob) Broodwar->drawLineMap(u->getPosition(), ave2, Colors::Red);
				continue;
			}
			continue;
		}
		else if (Type == UnitTypes::Zerg_Mutalisk){
			if (i == 0){ // targeting
				Home = squad[i]->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Creep_Colony || GetType == UnitTypes::Zerg_Sunken_Colony));
				if (!Home) Home = HATCHERY.getHHH(squad[i]);
				BOOST_FOREACH(Unit ranger, squad[i]->getUnitsInRadius(256)){
					if (!ranger->isVisible(Broodwar->self())) continue;
					if (ranger->getType() == UnitTypes::Zerg_Larva || ranger->getType() == UnitTypes::Zerg_Egg || ranger->getType() == UnitTypes::Zerg_Lurker_Egg) continue;
					if (!IsEnemy(ranger) || !squad[i]->canAttackUnit(ranger) || !squad[i]->canRightClickUnit(ranger))continue;

					//if (ranged && ranger->getType().airWeapon().damageAmount() > 0 && HP > ranger->getHitPoints()){
					if (ranged && ranger->getType().airWeapon().damageAmount() > 0 && ranged_dist > squad[i]->getDistance(ranger)){
						target = ranger;
						//HP = ranger->getHitPoints();
						ranged_dist = squad[i]->getDistance(ranger);
					}
					else if (!ranged && (ranger->getType().airWeapon().damageAmount() > 0 || ranger->getType() == UnitTypes::Terran_Bunker)){
						target = ranger;
						ranged = true;
						//HP = ranger->getHitPoints();
						ranged_dist = squad[i]->getDistance(ranger);
					}
					else if (!ranged && rangeD && HP > ranger->getHitPoints()){
						target = ranger;
						HP = ranger->getHitPoints();
					}
					else if (!ranged && !rangeD && ranger->getType().groundWeapon().damageAmount() > 0){
						target = ranger;
						rangeD = true;
						HP = ranger->getHitPoints();
					}
					else if (target == NULL || (!ranged && !rangeD && HP > ranger->getHitPoints())){
						target = ranger;
						HP = ranger->getHitPoints();
					}
				}
				//if (!target) target = squad[i]->getClosestUnit(IsEnemy);
				if (!target) target = Home;
				if (ranged){
					ppp.x = 4 * squad[i]->getPosition().x - 3 * target->getPosition().x;
					ppp.y = 4 * squad[i]->getPosition().y - 3 * target->getPosition().y;
					ppp.makeValid();
				}
			}
			if (squad[i]->getLastCommandFrame() + 5 > Broodwar->getFrameCount() && squad[i]->getLastCommand().getType() == UnitCommandTypes::Patrol) continue;
			if (target != Home){
				if (!squad[i]->isInWeaponRange(target)) squad[i]->attack(target->getPosition());
				else if (squad[i]->getDistance(target) < 85 && ranged){
					//squad[i]->attack(target);
					squad[i]->patrol(target->getPosition());
					squad[i]->move(ppp);
				}
				else squad[i]->attack(target);
				if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), target->getPosition(), Colors::Red);
			}
			else{
				squad[i]->attack(ave2);
				if (ob) Broodwar->drawLineMap(squad[i]->getPosition(), ave2, Colors::Red);
			}
		}
		else if (Type == UnitTypes::Zerg_Hydralisk){
			if (squad[i]->getLastCommandFrame() + 5 > Broodwar->getFrameCount()) continue;
			Unit u = squad[i];
			Unit uu = NULL;
			int uud = 100000;
			enum Hydra { Evade, Attack, Chase, Charge };
			int Heil_Hydra = Hydra::Charge;
			BOOST_FOREACH(Unit ee, squad[i]->getUnitsInRadius(256)){
				if (!IsEnemy(ee) || !ee->isVisible(Broodwar->self())) continue;
				if (((ee->isFlying() && u->getDistance(ee) <= u->getType().airWeapon().maxRange() * 4 / 10)
					|| (!ee->isFlying() && u->getDistance(ee) <= u->getType().groundWeapon().maxRange() * 4 / 10))
					&& ee->getType().groundWeapon().damageAmount() > 0){
					Position ppp;
					ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
					ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
					ppp.makeValid();
					u->attack(ppp);
					if (ob) Broodwar->drawLineMap(u->getPosition(), ppp, Colors::Red);
					Heil_Hydra = Hydra::Evade;
					break;
				}
				if (ee->getType().groundWeapon().damageAmount() > 0 && u->isInWeaponRange(ee)){
					if (Heil_Hydra == Hydra::Attack){
						if (ee->getHitPoints() < HP){
							target = ee;
							HP = ee->getHitPoints();
						}
					}
					else{
						target = ee;
						HP = ee->getHitPoints();
						Heil_Hydra = Hydra::Attack;
					}
				}
				if (Heil_Hydra == Hydra::Charge && ee->getType().groundWeapon().damageAmount() > 0){
					target = ee;
					Heil_Hydra = Hydra::Chase;
				}
				if (Heil_Hydra == Hydra::Charge && u->isInWeaponRange(ee) && !IsBuilding(ee) && (!uu || uud > u->getDistance(ee))){
					uu = ee;
					uud = u->getDistance(ee);
				}
			}
			switch (Heil_Hydra){
			case Hydra::Attack:
				u->attack(target);
				if (ob) Broodwar->drawLineMap(u->getPosition(), target->getPosition(), Colors::Red);
				break;
			case Hydra::Chase:
				u->attack(target);
				if (ob) Broodwar->drawLineMap(u->getPosition(), target->getPosition(), Colors::Red);
				break;
			case Hydra::Charge:
				target = u->getClosestUnit(IsEnemy && IsBuilding);
				if (uu){
					u->attack(uu->getPosition());
					if (ob) Broodwar->drawLineMap(u->getPosition(), uu->getPosition(), Colors::Red);
				}
				else if (target){
					u->attack(target->getPosition());
					if (ob) Broodwar->drawLineMap(u->getPosition(), target->getPosition(), Colors::Red);
				}
				else{
					u->attack(ave2);
					if (ob) Broodwar->drawLineMap(u->getPosition(), ave2, Colors::Red);
				}
				break;
			}
		}
	}
}
void Squad::Protect(){
	for (int i = 0; i < nSquad; i++){
		if (!squad[i]->exists()){
			pop(i);
			return;
		}
		if (squad[i]->getHitPoints() * 100 / squad[i]->getType().maxHitPoints() <= 30){
			Unit Cargo = HATCHERY.getHHH(squad[i]);
			if (Cargo) squad[i]->move(Cargo->getPosition());
			else squad[i]->move((Position)Broodwar->self()->getStartLocation());
			if (squad[i]->canBurrow()) squad[i]->burrow();
			pop(i);
			return;
		}
	}
}

void Seohwang(){
	for (int i = 0; i < nTroops; i++){
		if (Troops[i]->getType() == UnitTypes::Zerg_Zergling || ((Zia==Strat::Juae || Zia==Strat::Seohyun)&&Troops[i]->getType() == UnitTypes::Zerg_Hydralisk )){
			Seowhang = Troops[i];
			MANAGER.pop(Seowhang);
			return;
		}
	}
}
// \ Squad Manager

// Unit Counter
bool Unit_Counter(){
	/*
		Specially deals with Overlord search, Queens
	*/
	Supply_used = Broodwar->self()->supplyUsed();
	Unit_larva = 0;
	Unit_drones = 0;
	Unit_lings = 0;
	Unit_hydras = 0;
	Unit_queens = 0;
	Unit_scourges = 0;
	Unit_mutals = 0;

	HATCHERY.clear();
	Building_hatcheries = 0;
	Building_pool = 0;
	Building_pool2 = false;
	Building_lair = 0;
	Building_lair2 = false;
	Building_hive = 0;
	Building_hive2 = false;
	Building_spire = 0;
	Building_spire2 = false;
	Building_den = 0;
	Building_den2 = false;
	Building_chamber = 0;
	Building_queen = 0;
	BOOST_FOREACH(Unit u, Broodwar->self()->getUnits()){
		if (u->getType() != UnitTypes::Zerg_Lurker && u->canUnburrow() && u->getHitPoints() * 100 / u->getType().maxHitPoints() >= 50) u->unburrow();
		if (!u->getType().isWorker() && (u->canAttack() || u->getType() == UnitTypes::Zerg_Lurker) && u->isIdle() &&
			u->getHitPoints() * 100 / u->getType().maxHitPoints() >= 50 && !IsBuilding(u) && !IsIrradiated(u) &&
			u != Seowhang){
			MANAGER.push(u);
		}
		if (u->getType() == UnitTypes::Zerg_Egg){
			Supply_used += u->getBuildType().supplyRequired();
		}
		if (cancel){
			if (u->canCancelConstruction())
				u->cancelConstruction();
			if (u->canCancelResearch())
				u->cancelResearch();
			if (u->canCancelTrain())
				u->cancelTrain();
			if (u->canCancelUpgrade())
				u->cancelUpgrade();
		}
		if (u->canLift()) u->lift();
		if (u->isFlying() && IsBuilding(u)){
			if (u->isIdle()){
				u->move((Position)DESIGNER.getBase());
			}
		}
		if (u->getType() == UnitTypes::Zerg_Overlord && search_frame + 500 < Broodwar->getFrameCount() && Search){
			if (u->isIdle()){
				u->move((Position)DESIGNER.getBase());
			}
		}

		if (u->getType().isWorker())
			Unit_drones++;
		else if (u->getType() == UnitTypes::Zerg_Larva)
			Unit_larva++;
		else if (u->getType() == UnitTypes::Zerg_Hydralisk)
			Unit_hydras++;
		else if (u->getType() == UnitTypes::Zerg_Zergling)
			Unit_lings++;
		else if (u->getType() == UnitTypes::Zerg_Queen){
			Unit_queens++;
			if (u->isIrradiated()){
				if (u->getEnergy() >= 75){
					Unit target = u->getClosestUnit(IsEnemy && !IsBuilding && !IsParasited);
					if (u->canUseTechUnit(TechTypes::Parasite, target)) u->useTech(TechTypes::Parasite, target);
					else u->move(ENEMY.avE(u));
				}
				else{
					if (u->isIdle()) u->move(ENEMY.avE(u));
				}
			}
			else{
				Unit target = u->getClosestUnit(IsEnemy && (GetType == UnitTypes::Terran_Siege_Tank_Siege_Mode || GetType == UnitTypes::Terran_Siege_Tank_Tank_Mode));
				bool evade = false;
				Position ppp;
				BOOST_FOREACH(Unit QQ, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(QQ)){
						if (QQ->getType().airWeapon().damageAmount() > 0){
							if (QQ->isInWeaponRange(u)){
								evade = true;
								ppp.x = 2 * u->getPosition().x - 1 * QQ->getPosition().x;
								ppp.y = 2 * u->getPosition().y - 1 * QQ->getPosition().y;
								ppp.makeValid();
							}
						}
						if (!target && u->canUseTechUnit(TechTypes::Spawn_Broodlings, QQ) && QQ->getType().gasPrice() > 0 ) target = QQ;
					}
				}
				if (u->getEnergy() >= 150 && Broodwar->self()->hasResearched(TechTypes::Spawn_Broodlings)){
					//casting
					if (target){
						u->useTech(TechTypes::Spawn_Broodlings, target);
					}
					//hanging
					else if (evade){
						u->move(ppp);						
					}
					else{
						if (u->isIdle()){
							u->move((Position)DESIGNER.getBase());
						}
					}
				}
				else{
					//evade
					if (evade){
						u->move(ppp);
					}
					//home
					else{
						Unit home = HATCHERY.getHHH(u);
						if (home){
							if (u->getDistance(home) > 100) u->move(home->getPosition());
						}
					}
				}
			}
		}
		else if (u->getType() == UnitTypes::Zerg_Scourge)
			Unit_scourges++;
		else if (u->getType() == UnitTypes::Zerg_Mutalisk)
			Unit_mutals++;
		else if ((u->getType().producesLarva() || u->getBuildType() == UnitTypes::Zerg_Hatchery || u->getBuildType() == UnitTypes::Zerg_Lair
			|| u->getBuildType() == UnitTypes::Zerg_Hive) && IsBuilding(u)){

			if (u->getType() == UnitTypes::Zerg_Hive && !IsMorphing(u)) Building_hive2 = true;
			if (u->getBuildType() == UnitTypes::Zerg_Hive || u->getType() == UnitTypes::Zerg_Hive){
				Building_hive++;
				Building_lair++;
				Building_lair2 = true;
			}
			else {
				if (u->getBuildType() == UnitTypes::Zerg_Lair || u->getType() == UnitTypes::Zerg_Lair) Building_lair++;
				if ((u->getType() == UnitTypes::Zerg_Lair && u->isIdle())){
					Building_lair2 = true;
				}
			}

			Building_hatcheries++;
			if (DESIGNER.ask(u->getTilePosition()))
				HATCHERY.push(u);
		}
		else if (u->getType() == UnitTypes::Zerg_Spawning_Pool || u->getBuildType() == UnitTypes::Zerg_Spawning_Pool){
			if (u->isCompleted()) Building_pool2 = true;
			Building_pool++;
		}
		else if (u->getType() == UnitTypes::Zerg_Spire || u->getBuildType() == UnitTypes::Zerg_Spire){
			Building_spire++;
			if (u->isCompleted()) Building_spire2 = true;
		}
		else if (u->getType() == UnitTypes::Zerg_Hydralisk_Den){
			Building_den++;
			if (u->isCompleted()) Building_den2 = true;
		}
		else if (u->getType() == UnitTypes::Zerg_Evolution_Chamber)
			Building_chamber++;
		else if (u->getType() == UnitTypes::Zerg_Queens_Nest)
			Building_queen++;
	}

	if (Unit_drones > 0 || Broodwar->self()->minerals() >= 50)
		cancel = false;
	else
		cancel = true;

	if ((Broodwar->self()->minerals() < 50 && Supply_used == 0) || Broodwar->getFrameCount() >= 100000){
		Broodwar->sendText("gg");
		Broodwar->leaveGame();
	}
	return true;
}
// \Unit Counter

// Scout Manager
void yerin(){ // First scout
	if (Chicken == NULL || !Chicken->exists()){
		if (Yerin){
			ave = Startings[sStartings];
			Yerin = false;
		}
		return;
	}

	int dist = -1;
	for (int i = 0; i < nStartings; i++){
		if (Startings_check[i] == true) continue;
		if (dist == -1 || (dist != -1 && dist > Chicken->getDistance(Startings[i]))){
			sStartings = i;
			ave = Startings[sStartings];
			if (Zia == Dahyun || Zia == Dahye){
				BOOST_FOREACH(Unit lings, Broodwar->self()->getUnits()){
					if (lings->getType() == UnitTypes::Zerg_Zergling)
						lings->attack(ave);
				}
			}
			dist = Chicken->getDistance(Startings[i]);
		}
	}
	Chicken->move(Startings[sStartings]);
	if (Chicken->getDistance(Startings[sStartings]) < 200) Startings_check[sStartings] = true;
	if (sStartings >= nStartings) Yerin = false;
}
void chang(){
	static Unit Fried;
	if (!Chicken->exists()){
		Chicken = NULL;
		Chang = false;
		return;
	}
	if (Chicken->getHitPoints() < 40){
		Chang = false;
		Unit Cargo = HATCHERY.getHHH(Chicken);
		if (Cargo) Chicken->move(Cargo->getPosition());
		Chicken = NULL;
		return;
	}
	if (!Fried){
		Chicken->move(ave);
		Fried = Chicken->getClosestUnit(IsEnemy && GetType == Broodwar->enemy()->getRace().getWorker());
	}
	else{
		if (Chicken->getLastCommandFrame() + Broodwar->getLatencyFrames() < Broodwar->getFrameCount())
			Chicken->attack(Fried);
		if (Zia == Strat::Dahyun){
			Chang = false;
		}
	}
}
void ddangddang(){
	if (!Special_chicken){
		Ddangddang = false;
		return;
	}
	if (IsBuilding(Special_chicken)){
		Ddangddang = false;
		Special_chicken = NULL;
		return;
	}
	if (BUILD.ok(Special_chicken)){
		Unit EH = Special_chicken->getClosestUnit(IsEnemy && GetType == UnitTypes::Zerg_Hatchery && IsCompleted);
		if (EH){
			TilePosition tb = Broodwar->getBuildLocation(UnitTypes::Zerg_Creep_Colony, EH->getTilePosition());
			if (EH->getDistance((Position)tb) <= 400 && BUILD.ok(Special_chicken)){
				BUILD.push(Special_chicken, UnitTypes::Zerg_Creep_Colony, tb);
				return;
			}
		}
		else {
			Special_chicken->move(ave);
		}
		return;
	}
}
void neoddang(){
	if (!Neo_chicken){
		Neoddang = false;
		return;
	}
	if (IsBuilding(Neo_chicken)){
		Neoddang = false;
		Neo_chicken = NULL;
		return;
	}
	if (BUILD.ok(Neo_chicken)){
		Unit EH = Neo_chicken->getClosestUnit(IsEnemy && GetType == UnitTypes::Zerg_Hatchery && IsCompleted);
		if (EH){
			TilePosition tb = Broodwar->getBuildLocation(UnitTypes::Zerg_Creep_Colony, EH->getTilePosition());
			if (EH->getDistance((Position)tb) <= 400 && BUILD.ok(Neo_chicken)){
				BUILD.push(Neo_chicken, UnitTypes::Zerg_Creep_Colony, tb);
				return;
			}
		}
		else {
			Neo_chicken->move(ave);
		}
		return;
	}
}
void Hatchery::Destination(){
	static bool Jiyeon = false;
	if (Chitang){
		if (ob){
			Broodwar->drawCircleMap(Chitang->getPosition(), 3, Colors::Yellow, true);
		}
		if (Chitang->isIdle() && Chitang->getClosestUnit(IsMineralField)->getDistance(Chitang) > 50){
			Chitang = NULL;
			Broodwar << "Chitang Complete" << endl;
		}
	}
	if (Jiyeon) return;
	if (Chitang && Pascal){
		if (IsCarryingSomething(Chitang)){
			if (Broodwar->getFrameCount() % 10 == 0) Chitang->returnCargo();
		}
		else if (Chitang->getDistance(Pascal) > 50) Chitang->gather(Pascal);
		else Jiyeon = true;
		return;
	}
	if (nHatch >= 2){
		if (!Chitang){
			for (int i = 0; i < nHatch; i++){
				BOOST_FOREACH(Unit Min, Hatch[i]->getUnitsInRadius(1000)){
					if (IsMineralField(Min) && (Min->getResources() == 0 || Min->getResources() == 16)){
						Pascal = Min;
						Unit Proton = HATCHERY.getDDD();
						if (BUILD.ok(Proton) && Proton != Chicken) Chitang = Proton;
						break;
					}
				}
				if (Pascal) break;
			}
			if (Pascal && Chitang){
				Chitang->gather(Pascal);
				Broodwar << "Chitang Ordered" << std::endl;
			}
		}
	}
}
// \Scout Manager

// Player
void SquadManager::Dahyun(){ // 5-Drone
	static int dahyun = 0;
	static bool over_dahyun = false;
	BOOST_FOREACH(Unit u, Broodwar->self()->getUnits())
	{
		if (!u->exists()) continue;
		if (u->isLockedDown() || u->isMaelstrommed() || u->isStasised()) continue;
		if (u->isLoaded() || !u->isPowered() || u->isStuck()) continue;
		if (!u->isCompleted() && !u->getType().isResourceDepot()) continue;
		//Unit_lines:

		// Drones
		if (u->getType().isWorker()){
			if (u == Chicken || u == Chitang) continue;
			if (u->isIdle() && BUILD.ok(u)){
				Unit Cargo;
				if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis))
					Cargo = HATCHERY.getHFD(u);
				else
					Cargo = HATCHERY.getHFM(u);
				if (Cargo){
					u->gather(Cargo->getClosestUnit(IsMineralField));
				}
			}
			if (u->isUnderAttack() && u->getDistance(HATCHERY.getHHH(u)) < 300){
				Unit Friend = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringGas || IsGatheringMinerals));
				if (!BUILD.ok(Friend) || u->getDistance(Friend) >= 200) Friend = NULL;
				Unit target = u->getClosestUnit(IsEnemy);
				if (target){
					if (u->canAttackUnit(target) && u->getHitPoints() >= 20) u->attack(target);
				}
				if (Friend && target){
					if (Friend->canAttackUnit(target))Friend->attack(target);
				}
			}
			if (!BUILD.ok(u)) continue;
			Unit Cargo = HATCHERY.getHFD(u);
			if (Cargo){
				if (u->getDistance(Cargo) > 400 && !u->isCarryingMinerals() && !HATCHERY.getS(Cargo, Satis))
					u->gather(Cargo->getClosestUnit(IsMineralField));
			}
			continue;
		}
		// Overlords
		if (u->getType() == UnitTypes::Zerg_Overlord){
			Unit pr = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Hydralisk || GetType == UnitTypes::Zerg_Mutalisk));
			bool evade = true;
			Unit Home = HATCHERY.getHHH(u);
			if (u->isBlind()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
				continue;
			}
			if (u->isIdle()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
			}
			if (pr){
				if (u->getDistance(pr) <= 290) evade = false;
			}
			if (evade){
				// evade
				BOOST_FOREACH(Unit ee, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(ee) && ee->getType().airWeapon().damageAmount() > 0){
						Position ppp;
						ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
						ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
						ppp.makeValid();
						u->move(ppp);
						break;
					}
				}
			}
			continue;
		}

		// Hatcheries
		if (u->getType().producesLarva()){
			// Does not defend
			if (ob){
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 300, Colors::Red);
				}, nullptr, 2);
			}
			if (u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted()) continue;

			//Building Lines:

			//5 pool
			if (Broodwar->self()->minerals() > 190 && (Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool)) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (!Yerim && !ovo){
					Chicken = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
					if (Chicken){
						if (BUILD.ok(Chicken) && Chicken != Chitang){
							Yerim = true;
							Yerin = true;
						}
					}
				}
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spawning_Pool);
			}
			//Producing lines:
			BOOST_FOREACH(Unit Larva, u->getLarva()){
				// Overlord spawn
				if ( ((Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 - Broodwar->self()->supplyUsed() < Building_hatcheries * 4 &&
					Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 < 400) ||
					 (ovo &&!over_dahyun && Building_pool) )
					&& Larva->canTrain(UnitTypes::Zerg_Overlord)){
					Larva->train(UnitTypes::Zerg_Overlord);
					OVERLORD.push(Larva);
					if (ovo && !over_dahyun) over_dahyun = true;
					continue;
				}
				if (((dahyun == 0 && Building_pool == 0) || (dahyun == 1 && Building_pool == 1 && !ovo )) && Larva->canTrain(UnitTypes::Zerg_Drone)) {
					Larva->train(UnitTypes::Zerg_Drone);
					Unit_drones++;
					dahyun++;
					continue;
				}
				if (Larva->canTrain(UnitTypes::Zerg_Zergling)){
					Larva->train(UnitTypes::Zerg_Zergling);
					continue;
				}
				continue;
			}
		}

	}
	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		squad[i].Action();
	}
	if (Search){
		Zia = Strat::Jaeeun;
		Zia2 = Zia;
		Jia.append("->Jaeeun");
	}
	if (defensive){
		if (Zia2 != -1){
			Zia = Zia2;
		}
		else {
			Zia = rand() % (3 - (Broodwar->mapFileName().find("BlueStorm") != string::npos)) + 6;
			Zia2 = Zia;
		}
		switch (Zia){
		case Strat::Jaeeun:
			Jia.append("->Jaeeun");
			break;
		case Strat::Jungeun:
			Jia.append("->Jungeun");
			break;
		case Strat::Juae:
			Jia.append("->Juae");
			break;
		}
	}
}
void SquadManager::Dahye(){ // 9-drone includes sunken rush

	//if (Ddangddang) ddangddang();
	//if (Neoddang) neoddang();
	static int dahye = 0;
	static bool Neo = false;
	defense = false;
	BOOST_FOREACH(Unit u, Broodwar->self()->getUnits()){
		if (!u->exists()) continue;
		if (u->isLockedDown() || u->isMaelstrommed() || u->isStasised()) continue;
		if (u->isLoaded() || !u->isPowered() || u->isStuck()) continue;
		if (!u->isCompleted() && !u->getType().isResourceDepot()) continue;

		//Unit_lines:
		// Drones
		if (u->getType().isWorker()){
			if (u == Chicken || u == Chitang || u == Special_chicken || u == Neo_chicken) continue;
			if (u->isIdle() && BUILD.ok(u)){
				Unit Cargo;
				if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis))
					Cargo = HATCHERY.getHFD(u);
				else
					Cargo = HATCHERY.getHFM(u);
				if (Cargo){
					u->gather(Cargo->getClosestUnit(IsMineralField));
				}
			}
			if (u->isUnderAttack() && u->getDistance(HATCHERY.getHHH(u)) < 400){
				Unit Friend = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringGas || IsGatheringMinerals));
				if (!BUILD.ok(Friend) || u->getDistance(Friend) >= 200) Friend = NULL;
				Unit target = u->getClosestUnit(IsEnemy);
				if (target){
					if (u->canAttackUnit(target) && u->getHitPoints() >= 20) u->attack(target);
				}
				if (Friend && target){
					if (Friend->canAttackUnit(target))Friend->attack(target);
				}
			}
			if (!BUILD.ok(u)) continue;
			Unit Cargo = HATCHERY.getHFD(u);
			if (Cargo){
				if (u->getDistance(Cargo) > 400 && !u->isCarryingMinerals() && !HATCHERY.getS(Cargo, Satis))
					u->gather(Cargo->getClosestUnit(IsMineralField));
			}
			continue;
		}
		// Overlords
		if (u->getType() == UnitTypes::Zerg_Overlord){
			Unit pr = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Hydralisk || GetType == UnitTypes::Zerg_Mutalisk));
			bool evade = true;
			Unit Home = HATCHERY.getHHH(u);
			if (u->isBlind()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
				continue;
			}
			if (u->isIdle()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
			}
			if (pr){
				if (u->getDistance(pr) <= 290) evade = false;
			}
			if (evade){
				// evade
				BOOST_FOREACH(Unit ee, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(ee) && ee->getType().airWeapon().damageAmount() > 0){
						Position ppp;
						ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
						ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
						ppp.makeValid();
						u->move(ppp);
						break;
					}
				}
			}
			continue;
		}
		if (u->getType() == UnitTypes::Zerg_Creep_Colony){
			if (u->canMorph(UnitTypes::Zerg_Sunken_Colony)) u->morph(UnitTypes::Zerg_Sunken_Colony);
		}

		// Hatcheries
		if (u->getType().producesLarva()){
			//Defence System
			if (ob){
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 390, Colors::Red);
				}, nullptr, 2);
			}
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(390)){
				if (!IsEnemy(ee) || ee->getType() == UnitTypes::Zerg_Overlord || ee->getType() == UnitTypes::Protoss_Observer) continue;
				dew = true;
				ave2 = ee->getPosition();
				defense = true;
				break;
			}

			if (u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted()) continue;

			//Building lines
			static bool first_multi = true;
			if ((Building_hatcheries + BUILD.getask(UnitTypes::Zerg_Hatchery)) == 1 && Broodwar->self()->minerals() >= 400){
				if (first_multi){
					Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
					if (BUILD.ok(builder)){
						BUILD.push(builder, UnitTypes::Zerg_Hatchery, Multi);
						first_multi = false;
					}
				}
				else {
					Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
					TilePosition Nextbase;
					bool next = false;
					double ddd = 100000;

					for (int i = 0; i < DESIGNER.nBase; i++){
						if (!Broodwar->canBuildHere(DESIGNER.Bases[i], UnitTypes::Zerg_Hatchery, builder)) continue;
						double dd = BWTA::getGroundDistance(u->getTilePosition(), DESIGNER.Bases[i]);
						if (dd < ddd){
							ddd = dd;
							Nextbase = DESIGNER.Bases[i];
							next = true;
						}
					}
					if (next && BUILD.ok(builder)){
						BUILD.push(builder, UnitTypes::Zerg_Hatchery, Nextbase);
					}
				}
			}
			// 9 pool
			if (Broodwar->self()->minerals() > 190 && (Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool)) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (!Yerim){
					Chicken = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
					if (Chicken){
						if (BUILD.ok(Chicken) && Chicken != Chitang){
							Yerim = true;
							Yerin = true;
						}
					}
				}
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spawning_Pool);
			}
			// Sunken
			if (false){
				if (HATCHERY.getS(u, Hatch) == true && HATCHERY.getS(u, Sunken) < 1 && Building_pool2 && BUILD.getask(UnitTypes::Zerg_Creep_Colony) == 0){
					Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
						(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
					if (builder && BUILD.ok(builder) && builder != Chitang && builder != Neo_chicken){
						TilePosition ttt;
						ttt = u->getTilePosition();
						ttt.y -= UnitTypes::Zerg_Creep_Colony.tileHeight();
						if (Broodwar->canBuildHere(ttt, UnitTypes::Zerg_Creep_Colony, builder)){
							BUILD.push(builder, UnitTypes::Zerg_Creep_Colony, ttt);

						}
						else {
							ttt = u->getTilePosition() + u->getType().tileSize();
							ttt.x -= UnitTypes::Zerg_Creep_Colony.tileWidth();
							if (Broodwar->canBuildHere(ttt, UnitTypes::Zerg_Creep_Colony, builder))
								BUILD.push(builder, UnitTypes::Zerg_Creep_Colony, ttt);
						}
					}
				}
			}

			//Producing lines
			BOOST_FOREACH(Unit Larva, u->getLarva()){
				if (Larva->canTrain(UnitTypes::Zerg_Zergling)){
					Larva->train(UnitTypes::Zerg_Zergling);
					continue;
				}
				if (BUILD.getN() > 0 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 && Broodwar->self()->minerals() < 600) continue;
				// Overlord spawn
				if (Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 - Broodwar->self()->supplyUsed() < Building_hatcheries * 4
					&& Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 < 400
					&& Larva->canTrain(UnitTypes::Zerg_Overlord)
					&& Building_pool > 0){
					Larva->train(UnitTypes::Zerg_Overlord);
					OVERLORD.push(Larva);
					continue;
				}
				// Drone spawn
				if (Larva->canTrain(UnitTypes::Zerg_Drone) && ((Unit_drones < 9 - Building_pool || (Building_pool&&dahye == 0)) && !Building_pool2)){
					if (DESIGNER.ask(u->getTilePosition())){
						if (!HATCHERY.getS(u, Satis)){
							if (Building_pool) dahye++;
							Larva->train(UnitTypes::Zerg_Drone);
							Unit_drones++;
							continue;
						}
					}
					else if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis)){
						if (Building_pool) dahye++;
						Larva->train(UnitTypes::Zerg_Drone);
						Unit_drones++;
						continue;
					}
				}
			}
			continue;
		}
		if (!defense && dew){
			dew = false;
		}
	}
	if (!defense && dew){
		dew = false;
	}
	/*
	if (nSquad >= 1 && !Neo){
		Neo_chicken = HATCHERY.getDDD();
		if (Neo_chicken){
			if (Neo_chicken == Chicken || Neo_chicken == Special_chicken || !BUILD.ok(Neo_chicken));
			else{
				if(Broodwar->enemy()->getRace() == Races::Zerg) Neoddang = true;
				Neo = true;
			}
		}
	}
	*/
	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		if ((i == 0 && squad[i].getN() >= 6) || i>0)
			squad[i].Action();
		else{
			if (dew)
				squad[i].Dew();
			else
				squad[i].Defensive();
		}
	}
	if (Building_hatcheries >= 2 && Building_pool){
		if (Zia2 != -1){
			Zia = Zia2;
		}
		else {
			Zia = rand() % (3-(Broodwar->mapFileName().find("BlueStorm") != string::npos) ) + 6;
			Zia2 = Zia;
		}
		switch (Zia){
		case Strat::Jaeeun:
			Jia.append("->Jaeeun");
			break;
		case Strat::Jungeun:
			Jia.append("->Jungeun");
			break;
		case Strat::Juae:
			Jia.append("->Juae");
			break;
		}
	}
	/*
	if (Building_hatcheries >= 2 && Building_pool && Broodwar->enemy()->getName().find("Iron") != string::npos){
		Zia = Strat::Jaeeun;
		Zia2 = Zia;
		Jia.append("->Jaeeun");
		Broodwar->sendText("Hi Iron!");
	}
	else if (Building_hatcheries >= 2 && Building_pool && Broodwar->enemy()->getRace() == Races::Terran){
		Zia = Strat::Jungeun;
		Zia2 = Zia;
		Jia.append("->Jungeun");
	}
	else if (Building_hatcheries >= 2 && Building_pool && Broodwar->enemy()->getRace() == Races::Protoss){
		Zia = Strat::Juae;
		Zia2 = Zia;
		Jia.append("->Juae");
	}
	else if (Building_hatcheries >= 2 && Building_pool && Broodwar->enemy()->getRace() == Races::Zerg){
		Zia = Strat::Jaeeun;
		Zia2 = Zia;
		Jia.append("->Jaeun");
	}
	*/
}
void SquadManager::Daeun(){ // 12 - 11
	defense = false;
	BOOST_FOREACH(Unit u, Broodwar->self()->getUnits()){
		if (!u->exists()) continue;
		if (u->isLockedDown() || u->isMaelstrommed() || u->isStasised()) continue;
		if (u->isLoaded() || !u->isPowered() || u->isStuck()) continue;
		if (!u->isCompleted() && !u->getType().isResourceDepot()) continue;

		//Unit_lines:
		// Drones
		if (u->getType().isWorker()){
			if (u == Chicken || u == Chitang) continue;
			if (u->isIdle() && BUILD.ok(u)){
				Unit Cargo;
				if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis))
					Cargo = HATCHERY.getHFD(u);
				else
					Cargo = HATCHERY.getHFM(u);
				if (Cargo){
					u->gather(Cargo->getClosestUnit(IsMineralField));
				}
			}
			if (u->isUnderAttack() && u->getDistance(HATCHERY.getHHH(u)) < 400){
				Unit Friend = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringGas || IsGatheringMinerals));
				if (!BUILD.ok(Friend) || u->getDistance(Friend) >= 200) Friend = NULL;
				Unit target = u->getClosestUnit(IsEnemy);
				if (target){
					if (u->canAttackUnit(target) && u->getHitPoints() >= 20) u->attack(target);
				}
				if (Friend && target){
					if (Friend->canAttackUnit(target))Friend->attack(target);
				}
			}
			if (!BUILD.ok(u)) continue;
			Unit Cargo = HATCHERY.getHFD(u);
			if (Cargo){
				if (u->getDistance(Cargo) > 400 && !u->isCarryingMinerals() && !HATCHERY.getS(Cargo, Satis))
					u->gather(Cargo->getClosestUnit(IsMineralField));
			}
			continue;
		}
		// Overlords
		if (u->getType() == UnitTypes::Zerg_Overlord){
			Unit pr = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Hydralisk || GetType == UnitTypes::Zerg_Mutalisk));
			bool evade = true;
			Unit Home = HATCHERY.getHHH(u);
			if (u->isBlind()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
				continue;
			}
			if (u->isIdle()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
			}
			if (pr){
				if (u->getDistance(pr) <= 290) evade = false;
			}
			if (evade){
				// evade
				BOOST_FOREACH(Unit ee, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(ee) && ee->getType().airWeapon().damageAmount() > 0){
						Position ppp;
						ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
						ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
						ppp.makeValid();
						u->move(ppp);
						break;
					}
				}
			}
			continue;
		}
		// Hatcheries
		if (u->getType().producesLarva()){
			//Defence System
			if (ob){
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 390, Colors::Red);
				}, nullptr, 2);
			}
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(390)){
				if (!IsEnemy(ee) || ee->getType() == UnitTypes::Zerg_Overlord || ee->getType() == UnitTypes::Protoss_Observer) continue;
				dew = true;
				ave2 = ee->getPosition();
				defense = true;
				break;
			}

			if (u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted()) continue;

			//Building lines
			// 12 Drone
			static bool first_multi = true;
			if ( (Building_hatcheries + BUILD.getask(UnitTypes::Zerg_Hatchery)) == 1 && Broodwar->self()->minerals() >= 180 && Supply_used >= 24 ){
				if (first_multi){
					Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
					if (BUILD.ok(builder) && builder){
						BUILD.push(builder, UnitTypes::Zerg_Hatchery, Multi);
					}
				}
				else{
					Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
					TilePosition Nextbase;
					bool next = false;
					double ddd = 100000;
					for (int i = 0; i < DESIGNER.nBase && builder; i++){
						if (!Broodwar->canBuildHere(DESIGNER.Bases[i], UnitTypes::Zerg_Hatchery, builder)) continue;
						double dd = BWTA::getGroundDistance(u->getTilePosition(), DESIGNER.Bases[i]);
						if (dd < ddd){
							ddd = dd;
							Nextbase = DESIGNER.Bases[i];
							next = true;
						}
					}
					if (next && builder && BUILD.ok(builder)){
						BUILD.push(builder, UnitTypes::Zerg_Hatchery, Nextbase);
					}
				}
			}
			// 3rd Hatchery
			if (Building_hatcheries == 2 && MANAGER.getN() >= 1 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 &&
				Broodwar->self()->minerals() > 400){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Hatchery);
			}
			// 11 pool
			if (Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool) == 0 &&
				Building_hatcheries >= 2 && Broodwar->self()->minerals() >= 190 ){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (!Yerim){
					Chicken = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
					if (Chicken){
						if (BUILD.ok(Chicken) && Chicken != Chitang){
							Yerim = true;
							Yerin = true;
						}
					}
				}
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spawning_Pool);
			}

			//Producing lines
			if (BUILD.getN() > 0 && (Building_hatcheries < 3 || BUILD.getask(UnitTypes::Zerg_Hatchery)) && Broodwar->self()->minerals() < 600) continue;
			if (Building_hatcheries >= 2 && !Building_pool) continue;
			BOOST_FOREACH(Unit Larva, u->getLarva()){

				// Overlord spawn
				if (Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 - Broodwar->self()->supplyUsed() < Building_hatcheries * 4
					&& Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 < 400
					&& Larva->canTrain(UnitTypes::Zerg_Overlord)){
					Larva->train(UnitTypes::Zerg_Overlord);
					OVERLORD.push(Larva);
					continue;
				}
				// Drone spawn
				if (Larva->canTrain(UnitTypes::Zerg_Drone) && (Unit_drones <= 10 && !Building_pool2)){
					if (DESIGNER.ask(u->getTilePosition())){
						if (!HATCHERY.getS(u, Satis)){
							Larva->train(UnitTypes::Zerg_Drone);
							Unit_drones++;
							continue;
						}
					}
					else if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis)){
						Larva->train(UnitTypes::Zerg_Drone);
						Unit_drones++;
						continue;
					}
				}
				if (Larva->canTrain(UnitTypes::Zerg_Zergling)){
					Larva->train(UnitTypes::Zerg_Zergling);
					continue;
				}
			}
			continue;
		}
		if (!defense && dew){
			dew = false;
		}
	}
	if (!defense && dew){
		dew = false;
	}
	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		if (dew)
			squad[i].Dew();
		else
			squad[i].Defensive();
	}
	if (Building_hatcheries >= 2 && Building_pool){
		if (Zia2 != -1){
			Zia = Zia2;
		}
		else {
			Zia = rand() % (3 - (Broodwar->mapFileName().find("BlueStorm") != string::npos)) + 6;
			Zia2 = Zia;
		}
		switch (Zia){
		case Strat::Jaeeun:
			Jia.append("->Jaeeun");
			break;
		case Strat::Jungeun:
			Jia.append("->Jungeun");
			break;
		case Strat::Juae:
			Jia.append("->Juae");
			break;
		}
	}
	/*
	if (Building_hatcheries >= 2 && Building_pool && Broodwar->enemy()->getName().find("Iron") != string::npos){
		Zia = Strat::Jaeeun;
		Zia2 = Zia;
		Jia.append("->Jaeeun");
		Broodwar->sendText("Hi Iron!");
	}
	else if (Building_hatcheries >= 2 && Building_pool && Broodwar->enemy()->getRace() == Races::Terran){
		Zia = Strat::Jungeun;
		Zia2 = Zia;
		Jia.append("->Jungeun");
	}
	else if (Building_hatcheries >= 2 && Building_pool && Broodwar->enemy()->getRace() == Races::Protoss){
		Zia = Strat::Juae;
		Zia2 = Zia;
		Jia.append("->Juae");
	}
	else if (Building_hatcheries >= 2 && Building_pool && Broodwar->enemy()->getRace() == Races::Zerg){
		Zia = Strat::Jaeeun;
		Zia2 = Zia;
		Jia.append("->Jaeun");
	}
	*/
}
void SquadManager::Dahee(){ // 9 lings
	
	/// Build line ///

	// 9 - pool //
	if (Broodwar->self()->minerals() > 190 && (Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool)) == 0){
		Unit builder = HATCHERY.getDDD();
		if (builder && BUILD.ok(builder))
			BUILD.push(builder, UnitTypes::Zerg_Spawning_Pool);
	}
	// Multies //
	static bool first_multi = true;
	if ((Building_hatcheries + BUILD.getask(UnitTypes::Zerg_Hatchery)) == 1 && Broodwar->self()->minerals() >= 400){
		if (first_multi){
			Unit builder = HATCHERY.getDDD();
			if (BUILD.ok(builder)){
				BUILD.push(builder, UnitTypes::Zerg_Hatchery, Multi);
				first_multi = false;
			}
		}
		else{ // Random
			Unit builder = HATCHERY.getDDD();

			TilePosition Nextbase;
			bool next = false;
			int I = -1;
			int check = 100000;

			for (int i = 0; i < DESIGNER.nBase && builder; i++){
				if (!Broodwar->canBuildHere(DESIGNER.Bases[i], UnitTypes::Zerg_Hatchery, builder)) continue;

				if (builder->hasPath((Position)DESIGNER.Bases[i])){
					if (check > DESIGNER.Try[i]){
						next = true;
						check = DESIGNER.Try[i];
						Nextbase = DESIGNER.Bases[i];
						I = i;
					}
				}
			}

			if (next && builder && BUILD.ok(builder)){
				BUILD.push(builder, UnitTypes::Zerg_Hatchery, Nextbase);
				DESIGNER.Try[I]++;
			}
		}
	}

	static bool dahye = false;
	static bool metabolic = false;
	defense = false;

	BOOST_FOREACH(Unit u, Broodwar->self()->getUnits()){
		if (!u->exists()) continue;
		if (u->isLockedDown() || u->isMaelstrommed() || u->isStasised()) continue;
		if (u->isLoaded() || !u->isPowered() || u->isStuck()) continue;
		if (!u->isCompleted() && !u->getType().isResourceDepot()) continue;

		//Unit_lines:
		// Drones
		if (u->getType().isWorker()){
			if (u == Chicken || u == Chitang || u == Special_chicken || u == Neo_chicken) continue;
			if (u->isIdle() && BUILD.ok(u)){
				Unit Cargo;
				if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis))
					Cargo = HATCHERY.getHFD(u);
				else
					Cargo = HATCHERY.getHFM(u);
				if (Cargo){
					u->gather(Cargo->getClosestUnit(IsMineralField));
				}
			}
			if (u->isUnderAttack() && u->getDistance(HATCHERY.getHHH(u)) < 400){
				Unit Friend = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringGas || IsGatheringMinerals));
				if (!BUILD.ok(Friend) || u->getDistance(Friend) >= 200) Friend = NULL;
				Unit target = u->getClosestUnit(IsEnemy);
				if (target){
					if (u->canAttackUnit(target) && u->getHitPoints() >= 20) u->attack(target);
				}
				if (Friend && target){
					if (Friend->canAttackUnit(target))Friend->attack(target);
				}
			}
			if (!BUILD.ok(u)) continue;
			Unit Cargo = HATCHERY.getHFD(u);
			if (Cargo){
				if (u->getDistance(Cargo) > 400 && !u->isCarryingMinerals() && !HATCHERY.getS(Cargo, Satis))
					u->gather(Cargo->getClosestUnit(IsMineralField));
			}
			continue;
		}
		// Overlords
		if (u->getType() == UnitTypes::Zerg_Overlord){
			Unit pr = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Hydralisk || GetType == UnitTypes::Zerg_Mutalisk));
			bool evade = true;
			Unit Home = HATCHERY.getHHH(u);
			if (u->isBlind()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
				continue;
			}
			if (u->isIdle()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
			}
			if (pr){
				if (u->getDistance(pr) <= 290) evade = false;
			}
			if (evade){
				// evade
				BOOST_FOREACH(Unit ee, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(ee) && ee->getType().airWeapon().damageAmount() > 0){
						Position ppp;
						ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
						ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
						ppp.makeValid();
						u->move(ppp);
						break;
					}
				}
			}
			continue;
		}
		// Extractor
		if (u->getType() == UnitTypes::Zerg_Extractor){
			Unit Cargo = HATCHERY.getHFD(u);
			if (!Cargo) continue;
			if (u->getDistance(Cargo) > 300) continue;
			int g = 0;
			BOOST_FOREACH(Unit dr, u->getUnitsInRadius(u->getDistance(Cargo))){
				if (dr->isGatheringGas() && IsOwned(dr)) g++;
			}
			if (g > 3 || metabolic){
				Unit come = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					IsGatheringGas && !IsCarryingSomething);
				if (come && u->getDistance(come) <= 300)
					come->stop();
			}
			else if (g < 2 && HATCHERY.getS(HATCHERY.getHFD(u), m) > 6 && !metabolic){
				Unit ggg = HATCHERY.getHFD(u)->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (ggg && HATCHERY.getHFD(u)->getDistance(ggg) <= 300 && ggg != Chitang) ggg->gather(u);
			}
		}
		// Pool
		if (u->getType() == UnitTypes::Zerg_Spawning_Pool){
			if (u->canUpgrade(UpgradeTypes::Metabolic_Boost)){
				u->upgrade(UpgradeTypes::Metabolic_Boost);
				metabolic = true;
			}
			if (u->canUpgrade(UpgradeTypes::Adrenal_Glands)) u->upgrade(UpgradeTypes::Adrenal_Glands);
		}
		// Hatcheries
		if (u->getType().producesLarva()){
			//Defence System
			if (ob){
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 390, Colors::Red);
				}, nullptr, 2);
			}
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(390)){
				if (!IsEnemy(ee) || ee->getType() == UnitTypes::Zerg_Overlord || ee->getType() == UnitTypes::Protoss_Observer) continue;
				dew = true;
				ave2 = ee->getPosition();
				defense = true;
				break;
			}

			if (u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted()) continue;			
			// Geyers
			if (Building_pool > 0 && HATCHERY.getS(u, m) > 6) {
				Unit gasbuilder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingMinerals);
				if (gasbuilder){
					if (gasbuilder->getDistance(u) > 300 || gasbuilder == Chitang) gasbuilder = NULL;
				}
				Unit gas = NULL;
				BOOST_FOREACH(Unit uu, Broodwar->getGeysers()){
					if (u->getDistance(uu) <= 300 && IsNeutral(uu)){
						gas = uu;
						break;
					}
				}
				if (gasbuilder && gas != NULL && BUILD.ok(gas->getTilePosition(), UnitTypes::Zerg_Extractor)){
					BUILD.push(gasbuilder, UnitTypes::Zerg_Extractor, gas->getTilePosition());
				}
			}
			//Producing lines
			BOOST_FOREACH(Unit Larva, u->getLarva()){
				if (Larva->canTrain(UnitTypes::Zerg_Zergling)){
					Larva->train(UnitTypes::Zerg_Zergling);
					continue;
				}
				if (BUILD.getN() > 0 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 && Broodwar->self()->minerals() < 450) continue;
				// Overlord spawn
				if (Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 - Broodwar->self()->supplyUsed() < Building_hatcheries * 6
					&& Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 < 400
					&& Larva->canTrain(UnitTypes::Zerg_Overlord)
					&& Building_pool > 0){
					Larva->train(UnitTypes::Zerg_Overlord);
					OVERLORD.push(Larva);
					continue;
				}
				// Drone spawn
				if (Larva->canTrain(UnitTypes::Zerg_Drone) && ((!Building_pool&&Unit_drones < 9) || (Building_pool && !dahye))){
					if (DESIGNER.ask(u->getTilePosition())){
						if (!HATCHERY.getS(u, Satis)){
							if(Building_pool) dahye = true;
							Larva->train(UnitTypes::Zerg_Drone);
							Unit_drones++;
							continue;
						}
					}
					else if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis)){
						if (Building_pool) dahye = true;
						Larva->train(UnitTypes::Zerg_Drone);
						Unit_drones++;
						continue;
					}
				}
			}
			continue;
		}
		if (!defense && dew){
			dew = false;
		}
	}
	if (!defense && dew){
		dew = false;
	}

	// first_scout
	if (Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool) >= 1 && !Yerim){
		Unit temp = HATCHERY.getDDD();
		if (temp && BUILD.ok(temp)){
			Chicken = temp;
			Yerim = true;
			Yerin = true;
		}
	}
	// gas 100 only
	if (Broodwar->self()->gas() >= 100 && !metabolic) metabolic = true;

	// Launch attack
	static bool Dahee = false;
	if (getN() > 2) Dahee = true;

	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		if (dew)
			squad[i].Dew();
		else
			squad[i].Defensive();
	}
	if (Dahee){
		if (Zia2 != -1){
			Zia = Zia2;
		}
		else {
			Zia = rand() % (3 - (Broodwar->mapFileName().find("BlueStorm") != string::npos)) + 6;
			Zia2 = Zia;
		}
		switch (Zia){
		case Strat::Jaeeun:
			Jia.append("->Jaeeun");
			break;
		case Strat::Jungeun:
			Jia.append("->Jungeun");
			break;
		case Strat::Juae:
			Jia.append("->Juae");
			break;
		}
	}
}
void SquadManager::Dayoung(){ // Plasma
	bool mutal_dew = false;
	defense = false;
	BOOST_FOREACH(Unit u, Broodwar->self()->getUnits())
	{
		if (!u->exists()) continue;
		if (u->isLockedDown() || u->isMaelstrommed() || u->isStasised()) continue;
		if (u->isLoaded() || !u->isPowered() || u->isStuck()) continue;
		if (!u->isCompleted() && !u->getType().isResourceDepot()) continue;

		//Unit_lines:
		// Drones
		if (u->getType().isWorker()){
			if (u == Chicken || u == Chitang) continue;
			if (u->isIdle() && BUILD.ok(u)){
				Unit Cargo;
				if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis))
					Cargo = HATCHERY.getHFD(u);
				else
					Cargo = HATCHERY.getHFM(u);
				if (Cargo){
					u->gather(Cargo->getClosestUnit(IsMineralField));
				}
			}
			if (u->isUnderAttack() && u->getDistance(HATCHERY.getHHH(u)) < 400){
				Unit Friend = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringGas || IsGatheringMinerals));
				if (!BUILD.ok(Friend) || u->getDistance(Friend) >= 200) Friend = NULL;
				Unit target = u->getClosestUnit(IsEnemy);
				if (target){
					if (u->canAttackUnit(target) && u->getHitPoints() >= 20) u->attack(target);
				}
				if (Friend && target){
					if (Friend->canAttackUnit(target))Friend->attack(target);
				}
			}
			if (!BUILD.ok(u)) continue;
			Unit Cargo = HATCHERY.getHFD(u);
			if (Cargo){
				if (u->getDistance(Cargo) > 400 && !u->isCarryingMinerals() && !HATCHERY.getS(Cargo, Satis))
					u->gather(Cargo->getClosestUnit(IsMineralField));
			}
			continue;
		}
		// Overlords
		if (u->getType() == UnitTypes::Zerg_Overlord){
			Unit pr = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Hydralisk || GetType == UnitTypes::Zerg_Mutalisk));
			bool evade = true;
			Unit Home = HATCHERY.getHHH(u);
			if (u->isBlind()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
				continue;
			}
			if (u->isIdle()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
			}
			if (pr){
				if (u->getDistance(pr) <= 290) evade = false;
			}
			if (evade){
				// evade
				BOOST_FOREACH(Unit ee, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(ee) && ee->getType().airWeapon().damageAmount() > 0){
						Position ppp;
						ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
						ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
						ppp.makeValid();
						u->move(ppp);
						break;
					}
				}
			}
			continue;
		}

		// Extractor
		if (u->getType() == UnitTypes::Zerg_Extractor){
			Unit Cargo = HATCHERY.getHFD(u);
			if (!Cargo) continue;
			if (u->getDistance(Cargo) > 300) continue;
			int g = 0;
			BOOST_FOREACH(Unit dr, u->getUnitsInRadius(u->getDistance(Cargo))){
				if (dr->isGatheringGas() && IsOwned(dr)) g++;
			}
			if (g > 3){
				Unit come = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					IsGatheringGas && !IsCarryingSomething);
				if (come && u->getDistance(come) <= 300)
					come->stop();
			}
			else if (g < 2 && HATCHERY.getS(HATCHERY.getHFD(u), m) > 6){
				Unit ggg = HATCHERY.getHFD(u)->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (ggg && HATCHERY.getHFD(u)->getDistance(ggg) <= 300 && ggg != Chitang) ggg->gather(u);
			}
		}

		// Creep Colony
		if (u->getType() == UnitTypes::Zerg_Creep_Colony){
			if (u->canMorph(UnitTypes::Zerg_Sunken_Colony)) u->morph(UnitTypes::Zerg_Sunken_Colony);
		}

		// Hatcheries
		if (u->getType().producesLarva()){
			//drawn replace
			//Defence System
			if (ob){
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 390, Colors::Red);
				}, nullptr, 2);
			}
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(390)){
				if (!IsEnemy(ee) || ee->getType() == UnitTypes::Zerg_Overlord || ee->getType() == UnitTypes::Protoss_Observer) continue;
				//if (!dew) ave2 = ave;
				dew = true;
				ave2 = ee->getPosition();
				defense = true;
				break;
			}

			if (u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted()) continue;
			if (!HATCHERY.getfull() && HATCHERY.getS(u, m) > HATCHERY.getS(u, M) * 2 && Broodwar->getFrameCount() % 100 == 0){
				Unit Bye = u->getClosestUnit(IsOwned && IsWorker && IsGatheringMinerals && !IsCarryingSomething);
				if (Bye) Bye->stop();
			}
			//Building lines
			if ((Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool)) == 0 && Broodwar->self()->minerals() >= 190){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spawning_Pool);
			}
			// 2nd Hatchery
			if (Building_hatcheries == 1 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 &&
				Building_lair && Broodwar->self()->minerals() >= 250){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Hatchery);
			}
			// Geyers
			if (Building_pool > 0 && HATCHERY.getS(u, m) > 6) {
				Unit gasbuilder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingMinerals);
				if (gasbuilder){
					if (gasbuilder->getDistance(u) > 300 || gasbuilder == Chitang) gasbuilder = NULL;
				}
				Unit gas = NULL;
				BOOST_FOREACH(Unit uu, Broodwar->getGeysers()){
					if (u->getDistance(uu) <= 300 && IsNeutral(uu)){
						gas = uu;
						break;
					}
				}
				if (gasbuilder && gas != NULL && BUILD.ok(gas->getTilePosition(), UnitTypes::Zerg_Extractor)){
					BUILD.push(gasbuilder, UnitTypes::Zerg_Extractor, gas->getTilePosition());
				}
			}

			// Hive & Lair
			if (u->canMorph(UnitTypes::Zerg_Lair) && Building_lair == 0 && Unit_drones >= 12) u->morph(UnitTypes::Zerg_Lair);

			// Spire
			if (Building_lair2 && Building_spire + BUILD.getask(UnitTypes::Zerg_Spire) == 0 && Building_hatcheries >= 2 && Broodwar->self()->minerals() > 100 && Broodwar->self()->gas() > 100){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spire);
			}

			//Producing lines
			if (BUILD.getN() > 0 && (Building_hatcheries < 3 || BUILD.getask(UnitTypes::Zerg_Hatchery)) && Broodwar->self()->minerals() < 600) continue;
			BOOST_FOREACH(Unit Larva, u->getLarva()){
				int lar = (Building_spire && Must_mutal) * Unit_larva * 4;
				// Overlord spawn
				if (Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 - Broodwar->self()->supplyUsed() - lar < Building_hatcheries * 4 * (1 + (Building_spire || Building_den))
					&& Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 < 400
					&& Larva->canTrain(UnitTypes::Zerg_Overlord)
					&& Building_pool > 0){
					Larva->train(UnitTypes::Zerg_Overlord);
					OVERLORD.push(Larva);
					continue;
				}


				if (Building_spire2 && Must_mutal){
					if (Larva->canTrain(UnitTypes::Zerg_Mutalisk)){
						Larva->train(UnitTypes::Zerg_Mutalisk);
						continue;
					}
					continue;
				}

				// Drone spawn
				if (Larva->canTrain(UnitTypes::Zerg_Drone) && Unit_drones <= 80){
					if (DESIGNER.ask(u->getTilePosition())){
						if (!HATCHERY.getS(u, Satis)){
							Larva->train(UnitTypes::Zerg_Drone);
							Unit_drones++;
							continue;
						}
					}
					else if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis)){
						Larva->train(UnitTypes::Zerg_Drone);
						Unit_drones++;
						continue;
					}
				}
				if (Larva->canTrain(UnitTypes::Zerg_Mutalisk)){
					Larva->train(UnitTypes::Zerg_Mutalisk);
					continue;
				}
			}
			continue;
		}
	}
	if (!defense && dew){
		dew = false;
	}
	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		else if (squad[i].getT() == UnitTypes::Zerg_Mutalisk){
			squad[i].Protect();
			if (dew && !mutal_dew){
				squad[i].Dew();
				mutal_dew = true;
			}
			else if (dew){
				squad[i].Dew();
			}
			else{
				squad[i].Defensive();
			}
		}
	}
	if (!Must_mutal){
		if (Broodwar->enemy()->getRace() == Races::Protoss){
			//Zia = Strat::Juae;
			Zia = Strat::Jungeun;
			Zia2 = Zia;
			Jia.append("->Jungeun");
		}
		else if (Broodwar->enemy()->getRace() == Races::Terran){
			Zia = Strat::Jungeun;
			Zia2 = Zia;
			Jia.append("->Jungeun");
		}
		else if (Broodwar->enemy()->getRace() == Races::Zerg){
			Zia = Strat::Jaeeun;
			Zia2 = Zia;
			Jia.append("->Jaeeun");
		}
	}
}
void SquadManager::Dajung(){ // Mutal Opening
	bool mutal_dew = false;
	defense = false;
	BOOST_FOREACH(Unit u, Broodwar->self()->getUnits())
	{
		if (!u->exists()) continue;
		if (u->isLockedDown() || u->isMaelstrommed() || u->isStasised()) continue;
		if (u->isLoaded() || !u->isPowered() || u->isStuck()) continue;
		if (!u->isCompleted() && !u->getType().isResourceDepot()) continue;

		//Unit_lines:
		// Drones
		if (u->getType().isWorker()){
			if (u == Chicken || u == Chitang) continue;
			if (u->isIdle() && BUILD.ok(u)){
				Unit Cargo;
				if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis))
					Cargo = HATCHERY.getHFD(u);
				else
					Cargo = HATCHERY.getHFM(u);
				if (Cargo){
					u->gather(Cargo->getClosestUnit(IsMineralField));
				}
			}
			if (u->isUnderAttack() && u->getDistance(HATCHERY.getHHH(u)) < 400){
				Unit Friend = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringGas || IsGatheringMinerals));
				if (!BUILD.ok(Friend) || u->getDistance(Friend) >= 200) Friend = NULL;
				Unit target = u->getClosestUnit(IsEnemy);
				if (target){
					if (u->canAttackUnit(target) && u->getHitPoints() >= 20) u->attack(target);
				}
				if (Friend && target){
					if (Friend->canAttackUnit(target))Friend->attack(target);
				}
			}
			if (!BUILD.ok(u)) continue;
			Unit Cargo = HATCHERY.getHFD(u);
			if (Cargo){
				if (u->getDistance(Cargo) > 400 && !u->isCarryingMinerals() && !HATCHERY.getS(Cargo, Satis))
					u->gather(Cargo->getClosestUnit(IsMineralField));
			}
			continue;
		}
		// Overlords
		if (u->getType() == UnitTypes::Zerg_Overlord){
			Unit pr = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Hydralisk || GetType == UnitTypes::Zerg_Mutalisk));
			bool evade = true;
			Unit Home = HATCHERY.getHHH(u);
			if (u->isBlind()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
				continue;
			}
			if (u->isIdle()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
			}
			if (pr){
				if (u->getDistance(pr) <= 290) evade = false;
			}
			if (evade){
				// evade
				BOOST_FOREACH(Unit ee, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(ee) && ee->getType().airWeapon().damageAmount() > 0){
						Position ppp;
						ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
						ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
						ppp.makeValid();
						u->move(ppp);
						break;
					}
				}
			}
			continue;
		}

		// Extractor
		if (u->getType() == UnitTypes::Zerg_Extractor){
			Unit Cargo = HATCHERY.getHFD(u);
			if (!Cargo) continue;
			if (u->getDistance(Cargo) > 300) continue;
			int g = 0;
			BOOST_FOREACH(Unit dr, u->getUnitsInRadius(u->getDistance(Cargo))){
				if (dr->isGatheringGas() && IsOwned(dr)) g++;
			}
			if (g > 3){
				Unit come = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					IsGatheringGas && !IsCarryingSomething);
				if (come && u->getDistance(come) <= 300)
					come->stop();
			}
			else if (g < 2 && HATCHERY.getS(HATCHERY.getHFD(u), m) > 6){
				Unit ggg = HATCHERY.getHFD(u)->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (ggg && HATCHERY.getHFD(u)->getDistance(ggg) <= 300 && ggg != Chitang) ggg->gather(u);
			}
		}

		// Creep Colony
		if (u->getType() == UnitTypes::Zerg_Creep_Colony){
			if (u->canMorph(UnitTypes::Zerg_Sunken_Colony)) u->morph(UnitTypes::Zerg_Sunken_Colony);
		}

		// Hatcheries
		if (u->getType().producesLarva()){
			//drawn replace
			//Defence System
			if (ob){
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 390, Colors::Red);
				}, nullptr, 2);
			}
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(390)){
				if (!IsEnemy(ee) || ee->getType() == UnitTypes::Zerg_Overlord || ee->getType() == UnitTypes::Protoss_Observer) continue;
				//if (!dew) ave2 = ave;
				dew = true;
				ave2 = ee->getPosition();
				defense = true;
				break;
			}

			if (u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted()) continue;
			if (!HATCHERY.getfull() && HATCHERY.getS(u, m) > HATCHERY.getS(u, M) * 2 && Broodwar->getFrameCount() % 100 == 0){
				Unit Bye = u->getClosestUnit(IsOwned && IsWorker && IsGatheringMinerals && !IsCarryingSomething);
				if (Bye) Bye->stop();
			}
			//Build lines
			if ((Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool)) == 0 && Broodwar->self()->minerals() >= 190){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (!Yerim){
					Chicken = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
					if (Chicken){
						if (BUILD.ok(Chicken) && Chicken != Chitang){
							Yerim = true;
							Yerin = true;
						}
					}
				}
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spawning_Pool);
			}
			// 2nd Hatchery
			if (Building_hatcheries == 1 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 &&
				Building_lair && Broodwar->self()->minerals() >= 400){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Hatchery);
			}
			// Geyers
			if (Building_pool2 > 0 && HATCHERY.getS(u, m) > 6) {
				Unit gasbuilder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingMinerals);
				if (gasbuilder){
					if (gasbuilder->getDistance(u) > 300 || gasbuilder == Chitang) gasbuilder = NULL;
				}
				Unit gas = NULL;
				BOOST_FOREACH(Unit uu, Broodwar->getGeysers()){
					if (u->getDistance(uu) <= 300 && IsNeutral(uu)){
						gas = uu;
						break;
					}
				}
				if (gasbuilder && gas != NULL && BUILD.ok(gas->getTilePosition(), UnitTypes::Zerg_Extractor)){
					BUILD.push(gasbuilder, UnitTypes::Zerg_Extractor, gas->getTilePosition());
				}
			}

			// Hive & Lair
			if (u->canMorph(UnitTypes::Zerg_Lair) && Building_lair == 0) u->morph(UnitTypes::Zerg_Lair);

			// Spire
			if (Building_lair2 && Building_spire + BUILD.getask(UnitTypes::Zerg_Spire) == 0 && Broodwar->self()->minerals() > 100 && Broodwar->self()->gas() > 100){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spire);
			}

			// Sunken
			if (HATCHERY.getS(u, Hatch) == true && HATCHERY.getS(u, Sunken) < 1 && Building_pool && BUILD.getask(UnitTypes::Zerg_Creep_Colony) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder) && builder != Chitang && builder != Neo_chicken){
					TilePosition ttt;
					ttt = u->getTilePosition();
					ttt.y -= UnitTypes::Zerg_Creep_Colony.tileHeight();
					if (Broodwar->canBuildHere(ttt, UnitTypes::Zerg_Creep_Colony, builder)){
						BUILD.push(builder, UnitTypes::Zerg_Creep_Colony, ttt);

					}
					else {
						ttt = u->getTilePosition() + u->getType().tileSize();
						ttt.x -= UnitTypes::Zerg_Creep_Colony.tileWidth();
						if (Broodwar->canBuildHere(ttt, UnitTypes::Zerg_Creep_Colony, builder))
							BUILD.push(builder, UnitTypes::Zerg_Creep_Colony, ttt);
					}
				}
			}

			if (BUILD.getN() > 0 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 && Broodwar->self()->minerals() < 600) continue;
			//Producing lines
			BOOST_FOREACH(Unit Larva, u->getLarva()){

				int lar = (Building_spire && Must_mutal) * Unit_larva * 4;
				// Overlord spawn
				if (Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 - Broodwar->self()->supplyUsed() - lar < Building_hatcheries * 4 * (1 + (Building_spire || Building_den))
					&& Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 < 400
					&& Larva->canTrain(UnitTypes::Zerg_Overlord)
					&& Building_pool > 0){
					Larva->train(UnitTypes::Zerg_Overlord);
					OVERLORD.push(Larva);
					continue;
				}


				if (Building_spire2 && Must_mutal){
					if (Larva->canTrain(UnitTypes::Zerg_Mutalisk)){
						Larva->train(UnitTypes::Zerg_Mutalisk);
						continue;
					}
					continue;
				}

				// Drone spawn
				if (Larva->canTrain(UnitTypes::Zerg_Drone) && Unit_drones <= 8){
					if (DESIGNER.ask(u->getTilePosition())){
						if (!HATCHERY.getS(u, Satis)){
							Larva->train(UnitTypes::Zerg_Drone);
							Unit_drones++;
							continue;
						}
					}
					else if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis)){
						Larva->train(UnitTypes::Zerg_Drone);
						Unit_drones++;
						continue;
					}
				}
				if (Larva->canTrain(UnitTypes::Zerg_Zergling)){
					Larva->train(UnitTypes::Zerg_Zergling);
					continue;
				}
				if (Larva->canTrain(UnitTypes::Zerg_Mutalisk)){
					Larva->train(UnitTypes::Zerg_Mutalisk);
					continue;
				}
			}
			continue;
		}
	}
	if (!defense && dew){
		dew = false;
	}
	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		else if (squad[i].getT() == UnitTypes::Zerg_Zergling){
			if (dew){
				squad[i].Dew();
			}
			else if (getM(UnitTypes::Zerg_Zergling) >= 2){
				squad[i].Action();
			}
			else{
				squad[i].Defensive();
			}
		}
		else if (squad[i].getT() == UnitTypes::Zerg_Mutalisk){
			squad[i].Protect();
			if (dew && !mutal_dew){
				squad[i].Dew();
				mutal_dew = true;
			}
			else if (squad[i].getN() >= 8 || Search){
				squad[i].Action();
			}
			else if (dew){
				squad[i].Dew();
			}
			else{
				squad[i].Defensive();
			}
		}
	}
	if (!Must_mutal){
		if (Zia2 != -1){
			Zia = Zia2;
		}
		else {
			Zia = rand() % (3 - (Broodwar->mapFileName().find("BlueStorm") != string::npos)) + 6;
			Zia2 = Zia;
		}
		switch (Zia){
		case Strat::Jaeeun:
			Jia.append("->Jaeeun");
			break;
		case Strat::Jungeun:
			Jia.append("->Jungeun");
			break;
		case Strat::Juae:
			Jia.append("->Juae");
			break;
		}
	}
}
void SquadManager::Jaeeun(){ // Mutal

	//if (Ddangddang) ddangddang();
	//if (Neoddang) neoddang();
	bool mutal_dew = false;
	defense = false;
	BOOST_FOREACH(Unit u, Broodwar->getAllUnits())
	{
		if (IsEnemy(u)){
			if (u->getType() == UnitTypes::Protoss_Corsair || u->getType() == UnitTypes::Protoss_Archon){
				Zia = Strat::Juae;
				Zia3 = Zia;
				Jia.append(" ->Juae");
				return;
			}
			if (u->getType() == UnitTypes::Terran_Valkyrie || u->getType() == UnitTypes::Terran_Goliath){
				Zia = Strat::Seohyun;
				Zia3 = Zia;
				Jia.append(" ->Seohyun");
				return;
			}
			continue;
		}
		if (!u->exists()) continue;
		if (u->isLockedDown() || u->isMaelstrommed() || u->isStasised()) continue;
		if (u->isLoaded() || !u->isPowered() || u->isStuck()) continue;
		if (!u->isCompleted() && !u->getType().isResourceDepot()) continue;

		//Unit_lines:
		// Drones
		if (u->getType().isWorker()){
			if (u == Chicken || u == Chitang) continue;
			if (u->isIdle() && BUILD.ok(u)){
				Unit Cargo;
				if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis))
					Cargo = HATCHERY.getHFD(u);
				else
					Cargo = HATCHERY.getHFM(u);
				if (Cargo){
					u->gather(Cargo->getClosestUnit(IsMineralField));
				}
			}
			if (u->isUnderAttack() && u->getDistance(HATCHERY.getHHH(u)) < 400){
				Unit Friend = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringGas || IsGatheringMinerals));
				if (!BUILD.ok(Friend) || u->getDistance(Friend) >= 200) Friend = NULL;
				Unit target = u->getClosestUnit(IsEnemy);
				if (target){
					if (u->canAttackUnit(target) && u->getHitPoints() >= 20) u->attack(target);
				}
				if (Friend && target){
					if (Friend->canAttackUnit(target))Friend->attack(target);
				}
			}
			if (!BUILD.ok(u)) continue;
			Unit Cargo = HATCHERY.getHFD(u);
			if (Cargo){
				if (u->getDistance(Cargo) > 400 && !u->isCarryingMinerals() && !HATCHERY.getS(Cargo, Satis))
					u->gather(Cargo->getClosestUnit(IsMineralField));
			}
			continue;
		}
		// Overlords
		if (u->getType() == UnitTypes::Zerg_Overlord){
			Unit pr = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Hydralisk || GetType == UnitTypes::Zerg_Mutalisk));
			bool evade = true;
			Unit Home = HATCHERY.getHHH(u);
			if (u->isBlind()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
				continue;
			}
			if (u->isIdle()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
			}
			if (pr){
				if (u->getDistance(pr) <= 290) evade = false;
			}
			if (evade){
				// evade
				BOOST_FOREACH(Unit ee, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(ee) && ee->getType().airWeapon().damageAmount() > 0){
						Position ppp;
						ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
						ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
						ppp.makeValid();
						u->move(ppp);
						break;
					}
				}
			}
			continue;
		}

		// Extractor
		if (u->getType() == UnitTypes::Zerg_Extractor){
			Unit Cargo = HATCHERY.getHFD(u);
			if (!Cargo) continue;
			if (u->getDistance(Cargo) > 300) continue;
			int g = 0;
			BOOST_FOREACH(Unit dr, u->getUnitsInRadius(u->getDistance(Cargo))){
				if (dr->isGatheringGas() && IsOwned(dr)) g++;
			}
			if (g > 3){
				Unit come = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					IsGatheringGas && !IsCarryingSomething);
				if (come && u->getDistance(come) <= 300)
					come->stop();
			}
			else if (g < 2 && HATCHERY.getS(HATCHERY.getHFD(u), m) > 6){
				Unit ggg = HATCHERY.getHFD(u)->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (ggg && HATCHERY.getHFD(u)->getDistance(ggg) <= 300 && ggg != Chitang) ggg->gather(u);
			}
		}
		// Pool
		if (u->getType() == UnitTypes::Zerg_Spawning_Pool && Building_lair){
			if (u->canUpgrade(UpgradeTypes::Metabolic_Boost) && !Must_mutal) u->upgrade(UpgradeTypes::Metabolic_Boost);
			if (u->canUpgrade(UpgradeTypes::Adrenal_Glands)) u->upgrade(UpgradeTypes::Adrenal_Glands);
		}
		// Spire
		if (u->getType() == UnitTypes::Zerg_Spire){
			if (Must_mutal) continue;
			if (u->canUpgrade(UpgradeTypes::Zerg_Flyer_Carapace)) u->upgrade(UpgradeTypes::Zerg_Flyer_Carapace);
			if (u->canUpgrade(UpgradeTypes::Zerg_Flyer_Attacks)) u->upgrade(UpgradeTypes::Zerg_Flyer_Attacks);
		}

		// Chamber
		if (u->getType() == UnitTypes::Zerg_Evolution_Chamber){
			if (u->canUpgrade(UpgradeTypes::Zerg_Carapace)) u->upgrade(UpgradeTypes::Zerg_Carapace);
			if (u->canUpgrade(UpgradeTypes::Zerg_Melee_Attacks)) u->upgrade(UpgradeTypes::Zerg_Melee_Attacks);
		}

		// Creep Colony
		if (u->getType() == UnitTypes::Zerg_Creep_Colony){
			if (u->canMorph(UnitTypes::Zerg_Sunken_Colony)) u->morph(UnitTypes::Zerg_Sunken_Colony);
		}

		// Hatcheries
		if (u->getType().producesLarva()){
			//drawn replace
			//Defence System
			if (ob){
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 390, Colors::Red);
				}, nullptr, Broodwar->getLatencyFrames());
			}
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(390)){
				if (!IsEnemy(ee) || ee->getType() == UnitTypes::Zerg_Overlord || ee->getType() == UnitTypes::Protoss_Observer) continue;
				//if (!dew) ave2 = ave;
				dew = true;
				ave2 = ee->getPosition();
				defense = true;
				break;
			}

			if (u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted()) continue;
			if (!HATCHERY.getfull() && HATCHERY.getS(u, m) > HATCHERY.getS(u, M) * 2 && Broodwar->getFrameCount() % 100 == 0){
				Unit Bye = u->getClosestUnit(IsOwned && IsWorker && IsGatheringMinerals && !IsCarryingSomething);
				if (Bye) Bye->stop();
			}
			///////////////////Building lines/////////////////////////
			if ((Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool)) == 0 && Broodwar->self()->minerals() >= 190 ){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spawning_Pool);
			}
			//More Hatcheries
			if (Building_hatcheries > 1 && Building_hatcheries <= 6 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 &&
				HATCHERY.getN() * 2 - 1 > Building_hatcheries && Broodwar->self()->minerals() >= 500 && !(Building_spire && Must_mutal)){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Hatchery);
			}
			// More bases (Random)
			else if ((HATCHERY.getfull() || Broodwar->self()->minerals() >= 500) && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 &&
				!(Building_spire && Must_mutal)){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);

				TilePosition Nextbase;
				bool next = false;
				int check = 100000;
				int I = -1;
				double ddd = 100000;
				for (int i = 0; i < DESIGNER.nBase && builder; i++){
					if (!Broodwar->canBuildHere(DESIGNER.Bases[i], UnitTypes::Zerg_Hatchery, builder)) continue;
					double dd;
					if (Broodwar->mapFileName().find("Plasma") != string::npos){
						if (!HATCHERY.getS(u, Hatch)){
							next = false;
							break;
						}
						dd = u->getDistance((Position)DESIGNER.Bases[i]);
						if (dd < ddd){
							ddd = dd;
							Nextbase = DESIGNER.Bases[i];
							next = true;
						}
					}
					else{
						if (builder->hasPath((Position)DESIGNER.Bases[i])){
							if (check > DESIGNER.Try[i]){
								next = true;
								check = DESIGNER.Try[i];
								Nextbase = DESIGNER.Bases[i];
								I = i;
							}
						}
					}
				}

				if (builder && next && BUILD.ok(builder)){
					BUILD.push(builder, UnitTypes::Zerg_Hatchery, Nextbase);
					if (Broodwar->mapFileName().find("Plasma") == string::npos) DESIGNER.Try[I]++;
				}
			}
			// Geyers
			if (Building_pool > 0 && HATCHERY.getS(u, m) > 6) {
				Unit gasbuilder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingMinerals);
				if (gasbuilder){
					if (gasbuilder->getDistance(u) > 300 || gasbuilder == Chitang) gasbuilder = NULL;
				}
				Unit gas = NULL;
				BOOST_FOREACH(Unit uu, Broodwar->getGeysers()){
					if (u->getDistance(uu) <= 300 && IsNeutral(uu)){
						gas = uu;
						break;
					}
				}
				if (gasbuilder && gas != NULL && BUILD.ok(gas->getTilePosition(), UnitTypes::Zerg_Extractor)){
					BUILD.push(gasbuilder, UnitTypes::Zerg_Extractor, gas->getTilePosition());
				}
			}
			// Sunken
			if (u->getTilePosition() != Broodwar->self()->getStartLocation() && HATCHERY.getS(u, Hatch) == true && HATCHERY.getS(u, Sunken) < 2 && BUILD.getask(UnitTypes::Zerg_Creep_Colony) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder) && builder != Chitang){
					if (builder->getDistance(u) <= 300) BUILD.push(builder, UnitTypes::Zerg_Creep_Colony);
				}
			}

			// Hive & Lair
			if (u->canMorph(UnitTypes::Zerg_Lair) && Building_lair == 0) u->morph(UnitTypes::Zerg_Lair);
			if (u->canMorph(UnitTypes::Zerg_Hive) && Building_hive == 0) u->morph(UnitTypes::Zerg_Hive);
			if (u->canUpgrade(UpgradeTypes::Pneumatized_Carapace) && Building_hatcheries >= 7) u->upgrade(UpgradeTypes::Pneumatized_Carapace);
			if (u->canResearch(TechTypes::Burrowing) && Building_hatcheries >= 7) u->research(TechTypes::Burrowing);

			// Spire
			if (Building_lair2 && Building_spire + BUILD.getask(UnitTypes::Zerg_Spire) == 0 && Broodwar->self()->minerals() > 100 && Broodwar->self()->gas() > 100){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spire);
			}

			// Queens nest
			if (Building_lair2 && Building_queen + BUILD.getask(UnitTypes::Zerg_Queens_Nest) == 0 && Building_hatcheries > 5){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Queens_Nest);
			}
			// Chamber
			if (Building_hatcheries >= 5 && Building_chamber + BUILD.getask(UnitTypes::Zerg_Evolution_Chamber) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Evolution_Chamber);
			}

			//Producing lines
			if (BUILD.getN() > 0 && (Building_hatcheries < 3 || BUILD.getask(UnitTypes::Zerg_Hatchery)) && Broodwar->self()->minerals() < 600) continue;
			BOOST_FOREACH(Unit Larva, u->getLarva()){

				// Overlord spawn
				int lar = (Building_spire && Must_mutal) * Unit_larva * 4;
				if (Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 - Broodwar->self()->supplyUsed() - lar < Building_hatcheries * 4 * (1 + (Building_spire || Building_den))
					&& Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 < 400
					&& Larva->canTrain(UnitTypes::Zerg_Overlord)){
					Larva->train(UnitTypes::Zerg_Overlord);
					OVERLORD.push(Larva);
					continue;
				}


				if (Building_spire2 && Must_mutal){
					if (Larva->canTrain(UnitTypes::Zerg_Mutalisk)){
						Larva->train(UnitTypes::Zerg_Mutalisk);
						continue;
					}
					continue;
				}

				// Drone spawn
				if (Larva->canTrain(UnitTypes::Zerg_Drone) && Unit_drones <= 80 && !dew){
					if (DESIGNER.ask(u->getTilePosition())){
						if (!HATCHERY.getS(u, Satis)){
							Larva->train(UnitTypes::Zerg_Drone);
							Unit_drones++;
							continue;
						}
					}
					else if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis)){
						Larva->train(UnitTypes::Zerg_Drone);
						Unit_drones++;
						continue;
					}
				}
				if (Larva->canTrain(UnitTypes::Zerg_Mutalisk)){
					Larva->train(UnitTypes::Zerg_Mutalisk);
					continue;
				}
				if (Larva->canTrain(UnitTypes::Zerg_Zergling) && !(Building_spire&&Must_mutal) ){
					Larva->train(UnitTypes::Zerg_Zergling);
					continue;
				}
			}
			continue;
		}
	}
	if (!defense && dew){
		dew = false;
	}
	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		if (squad[i].getT() == UnitTypes::Zerg_Zergling){
			if (Search || getM(UnitTypes::Zerg_Zergling) >= 2 || (Zia1 == Strat::Dahye && Must_mutal && squad[i].getN() >= 6)){
				squad[i].Action();
			}
			else if (dew){
				squad[i].Dew();
			}
			else{
				squad[i].Defensive();
			}
		}
		else if (squad[i].getT() == UnitTypes::Zerg_Mutalisk){
			if(Broodwar->enemy()->getRace() != Races::Zerg) squad[i].Protect();
			if (dew && !mutal_dew){
				squad[i].Dew();
				mutal_dew = true;
			}
			else if (squad[i].getN() >= 8 || Search){
				squad[i].Action();
			}
			else if (dew){
				squad[i].Dew();
			}
			else{
				squad[i].Defensive();
			}
		}
	}
}
void SquadManager::Juae(){
	defense = false;
	static bool juae = false;
	static bool first_juae = true;
	static bool fast_over = false;
	if (juae){
		if (getN() <= 1) juae = false;
	}
	else if (getM(UnitTypes::Zerg_Hydralisk) >= 3 - first_juae){
		juae = true;
		if (first_juae) first_juae = false;
	}

	BOOST_FOREACH(Unit u, Broodwar->getAllUnits())
	{
		if (IsEnemy(u)){
			if (u->getType() == UnitTypes::Terran_Medic){
				Zia = Strat::Soyoung;
				Zia3 = Zia;
				Jia.append(" ->Soyoung");
				return;
			}
			if (u->getType() == UnitTypes::Terran_Siege_Tank_Siege_Mode){
				Zia = Strat::Seohyun;
				Zia3 = Zia;
				Jia.append(" ->Seohyun");
				return;
			}
			if (u->getType() == UnitTypes::Protoss_Corsair || u->getType() == UnitTypes::Protoss_Dark_Templar){
				fast_over = true;
			}
			continue;
		}
		if (!u->exists()) continue;
		if (u->isLockedDown() || u->isMaelstrommed() || u->isStasised()) continue;
		if (u->isLoaded() || !u->isPowered() || u->isStuck()) continue;
		if (!u->isCompleted() && !u->getType().isResourceDepot()) continue;

		//Unit_lines:
		// Drones
		if (u->getType().isWorker()){
			if (u == Chicken || u == Chitang) continue;
			if (u->isIdle() && BUILD.ok(u)){
				Unit Cargo;
				if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis))
					Cargo = HATCHERY.getHFD(u);
				else
					Cargo = HATCHERY.getHFM(u);
				if (Cargo){
					u->gather(Cargo->getClosestUnit(IsMineralField));
				}
			}
			if (u->isUnderAttack() && u->getDistance(HATCHERY.getHHH(u)) < 400){
				Unit Friend = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringGas || IsGatheringMinerals));
				if (!BUILD.ok(Friend) || u->getDistance(Friend) >= 200) Friend = NULL;
				Unit target = u->getClosestUnit(IsEnemy);
				if (target){
					if (u->canAttackUnit(target) && u->getHitPoints() >= 20) u->attack(target);
				}
				if (Friend && target){
					if (Friend->canAttackUnit(target))Friend->attack(target);
				}
			}
			if (!BUILD.ok(u)) continue;
			Unit Cargo = HATCHERY.getHFD(u);
			if (Cargo){
				if (u->getDistance(Cargo) > 400 && !u->isCarryingMinerals() && !HATCHERY.getS(Cargo, Satis))
					u->gather(Cargo->getClosestUnit(IsMineralField));
			}
			continue;
		}
		// Overlords
		if (u->getType() == UnitTypes::Zerg_Overlord){
			Unit pr = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Hydralisk || GetType == UnitTypes::Zerg_Mutalisk));
			Unit Home = HATCHERY.getHHH(u);
			bool evade = true;
			if (u->isBlind()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
				continue;
			}
			if (u->isIdle()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
			}
			if (pr){
				if (u->getDistance(pr) <= 290) evade = false;
			}
			if (evade){
				// evade
				BOOST_FOREACH(Unit ee, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(ee) && ee->getType().airWeapon().damageAmount() > 0){
						Position ppp;
						ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
						ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
						ppp.makeValid();
						u->move(ppp);
						break;
					}
				}
			}
			continue;
		}

		////Buildings ////
		// Extractor
		if (u->getType() == UnitTypes::Zerg_Extractor){
			Unit Cargo = HATCHERY.getHFD(u);
			if (!Cargo) continue;
			if (u->getDistance(Cargo) > 300) continue;
			int g = 0;
			BOOST_FOREACH(Unit dr, u->getUnitsInRadius(u->getDistance(Cargo))){
				if (dr->isGatheringGas() && IsOwned(dr)) g++;
			}
			if (g > (Building_hatcheries >= 3 ? 3 : 2 ) ){
				Unit come = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					IsGatheringGas && !IsCarryingSomething);
				if (come && u->getDistance(come) <= 300)
					come->stop();
			}
			else if (g < (Building_hatcheries >= 3 ? 2 : 1) && HATCHERY.getS(HATCHERY.getHFD(u), m) > 6){
				Unit ggg = HATCHERY.getHFD(u)->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (ggg && HATCHERY.getHFD(u)->getDistance(ggg) <= 300 && ggg != Chitang) ggg->gather(u);
			}
		}
		// Hydra den
		if (u->getType() == UnitTypes::Zerg_Hydralisk_Den){
			if (u->canUpgrade(UpgradeTypes::Muscular_Augments)) u->upgrade(UpgradeTypes::Muscular_Augments);
			if (u->canUpgrade(UpgradeTypes::Grooved_Spines)) u->upgrade(UpgradeTypes::Grooved_Spines);
		}

		// Chamber
		if (u->getType() == UnitTypes::Zerg_Evolution_Chamber){
			if (u->canUpgrade(UpgradeTypes::Zerg_Carapace)) u->upgrade(UpgradeTypes::Zerg_Carapace);
			if (u->canUpgrade(UpgradeTypes::Zerg_Missile_Attacks) && Building_den) u->upgrade(UpgradeTypes::Zerg_Missile_Attacks);
		}

		// Creep Colony
		if (u->getType() == UnitTypes::Zerg_Creep_Colony){
			if (u->canMorph(UnitTypes::Zerg_Sunken_Colony)) u->morph(UnitTypes::Zerg_Sunken_Colony);
		}

		// Hatcheries
		if (u->getType().producesLarva()){
			//drawn replace
			//Defence System
			if (ob){
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 390, Colors::Red);
				}, nullptr, 2);
			}
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(390)){
				if (!IsEnemy(ee) || ee->getType() == UnitTypes::Zerg_Overlord || ee->getType() == UnitTypes::Protoss_Observer) continue;
				//if (!dew) ave2 = ave;
				dew = true;
				ave2 = ee->getPosition();
				defense = true;
				break;
			}

			if (u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted()) continue;
			if (!HATCHERY.getfull() && HATCHERY.getS(u, m) > HATCHERY.getS(u, M) * 2 && Broodwar->getFrameCount() % 100 == 0){
				Unit Bye = u->getClosestUnit(IsOwned && IsWorker && IsGatheringMinerals && !IsCarryingSomething);
				if (Bye) Bye->stop();
			}
			/////////////////Build lines/////////////////////
			// pool
			if ((Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool)) == 0 && // base
				Building_hatcheries >= 2) {
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (!Zia){
					Chicken = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
					if (Chicken){
						if (BUILD.ok(Chicken) && Chicken != Chitang){
							Zia = true;
							Yerin = true;
						}
					}
				}
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spawning_Pool);
			}
			//More Hatcheries
			if (Building_hatcheries <= 6 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 &&
				HATCHERY.getN() * 2 -1 > Building_hatcheries && Broodwar->self()->minerals() >= 500
				){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Hatchery);
			}

			// More bases
			//Multi
			else if ((HATCHERY.getfull() || (Broodwar->self()->minerals() >= 500 && (Building_hatcheries >= 3 ? true : Unit_drones >= Building_hatcheries * 7)) ) &&
				HATCHERY.getN() == 1 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0){
				static bool first_multi = true;
				
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (first_multi){
					if (BUILD.ok(builder) && builder){
						BUILD.push(builder, UnitTypes::Zerg_Hatchery, Multi);
						first_multi = false;
					}
				}
				else{
					TilePosition Nextbase;
					bool next = false;
					double ddd = 100000;

					for (int i = 0; i < DESIGNER.nBase && builder; i++){
						if (!Broodwar->canBuildHere(DESIGNER.Bases[i], UnitTypes::Zerg_Hatchery, builder)) continue;

						double dd;
						if (Broodwar->mapFileName().find("Plasma") != string::npos){
							if (!HATCHERY.getS(u, Hatch)){
								next = false;
								break;
							}
							dd = u->getDistance((Position)DESIGNER.Bases[i]);
						}
						else dd = BWTA::getGroundDistance(u->getTilePosition(), DESIGNER.Bases[i]);
						if (dd < ddd){
							ddd = dd;
							Nextbase = DESIGNER.Bases[i];
							next = true;
						}
					}
					if (next && builder && BUILD.ok(builder)){
						BUILD.push(builder, UnitTypes::Zerg_Hatchery, Nextbase);
					}
				}
			}
			// More bases (Random)
			else if ((HATCHERY.getfull() || (Broodwar->self()->minerals() >= 500 && (Building_hatcheries >= 3 ? true : Unit_drones >= Building_hatcheries * 7))) &&
				BUILD.getask(UnitTypes::Zerg_Hatchery) == 0){
				 
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);

				TilePosition Nextbase;
				bool next = false;
				int check = 100000;
				int I;

				double ddd = 100000;

				for (int i = 0; i < DESIGNER.nBase && builder; i++){
					if (!Broodwar->canBuildHere(DESIGNER.Bases[i], UnitTypes::Zerg_Hatchery, builder)) continue;

					double dd;
					if (Broodwar->mapFileName().find("Plasma") != string::npos){
						if (!HATCHERY.getS(u, Hatch)){
							next = false;
							break;
						}
						dd = u->getDistance((Position)DESIGNER.Bases[i]);
						if (dd < ddd){
							ddd = dd;
							Nextbase = DESIGNER.Bases[i];
							next = true;
						}
					}
					else{
						if (builder->hasPath((Position)DESIGNER.Bases[i])){
							if (check > DESIGNER.Try[i]){
								next = true;
								check = DESIGNER.Try[i];
								Nextbase = DESIGNER.Bases[i];
								I = i;
							}
						}
					}
				}

				if (next && builder && BUILD.ok(builder)){
					if (Broodwar->mapFileName().find("Plasma") == string::npos) DESIGNER.Try[I]++;
					BUILD.push(builder, UnitTypes::Zerg_Hatchery, Nextbase);
				}
			}

			// Geyers
			//if (Building_pool > 0 && (HATCHERY.getS(u, m) > 8 || (Broodwar->enemy()->getRace() == Races::Zerg && u->getTilePosition() == Broodwar->self()->getStartLocation()))){
			if (HATCHERY.getS(u, m) > 6) {
				Unit gasbuilder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingMinerals);
				if (gasbuilder){
					if (gasbuilder->getDistance(u) > 300 || gasbuilder == Chitang) gasbuilder = NULL;
				}
				Unit gas = NULL;
				BOOST_FOREACH(Unit uu, Broodwar->getGeysers()){
					if (u->getDistance(uu) <= 300 && IsNeutral(uu)){
						gas = uu;
						break;
					}
				}
				if (gasbuilder && gas != NULL && BUILD.ok(gas->getTilePosition(), UnitTypes::Zerg_Extractor)){
					BUILD.push(gasbuilder, UnitTypes::Zerg_Extractor, gas->getTilePosition());
				}
			}
			// Sunken
			if (u->getTilePosition() != Broodwar->self()->getStartLocation() && HATCHERY.getS(u, Hatch) == true && HATCHERY.getS(u, Sunken) < 2 && BUILD.getask(UnitTypes::Zerg_Creep_Colony) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder) && builder != Chitang){
					if (builder->getDistance(u) <= 300) BUILD.push(builder, UnitTypes::Zerg_Creep_Colony);
				}
			}

			// Hive & Lair
			if (u->canMorph(UnitTypes::Zerg_Lair) && Building_lair == 0 && (Building_hatcheries >= 5||fast_over)) u->morph(UnitTypes::Zerg_Lair);
			if (u->canUpgrade(UpgradeTypes::Pneumatized_Carapace)) u->upgrade(UpgradeTypes::Pneumatized_Carapace);
			if (u->canResearch(TechTypes::Burrowing) && Building_lair2) u->research(TechTypes::Burrowing);

			// Hydraden versus not zerg
			if (Building_pool2 && Building_den + BUILD.getask(UnitTypes::Zerg_Hydralisk_Den) == 0 && Broodwar->self()->gas() >= 50){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Hydralisk_Den);
			}

			// Chamber
			if (Building_hatcheries >= 5 && Building_chamber + BUILD.getask(UnitTypes::Zerg_Evolution_Chamber) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Evolution_Chamber);
			}

			//Producing lines
			if (BUILD.getN() > 0 && (Building_hatcheries <= 3 || BUILD.getask(UnitTypes::Zerg_Hatchery)) && Broodwar->self()->minerals() < 500) continue;
			BOOST_FOREACH(Unit Larva, u->getLarva()){

				// Overlord spawn
				if (Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 - Broodwar->self()->supplyUsed() < Building_hatcheries * 8
					&& Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 < 400
					&& Larva->canTrain(UnitTypes::Zerg_Overlord)){
					Larva->train(UnitTypes::Zerg_Overlord);
					OVERLORD.push(Larva);
					continue;
				}

				// Drone spawn
				if (Larva->canTrain(UnitTypes::Zerg_Drone) && Unit_drones <= 80 && 
					Building_hatcheries >= 3 ? true :  Unit_drones < Building_hatcheries * (7 + juae * 3)
					&& !dew){
					if (DESIGNER.ask(u->getTilePosition())){
						if (!HATCHERY.getS(u, Satis)){
							Larva->train(UnitTypes::Zerg_Drone);
							Unit_drones++;
							continue;
						}
					}
					else if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis)){
						Larva->train(UnitTypes::Zerg_Drone);
						Unit_drones++;
						continue;
					}
				}
				if (Larva->canTrain(UnitTypes::Zerg_Hydralisk)){
					Larva->train(UnitTypes::Zerg_Hydralisk);
					continue;
				}
				if (Larva->canTrain(UnitTypes::Zerg_Zergling) && dew){
					Larva->train(UnitTypes::Zerg_Zergling);
					continue;
				}
			}
			continue;
		}

	} // closure: unit iterator
	if (!defense && dew){
		dew = false;
	}
	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		if (squad[i].getT() == UnitTypes::Zerg_Mutalisk){
			squad[i].Action();
		}
		else if (squad[i].getT() == UnitTypes::Zerg_Zergling){
			if (dew){
				squad[i].Dew();
			}
			else if (juae || Zia1 == Strat::Dahye || Zia1 == Strat::Dahee){
				squad[i].Action();
			}
			else{
				squad[i].Defensive();
			}
		}
		else if (squad[i].getT() == UnitTypes::Zerg_Hydralisk){
			if (Broodwar->self()->hasResearched(TechTypes::Burrowing)) squad[i].Protect();
			if (dew){
				squad[i].Dew();
			}
			else if (juae){
				squad[i].Action();
			}
			else{
				squad[i].Defensive();
			}
		}
	}
}
void SquadManager::Jungeun(){ // Lurker
	static bool must_aspect = true;
	static bool fast_over = false;
	bool mutal_dew = false;
	defense = false;
	// Unit Iterate
	BOOST_FOREACH(Unit u, Broodwar->getAllUnits() )
	{
		if (IsEnemy(u)){
			if (IsFlying(u) && !IsBuilding(u) && (u->getEnergy() > 0 || u->getType().groundWeapon().damageAmount() > 0 || u->getType().airWeapon().damageAmount() > 0)){
				Zia = rand() % 2 + 10;
				Zia3 = Zia;
				switch (Zia){
				case Strat::Seohyun:
					Jia.append(" ->Seohyun");
					break;
				case Strat::Soyoung:
					Jia.append(" ->Soyoung");
					break;
				}
				return;
			}
			if (u->getType() == UnitTypes::Protoss_Corsair || u->getType() == UnitTypes::Protoss_Dark_Templar){
				fast_over = true;
			}
			continue;
		}
		if (!u->exists()) continue;
		if (u->isLockedDown() || u->isMaelstrommed() || u->isStasised()) continue;
		if (u->isLoaded() || !u->isPowered() || u->isStuck()) continue;
		if (!u->isCompleted() && !u->getType().isResourceDepot()) continue;

		//Unit_lines:
		// Drones
		if (u->getType().isWorker()){
			if (u == Chicken || u == Chitang) continue;
			if (u->isIdle() && BUILD.ok(u)){
				Unit Cargo;
				if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis))
					Cargo = HATCHERY.getHFD(u);
				else
					Cargo = HATCHERY.getHFM(u);
				if (Cargo){
					u->gather(Cargo->getClosestUnit(IsMineralField));
				}
			}
			if (u->isUnderAttack() && u->getDistance(HATCHERY.getHHH(u)) < 400){
				Unit Friend = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringGas || IsGatheringMinerals));
				if (!BUILD.ok(Friend) || u->getDistance(Friend) >= 200) Friend = NULL;
				Unit target = u->getClosestUnit(IsEnemy);
				if (target){
					if (u->canAttackUnit(target) && u->getHitPoints() >= 20) u->attack(target);
				}
				if (Friend && target){
					if (Friend->canAttackUnit(target))Friend->attack(target);
				}
			}
			if (!BUILD.ok(u)) continue;
			Unit Cargo = HATCHERY.getHFD(u);
			if (Cargo){
				if (u->getDistance(Cargo) > 400 && !u->isCarryingMinerals() && !HATCHERY.getS(Cargo, Satis))
					u->gather(Cargo->getClosestUnit(IsMineralField));
			}
			continue;
		}
		// Overlords
		if (u->getType() == UnitTypes::Zerg_Overlord){
			Unit pr = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Hydralisk || GetType == UnitTypes::Zerg_Mutalisk));
			bool evade = true;
			Unit Home = HATCHERY.getHHH(u);
			if (u->isBlind()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
				continue;
			}
			if (u->isIdle()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
			}
			if (pr){
				if (u->getDistance(pr) <= 290) evade = false;
			}
			if (evade){
				// evade
				BOOST_FOREACH(Unit ee, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(ee) && ee->getType().airWeapon().damageAmount() > 0){
						Position ppp;
						ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
						ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
						ppp.makeValid();
						u->move(ppp);
						break;
					}
				}
			}
			continue;
		}

		if (u->getType() == UnitTypes::Zerg_Lurker && dew){
			if (u->canUnburrow() && Broodwar->getFrameCount() % 300 != 0) continue;
			bool EE = false;
			// find enemy
			BOOST_FOREACH(Unit target, u->getUnitsInRadius(190)){
				if (!IsEnemy(target) || !IsVisible(target) || IsFlying(target)) continue;
				EE = true;
				if (u->canBurrow()){
					u->burrow();
					break;
				}
			}
			if (!EE && u->canUnburrow()) u->unburrow();
			u->move(ave2);
			if (ob) Broodwar->drawLineMap(u->getPosition(), ave2, Colors::Red);
			continue;
		}

		///Buildings ///
		// Extractor
		if (u->getType() == UnitTypes::Zerg_Extractor){
			Unit Cargo = HATCHERY.getHFD(u);
			if (!Cargo) continue;
			if (u->getDistance(Cargo) > 300) continue;
			int g = 0;
			BOOST_FOREACH(Unit dr, u->getUnitsInRadius(u->getDistance(Cargo))){
				if (dr->isGatheringGas() && IsOwned(dr)) g++;
			}
			if (g > 3){
				Unit come = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					IsGatheringGas && !IsCarryingSomething);
				if (come && u->getDistance(come) <= 300)
					come->stop();
			}
			else if (g < 2 && HATCHERY.getS(HATCHERY.getHFD(u), m) > 6){
				Unit ggg = HATCHERY.getHFD(u)->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (ggg && HATCHERY.getHFD(u)->getDistance(ggg) <= 300 && ggg != Chitang) ggg->gather(u);
			}
		}
		// Pool
		if (u->getType() == UnitTypes::Zerg_Spawning_Pool && Building_lair){
			if (!Broodwar->self()->hasResearched(TechTypes::Lurker_Aspect)) continue;
			if (u->canUpgrade(UpgradeTypes::Metabolic_Boost)) u->upgrade(UpgradeTypes::Metabolic_Boost);
			if (u->canUpgrade(UpgradeTypes::Adrenal_Glands)) u->upgrade(UpgradeTypes::Adrenal_Glands);
		}
		// Hydra den
		if (u->getType() == UnitTypes::Zerg_Hydralisk_Den){
			if (u->canResearch(TechTypes::Lurker_Aspect)){
				u->research(TechTypes::Lurker_Aspect);
				must_aspect = false;
			}
		}

		// Chamber
		if (u->getType() == UnitTypes::Zerg_Evolution_Chamber){
			if (u->canUpgrade(UpgradeTypes::Zerg_Carapace)) u->upgrade(UpgradeTypes::Zerg_Carapace);
			if (u->canUpgrade(UpgradeTypes::Zerg_Missile_Attacks) && Building_den) u->upgrade(UpgradeTypes::Zerg_Missile_Attacks);
			if (u->canUpgrade(UpgradeTypes::Zerg_Melee_Attacks)) u->upgrade(UpgradeTypes::Zerg_Melee_Attacks);
		}

		// Creep Colony
		if (u->getType() == UnitTypes::Zerg_Creep_Colony){
			if (u->canMorph(UnitTypes::Zerg_Sunken_Colony)) u->morph(UnitTypes::Zerg_Sunken_Colony);
		}

		// Hatcheries
		if (u->getType().producesLarva()){
			//drawn replace
			//Defence System
			//bool Sky_defense = false;
			if (ob){
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 390, Colors::Red);
				}, nullptr, 2);
			}
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(390)){
				if (!IsEnemy(ee) || ee->getType() == UnitTypes::Zerg_Overlord || ee->getType() == UnitTypes::Protoss_Observer) continue;
				//if (!dew) ave2 = ave;
				dew = true;
				ave2 = ee->getPosition();
				defense = true;
				break;
			}

			if (u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted()) continue;
			if (!HATCHERY.getfull() && HATCHERY.getS(u, m) > HATCHERY.getS(u, M) * 2 && Broodwar->getFrameCount() % 100 == 0){
				Unit Bye = u->getClosestUnit(IsOwned && IsWorker && IsGatheringMinerals && !IsCarryingSomething);
				if (Bye) Bye->stop();
			}
			/////////////////////////Build lines/////////////////////////
			if ((Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool)) == 0 && Broodwar->self()->minerals() >= 190) {
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spawning_Pool);
			}
			//More Hatcheries
			if (Building_hatcheries <= 5 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 && Broodwar->self()->minerals() >= 500 &&
				HATCHERY.getN() * 2 - 1 > Building_hatcheries){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Hatchery);
			}
			// More bases
			else if ( HATCHERY.getN() == 1 && (HATCHERY.getfull() || Broodwar->self()->minerals() >= 500) && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0){
				static bool first_multi = true;
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (first_multi && builder){
					if (BUILD.ok(builder)){
						first_multi = false;
						BUILD.push(builder, UnitTypes::Zerg_Hatchery, Multi);
					}
				}
				else if (builder){
					TilePosition Nextbase;
					bool next = false;
					double ddd = 100000;
					for (auto &nn : getBaseLocations()){
						if (!Broodwar->canBuildHere(nn->getTilePosition(), UnitTypes::Zerg_Hatchery, builder)) continue;
						double dd;
						if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
							if (!HATCHERY.getS(u, Hatch)){
								next = false;
								break;
							}
							dd = u->getDistance(nn->getPosition());
						}
						else dd = BWTA::getGroundDistance(u->getTilePosition(), nn->getTilePosition());
						if (dd < ddd){
							ddd = dd;
							Nextbase = nn->getTilePosition();
							next = true;
						}
					}
					if (next && BUILD.ok(builder)){
						BUILD.push(builder, UnitTypes::Zerg_Hatchery, Nextbase);
					}
				}
			}
			// More bases (Random)
			else if ((HATCHERY.getfull() || Broodwar->self()->minerals() >= 500) && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);

				TilePosition Nextbase;
				bool next = false;
				int check = 100000;
				int I;
				double ddd = 100000;

				for (int i = 0; i < DESIGNER.nBase && builder; i++){
					if (!Broodwar->canBuildHere(DESIGNER.Bases[i], UnitTypes::Zerg_Hatchery, builder)) continue;

					double dd;
					if (Broodwar->mapFileName().find("Plasma") != string::npos){
						if (!HATCHERY.getS(u, Hatch)){
							next = false;
							break;
						}
						dd = u->getDistance((Position)DESIGNER.Bases[i]);
						if (dd < ddd){
							ddd = dd;
							Nextbase = DESIGNER.Bases[i];
							next = true;
						}
					}
					else{
						if (builder->hasPath((Position)DESIGNER.Bases[i])){
							if (check > DESIGNER.Try[i]){
								I = i;
								next = true;
								check = DESIGNER.Try[i];
								Nextbase = DESIGNER.Bases[i];
							}
						}
					}
				}

				if (next && builder && BUILD.ok(builder)){
					if (Broodwar->mapFileName().find("Plasma") == string::npos) DESIGNER.Try[I]++;
					BUILD.push(builder, UnitTypes::Zerg_Hatchery, Nextbase);
				}
			}
			// Geyers
			if (Building_pool > 0 && HATCHERY.getS(u, m) > 8 && Building_hatcheries >= 2) {
				Unit gasbuilder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingMinerals);
				if (gasbuilder){
					if (gasbuilder->getDistance(u) > 300 || gasbuilder == Chitang) gasbuilder = NULL;
				}
				Unit gas = NULL;
				BOOST_FOREACH(Unit uu, Broodwar->getGeysers()){
					if (u->getDistance(uu) <= 300 && IsNeutral(uu)){
						gas = uu;
						break;
					}
				}
				if (gasbuilder && gas != NULL && BUILD.ok(gas->getTilePosition(), UnitTypes::Zerg_Extractor)){
					BUILD.push(gasbuilder, UnitTypes::Zerg_Extractor, gas->getTilePosition());
				}
			}
			// Sunken
			if (u->getTilePosition() != Broodwar->self()->getStartLocation() && HATCHERY.getS(u, Hatch) == true && 
				HATCHERY.getS(u, Sunken) < 2 + (u->getTilePosition()==Multi && Building_hatcheries >= 3) *2
				&& BUILD.getask(UnitTypes::Zerg_Creep_Colony) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder) && builder != Chitang){
					if (builder->getDistance(u) <= 300) BUILD.push(builder, UnitTypes::Zerg_Creep_Colony);
				}
			}

			// Hive & Lair
			if (u->canMorph(UnitTypes::Zerg_Lair) && Building_lair == 0) u->morph(UnitTypes::Zerg_Lair);
			if (u->canMorph(UnitTypes::Zerg_Hive) && Building_hive == 0) u->morph(UnitTypes::Zerg_Hive);
			if (u->canUpgrade(UpgradeTypes::Pneumatized_Carapace) && (fast_over||Building_hatcheries >= 7)) u->upgrade(UpgradeTypes::Pneumatized_Carapace);
			if (u->canResearch(TechTypes::Burrowing) && Building_hatcheries >= 7) u->research(TechTypes::Burrowing);

			// Spire
			if (false &&
				Building_lair2 && Building_spire + BUILD.getask(UnitTypes::Zerg_Spire) == 0 && Broodwar->self()->minerals() > 100 && Broodwar->self()->gas() > 100){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spire);
			}

			// Queens nest
			if (Building_lair2 && Building_queen + BUILD.getask(UnitTypes::Zerg_Queens_Nest) == 0 && Building_hatcheries > 6){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Queens_Nest);
			}

			// Hydraden
			if (Building_pool2 && Building_lair && Building_den + BUILD.getask(UnitTypes::Zerg_Hydralisk_Den) == 0 && Broodwar->self()->gas() >= 50){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Hydralisk_Den);
			}

			// Chamber
			if (Building_hatcheries >= 4 && Building_chamber + BUILD.getask(UnitTypes::Zerg_Evolution_Chamber) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Evolution_Chamber);
			}

			//Producing lines
			if (BUILD.getN() > 0 && (Building_hatcheries < 3 || BUILD.getask(UnitTypes::Zerg_Hatchery)) && Broodwar->self()->minerals() < 500) continue;
			if (Building_lair2 && Building_den2 && !Broodwar->self()->hasResearched(TechTypes::Lurker_Aspect) && must_aspect) continue;
			BOOST_FOREACH(Unit Larva, u->getLarva()){

				// Overlord spawn
				if (Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 - Broodwar->self()->supplyUsed() < Building_hatcheries * 4 * (1 + (Building_spire || Building_den))
					&& Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 < 400
					&& Larva->canTrain(UnitTypes::Zerg_Overlord)){
					Larva->train(UnitTypes::Zerg_Overlord);
					OVERLORD.push(Larva);
					continue;
				}

				// Drone spawn
				if (Larva->canTrain(UnitTypes::Zerg_Drone) && Unit_drones <= 80 && !dew){
					if (DESIGNER.ask(u->getTilePosition())){
						if (!HATCHERY.getS(u, Satis)){
							Larva->train(UnitTypes::Zerg_Drone);
							Unit_drones++;
							continue;
						}
					}
					else if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis)){
						Larva->train(UnitTypes::Zerg_Drone);
						Unit_drones++;
						continue;
					}
				}
				if (Larva->canTrain(UnitTypes::Zerg_Hydralisk)){
					if (Unit_hydras == 0){
						Larva->train(UnitTypes::Zerg_Hydralisk);
						continue;
					}
				}
				if (Larva->canTrain(UnitTypes::Zerg_Zergling)){
					Larva->train(UnitTypes::Zerg_Zergling);
					continue;
				}
			}
			continue;
		}

	} // closure: unit iterator

	if (!defense && dew){
		dew = false;
	}
	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		if (squad[i].getT() == UnitTypes::Zerg_Hydralisk){
			if (dew) squad[i].Dew();
			else squad[i].Defensive();
		}
		else if (squad[i].getT() == UnitTypes::Zerg_Zergling){
			if (Search || ((Zia1 == Strat::Dahye||Zia == Strat::Dahee)&& !Broodwar->self()->hasResearched(TechTypes::Lurker_Aspect) && (i>0 || squad[i].getN() >=6))){
				squad[i].Action();
			}
			else if (dew){
				squad[i].Dew();
			}
			else if (getM(UnitTypes::Zerg_Zergling) >= (HATCHERY.getN() + 1 >= 4? 4 : 3) ){
				squad[i].Action();
			}
			else{
				squad[i].Defensive();
			}
		}
		else if (squad[i].getT() == UnitTypes::Zerg_Mutalisk){
			if (dew) squad[i].Dew();
			else squad[i].Action();
		}
	}
}
void SquadManager::Jung_a(){ // Now Sealed
	/// Build line ///

	// 9 - pool //
	if (Broodwar->self()->minerals() > 190 && (Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool)) == 0){
		Unit builder = HATCHERY.getDDD();
		if (builder && BUILD.ok(builder))
			BUILD.push(builder, UnitTypes::Zerg_Spawning_Pool);
	}
	// Multies //
	static bool first_multi = true;
	if ((Building_hatcheries + BUILD.getask(UnitTypes::Zerg_Hatchery)) == 1 && Broodwar->self()->minerals() >= 400){
		if (first_multi){
			Unit builder = HATCHERY.getDDD();
			if (BUILD.ok(builder)){
				BUILD.push(builder, UnitTypes::Zerg_Hatchery, Multi);
				first_multi = false;
			}
		}
		else{ // Random
			Unit builder = HATCHERY.getDDD();

			TilePosition Nextbase;
			bool next = false;
			int I = -1;
			int check = 100000;

			for (int i = 0; i < DESIGNER.nBase; i++){
				if (!Broodwar->canBuildHere(DESIGNER.Bases[i], UnitTypes::Zerg_Hatchery, builder)) continue;

				if (builder->hasPath((Position)DESIGNER.Bases[i])){
					if (check > DESIGNER.Try[i]){
						next = true;
						check = DESIGNER.Try[i];
						Nextbase = DESIGNER.Bases[i];
						I = i;
					}
				}
			}

			if (next && BUILD.ok(builder)){
				BUILD.push(builder, UnitTypes::Zerg_Hatchery, Nextbase);
				DESIGNER.Try[I]++;
			}
		}
	}

	static bool metabolic = false;
	static int dahye = 0;
	static bool Neo = false;
	defense = false;

	BOOST_FOREACH(Unit u, Broodwar->self()->getUnits()){
		if (!u->exists()) continue;
		if (u->isLockedDown() || u->isMaelstrommed() || u->isStasised()) continue;
		if (u->isLoaded() || !u->isPowered() || u->isStuck()) continue;
		if (!u->isCompleted() && !u->getType().isResourceDepot()) continue;

		//Unit_lines:
		// Drones
		if (u->getType().isWorker()){
			if (u == Chicken || u == Chitang || u == Special_chicken || u == Neo_chicken) continue;
			if (u->isIdle() && BUILD.ok(u)){
				Unit Cargo;
				if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis))
					Cargo = HATCHERY.getHFD(u);
				else
					Cargo = HATCHERY.getHFM(u);
				if (Cargo){
					u->gather(Cargo->getClosestUnit(IsMineralField));
				}
			}
			if (u->isUnderAttack() && u->getDistance(HATCHERY.getHHH(u)) < 400){
				Unit Friend = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringGas || IsGatheringMinerals));
				if (!BUILD.ok(Friend) || u->getDistance(Friend) >= 200) Friend = NULL;
				Unit target = u->getClosestUnit(IsEnemy);
				if (target){
					if (u->canAttackUnit(target) && u->getHitPoints() >= 20) u->attack(target);
				}
				if (Friend && target){
					if (Friend->canAttackUnit(target))Friend->attack(target);
				}
			}
			if (!BUILD.ok(u)) continue;
			Unit Cargo = HATCHERY.getHFD(u);
			if (Cargo){
				if (u->getDistance(Cargo) > 400 && !u->isCarryingMinerals() && !HATCHERY.getS(Cargo, Satis))
					u->gather(Cargo->getClosestUnit(IsMineralField));
			}
			continue;
		}
		// Overlords
		if (u->getType() == UnitTypes::Zerg_Overlord){
			Unit pr = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Hydralisk || GetType == UnitTypes::Zerg_Mutalisk));
			bool evade = true;
			Unit Home = HATCHERY.getHHH(u);
			if (u->isBlind()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
				continue;
			}
			if (u->isIdle()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
			}
			if (pr){
				if (u->getDistance(pr) <= 290) evade = false;
			}
			if (evade){
				// evade
				BOOST_FOREACH(Unit ee, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(ee) && ee->getType().airWeapon().damageAmount() > 0){
						Position ppp;
						ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
						ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
						ppp.makeValid();
						u->move(ppp);
						break;
					}
				}
			}
			continue;
		}
		// Extractor
		if (u->getType() == UnitTypes::Zerg_Extractor){
			Unit Cargo = HATCHERY.getHFD(u);
			if (!Cargo) continue;
			if (u->getDistance(Cargo) > 300) continue;
			int g = 0;
			BOOST_FOREACH(Unit dr, u->getUnitsInRadius(u->getDistance(Cargo))){
				if (dr->isGatheringGas() && IsOwned(dr)) g++;
			}
			if (g > 3 || metabolic){
				Unit come = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					IsGatheringGas && !IsCarryingSomething);
				if (come && u->getDistance(come) <= 300)
					come->stop();
			}
			else if (g < 2 && HATCHERY.getS(HATCHERY.getHFD(u), m) > 6 && !metabolic){
				Unit ggg = HATCHERY.getHFD(u)->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (ggg && HATCHERY.getHFD(u)->getDistance(ggg) <= 300 && ggg != Chitang) ggg->gather(u);
			}
		}
		// Pool
		if (u->getType() == UnitTypes::Zerg_Spawning_Pool){
			if (u->canUpgrade(UpgradeTypes::Metabolic_Boost)){
				u->upgrade(UpgradeTypes::Metabolic_Boost);
				metabolic = true;
			}
			if (u->canUpgrade(UpgradeTypes::Adrenal_Glands)) u->upgrade(UpgradeTypes::Adrenal_Glands);
		}
		// Hatcheries
		if (u->getType().producesLarva()){
			//Defence System
			if (ob){
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 390, Colors::Red);
				}, nullptr, 2);
			}
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(390)){
				if (!IsEnemy(ee) || ee->getType() == UnitTypes::Zerg_Overlord || ee->getType() == UnitTypes::Protoss_Observer) continue;
				dew = true;
				ave2 = ee->getPosition();
				defense = true;
				break;
			}

			if (u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted()) continue;
			// Geyers
			if (Building_pool > 0 && HATCHERY.getS(u, m) > 6) {
				Unit gasbuilder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingMinerals);
				if (gasbuilder){
					if (gasbuilder->getDistance(u) > 300 || gasbuilder == Chitang) gasbuilder = NULL;
				}
				Unit gas = NULL;
				BOOST_FOREACH(Unit uu, Broodwar->getGeysers()){
					if (u->getDistance(uu) <= 300 && IsNeutral(uu)){
						gas = uu;
						break;
					}
				}
				if (gasbuilder && gas != NULL && BUILD.ok(gas->getTilePosition(), UnitTypes::Zerg_Extractor)){
					BUILD.push(gasbuilder, UnitTypes::Zerg_Extractor, gas->getTilePosition());
				}
			}
			//Producing lines
			BOOST_FOREACH(Unit Larva, u->getLarva()){
				if (Larva->canTrain(UnitTypes::Zerg_Zergling)){
					Larva->train(UnitTypes::Zerg_Zergling);
					continue;
				}
				if (BUILD.getN() > 0 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 && Broodwar->self()->minerals() < 450) continue;
				// Overlord spawn
				if (Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 - Broodwar->self()->supplyUsed() < Building_hatcheries * 4
					&& Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 < 400
					&& Larva->canTrain(UnitTypes::Zerg_Overlord)
					&& Building_pool > 0){
					Larva->train(UnitTypes::Zerg_Overlord);
					OVERLORD.push(Larva);
					continue;
				}
				// Drone spawn
				if (Larva->canTrain(UnitTypes::Zerg_Drone) && ((Unit_drones < 9 - Building_pool || (Building_pool&&dahye == 0)) && !Building_pool2)){
					if (DESIGNER.ask(u->getTilePosition())){
						if (!HATCHERY.getS(u, Satis)){
							if (Building_pool) dahye++;
							Larva->train(UnitTypes::Zerg_Drone);
							Unit_drones++;
							continue;
						}
					}
					else if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis)){
						if (Building_pool) dahye++;
						Larva->train(UnitTypes::Zerg_Drone);
						Unit_drones++;
						continue;
					}
				}
			}
			continue;
		}
		if (!defense && dew){
			dew = false;
		}
	}
	if (!defense && dew){
		dew = false;
	}

	if (!metabolic && (Broodwar->self()->gas() >= 100 || Broodwar->self()->getUpgradeLevel(UpgradeTypes::Metabolic_Boost))) metabolic = true;
	if (false);

	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		if ((i == 0 && squad[i].getN() >= 6) || i>0)
			squad[i].Action();
		else{
			if (dew)
				squad[i].Dew();
			else
				squad[i].Defensive();
		}
	}
}
void SquadManager::Seohyun(){ // Hydra & Queen
	defense = false;
	static bool juae = false;
	if (juae){
		if (getN() <= 1) juae = false;
	}
	else if (getM(UnitTypes::Zerg_Hydralisk) >= 4){
		juae = true;
	}

	/// Build ///

	// Queens nest
	if (Building_lair2 && Building_queen + BUILD.getask(UnitTypes::Zerg_Queens_Nest) == 0){
		Unit builder = HATCHERY.getDDD();
		if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Queens_Nest);
	}

	BOOST_FOREACH(Unit u, Broodwar->self()->getUnits())
	{
		if (!u->exists()) continue;
		if (u->isLockedDown() || u->isMaelstrommed() || u->isStasised()) continue;
		if (u->isLoaded() || !u->isPowered() || u->isStuck()) continue;
		if (!u->isCompleted() && !u->getType().isResourceDepot()) continue;

		//Unit_lines:
		// Drones
		if (u->getType().isWorker()){
			if (u == Chicken || u == Chitang) continue;
			if (u->isIdle() && BUILD.ok(u)){
				Unit Cargo;
				if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis))
					Cargo = HATCHERY.getHFD(u);
				else
					Cargo = HATCHERY.getHFM(u);
				if (Cargo){
					u->gather(Cargo->getClosestUnit(IsMineralField));
				}
			}
			if (u->isUnderAttack() && u->getDistance(HATCHERY.getHHH(u)) < 400){
				Unit Friend = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringGas || IsGatheringMinerals));
				if (!BUILD.ok(Friend) || u->getDistance(Friend) >= 200) Friend = NULL;
				Unit target = u->getClosestUnit(IsEnemy);
				if (target){
					if (u->canAttackUnit(target) && u->getHitPoints() >= 20) u->attack(target);
				}
				if (Friend && target){
					if (Friend->canAttackUnit(target))Friend->attack(target);
				}
			}
			if (!BUILD.ok(u)) continue;
			Unit Cargo = HATCHERY.getHFD(u);
			if (Cargo){
				if (u->getDistance(Cargo) > 400 && !u->isCarryingMinerals() && !HATCHERY.getS(Cargo, Satis))
					u->gather(Cargo->getClosestUnit(IsMineralField));
			}
			continue;
		}
		// Overlords
		if (u->getType() == UnitTypes::Zerg_Overlord){
			Unit pr = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Hydralisk || GetType == UnitTypes::Zerg_Mutalisk));
			Unit Home = HATCHERY.getHHH(u);
			bool evade = true;
			if (u->isBlind()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
				continue;
			}
			if (u->isIdle()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
			}
			if (pr){
				if (u->getDistance(pr) <= 290) evade = false;
			}
			if (evade){
				// evade
				BOOST_FOREACH(Unit ee, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(ee) && ee->getType().airWeapon().damageAmount() > 0){
						Position ppp;
						ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
						ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
						ppp.makeValid();
						u->move(ppp);
						break;
					}
				}
			}
			continue;
		}

		////Buildings ////
		// Extractor
		if (u->getType() == UnitTypes::Zerg_Extractor){
			Unit Cargo = HATCHERY.getHFD(u);
			if (!Cargo) continue;
			if (u->getDistance(Cargo) > 300) continue;
			int g = 0;
			BOOST_FOREACH(Unit dr, u->getUnitsInRadius(u->getDistance(Cargo))){
				if (dr->isGatheringGas() && IsOwned(dr)) g++;
			}
			if (g > (Building_hatcheries >= 3 ? 3 : 2)){
				Unit come = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					IsGatheringGas && !IsCarryingSomething);
				if (come && u->getDistance(come) <= 300)
					come->stop();
			}
			else if (g < (Building_hatcheries >= 3 ? 2 : 1) && HATCHERY.getS(HATCHERY.getHFD(u), m) > 6){
				Unit ggg = HATCHERY.getHFD(u)->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (ggg && HATCHERY.getHFD(u)->getDistance(ggg) <= 300 && ggg != Chitang) ggg->gather(u);
			}
		}
		// Hydra den
		if (u->getType() == UnitTypes::Zerg_Hydralisk_Den){
			if (u->canUpgrade(UpgradeTypes::Muscular_Augments)) u->upgrade(UpgradeTypes::Muscular_Augments);
			if (u->canUpgrade(UpgradeTypes::Grooved_Spines)) u->upgrade(UpgradeTypes::Grooved_Spines);
		}

		// Chamber
		if (u->getType() == UnitTypes::Zerg_Evolution_Chamber){
			if (u->canUpgrade(UpgradeTypes::Zerg_Carapace)) u->upgrade(UpgradeTypes::Zerg_Carapace);
			if (u->canUpgrade(UpgradeTypes::Zerg_Missile_Attacks) && Building_den) u->upgrade(UpgradeTypes::Zerg_Missile_Attacks);
		}

		// Creep Colony
		if (u->getType() == UnitTypes::Zerg_Creep_Colony){
			if (u->canMorph(UnitTypes::Zerg_Sunken_Colony)) u->morph(UnitTypes::Zerg_Sunken_Colony);
		}

		// Queens Nest
		if (u->getType() == UnitTypes::Zerg_Queens_Nest){
			if (u->canResearch(TechTypes::Spawn_Broodlings)) u->research(TechTypes::Spawn_Broodlings);
		}

		// Hatcheries
		if (u->getType().producesLarva()){
			//drawn replace
			//Defence System
			if (ob){
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 390, Colors::Red);
				}, nullptr, 2);
			}
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(390)){
				if (!IsEnemy(ee) || ee->getType() == UnitTypes::Zerg_Overlord || ee->getType() == UnitTypes::Protoss_Observer) continue;
				//if (!dew) ave2 = ave;
				dew = true;
				ave2 = ee->getPosition();
				defense = true;
				break;
			}

			if (u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted()) continue;
			if (!HATCHERY.getfull() && HATCHERY.getS(u, m) > HATCHERY.getS(u, M) * 2 && Broodwar->getFrameCount() % 100 == 0){
				Unit Bye = u->getClosestUnit(IsOwned && IsWorker && IsGatheringMinerals && !IsCarryingSomething);
				if (Bye) Bye->stop();
			}
			/////////////////Build lines/////////////////////
			// pool
			if ((Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool)) == 0 && // base
				Building_hatcheries >= 2) {
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (!Zia){
					Chicken = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
					if (Chicken){
						if (BUILD.ok(Chicken) && Chicken != Chitang){
							Zia = true;
							Yerin = true;
						}
					}
				}
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spawning_Pool);
			}
			//More Hatcheries
			if (Building_hatcheries <= 6 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 &&
				HATCHERY.getN() * 2 - 1 > Building_hatcheries && Broodwar->self()->minerals() >= 500
				){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Hatchery);
			}

			// More bases
			//Multi
			else if ((HATCHERY.getfull() || (Broodwar->self()->minerals() >= 500 && (Building_hatcheries >= 3 ? true : Unit_drones >= Building_hatcheries * 7))) &&
				HATCHERY.getN() == 1 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0){
				static bool first_multi = true;

				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (first_multi){
					if (BUILD.ok(builder) && builder){
						BUILD.push(builder, UnitTypes::Zerg_Hatchery, Multi);
						first_multi = false;
					}
				}
				else{
					TilePosition Nextbase;
					bool next = false;
					double ddd = 100000;

					for (int i = 0; i < DESIGNER.nBase && builder; i++){
						if (!Broodwar->canBuildHere(DESIGNER.Bases[i], UnitTypes::Zerg_Hatchery, builder)) continue;

						double dd;
						if (Broodwar->mapFileName().find("Plasma") != string::npos){
							if (!HATCHERY.getS(u, Hatch)){
								next = false;
								break;
							}
							dd = u->getDistance((Position)DESIGNER.Bases[i]);
						}
						else dd = BWTA::getGroundDistance(u->getTilePosition(), DESIGNER.Bases[i]);
						if (dd < ddd){
							ddd = dd;
							Nextbase = DESIGNER.Bases[i];
							next = true;
						}
					}
					if (next && builder && BUILD.ok(builder)){
						BUILD.push(builder, UnitTypes::Zerg_Hatchery, Nextbase);
					}
				}
			}
			// More bases (Random)
			else if ((HATCHERY.getfull() || (Broodwar->self()->minerals() >= 500 && (Building_hatcheries >= 3 ? true : Unit_drones >= Building_hatcheries * 7))) &&
				BUILD.getask(UnitTypes::Zerg_Hatchery) == 0){

				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);

				TilePosition Nextbase;
				bool next = false;
				int check = 100000;
				int I;

				double ddd = 100000;

				for (int i = 0; i < DESIGNER.nBase && builder; i++){
					if (!Broodwar->canBuildHere(DESIGNER.Bases[i], UnitTypes::Zerg_Hatchery, builder)) continue;

					double dd;
					if (Broodwar->mapFileName().find("Plasma") != string::npos){
						if (!HATCHERY.getS(u, Hatch)){
							next = false;
							break;
						}
						dd = u->getDistance((Position)DESIGNER.Bases[i]);
						if (dd < ddd){
							ddd = dd;
							Nextbase = DESIGNER.Bases[i];
							next = true;
						}
					}
					else{
						if (builder->hasPath((Position)DESIGNER.Bases[i])){
							if (check > DESIGNER.Try[i]){
								next = true;
								check = DESIGNER.Try[i];
								Nextbase = DESIGNER.Bases[i];
								I = i;
							}
						}
					}
				}

				if (next && builder && BUILD.ok(builder)){
					if (Broodwar->mapFileName().find("Plasma") == string::npos) DESIGNER.Try[I]++;
					BUILD.push(builder, UnitTypes::Zerg_Hatchery, Nextbase);
				}
			}

			// Geyers
			//if (Building_pool > 0 && (HATCHERY.getS(u, m) > 8 || (Broodwar->enemy()->getRace() == Races::Zerg && u->getTilePosition() == Broodwar->self()->getStartLocation()))){
			if (HATCHERY.getS(u, m) > 6) {
				Unit gasbuilder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingMinerals);
				if (gasbuilder){
					if (gasbuilder->getDistance(u) > 300 || gasbuilder == Chitang) gasbuilder = NULL;
				}
				Unit gas = NULL;
				BOOST_FOREACH(Unit uu, Broodwar->getGeysers()){
					if (u->getDistance(uu) <= 300 && IsNeutral(uu)){
						gas = uu;
						break;
					}
				}
				if (gasbuilder && gas != NULL && BUILD.ok(gas->getTilePosition(), UnitTypes::Zerg_Extractor)){
					BUILD.push(gasbuilder, UnitTypes::Zerg_Extractor, gas->getTilePosition());
				}
			}
			// Sunken
			if (u->getTilePosition() != Broodwar->self()->getStartLocation() && HATCHERY.getS(u, Hatch) == true && HATCHERY.getS(u, Sunken) < 2 && BUILD.getask(UnitTypes::Zerg_Creep_Colony) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder) && builder != Chitang){
					if (builder->getDistance(u) <= 300) BUILD.push(builder, UnitTypes::Zerg_Creep_Colony);
				}
			}

			// Hive & Lair
			if (u->canMorph(UnitTypes::Zerg_Lair) && Building_lair == 0) u->morph(UnitTypes::Zerg_Lair);
			if (u->canMorph(UnitTypes::Zerg_Hive) && Building_hive == 0) u->morph(UnitTypes::Zerg_Hive);
			if (u->canUpgrade(UpgradeTypes::Pneumatized_Carapace)) u->upgrade(UpgradeTypes::Pneumatized_Carapace);
			if (u->canResearch(TechTypes::Burrowing) && Building_lair2) u->research(TechTypes::Burrowing);

			// Hydraden
			if (Building_pool2 && Building_den + BUILD.getask(UnitTypes::Zerg_Hydralisk_Den) == 0 && Broodwar->self()->gas() >= 50){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Hydralisk_Den);
			}

			// Chamber
			if (Building_hatcheries >= 5 && Building_chamber + BUILD.getask(UnitTypes::Zerg_Evolution_Chamber) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Evolution_Chamber);
			}

			//Producing lines
			if (BUILD.getN() > 0 && (Building_hatcheries <= 3 || BUILD.getask(UnitTypes::Zerg_Hatchery)) && Broodwar->self()->minerals() < 500) continue;
			BOOST_FOREACH(Unit Larva, u->getLarva()){

				// Overlord spawn
				if (Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 - Broodwar->self()->supplyUsed() < Building_hatcheries * 8
					&& Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 < 400
					&& Larva->canTrain(UnitTypes::Zerg_Overlord)){
					Larva->train(UnitTypes::Zerg_Overlord);
					OVERLORD.push(Larva);
					continue;
				}

				// Drone spawn
				if (Larva->canTrain(UnitTypes::Zerg_Drone) && Unit_drones <= 80 && !dew){
					if (DESIGNER.ask(u->getTilePosition())){
						if (!HATCHERY.getS(u, Satis)){
							Larva->train(UnitTypes::Zerg_Drone);
							Unit_drones++;
							continue;
						}
					}
					else if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis)){
						Larva->train(UnitTypes::Zerg_Drone);
						Unit_drones++;
						continue;
					}
				}
				if (Larva->canTrain(UnitTypes::Zerg_Queen) && Unit_queens < 18){
					Larva->train(UnitTypes::Zerg_Queen);
					continue;
				}
				if (Larva->canTrain(UnitTypes::Zerg_Hydralisk)){
					Larva->train(UnitTypes::Zerg_Hydralisk);
					continue;
				}
				if (Larva->canTrain(UnitTypes::Zerg_Zergling) && dew){
					Larva->train(UnitTypes::Zerg_Zergling);
					continue;
				}
			}
			continue;
		}

	} // closure: unit iterator
	if (!defense && dew){
		dew = false;
	}
	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		if (squad[i].getT() == UnitTypes::Zerg_Mutalisk){
			squad[i].Action();
		}
		else if (squad[i].getT() == UnitTypes::Zerg_Zergling){
			if (dew){
				squad[i].Dew();
			}
			else if (juae){
				squad[i].Action();
			}
			else{
				squad[i].Defensive();
			}
		}
		else if (squad[i].getT() == UnitTypes::Zerg_Hydralisk){
			if (Broodwar->self()->hasResearched(TechTypes::Burrowing)) squad[i].Protect();
			if (dew){
				squad[i].Dew();
			}
			else if (juae){
				squad[i].Action();
			}
			else{
				squad[i].Defensive();
			}
		}
	}
}
void SquadManager::Soyoung(){ // Lurker with scourges
	static bool must_aspect = true;
	bool mutal_dew = false;
	defense = false;
	// Unit Iterate
	BOOST_FOREACH(Unit u, Broodwar->self()->getUnits())
	{
		if (!u->exists()) continue;
		if (u->isLockedDown() || u->isMaelstrommed() || u->isStasised()) continue;
		if (u->isLoaded() || !u->isPowered() || u->isStuck()) continue;
		if (!u->isCompleted() && !u->getType().isResourceDepot()) continue;

		//Unit_lines:
		// Drones
		if (u->getType().isWorker()){
			if (u == Chicken || u == Chitang) continue;
			if (u->isIdle() && BUILD.ok(u)){
				Unit Cargo;
				if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis))
					Cargo = HATCHERY.getHFD(u);
				else
					Cargo = HATCHERY.getHFM(u);
				if (Cargo){
					u->gather(Cargo->getClosestUnit(IsMineralField));
				}
			}
			if (u->isUnderAttack() && u->getDistance(HATCHERY.getHHH(u)) < 400){
				Unit Friend = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringGas || IsGatheringMinerals));
				if (!BUILD.ok(Friend) || u->getDistance(Friend) >= 200) Friend = NULL;
				Unit target = u->getClosestUnit(IsEnemy);
				if (target){
					if (u->canAttackUnit(target) && u->getHitPoints() >= 20) u->attack(target);
				}
				if (Friend && target){
					if (Friend->canAttackUnit(target))Friend->attack(target);
				}
			}
			if (!BUILD.ok(u)) continue;
			Unit Cargo = HATCHERY.getHFD(u);
			if (Cargo){
				if (u->getDistance(Cargo) > 400 && !u->isCarryingMinerals() && !HATCHERY.getS(Cargo, Satis))
					u->gather(Cargo->getClosestUnit(IsMineralField));
			}
			continue;
		}
		// Overlords
		if (u->getType() == UnitTypes::Zerg_Overlord){
			Unit pr = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Hydralisk || GetType == UnitTypes::Zerg_Mutalisk));
			bool evade = true;
			Unit Home = HATCHERY.getHHH(u);
			if (u->isBlind()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
				continue;
			}
			if (u->isIdle()){
				if (!Home) continue;
				if (u->getDistance(HATCHERY.getHHH(u)) >= 200) u->move(HATCHERY.getHHH(u)->getPosition());
			}
			if (pr){
				if (u->getDistance(pr) <= 290) evade = false;
			}
			if (evade){
				// evade
				BOOST_FOREACH(Unit ee, u->getUnitsInRadius(u->getType().sightRange())){
					if (IsEnemy(ee) && ee->getType().airWeapon().damageAmount() > 0){
						Position ppp;
						ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
						ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
						ppp.makeValid();
						u->move(ppp);
						break;
					}
				}
			}
			continue;
		}

		if (u->getType() == UnitTypes::Zerg_Lurker && dew){
			if (u->canUnburrow() && Broodwar->getFrameCount() % 300 != 0) continue;
			bool EE = false;
			// find enemy
			BOOST_FOREACH(Unit target, u->getUnitsInRadius(190)){
				if (!IsEnemy(target) || !IsVisible(target) || IsFlying(target)) continue;
				EE = true;
				if (u->canBurrow()){
					u->burrow();
					break;
				}
			}
			if (!EE && u->canUnburrow()) u->unburrow();
			u->move(ave2);
			if (ob) Broodwar->drawLineMap(u->getPosition(), ave2, Colors::Red);
			continue;
		}

		if (u->getType() == UnitTypes::Zerg_Queen){
			if (u->isIrradiated()){

			}
			if (u->getEnergy() >= 150){

			}
		}

		///Buildings ///
		// Extractor
		if (u->getType() == UnitTypes::Zerg_Extractor){
			Unit Cargo = HATCHERY.getHFD(u);
			if (!Cargo) continue;
			if (u->getDistance(Cargo) > 300) continue;
			int g = 0;
			BOOST_FOREACH(Unit dr, u->getUnitsInRadius(u->getDistance(Cargo))){
				if (dr->isGatheringGas() && IsOwned(dr)) g++;
			}
			if (g > 3){
				Unit come = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					IsGatheringGas && !IsCarryingSomething);
				if (come && u->getDistance(come) <= 300)
					come->stop();
			}
			else if (g < 2 && HATCHERY.getS(HATCHERY.getHFD(u), m) > 6){
				Unit ggg = HATCHERY.getHFD(u)->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (ggg && HATCHERY.getHFD(u)->getDistance(ggg) <= 300 && ggg != Chitang) ggg->gather(u);
			}
		}
		// Pool
		if (u->getType() == UnitTypes::Zerg_Spawning_Pool && Building_lair){
			if (!Broodwar->self()->hasResearched(TechTypes::Lurker_Aspect)) continue;
			if (u->canUpgrade(UpgradeTypes::Metabolic_Boost)) u->upgrade(UpgradeTypes::Metabolic_Boost);
			if (u->canUpgrade(UpgradeTypes::Adrenal_Glands)) u->upgrade(UpgradeTypes::Adrenal_Glands);
		}
		// Hydra den
		if (u->getType() == UnitTypes::Zerg_Hydralisk_Den){
			if (u->canResearch(TechTypes::Lurker_Aspect)){
				u->research(TechTypes::Lurker_Aspect);
				must_aspect = false;
			}
		}

		// Chamber
		if (u->getType() == UnitTypes::Zerg_Evolution_Chamber){
			if (u->canUpgrade(UpgradeTypes::Zerg_Carapace)) u->upgrade(UpgradeTypes::Zerg_Carapace);
			if (u->canUpgrade(UpgradeTypes::Zerg_Missile_Attacks) && Building_den) u->upgrade(UpgradeTypes::Zerg_Missile_Attacks);
			if (u->canUpgrade(UpgradeTypes::Zerg_Melee_Attacks)) u->upgrade(UpgradeTypes::Zerg_Melee_Attacks);
		}

		// Creep Colony
		if (u->getType() == UnitTypes::Zerg_Creep_Colony){
			if (u->canMorph(UnitTypes::Zerg_Sunken_Colony)) u->morph(UnitTypes::Zerg_Sunken_Colony);
		}

		// Queens Nest
		if (u->getType() == UnitTypes::Zerg_Queens_Nest){
			if (u->canResearch(TechTypes::Spawn_Broodlings)) u->research(TechTypes::Spawn_Broodlings);
		}

		// Hatcheries
		if (u->getType().producesLarva()){
			//drawn replace
			//Defence System
			//bool Sky_defense = false;
			if (ob){
				Broodwar->registerEvent([u](Game*)
				{
					Broodwar->drawCircleMap(u->getPosition(), 390, Colors::Red);
				}, nullptr, 2);
			}
			BOOST_FOREACH(Unit ee, u->getUnitsInRadius(390)){
				if (!IsEnemy(ee) || ee->getType() == UnitTypes::Zerg_Overlord || ee->getType() == UnitTypes::Protoss_Observer) continue;
				//if (!dew) ave2 = ave;
				dew = true;
				ave2 = ee->getPosition();
				defense = true;
				break;
			}

			if (u->getType() == UnitTypes::Zerg_Hatchery && !u->isCompleted()) continue;
			if (!HATCHERY.getfull() && HATCHERY.getS(u, m) > HATCHERY.getS(u, M) * 2 && Broodwar->getFrameCount() % 100 == 0){
				Unit Bye = u->getClosestUnit(IsOwned && IsWorker && IsGatheringMinerals && !IsCarryingSomething);
				if (Bye) Bye->stop();
			}
			/////////////////////////Building lines/////////////////////////
			if ((Building_pool + BUILD.getask(UnitTypes::Zerg_Spawning_Pool)) == 0 && Broodwar->self()->minerals() >= 190) {
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spawning_Pool);
			}
			//More Hatcheries
			if (Building_hatcheries <= 5 && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0 && Broodwar->self()->minerals() >= 500
				//HATCHERY.getN() + HATCHERY.getS(NULL, nSatis) > Building_hatcheries &&
				//(HATCHERY.getS(NULL, nSatis) >= 2 || Broodwar->self()->minerals() > 400)
				){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Hatchery);
			}
			// More bases (Random)
			else if ((HATCHERY.getfull() || Broodwar->self()->minerals() >= 500) && BUILD.getask(UnitTypes::Zerg_Hatchery) == 0){
				 
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);

				TilePosition Nextbase;
				bool next = false;
				int check = 100000;
				int I;
				double ddd = 100000;

				for (int i = 0; i < DESIGNER.nBase && builder; i++){
					if (!Broodwar->canBuildHere(DESIGNER.Bases[i], UnitTypes::Zerg_Hatchery, builder)) continue;

					double dd;
					if (Broodwar->mapFileName().find("Plasma") != string::npos){
						if (!HATCHERY.getS(u, Hatch)){
							next = false;
							break;
						}
						dd = u->getDistance((Position)DESIGNER.Bases[i]);
						if (dd < ddd){
							ddd = dd;
							Nextbase = DESIGNER.Bases[i];
							next = true;
						}
					}
					else{
						if (builder->hasPath((Position)DESIGNER.Bases[i])){
							if (check > DESIGNER.Try[i]){
								I = i;
								next = true;
								check = DESIGNER.Try[i];
								Nextbase = DESIGNER.Bases[i];
							}
						}
					}
				}

				if (next && builder && BUILD.ok(builder)){
					if (Broodwar->mapFileName().find("Plasma") == string::npos) DESIGNER.Try[I]++;
					BUILD.push(builder, UnitTypes::Zerg_Hatchery, Nextbase);
				}
			}
			// Geyers
			if (Building_pool > 0 && HATCHERY.getS(u, m) > 8 && Building_hatcheries >= 2) {
				Unit gasbuilder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingMinerals);
				if (gasbuilder){
					if (gasbuilder->getDistance(u) > 300 || gasbuilder == Chitang) gasbuilder = NULL;
				}
				Unit gas = NULL;
				BOOST_FOREACH(Unit uu, Broodwar->getGeysers()){
					if (u->getDistance(uu) <= 300 && IsNeutral(uu)){
						gas = uu;
						break;
					}
				}
				if (gasbuilder && gas != NULL && BUILD.ok(gas->getTilePosition(), UnitTypes::Zerg_Extractor)){
					BUILD.push(gasbuilder, UnitTypes::Zerg_Extractor, gas->getTilePosition());
				}
			}
			// Sunken
			if (u->getTilePosition() != Broodwar->self()->getStartLocation() && HATCHERY.getS(u, Hatch) == true &&
				HATCHERY.getS(u, Sunken) < 2 + (u->getTilePosition() == Multi && Building_hatcheries >= 3) * 2
				&& BUILD.getask(UnitTypes::Zerg_Creep_Colony) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder) && builder != Chitang){
					if (builder->getDistance(u) <= 300) BUILD.push(builder, UnitTypes::Zerg_Creep_Colony);
				}
			}

			// Hive & Lair
			if (u->canMorph(UnitTypes::Zerg_Lair) && Building_lair == 0) u->morph(UnitTypes::Zerg_Lair);
			if (u->canMorph(UnitTypes::Zerg_Hive) && Building_hive == 0) u->morph(UnitTypes::Zerg_Hive);
			if (u->canUpgrade(UpgradeTypes::Pneumatized_Carapace) && Building_hatcheries >= 7) u->upgrade(UpgradeTypes::Pneumatized_Carapace);
			if (u->canResearch(TechTypes::Burrowing) && Building_hatcheries >= 7) u->research(TechTypes::Burrowing);

			// Spire
			if (Building_lair2 && Building_spire + BUILD.getask(UnitTypes::Zerg_Spire) == 0 && Broodwar->self()->minerals() > 100 && Broodwar->self()->gas() > 100){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Spire);
			}

			// Queens nest
			if (Building_lair2 && Building_queen + BUILD.getask(UnitTypes::Zerg_Queens_Nest) == 0 && Building_hatcheries > 6){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Queens_Nest);
			}

			// Hydraden
			if (Building_pool2 && Building_lair && Building_den + BUILD.getask(UnitTypes::Zerg_Hydralisk_Den) == 0 && Broodwar->self()->gas() >= 50){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Hydralisk_Den);
			}

			// Chamber
			if (Building_hatcheries >= 4 && Building_chamber + BUILD.getask(UnitTypes::Zerg_Evolution_Chamber) == 0){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
					(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (builder && BUILD.ok(builder)) BUILD.push(builder, UnitTypes::Zerg_Evolution_Chamber);
			}

			//Producing lines
			if (BUILD.getN() - BUILD.getask(UnitTypes::Zerg_Creep_Colony) - BUILD.getask(UnitTypes::Zerg_Extractor) > 0 &&
				Broodwar->self()->minerals() < 500) continue;
			BOOST_FOREACH(Unit Larva, u->getLarva()){

				// Overlord spawn
				if (Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 - Broodwar->self()->supplyUsed() < Building_hatcheries * 4 * (1 + (Building_spire || Building_den))
					&& Broodwar->self()->supplyTotal() + OVERLORD.getN() * 16 < 400
					&& Larva->canTrain(UnitTypes::Zerg_Overlord)){
					Larva->train(UnitTypes::Zerg_Overlord);
					OVERLORD.push(Larva);
					continue;
				}

				// Drone spawn
				if (Larva->canTrain(UnitTypes::Zerg_Drone) && Unit_drones <= 80 && !dew){
					if (DESIGNER.ask(u->getTilePosition())){
						if (!HATCHERY.getS(u, Satis)){
							Larva->train(UnitTypes::Zerg_Drone);
							Unit_drones++;
							continue;
						}
					}
					else if (!HATCHERY.getS(HATCHERY.getHFD(u), Satis)){
						Larva->train(UnitTypes::Zerg_Drone);
						Unit_drones++;
						continue;
					}
				}
				if (Larva->canTrain(UnitTypes::Zerg_Hydralisk)){
					if (Unit_hydras == 0){
						Larva->train(UnitTypes::Zerg_Hydralisk);
						continue;
					}
				}
				/*
				if (Larva->canTrain(UnitTypes::Zerg_Queen)){
					if (Unit_queens < 3){
						Larva->train(UnitTypes::Zerg_Queen);
						continue;
					}
				}
				*/
				if (Larva->canTrain(UnitTypes::Zerg_Scourge)){
					if (Unit_scourges < 2){
						Larva->train(UnitTypes::Zerg_Scourge);
						continue;
					}
				}
				if (Larva->canTrain(UnitTypes::Zerg_Zergling)){
					Larva->train(UnitTypes::Zerg_Zergling);
					continue;
				}
			}
			continue;
		}

	} // closure: unit iterator

	if (!defense && dew){
		dew = false;
	}
	for (int i = 0; i < nSquad; i++){
		if (squad[i].getN() == 0){
			pop(i--);
			continue;
		}
		if (squad[i].getT() == UnitTypes::Zerg_Hydralisk){
			if (dew) squad[i].Dew();
			else squad[i].Defensive();
		}
		else if (squad[i].getT() == UnitTypes::Zerg_Zergling){
			if (Search){
				squad[i].Action();
			}
			else if (dew){
				squad[i].Dew();
			}
			else if (getM(UnitTypes::Zerg_Zergling) >= (HATCHERY.getN() + 1 >= 4 ? 4 : 3)){
				squad[i].Action();
			}
			else{
				squad[i].Defensive();
			}
		}
		else if (squad[i].getT() == UnitTypes::Zerg_Mutalisk){
			if (dew) squad[i].Dew();
			else squad[i].Action();
		}
		else { // Scourges
			squad[i].Action();
		}
	}
}
// \Player

void ZiabotModule::onStart()
{
	// Enable the UserInput flag, which allows us to control the bot and type messages.
	Broodwar->enableFlag(Flag::UserInput);
	// Set the command optimization level so that common commands can be grouped
	// and reduce the bot's APM (Actions Per Minute).
	Broodwar->setCommandOptimizationLevel(2);

	if (Broodwar->isReplay())
	{
		Broodwar << "The following players are in this replay:" << std::endl;

		Playerset players = Broodwar->getPlayers();
		for (auto p : players)
		{
			// Only print the player if they are not an observer
			if (!p->isObserver())
				Broodwar << p->getName() << ", playing as " << p->getRace() << std::endl;
		}
	}
	else // if this is not a replay
	{
		if (Broodwar->enemy()) // First make sure there is an enemy
			Broodwar << "The matchup is " << Broodwar->self()->getRace() << " vs " << Broodwar->enemy()->getRace() << std::endl;
	}

	//string nnn = Broodwar->mapFileName().append(".txt");
	//ifstream input(nnn);

	if (read()){
		Broodwar << "Data successfully loaded" << endl;
	}
	else{
		Broodwar << "Reading failed" << endl;
	}
	Enemy_name = Broodwar->enemy()->getName().c_str();
	while (Enemy_name.find((char)32) != string::npos) {
		Enemy_name[Enemy_name.find((char)32)] = (char)95;
	}
	if (Youngju()){
		Broodwar->sendText("Hi again!");
	}
	else{
		Broodwar->sendText("Nice to meet you!");
		if (Broodwar->enemy()->getRace() == Races::Zerg){
			Zia1 = Strat::Dahee;
			Zia2 = Strat::Jaeeun;
		}
	}
	
	BWTA::readMap();
	BWTA::analyze();
	BASES.clear();

	for (auto &bases : BWTA::getBaseLocations()){
		DESIGNER.push(bases->getTilePosition());
		BASES.push_back(bases->getTilePosition());
	}DESIGNER.Try = new int[DESIGNER.nBase];
	for (int i = 0; i < DESIGNER.nBase; i++) DESIGNER.Try[i] = 0;

	if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
		Zia = Dayoung;
	}
	else if (Broodwar->mapFileName() == "(2)Hitchhiker 1.1.SCX"){
		Zia = Dahyun;
	}
	else if (Zia1 != -1){
		Zia = Zia1;
		Broodwar->sendText("I may overwhelm you, %s", Broodwar->enemy()->getName().c_str());
	}
	else {
		srand(time(NULL));
		Zia = rand() % 4 + (Broodwar->enemy()->getRace() == Races::Zerg);
		Broodwar->sendText("It's gonna be harsh game, %s", Broodwar->enemy()->getName().c_str());
	}
	Zia1 = Zia;
	switch (Zia){
	case Strat::Dahyun:
		Jia = "Dahyun ";
		break;
	case Strat::Dahye:
		Jia = "Dahye ";
		break;
	case Strat::Dahee:
		Jia = "Dahee ";
		break;
	case Strat::Daeun:
		Jia = "Daeun ";
		break;
	case Strat::Dayoung:
		Jia = "Dayoung ";
		break;
	case Strat::Dajung:
		Jia = "Dajung ";
		break;
	}
}
void ZiabotModule::onFrame()
{
	// Screen
	if (ob){
		Broodwar->drawTextScreen(0, 0, "Frame: %d Latency: %d, %d", Broodwar->getFrameCount(), Broodwar->getLatency(), Broodwar->getLatencyFrames());
		Broodwar->drawTextScreen(0, 20, "APM: %d", Broodwar->getAPM());
		Broodwar->drawTextScreen(0, 40, "Enemy: %d", ENEMY.getN());
		Broodwar->drawTextScreen(0, 60, "nSquad : %d", MANAGER.getN());
		Broodwar->drawTextScreen(0, 80, "nBuild : %d", BUILD.getN());
		Broodwar->drawTextScreen(0, 100, "%d / %d + %d", Supply_used / 2, Broodwar->self()->supplyTotal() / 2, OVERLORD.getN() * 8);
		if (dew) Broodwar->drawTextScreen(50, 50, "Dew");
		if (Search) Broodwar->drawTextScreen(50, 50, "Search");

		Broodwar->drawTextScreen(200, 0, "Map name : %s", Broodwar->mapFileName());
		Broodwar->drawTextScreen(200, 20, "Enemy race : %s", Broodwar->enemy()->getRace().c_str());
		Broodwar->drawTextScreen(200, 40, "Strats : %s", Jia.c_str() );

		for (int i = 0; i < nTroops; i++){
			Broodwar->drawCircleMap(Troops[i]->getPosition(), 2, Colors::Cyan, true);
		}
		Broodwar->drawCircleMap(ave, 150, Colors::Green);
		Broodwar->drawCircleMap(ave, 3, Colors::Green, true);
		if (dew){
			Broodwar->drawCircleMap(ave2, 150, Colors::Red);
			Broodwar->drawCircleMap(ave2, 3, Colors::Red, true);
		}
		if(Multi) Broodwar->drawCircleMap((Position)Multi, 3, Colors::Purple, true);
	}

	if (Broodwar->isReplay() || Broodwar->isPaused() || !Broodwar->self())
		return;

	if (Broodwar->getFrameCount() % Broodwar->getLatencyFrames() != 0) return;

	// scout
	if (Yerin) yerin();
	if (Chang) chang();
	if (Broodwar->mapFileName() == "(2)Destination1.1.scx" ||
		Broodwar->mapFileName() == "(2)Destination.scx" ||
		Broodwar->mapFileName() == "(2)Heartbreak Ridge.scx" ||
		Broodwar->mapFileName() == "(2)Ride of Valkyries1.0.scx"){
		HATCHERY.Destination();
	}
	if (Yerim && !Yerin && !Chang && Zia != Strat::Dahyun && Zia != Strat::Dajung && Zia != Dahye){
		if (Seowhang == NULL){
			Seohwang();
		}
		else if (!Seowhang->exists()){
			Seohwang();
		}
		else{
			if (Seowhang->isIdle() || seowhang_frame + 1000 < Broodwar->getFrameCount()){
				TilePosition tt = DESIGNER.getBase();
				if (BWTA::isConnected(tt, Seowhang->getTilePosition())){
					Seowhang->move((Position)tt);
					if (ob) Broodwar->drawLineMap(Seowhang->getPosition(), (Position)tt, Colors::Yellow);
					seowhang_frame = Broodwar->getFrameCount();
				}
			}
		}
	}

	if (!Unit_Counter()) return;
	BUILD.build();
	OVERLORD.OVER();
	ENEMY.Jieun();

	switch (Zia){
	case Strat::Dahyun: // Dahyun, 5 Drone
		MANAGER.Dahyun();
		break;
	case Strat::Dahye: // Dahye, 9 Drone
		MANAGER.Dahye();
		break;
	case Strat::Dahee: // Dahee, 9 lings
		MANAGER.Dahee();
		break;
	case Strat::Daeun: // Daeun, 12 - 11
		MANAGER.Daeun();
		break;
	case Strat::Dayoung: // Dayoung, Plasma
		MANAGER.Dayoung();
		break;
	case Strat::Dajung: // Dajung, 1 Hatch Mutal
		MANAGER.Dajung();
		break;
	case Strat::Jaeeun: // Jaeeun, Mutal
		MANAGER.Jaeeun();
		break;
	case Strat::Juae: // Juae, Hydra
		MANAGER.Juae();
		break;
	case Strat::Jungeun: // Jungeun, Lurker ling
		MANAGER.Jungeun();
		break;
	case Strat::Jung_a: // Jung_a, linglings
		MANAGER.Jung_a();
		break;
	case Strat::Seohyun: // Seohyun, Hydra Lurker
		MANAGER.Seohyun();
		break;
	case Strat::Soyoung: // Soyoung, Lurker with scurges
		MANAGER.Soyoung();
		break;
	}
}
void ZiabotModule::onSendText(std::string text)
{

	if (text == "/ob"){
		ob = !ob;
		Broodwar << "Zia Cheers!" << endl;
	}
	//Broodwar->sendText("%s", text.c_str());
}
void ZiabotModule::onReceiveText(BWAPI::Player player, std::string text)
{
	// Parse the received text
	//Broodwar << player->getName() << " said \"" << text << "\"" << std::endl;
	if (text.find("good") != string::npos || text.find("good") != string::npos){
		Broodwar->sendText("gg");
	}
}
void ZiabotModule::onPlayerLeft(BWAPI::Player player)
{
	// Interact verbally with the other players in the game by
	// announcing that the other player has left.
	Broodwar->sendText("Goodbye %s!", player->getName().c_str());
}
void ZiabotModule::onNukeDetect(BWAPI::Position target)
{

	// Check if the target is a valid position
	if (target)
	{
		// if so, print the location of the nuclear strike target
		Broodwar << "Nuclear Launch Detected at " << target << std::endl;
	}
	else
	{
		// Otherwise, ask other players where the nuke is!
		Broodwar->sendText("Where's the nuke?");
	}

	// You can also retrieve all the nuclear missile targets using Broodwar->getNukeDots()!
}
void ZiabotModule::onUnitDiscover(BWAPI::Unit unit)
{
	if (IsBuilding(unit) && IsEnemy(unit) && !IsRefinery(unit)) ENEMY.push(unit);
	if (ave == (Position)Broodwar->self()->getStartLocation() && IsEnemy(unit) && IsBuilding(unit) && !IsAddon(unit)){
		ave = unit->getPosition();
	}
	if (Zia == Strat::Dayoung && !Yerim && unit->getType() == UnitTypes::Zerg_Overlord && IsOwned(unit)){
		Yerim = true;
		Chicken = unit;
		Yerin = true;
	}
	if (unit->getType() == unit->getType().getRace().getCenter() && IsOwned(unit) && Broodwar->getFrameCount() < 10){
		
		TilePosition Nextbase;
		double ddd = 100000;
		for (auto &nn : getBaseLocations()){
			if (unit->getTilePosition() == nn->getTilePosition()) continue;
			double dd;
			if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
				dd = unit->getDistance(nn->getPosition());
			}
			else dd = BWTA::getGroundDistance(unit->getTilePosition(), nn->getTilePosition());
			if (dd < ddd && dd > 0){
				ddd = dd;
				Nextbase = nn->getTilePosition();
			}
		}
		Multi = Nextbase;

		for (auto &maps : Broodwar->getStartLocations()){
			if (maps == Broodwar->self()->getStartLocation()){
				ave = (Position)maps;
				continue;
			}
			Position *tStartings = Startings;
			Startings = new Position[++nStartings];
			Startings_check = new bool[nStartings];
			for (int i = 0; i < nStartings; i++) Startings_check[i] = false;
			Startings[0] = (Position)maps;
			for (int i = 1; i < nStartings; i++) Startings[i] = tStartings[i - 1];
			delete[] tStartings;
		}
		if (nStartings == 1){
			ovo = true;
			ave = Startings[0];
		}
	}
	if (unit->getType() == unit->getType().getRace().getCenter() && IsEnemy(unit) && IsCompleted(unit)){
		if (Yerin){ // end scout, and let it fight
			ave = unit->getPosition();
			Chicken->move(ave);
			Yerin = false;
			if (Zia == Strat::Dahye && Broodwar->enemy()->getRace() == Races::Zerg && false){
				Special_chicken = Chicken;
				Chicken = NULL;
				Ddangddang = true;
			}
			else if(Zia1 != Strat::Dayoung) Chang = true;
			if (Zia == Strat::Dahyun || Zia == Strat::Dahye){
				BOOST_FOREACH(Unit lings, Broodwar->self()->getUnits()){
					if (lings->getType() == UnitTypes::Zerg_Zergling)
						lings->attack(ave);
				}
			}
		}
	}
}
void ZiabotModule::onUnitEvade(BWAPI::Unit unit)
{
}
void ZiabotModule::onUnitShow(BWAPI::Unit unit)
{
}
void ZiabotModule::onUnitHide(BWAPI::Unit unit)
{
}
void ZiabotModule::onUnitCreate(BWAPI::Unit unit)
{
	if (Broodwar->isReplay())
	{
		// if we are in a replay, then we will print out the build order of the structures
		if (unit->getType().isBuilding() && !unit->getPlayer()->isNeutral())
		{
			int seconds = Broodwar->getFrameCount() / 24;
			int minutes = seconds / 60;
			seconds %= 60;
			Broodwar->sendText("%.2d:%.2d: %s creates a %s", minutes, seconds, unit->getPlayer()->getName().c_str(), unit->getType().c_str());
		}
	}
}
void ZiabotModule::onUnitDestroy(BWAPI::Unit unit)
{
}
void ZiabotModule::onUnitMorph(BWAPI::Unit unit)
{
	if (Broodwar->isReplay())
	{
		// if we are in a replay, then we will print out the build order of the structures
		if (unit->getType().isBuilding() && !unit->getPlayer()->isNeutral())
		{
			int seconds = Broodwar->getFrameCount() / 24;
			int minutes = seconds / 60;
			seconds %= 60;
			Broodwar->sendText("%.2d:%.2d: %s morphs a %s", minutes, seconds, unit->getPlayer()->getName().c_str(), unit->getType().c_str());
		}
	}
}
void ZiabotModule::onUnitRenegade(BWAPI::Unit unit)
{
}
void ZiabotModule::onSaveGame(std::string gameName)
{
	Broodwar << "The game was saved to \"" << gameName << "\"" << std::endl;
}
void ZiabotModule::onUnitComplete(BWAPI::Unit unit)
{
}
void ZiabotModule::onEnd(bool isWinner)
{
	int race;
	string name, map;
	int z1, z2, z3, W, L;
	if (isWinner){
		W = 1;
		L = 0;
	}
	else{
		W = 0;
		L = 1;
	}

	race = (int)Broodwar->enemy()->getRace();
	name = Broodwar->enemy()->getName().c_str();
	while (name.find((char)32) != string::npos) {
		name[name.find((char)32)] = (char)95;
	}
	map = Broodwar->mapFileName().c_str();
	while (map.find((char)32) != string::npos) {
		map[map.find((char)32)] = (char)95;
	}
	z1 = Zia1; z2 = Zia2; z3 = Zia3;

	bool BREAK = false;

	for (int i = 0; i <= Cheers.name.size() && !BREAK; i++){
		if (i == Cheers.name.size()){
			NAME nn(race, name, map, z1, z2, z3, W, L);
			Cheers.name.push_back(nn);
			BREAK = true;
		}
		else if (race == Cheers.name[i].race && name == Cheers.name[i].name){
			for (int j = 0; j <= Cheers.name[i].map.size() && !BREAK; j++){
				if (j == Cheers.name[i].map.size()){
					MAP mm(map, z1, z2, z3, W, L);
					Cheers.name[i].map.push_back(mm);
					BREAK = true;
				}
				else if (map == Cheers.name[i].map[j].map){
					for (int k = 0; k <= Cheers.name[i].map[j].z1.size() && !BREAK; k++){
						if (k == Cheers.name[i].map[j].z1.size()){
							Z1 zz(z1, z2, z3, W, L);
							Cheers.name[i].map[j].z1.push_back(zz);
							BREAK = true;
						}
						else if (z1 == Cheers.name[i].map[j].z1[k].z1){
							for (int l = 0; l <= Cheers.name[i].map[j].z1[k].z2.size() && !BREAK; l++){
								if (l == Cheers.name[i].map[j].z1[k].z2.size()){
									Z2 zz(z2, z3, W, L);
									Cheers.name[i].map[j].z1[k].z2.push_back(zz);
									BREAK = true;
								}
								else if (z2 == Cheers.name[i].map[j].z1[k].z2[l].z2){
									for (int m = 0; m <= Cheers.name[i].map[j].z1[k].z2[l].z3.size() && !BREAK; m++){
										if (m == Cheers.name[i].map[j].z1[k].z2[l].z3.size()){
											Z3 zz(z3, W, L);
											Cheers.name[i].map[j].z1[k].z2[l].z3.push_back(zz);
											BREAK = true;
										}
										else if (z3 == Cheers.name[i].map[j].z1[k].z2[l].z3[m].z3){
											Cheers.name[i].map[j].z1[k].z2[l].z3[m].w += W;
											Cheers.name[i].map[j].z1[k].z2[l].z3[m].l += L;
											BREAK = true;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	ofstream out("bwapi-data/write/Zia.txt");

	if (out.is_open()){
		out << "20160831" << endl;
		for (int i = 0; i < Cheers.name.size(); i++){
			race = Cheers.name[i].race;
			name = Cheers.name[i].name;
			for (int j = 0; j < Cheers.name[i].map.size(); j++){
				map = Cheers.name[i].map[j].map;
				for (int k = 0; k < Cheers.name[i].map[j].z1.size(); k++){
					z1 = Cheers.name[i].map[j].z1[k].z1;
					for (int l = 0; l < Cheers.name[i].map[j].z1[k].z2.size(); l++){
						z2 = Cheers.name[i].map[j].z1[k].z2[l].z2;
						for (int m = 0; m < Cheers.name[i].map[j].z1[k].z2[l].z3.size(); m++){
							z3 = Cheers.name[i].map[j].z1[k].z2[l].z3[m].z3;
							W = Cheers.name[i].map[j].z1[k].z2[l].z3[m].w;
							L = Cheers.name[i].map[j].z1[k].z2[l].z3[m].l;
							out << race << " " << name << " " << map << " " << z1 << " " << z2 << " " << z3 << " " << W << " " << L<<endl;
						}
					}
				}
			}
		}
		out.close();
	}
	else {
		Broodwar << "Failed to save data";
	}
}
void ZiabotModule::drawTerrainData()
{
	//we will iterate through all the base locations, and draw their outlines.
	for (const auto& baseLocation : BWTA::getBaseLocations()) {
		TilePosition p = baseLocation->getTilePosition();

		//draw outline of center location
		Position leftTop(p.x * TILE_SIZE, p.y * TILE_SIZE);
		Position rightBottom(leftTop.x + 4 * TILE_SIZE, leftTop.y + 3 * TILE_SIZE);
		Broodwar->drawBoxMap(leftTop, rightBottom, Colors::Blue);

		//draw a circle at each mineral patch
		BOOST_FOREACH(Unit mineral, baseLocation->getStaticMinerals()) {
			Broodwar->drawCircleMap(mineral->getInitialPosition(), 30, Colors::Cyan);
		}

		//draw the outlines of Vespene geysers
		BOOST_FOREACH(Unit geyser, baseLocation->getGeysers()) {
			TilePosition p1 = geyser->getInitialTilePosition();
			Position leftTop1(p1.x * TILE_SIZE, p1.y * TILE_SIZE);
			Position rightBottom1(leftTop1.x + 4 * TILE_SIZE, leftTop1.y + 2 * TILE_SIZE);
			Broodwar->drawBoxMap(leftTop1, rightBottom1, Colors::Orange);
		}

		//if this is an island expansion, draw a yellow circle around the base location
		if (baseLocation->isIsland()) {
			Broodwar->drawCircleMap(baseLocation->getPosition(), 80, Colors::Yellow);
		}
	}

	//we will iterate through all the regions and ...
	for (const auto& region : BWTA::getRegions()) {
		// draw the polygon outline of it in green
		BWTA::Polygon p = region->getPolygon();
		for (size_t j = 0; j < p.size(); ++j) {
			Position point1 = p[j];
			Position point2 = p[(j + 1) % p.size()];
			Broodwar->drawLineMap(point1, point2, Colors::Green);
		}
		// visualize the chokepoints with red lines
		for (auto const& chokepoint : region->getChokepoints()) {
			Position point1 = chokepoint->getSides().first;
			Position point2 = chokepoint->getSides().second;
			Broodwar->drawLineMap(point1, point2, Colors::Red);
		}
	}
}
