//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#ifndef STARPORT_H
#define STARPORT_H

#include "my.h"


namespace iron
{



template<tid_t> class My;



//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class My<Terran_Starport>
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////
//

template<>
class My<Terran_Starport> : public MyBuilding
{
public:
	static ConstructingExpert *	GetConstructingExpert();

							My(BWAPI::Unit u);

	vector<ConstructingAddonExpert *>	ConstructingAddonExperts() override {CI(this); return m_ConstructingAddonExperts; }

private:
	void					DefaultBehaviorOnFrame() override;

	static ExpertInConstructing<Terran_Starport>	m_ConstructingExpert;


	static vector<ConstructingAddonExpert *>	m_ConstructingAddonExperts;
};



//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class My<Terran_Wraith>
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////
//


template<>
class My<Terran_Wraith> : public MyUnit
{
public:
							My(BWAPI::Unit u);

	int						MaxRepairers() const override						{ return 2; }
private:
	void					DefaultBehaviorOnFrame() override;
};




} // namespace iron


#endif

