//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#include "refinery.h"
#include "../strategy/strategy.h"
#include "../strategy/zerglingRush.h"
#include "../Iron.h"

namespace { auto & bw = Broodwar; }


namespace iron
{


//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class My<Terran_Refinery>
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////


template<>
class ExpertInConstructing<Terran_Refinery> : public ConstructingExpert
{
public:
						ExpertInConstructing() : ConstructingExpert(Terran_Refinery) {}

	void				UpdateConstructingPriority() override;

private:
};


void ExpertInConstructing<Terran_Refinery>::UpdateConstructingPriority()
{
	if (auto s = ai()->GetStrategy()->Detected<ZerglingRush>())
		if (!s->TechRestartingCondition())
			{ m_priority = 0; return; }

	if (Builders() < BuildingsUncompleted()) { m_priority = 590; return; }

	if (Buildings() == 0)
	{
		if (!me().Buildings(Terran_Barracks).empty())
		{
			if (me().SupplyUsed() >= 12)	m_priority = 610;
			else							m_priority = 590;
			return;
		}
	}
	else
	{
		if (me().GasAvailable() < 200)
			for (VBase * base : me().Bases())
				if (base->Active())
					if (!base->BWEMPart()->Geysers().empty())
						if (none_of(me().Buildings(Terran_Refinery).begin(), me().Buildings(Terran_Refinery).end(),
									[base](const unique_ptr<MyBuilding> & b){ return b->GetStronghold() == base->GetStronghold(); }))
						{
							m_priority = 500;
							return;
						}
	}

	m_priority = 0;
}


ExpertInConstructing<Terran_Refinery>	My<Terran_Refinery>::m_ConstructingExpert;

ConstructingExpert * My<Terran_Refinery>::GetConstructingExpert() { return &m_ConstructingExpert; }


My<Terran_Refinery>::My(BWAPI::Unit u)
	: MyBuilding(u, make_unique<DefaultBehavior>(this))
{
	assert_throw(u->getType() == Terran_Refinery);

	m_ConstructingExpert.OnBuildingCreated();
}


void My<Terran_Refinery>::DefaultBehaviorOnFrame()
{CI(this);
	if (DefaultBehaviorOnFrame_common()) return;
}




	
} // namespace iron



