//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#ifndef FIGHT_H
#define FIGHT_H

#include "../debug.h"
#include "../defs.h"

namespace iron
{

class MyUnit;
class HisUnit;

//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class FightSim
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////
//

class FightSim
{
public:
						FightSim();

	void				AddMyUnit(BWAPI::UnitType type, int life, int shields);
	void				AddHisUnit(BWAPI::UnitType type, int life, int shields);

	void				Eval();

	int					Efficiency() const		{ return m_efficiency; }
	bool				Win() const				{ return m_win; }
	const string &		FinalState() const		{ return m_finalState; }

private:
	struct UnitInfo
	{
							UnitInfo(BWAPI::UnitType type, int life, int shields)
								: type(type), life_times4(life*4), shields(shields) {}
		BWAPI::UnitType		type;
		int					life_times4;
		int					shields;
		frame_t				death = 1000000;

		void				UpdateShields(int v, frame_t time);
		void				UpdateLife4(int v4, frame_t time);
	};

	struct FaceOffInfo
	{
		int					pleinAttack;
		int					sizedAttack_times4;
	};

	void				Compute_FaceOffInfoMatrix();
	bool				EvalAttack(const UnitInfo * pAttacker, vector<UnitInfo> & Targets, frame_t time);
	void				PrintState(ostream & out, char eventType, frame_t time) const;
	void				PrintUnitState(ostream & out, const UnitInfo & u) const;
	void				CalculateEfficiency();

	vector<UnitInfo>	m_MyUnits;
	vector<UnitInfo>	m_HisUnits;

	map<pair<BWAPI::UnitType, BWAPI::UnitType>, FaceOffInfo>	m_FaceOffInfoMatrix;		// (attacker, defender)

	string				m_finalState;
	int					m_efficiency;
	bool				m_win;

	class Event;
};




} // namespace iron


#endif

