//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#include "ebay.h"
#include "army.h"
#include "../Iron.h"

namespace { auto & bw = Broodwar; }


namespace iron
{

//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class My<Terran_Engineering_Bay>
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////


template<>
class ExpertInConstructing<Terran_Engineering_Bay> : public ConstructingExpert
{
public:
						ExpertInConstructing() : ConstructingExpert(Terran_Engineering_Bay) {}

	void				UpdateConstructingPriority() override;

private:
};


void ExpertInConstructing<Terran_Engineering_Bay>::UpdateConstructingPriority()
{
	if (Builders() < BuildingsUncompleted()) { m_priority = 590; return; }

	if (Buildings() == 0)
	{
		if (him().Race() == Races::Terran)
		{
			if (him().MayWraith() || (me().Army().HisInvisibleUnits() >= 1))
				{ m_priority = 500; return; }

			if (me().Buildings(Terran_Command_Center).size() >= 3)
				if (me().SupplyUsed() >= 100)
					if (me().Army().GroundLead())
						{ m_priority = 500; return; }
		}
		else if (him().Race() == Races::Protoss)
		{
			if (him().MayDarkTemplar())
				{ m_priority = 500; return; }

			if (me().Units(Terran_Siege_Tank_Tank_Mode).size() >= 1)
				if (me().Army().GroundLead())
					{ m_priority = 500; return; }
		}
		else
		{
//			if (me().Units(Terran_Siege_Tank_Tank_Mode).size() >= 1)
			if (me().Units(Terran_Vulture).size() >= 5)
				{ m_priority = 500; return; }
		}
	}

	m_priority = 0;
}


ExpertInConstructing<Terran_Engineering_Bay>	My<Terran_Engineering_Bay>::m_ConstructingExpert;

ConstructingExpert * My<Terran_Engineering_Bay>::GetConstructingExpert() { return &m_ConstructingExpert; }




template<>
class ExpertInUpgraging<UpgradeTypes::Enum::Terran_Infantry_Armor> : public ResearchingExpert
{
public:
						ExpertInUpgraging(MyBuilding * pWhere) : ResearchingExpert(UpgradeTypes::Enum::Terran_Infantry_Armor, pWhere) {}

	void				UpdateResearchingPriority() override;

private:
};


void ExpertInUpgraging<UpgradeTypes::Enum::Terran_Infantry_Armor>::UpdateResearchingPriority()
{
	if (me().Player()->getUpgradeLevel(UpgradeTypes::Enum::Terran_Infantry_Armor) == 0)
		if (me().Bases().size() >= 2)
			{ m_priority = 300; return; }

	m_priority = 0;
}



My<Terran_Engineering_Bay>::My(BWAPI::Unit u)
	: MyBuilding(u, make_unique<DefaultBehavior>(this))
{
	assert_throw(u->getType() == Terran_Engineering_Bay);

	AddUpgragingExpert<UpgradeTypes::Enum::Terran_Infantry_Armor>();


	m_ConstructingExpert.OnBuildingCreated();
}


void My<Terran_Engineering_Bay>::DefaultBehaviorOnFrame()
{CI(this);
	if (DefaultBehaviorOnFrame_common()) return;
}

	
} // namespace iron



