//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#ifndef CC_H
#define CC_H

#include "my.h"


namespace iron
{



template<tid_t> class My;



//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class My<Terran_Command_Center>
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////
//

template<>
class My<Terran_Command_Center> : public MyBuilding
{
public:
	static ConstructingExpert *	GetConstructingExpert();

							My(BWAPI::Unit u);

private:
	void					DefaultBehaviorOnFrame() override;

	double					MinLifePercentageToRepair() const override	{ return 0.66; }
	double					MaxLifePercentageToRepair() const override	{ return 0.80; }

	static ExpertInConstructing<Terran_Command_Center>	m_ConstructingExpert;
};





//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class My<Terran_SCV>
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////
//


template<>
class My<Terran_SCV> : public MyUnit
{
public:
							My(BWAPI::Unit u);

	void					Gather(Mineral * m, bool noCheck = false);
	void					Gather(Geyser * g, bool noCheck = false);
	void					ReturnCargo(bool noCheck = false);
	void					Repair(MyBWAPIUnit * target, bool noCheck = false);
	bool					Build(BWAPI::UnitType type, TilePosition location, bool noCheck = false);

	void					SetSoldierForever()		{CI(this); m_soldierForever = true; }
	bool					SoldierForever() const	{CI(this); return m_soldierForever; }

private:
	void					DefaultBehaviorOnFrame() override;
	bool					m_soldierForever = false;
};




} // namespace iron


#endif

