//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#ifndef ARMY_H
#define ARMY_H

#include <BWAPI.h>
#include "../defs.h"


namespace iron
{


//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class Army
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////
//

class Army
{
public:
									Army();

	void							Update();

	bool							GroundLead() const				{ return m_groundLead; }
	const string &					GroundLeadStatus_vultures() const	{ return m_groundLeadStatus_vultures; }
	const string &					GroundLeadStatus_mines() const		{ return m_groundLeadStatus_mines; }
	bool							VulturesCond() const			{ return m_vulturesCond; }
	bool							MinesCond() const				{ return m_minesCond; }
	int								MyGroundUnitsAhead() const		{ return m_myGroundUnitsAhead; }
	int								HisGroundUnitsAhead() const		{ return m_hisGroundUnitsAhead; }

	// These ratios are tenths of all the vultures + tanks + goliaths:
	int								TankRatioWanted() const			{ return m_tankRatioWanted; }
	int								GoliathRatioWanted() const		{ return m_goliathRatioWanted; }

	// tenth
	int								AirAttackOpportunity() const	{ return m_hisSoldiersFearingAir * 10 / max(1, m_hisSoldiers); }

	int								HisInvisibleUnits() const		{ return m_hisInvisibleUnits; }
	int								HisMarines() const				{ return m_hisMarines; }
	int								HisMedics() const				{ return m_hisMedics; }

private:
	void							UpdateHisArmyStats();
	void							UpdateGroundLead();
	void							UpdateRatios();
	void							UpdateRatios_vsTerran();
	void							UpdateRatios_vsProtoss();
	void							UpdateRatios_vsZerg();

	int								m_hisSoldiers;
	int								m_hisMarines;
	int								m_hisMedics;
	int								m_hisSoldiersFearingAir;
	int								m_hisInvisibleUnits;

	int								m_myGroundUnitsAhead = -1;
	int								m_hisGroundUnitsAhead = -1;

	bool							m_vulturesCond;
	bool							m_minesCond;
	bool							m_groundLead;
	string							m_groundLeadStatus_vultures;
	string							m_groundLeadStatus_mines;

	int								m_tankRatioWanted = 2;
	int								m_goliathRatioWanted = 0;
};



} // namespace iron


#endif

