//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#include "armory.h"
#include "../behavior/defaultBehavior.h"
#include "../Iron.h"

namespace { auto & bw = Broodwar; }


namespace iron
{

//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class My<Terran_Armory>
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////


template<>
class ExpertInConstructing<Terran_Armory> : public ConstructingExpert
{
public:
						ExpertInConstructing() : ConstructingExpert(Terran_Armory) {}

	void				UpdateConstructingPriority() override;

private:
};


void ExpertInConstructing<Terran_Armory>::UpdateConstructingPriority()
{
	if (me().CompletedBuildings(Terran_Factory) == 0) { m_priority = 0; return; }

	if (him().Race() != Races::Terran)
		if (me().CompletedBuildings(Terran_Engineering_Bay) == 0) { m_priority = 0; return; }

	if (Builders() < BuildingsUncompleted()) { m_priority = 590; return; }

	if (Buildings() < 1)
		if (me().Buildings(Terran_Command_Center).size() >= 2)
			if ((him().Race() != Races::Terran) || him().MayWraith() || (me().SupplyUsed() >= 80))
			{
				static frame_t startingFrame = ai()->Frame();
				m_priority = min(500, 350 + (ai()->Frame() - startingFrame)/10);
				return;
			}

	if (Buildings() < 2)
		if (me().Buildings(Terran_Command_Center).size() >= 3)
			{ m_priority = 350; return; }

	m_priority = 0;
}


ExpertInConstructing<Terran_Armory>	My<Terran_Armory>::m_ConstructingExpert;

ConstructingExpert * My<Terran_Armory>::GetConstructingExpert() { return &m_ConstructingExpert; }




template<>
class ExpertInUpgraging<UpgradeTypes::Enum::Terran_Vehicle_Weapons> : public ResearchingExpert
{
public:
						ExpertInUpgraging(MyBuilding * pWhere) : ResearchingExpert(UpgradeTypes::Enum::Terran_Vehicle_Weapons, pWhere) {}

	void				UpdateResearchingPriority() override;

private:
};


void ExpertInUpgraging<UpgradeTypes::Enum::Terran_Vehicle_Weapons>::UpdateResearchingPriority()
{
	m_priority = 410 - 50*me().Player()->getUpgradeLevel(UpgradeTypes::Enum::Terran_Vehicle_Weapons);
}



template<>
class ExpertInUpgraging<UpgradeTypes::Enum::Terran_Vehicle_Plating> : public ResearchingExpert
{
public:
						ExpertInUpgraging(MyBuilding * pWhere) : ResearchingExpert(UpgradeTypes::Enum::Terran_Vehicle_Plating, pWhere) {}

	void				UpdateResearchingPriority() override;

private:
};


void ExpertInUpgraging<UpgradeTypes::Enum::Terran_Vehicle_Plating>::UpdateResearchingPriority()
{
	m_priority = 409 - 50*me().Player()->getUpgradeLevel(UpgradeTypes::Enum::Terran_Vehicle_Plating);
}



template<>
class ExpertInUpgraging<UpgradeTypes::Enum::Terran_Ship_Weapons> : public ResearchingExpert
{
public:
						ExpertInUpgraging(MyBuilding * pWhere) : ResearchingExpert(UpgradeTypes::Enum::Terran_Ship_Weapons, pWhere) {}

	void				UpdateResearchingPriority() override;

private:
};


void ExpertInUpgraging<UpgradeTypes::Enum::Terran_Ship_Weapons>::UpdateResearchingPriority()
{
	const int flyingForce =
		me().Units(Terran_Battlecruiser).size() +
		me().Units(Terran_Valkyrie).size() + 
		me().Units(Terran_Wraith).size();

	m_priority = min(450, 50*flyingForce) / (1 + me().Player()->getUpgradeLevel(UpgradeTypes::Enum::Terran_Ship_Weapons));
}



template<>
class ExpertInUpgraging<UpgradeTypes::Enum::Terran_Ship_Plating> : public ResearchingExpert
{
public:
						ExpertInUpgraging(MyBuilding * pWhere) : ResearchingExpert(UpgradeTypes::Enum::Terran_Ship_Plating, pWhere) {}

	void				UpdateResearchingPriority() override;

private:
};


void ExpertInUpgraging<UpgradeTypes::Enum::Terran_Ship_Plating>::UpdateResearchingPriority()
{
	const int flyingForce =
		me().Units(Terran_Battlecruiser).size() +
		me().Units(Terran_Valkyrie).size() + 
		me().Units(Terran_Wraith).size();

	m_priority = max(0, (min(450, 50*flyingForce) / (1 + me().Player()->getUpgradeLevel(UpgradeTypes::Enum::Terran_Ship_Plating)) - 1));
}



My<Terran_Armory>::My(BWAPI::Unit u)
	: MyBuilding(u, make_unique<DefaultBehavior>(this))
{
	assert_throw(u->getType() == Terran_Armory);

	AddUpgragingExpert<UpgradeTypes::Enum::Terran_Vehicle_Weapons>();
	AddUpgragingExpert<UpgradeTypes::Enum::Terran_Vehicle_Plating>();
	AddUpgragingExpert<UpgradeTypes::Enum::Terran_Ship_Weapons>();
	AddUpgragingExpert<UpgradeTypes::Enum::Terran_Ship_Plating>();

	m_ConstructingExpert.OnBuildingCreated();
}


void My<Terran_Armory>::DefaultBehaviorOnFrame()
{CI(this);
	if (DefaultBehaviorOnFrame_common()) return;
}

	
} // namespace iron



