//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#include "academy.h"
#include "army.h"
#include "../behavior/defaultBehavior.h"
#include "../Iron.h"

namespace { auto & bw = Broodwar; }


namespace iron
{

//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class My<Terran_Academy>
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////


template<>
class ExpertInConstructing<Terran_Academy> : public ConstructingExpert
{
public:
						ExpertInConstructing() : ConstructingExpert(Terran_Academy) {}

	void				UpdateConstructingPriority() override;

private:
};


void ExpertInConstructing<Terran_Academy>::UpdateConstructingPriority()
{
	if (him().Race() != Races::Zerg) { m_priority = 0; return; }	// disabled for Terran and Protoss

	if (me().CompletedBuildings(Terran_Barracks) == 0) { m_priority = 0; return; }
	if (me().CompletedBuildings(Terran_Engineering_Bay) == 0) { m_priority = 0; return; }	// Ebay first

	if (Builders() < BuildingsUncompleted()) { m_priority = 590; return; }

	if (Buildings() == 0)
		if (me().Buildings(Terran_Command_Center).size() >= 2)
		{
			if (me().Army().HisInvisibleUnits() >= 1)
				if (me().Army().GroundLead())
					{ m_priority = 500; return; }

			static frame_t startingFrame = ai()->Frame();
			m_priority = min(500, 100 + 50*me().Army().HisInvisibleUnits() + (ai()->Frame() - startingFrame)/10); return;
		}

	m_priority = 0;
}


ExpertInConstructing<Terran_Academy>	My<Terran_Academy>::m_ConstructingExpert;

ConstructingExpert * My<Terran_Academy>::GetConstructingExpert() { return &m_ConstructingExpert; }




template<>
class ExpertInUpgraging<UpgradeTypes::Enum::U_238_Shells> : public ResearchingExpert
{
public:
						ExpertInUpgraging(MyBuilding * pWhere) : ResearchingExpert(UpgradeTypes::Enum::U_238_Shells, pWhere) {}

	void				UpdateResearchingPriority() override;

private:
};


void ExpertInUpgraging<UpgradeTypes::Enum::U_238_Shells>::UpdateResearchingPriority()
{
	m_priority = 0;
}



My<Terran_Academy>::My(BWAPI::Unit u)
	: MyBuilding(u, make_unique<DefaultBehavior>(this))
{
	assert_throw(u->getType() == Terran_Academy);

	AddUpgragingExpert<UpgradeTypes::Enum::U_238_Shells>();


	m_ConstructingExpert.OnBuildingCreated();
}


void My<Terran_Academy>::DefaultBehaviorOnFrame()
{CI(this);
	if (DefaultBehaviorOnFrame_common()) return;
}

	
} // namespace iron



