//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#ifndef VCP_H
#define VCP_H

#include <BWAPI.h>
#include "../utils.h"
#include "../defs.h"


namespace iron
{


//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class VChokePoint
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////
//

class VChokePoint
{
public:
	static VChokePoint *				Get(const BWEM::ChokePoint * pBWEMPart);

										VChokePoint(const BWEM::ChokePoint * pBWEMPart);
										~VChokePoint();

	const BWEM::ChokePoint *			BWEMPart() const		{ return m_pBWEMPart; }

	int									AirDistanceFrom(Position p) const;

	altitude_t							MaxAltitude() const			{ return m_maxAltitude; }
	int									Length() const				{ return 2 * m_maxAltitude; }

	vector<VChokePoint *>				Twins() const;

	VChokePoint &						operator=(const VChokePoint &) = delete;

private:
	const BWEM::ChokePoint *			m_pBWEMPart;
	altitude_t							m_maxAltitude;
};



} // namespace iron


#endif

