//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#ifndef ZERGLING_RUSH_H
#define ZERGLING_RUSH_H

#include <BWAPI.h>
#include "strat.h"
#include "../defs.h"
#include "../utils.h"


namespace iron
{

class MyUnit;
FORWARD_DECLARE_MY(Terran_SCV)

//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class ZerglingRush
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////
//

class ZerglingRush : public Strat
{
public:
									ZerglingRush();
									~ZerglingRush();

	string							Name() const override { return "ZerglingRush"; }
	string							StateDescription() const override;

	bool							Detected() const		{ return m_detected; }

	int								MaxMarines() const		{ return m_maxMarines; }
	bool							TechRestartingCondition() const;

	void							SetNoLocationForBunkerForDefenseCP()	{ m_noLocationForBunkerForDefenseCP = true; }
	bool							NoLocationForBunkerForDefenseCP() const	{ return m_noLocationForBunkerForDefenseCP; }
	bool							SnipersAvailable() const				{ return m_snipersAvailable; }

private:
	void							OnBWAPIUnitDestroyed(BWAPIUnit * pBWAPIUnit) override;
	void							OnFrame_v() override;
	void							ChokePointDefense();
	void							WorkerDefense();

	bool							m_detected = false;
	frame_t							m_detetedSince;
	My<Terran_SCV> *				m_pSentry = nullptr;
	bool							m_zerglingsNearSentry = false;
	bool							m_noLocationForBunkerForDefenseCP = false;
	bool							m_snipersAvailable = false;
	//TilePosition					m_BunkerLocation = TilePositions::None;
	int								m_zerglings = 0;
	int								m_maxMarines = 4;
};


} // namespace iron


#endif

