//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#ifndef WATCH_ARMY_H
#define WATCH_ARMY_H

#include <BWAPI.h>
#include "strat.h"
#include "../defs.h"
#include "../utils.h"


namespace iron
{

class HisUnitTrace;
class HisUnit;
class VBase;

//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class WatchArmy
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////
//

class WatchArmy : public Strat
{
public:
									WatchArmy();
									~WatchArmy();

	string							Name() const override { return "WatchArmy"; }
	string							StateDescription() const override;

	bool							Active() const		{ return m_active; }

private:
	bool							PreBehavior() const override		{ return true; }
	void							OnFrame_v() override;

	bool							m_active = false;
	frame_t							m_activeSince = 0;
};

} // namespace iron


#endif

