//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#ifndef ENEMY_SCOUT_H
#define ENEMY_SCOUT_H

#include <BWAPI.h>
#include "strat.h"
#include "../defs.h"
#include "../utils.h"


namespace iron
{

class HisUnit;
	
//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class EnemyScout
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////
//

class EnemyScout : public Strat
{
public:
									EnemyScout();
									~EnemyScout();

	string							Name() const override { return "EnemyScout"; }
	string							StateDescription() const override;

	bool							Detected() const		{ return m_pHisScout != nullptr; }
	HisUnit *						Get() const				{ return m_pHisScout; }
	frame_t							MaxChasingTime() const	{ return m_maxChasingTime; }

private:
	void							OnBWAPIUnitDestroyed(BWAPIUnit * pBWAPIUnit) override;
	void							OnFrame_v() override;
	void							ReleaseExplorers() const;

	HisUnit *						m_pHisScout = nullptr;
	frame_t							m_maxChasingTime;
};


} // namespace iron


#endif

