//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#ifndef EARLY_RUN_BY_H
#define EARLY_RUN_BY_H

#include <BWAPI.h>
#include "strat.h"
#include "../defs.h"
#include "../utils.h"


namespace iron
{

class MyUnit;
	
//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class EarlyRunBy
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////
//

class EarlyRunBy : public Strat
{
public:
									EarlyRunBy();
									~EarlyRunBy();

	string							Name() const override { return "EarlyRunBy"; }
	string							StateDescription() const override;

	bool							Started() const		{ return m_started; }

private:
	void							OnFrame_v() override;
	void							OnBWAPIUnitDestroyed(BWAPIUnit * pBWAPIUnit) override;

	bool							m_started = false;
	frame_t							m_startedSince;
	vector<MyUnit *>				m_Squad;
	int								m_tries = 0;
};


} // namespace iron


#endif

