//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#ifndef BASE_DEFENSE_H
#define BASE_DEFENSE_H

#include <BWAPI.h>
#include "strat.h"
#include "../defs.h"
#include "../utils.h"


namespace iron
{

class HisUnitTrace;
class VBase;


//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class BaseDefense
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////
//

class BaseDefense : public Strat
{
public:
									BaseDefense();
									~BaseDefense();

	string							Name() const override { return "BaseDefense"; }
	string							StateDescription() const override;

	bool							Active() const		{ return m_active; }

private:
	int								EvalVulturesNeededAgainst_Terran(const vector<const HisUnitTrace *> & Threats) const;
	int								EvalVulturesNeededAgainst_Protoss(const vector<const HisUnitTrace *> & Threats) const;
	int								EvalVulturesNeededAgainst_Zerg(const vector<const HisUnitTrace *> & Threats) const;
	int								EvalVulturesNeededAgainst(const vector<const HisUnitTrace *> & Threats) const;
	void							OnFrame_v() override;

	bool							m_active = false;
	frame_t							m_activeSince = 0;
};


VBase * findMyClosestBase(Position pos, int maxTileDistanceToArea = 10);

} // namespace iron


#endif

