//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#include "debug.h"
#include "Iron.h"

namespace { auto & bw = Broodwar; }




namespace iron
{

#if DEV
//4
//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class TimerStats
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////

void TimerStats::Finishing()
{
	++m_count;
	m_time = m_Timer.ElapsedMilliseconds();
	m_total += m_time;
	m_max = max(m_max, m_time);
}
#endif


void reportCommandError(const string & command)
{
	::unused(command);
#if DEV
	bw << "BWAPI ERROR: " << bw->getLastError() << " on: " << command << endl;//2
	bw->setLastError();//2
	ai()->SetDelay(2000);//2
#endif
}


void drawLineMap(Position a, Position b, Color color, bool crop)
{
	if (crop)
	{
		a = ai()->GetMap().Crop(a);
		b = ai()->GetMap().Crop(b);
	}

	CHECK_POS(a);
	CHECK_POS(b);
	bw->drawLineMap(a, b, color);
}
	
} // namespace iron


