//////////////////////////////////////////////////////////////////////////
//
// This file is part of the BWEM Library.
// BWEM is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2015, 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#ifndef BWEM_H
#define BWEM_H


#include "map.h"
#include "tiles.h"
#include "area.h"
#include "cp.h"
#include "base.h"
#include "neutral.h"
#include "gridMap.h"
#include "examples.h"
#include "mapDrawer.h"
#include "utils.h"
#include "bwapiExt.h"
#include "defs.h"

/*

To see examples of how to use the BWEM library, have a look at the functions declared in examples.h.

To get into the documentation, just read the API comments in the following files (preferably in this order):
	tiles.h
	map.h
	area.h
	cp.h
	base.h
	neutral.h

gridMap.h provides the generic type GridMap

*/


namespace BWEM
{


} // namespace BWEM


#endif

