//////////////////////////////////////////////////////////////////////////
//
// This file is part of Iron's source files.
// Iron is free software, licensed under the MIT/X11 License. 
// A copy of the license is provided with the library in the LICENSE file.
// Copyright (c) 2016, Igor Dimitrijevic
//
//////////////////////////////////////////////////////////////////////////


#include "retraiting.h"
#include "kiting.h"
#include "walking.h"
#include "laying.h"
#include "defaultBehavior.h"
#include "../territory/vgridMap.h"
#include "../units/factory.h"
#include "../Iron.h"

namespace { auto & bw = Broodwar; }


namespace iron
{



int Retraiting::Condition(const MyUnit * u, const vector<const FaceOff *> & Threats, int & coverMines)
{
	assert_throw(u->Is(Terran_Vulture));

	if ((him().Race() == Races::Zerg) ||
		me().CompletedUnits(Terran_Siege_Tank_Tank_Mode) || me().CompletedUnits(Terran_Goliath))
		return 0;

	int dangerousUnits = 0;
	int hisVultureScore = 0;
	coverMines = 1;
	bool tryCoverMines = false;

	for (const auto * pFaceOff : Threats)
		if (HisUnit * pHisUnit = pFaceOff->His()->IsHisUnit())
			if (!pHisUnit->Type().isWorker())
				switch (pHisUnit->Type())
				{
				case Terran_Vulture:				hisVultureScore += 2;	++dangerousUnits;	coverMines += 1; break;
				case Terran_Marine:					hisVultureScore += 1;						coverMines += 1; break;
				case Terran_Siege_Tank_Tank_Mode:	hisVultureScore += 6;	++dangerousUnits;	coverMines += 1; tryCoverMines = true; break;
				case Terran_Goliath:				hisVultureScore += 4;						coverMines += 1; tryCoverMines = true; break;
				case Protoss_Dragoon:				hisVultureScore += 6;	++dangerousUnits;	coverMines += 1; tryCoverMines = true; break;
				case Protoss_Zealot:				hisVultureScore += 1;						coverMines += 1; break;
				}
	hisVultureScore /= 2;

	if (!tryCoverMines) coverMines = 0;

	if (dangerousUnits == 0) return 0;

	int myVultureScore = 0;
	for (const auto & v : me().Units(Terran_Vulture))
		if (v->Completed())
			if ((v->Life()*3 > v->MaxLife()) || !v->WorthBeingRepaired())
				if (!v->GetBehavior()->IsRetraiting())
					if (dist(u->Pos(), v->Pos()) < 12*32)
						++myVultureScore;

	if (myVultureScore <= hisVultureScore) return hisVultureScore + 1;

	return 0;
}


//////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                          //
//                                  class Retraiting
//                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////

vector<Retraiting *> Retraiting::m_Instances;

Retraiting::Retraiting(MyUnit * pAgent, Position target, int numberNeeded, int coverMines)
	: Behavior(pAgent, behavior_t::Retraiting), m_target(target),
		m_numberNeeded(numberNeeded),
		m_pGroup(make_shared<vector<Retraiting *>>()),
		m_pCoverMines(make_shared<int>(coverMines))
{
	assert_throw(pAgent->Is(Terran_Vulture));
	assert_throw(!Agent()->GetStronghold());
	assert_throw(pathExists(pAgent->Pos(), target));

	m_pTargetArea = ai()->GetMap().GetNearestArea(WalkPosition(Target()));

	PUSH_BACK_UNCONTAINED_ELEMENT(m_Instances, this);
	m_pGroup->push_back(this);

///	bw << pAgent->NameWithId() << " retraiting, need " << numberNeeded << endl;
///	ai()->SetDelay(50);
}


Retraiting::Retraiting(MyUnit * pAgent, Retraiting * pExistingGroup)
	: Retraiting(pAgent, pExistingGroup->Target(), pExistingGroup->m_numberNeeded, 0)
{
	assert_throw(!contains(*pExistingGroup->m_pGroup, this));

	m_pTargetArea = pExistingGroup->m_pTargetArea;

	m_pGroup = pExistingGroup->m_pGroup;
	m_pGroup->push_back(this);

	m_pCoverMines = pExistingGroup->m_pCoverMines;
}


Retraiting::~Retraiting()
{
#if !DEV
	try //3
#endif
	{
		really_remove(*m_pGroup, this);

		if (m_releaseGroupWhenLeaving)
			while (!m_pGroup->empty())
			{
				Retraiting * r = m_pGroup->back();
				r->Agent()->ChangeBehavior<DefaultBehavior>(r->Agent());
			}

		assert_throw(contains(m_Instances, this));
		really_remove(m_Instances, this);
	}
#if !DEV
	catch(...){} //3
#endif
}


void Retraiting::ChangeState(state_t st)
{CI(this);
	assert_throw(m_state != st);
	
	m_state = st; OnStateChanged();
}


string Retraiting::StateName() const
{CI(this);
	switch(State())
	{
	case retraiting:
	{
		string s = "retraiting";
		s += " (need " + to_string(m_numberNeeded);
		s += ", coverMines = " + to_string(*m_pCoverMines);
		if (m_layingCoverMinesTime) s += " (laying in = " + to_string(m_layingCoverMinesTime - ai()->Frame()) + ")";
		s += ", time = " + to_string(ai()->Frame() - InStateSince()) + ")";
		return s;
	}
	default:				return "?";
	}
}


bool Retraiting::TryCounterNow()
{CI(this);
	if (me().HasResearched(TechTypes::Spider_Mines))
		if (*m_pCoverMines > 0)
			if (Agent()->IsMy<Terran_Vulture>())
			{
				int minDistToTargetInGroup = numeric_limits<int>::max();
				const Retraiting * pMostAdvancedCandidate = nullptr;;

				int minesAvailableInGroup = 0;
				for (Retraiting * r : *m_pGroup)
				{
					if (const My<Terran_Vulture> * pVulture = r->Agent()->IsMy<Terran_Vulture>())
						if (pVulture->RemainingMines() >= 2)
						{
							if (!r->Agent()->FaceOffs().empty()) r->m_layingCoverMinesTime = 0;
							else if (m_layingCoverMinesTime == 0)
							{
								m_layingCoverMinesTime = ai()->Frame() + 50;
							///	ai()->SetDelay(1000);
							///	bw << Agent()->NameWithId() << "will lay cover mines in " << m_layingCoverMinesTime - ai()->Frame() << endl;
							}

							minesAvailableInGroup += pVulture->RemainingMines();

							int d = groundDist(r->Agent()->Pos(), Target());
							if (d < minDistToTargetInGroup)
							{
								minDistToTargetInGroup = d;
								pMostAdvancedCandidate = r;
							}
						}
						else r->m_layingCoverMinesTime = 0;

				}

//				if (minesAvailableInGroup >= *m_pCoverMines)
					if (pMostAdvancedCandidate == this)
						if (Agent()->FaceOffs().empty())
							if (ai()->Frame() >= m_layingCoverMinesTime)
							{
								*m_pCoverMines -= Agent()->IsMy<Terran_Vulture>()->RemainingMines();
								m_releaseGroupWhenLeaving = false;
								Agent()->ChangeBehavior<Laying>(Agent());
								return true;
							}
			}

	return false;
}


void Retraiting::OnFrame_v()
{CI(this);
#if DEV
	drawLineMap(Agent()->Pos(), m_target, GetColor());//1
#endif

	if (!Agent()->CanAcceptCommand()) return;

	if (JustArrivedInState())
	{
		m_inStateSince = ai()->Frame();
//		if (Agent()->Flying())
//			return Agent()->Move(Target());
//		else
			return SetSubBehavior<Walking>(Agent(), Target(), __FILE__ + to_string(__LINE__));
	}

	if (ai()->Frame() - m_inStateSince > 60)
		if (Agent()->Life() < Agent()->PrevLife(10))
			return Agent()->ChangeBehavior<Kiting>(Agent());

	if ((dist(Agent()->Pos(), Target()) < 32*5) && (Agent()->GetArea(no_check) == TargetArea()) ||
		(ai()->Frame() - m_inStateSince > 400) ||
		(ai()->Frame() - m_inStateSince > 200) && m_growed)
		{
			ResetSubBehavior();
			return Agent()->ChangeBehavior<DefaultBehavior>(Agent());
		}

	{
		const int tileRadius = 10;
		vector<MyUnit *> MyUnitsAround = ai()->GetGridMap().GetMyUnits(ai()->GetMap().Crop(TilePosition(Agent()->Pos())-tileRadius), ai()->GetMap().Crop(TilePosition(Agent()->Pos())+tileRadius));

		for (MyUnit * u : MyUnitsAround)
			if (u->Is(Terran_Vulture))
				if (!u->GetStronghold())
					if ((u->Life()*2 > u->MaxLife()) || !u->WorthBeingRepaired())
						if (groundDist(u->Pos(), Agent()->Pos()) < tileRadius*32)
							if (u->GetBehavior()->IsRaiding() ||
								u->GetBehavior()->IsKiting() ||
								u->GetBehavior()->IsRepairing() ||
								u->GetBehavior()->IsRetraiting() && (m_pGroup.get() != u->GetBehavior()->IsRetraiting()->m_pGroup.get()))
							{
								assert_throw(u != Agent());
								m_growed = true;
							///	bw << "merge !!!!!!!!!!!!!!!" << endl;
								if (u->GetBehavior()->IsRetraiting())
									assert_throw(!contains(*u->GetBehavior()->IsRetraiting()->m_pGroup, this));
								u->ChangeBehavior<Retraiting>(u, this);
							}
	}

	{
		if ((int)m_pGroup->size() >= m_numberNeeded)
		{
		///	bw << "release Retraiting group" << endl;
			return Agent()->ChangeBehavior<DefaultBehavior>(Agent());
		}
	}
/*
	{
		int distToTarget = groundDist(Agent()->Pos(), Target());
		int maxDistToTargetInGroup = numeric_limits<int>::min();
		for (const Retraiting * r : *m_pGroup)
			maxDistToTargetInGroup = max(maxDistToTargetInGroup, groundDist(r->Agent()->Pos(), Target()));
	
		if (distToTarget + 7*32 < maxDistToTargetInGroup)
		{
#if DEV
			for (const Retraiting * r : *m_pGroup)
				drawLineMap(Agent()->Pos(), r->Agent()->Pos(), GetColor());
#endif
		///	bw << Agent()->NameWithId() << " wait" << endl;
			return ResetSubBehavior();
		}
	}
*/
	if (TryCounterNow()) return;

	if (ai()->Frame() - m_inStateSince > 15)
	{
		if (!GetSubBehavior())
			if (ai()->Frame() - Agent()->LastFrameMoving() > 10)
				return SetSubBehavior<Walking>(Agent(), Target(), __FILE__ + to_string(__LINE__));

		if (ai()->Frame() - Agent()->LastFrameMoving() > 50)
			return Agent()->ChangeBehavior<DefaultBehavior>(Agent());
	}
}



} // namespace iron



