/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import javabot.JavaBot;
import javabot.knowledge.Tech;
import javabot.managers.BaseManager;
import javabot.managers.BwapiCallsManager;
import javabot.managers.EnemyBuildingManager;
import javabot.managers.EnemyUnitManager;
import javabot.managers.UnitManager;
import javabot.model.Unit;
import javabot.types.TechType;

public class ZerglingManager
extends UnitManager {
    int transitionStates = 0;
    MICRO_STATES microState;

    public ZerglingManager(Unit u) {
        super(u);
        this.explore = true;
        this.microState = MICRO_STATES.ATTACKING;
    }

    @Override
    public void update() {
        super.update();
        this.safeMarge = (35 - this.hp) * 2;
        if (this.transitionStates > 0) {
            --this.transitionStates;
        } else {
            switch (this.microState) {
                case ATTACKING: {
                    this.updateAttacking();
                    break;
                }
                case IN_BURROW: {
                    this.updateInBurrow();
                    break;
                }
                case BURROWED: {
                    this.updateBurrowed();
                    break;
                }
                case UN_BURROW: {
                    this.updateUnBurrow();
                    break;
                }
                default: {
                    this.updateAttacking();
                }
            }
        }
        this.nbNemesis = 0;
    }

    private void goToState(MICRO_STATES state, int transitionTime) {
        this.microState = state;
        this.transitionStates = transitionTime;
    }

    private boolean mustBurrow() {
        if (this.unit.getHitPoints() > 28 || Tech.burrow != 2 || this.nearbyDetector()) {
            return false;
        }
        boolean nearbyThreat = this.nearbyGroundEnemy(this.safeMarge);
        return nearbyThreat;
    }

    private void updateAttacking() {
        if (this.mustBurrow()) {
            this.goToState(MICRO_STATES.IN_BURROW, 0);
        } else if (this.unit.isBurrowed()) {
            this.goToState(MICRO_STATES.BURROWED, 0);
        } else {
            this.attackRandomZergling();
        }
    }

    private void updateUnBurrow() {
        if (this.countDontAct == 0 && BwapiCallsManager.useTech(this.unit.getID(), TechType.TechTypes.Burrowing.ordinal())) {
            this.countDontAct = 40;
        }
        if (!this.unit.isBurrowed()) {
            this.goToState(MICRO_STATES.ATTACKING, 10);
            this.countDontAct = 0;
        }
    }

    private void updateBurrowed() {
        if (!this.unit.isBurrowed()) {
            this.goToState(MICRO_STATES.ATTACKING, 0);
        } else if (this.nearbyDetector() || !this.nearbyGroundEnemy(this.safeMarge) || this.unit.getHitPoints() >= 33) {
            this.goToState(MICRO_STATES.UN_BURROW, 0);
            return;
        }
    }

    private void updateInBurrow() {
        if (this.countDontAct == 0 && BwapiCallsManager.useTech(this.unit.getID(), TechType.TechTypes.Burrowing.ordinal())) {
            this.countDontAct = 80;
        }
        if (this.unit.isBurrowed()) {
            this.countDontAct = 30;
            this.goToState(MICRO_STATES.BURROWED, 30);
        }
    }

    public void attackRandomZergling() {
        if (this.countDontAct > 0) {
            return;
        }
        ++this.countResetAction;
        if (this.countResetAction > this.countMaxResetAction) {
            if (BwapiCallsManager.stop(this.unit.getID())) {
                this.countResetAction = 0;
                this.countDontAct = 3;
            }
        } else if (this.unit.isIdle()) {
            if (JavaBot.enemyBuildingsManager.size() > 0 && Math.random() < 0.7) {
                int iterBuilding = (int)(Math.random() * (double)JavaBot.enemyBuildingsManager.size());
                if (iterBuilding >= JavaBot.enemyBuildingsManager.size()) {
                    --iterBuilding;
                }
                if (iterBuilding < 0) {
                    iterBuilding = 0;
                }
                EnemyBuildingManager buildingToAttack = JavaBot.enemyBuildingsManager.get(iterBuilding);
                if (BwapiCallsManager.attack(this.unit.getID(), buildingToAttack.posX, buildingToAttack.posY)) {
                    this.countResetAction = 0;
                    this.countDontAct = 3;
                }
            } else if (Math.random() < 0.6 && JavaBot.enemyUnitsGroundManager.size() > 0) {
                int iterUnit = (int)(Math.random() * (double)JavaBot.enemyUnitsGroundManager.size());
                if (iterUnit < 0) {
                    iterUnit = 0;
                }
                if (iterUnit >= JavaBot.enemyUnitsGroundManager.size()) {
                    --iterUnit;
                }
                EnemyUnitManager unitToAttack = JavaBot.enemyUnitsGroundManager.get(iterUnit);
                BwapiCallsManager.attack(this.unit.getID(), unitToAttack.posX, unitToAttack.posY);
            } else if (Math.random() < (double)0.7f) {
                for (BaseManager baseM : JavaBot.bases) {
                    if (baseM.state == BaseManager.BaseState.FRIENDLY || !baseM.baseLocation.isStartLocation() || !(Math.random() < 0.3)) continue;
                    if (BwapiCallsManager.attack(this.unit.getID(), baseM.posX, baseM.posY)) {
                        this.countResetAction = 0;
                        this.countDontAct = 3;
                    }
                    break;
                }
            } else {
                int randX = (int)(Math.random() * ((double)this.bwapi.getMap().getWidth() * 32.0));
                int randY = (int)(Math.random() * ((double)this.bwapi.getMap().getHeight() * 32.0));
                if (BwapiCallsManager.attack(this.unit.getID(), randX, randY)) {
                    this.countResetAction = 0;
                    this.countDontAct = 3;
                }
            }
        }
    }

    @Override
    public void drawDebug() {
    }

    public static enum MICRO_STATES {
        IDLE,
        ATTACKING,
        IN_BURROW,
        BURROWED,
        UN_BURROW;

    }
}

