/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import javabot.JavaBot;
import javabot.knowledge.Tech;
import javabot.managers.BuildingManager;
import javabot.managers.BwapiCallsManager;
import javabot.managers.UnitManager;
import javabot.model.Unit;
import javabot.operators.Operators;
import javabot.types.UpgradeType;

public class SpawningPoolManager
extends BuildingManager {
    public UnitManager.UPGRADE_STATES state = UnitManager.UPGRADE_STATES.NONE;
    public int upgradeToDo = 0;

    public SpawningPoolManager(Unit u) {
        super(u);
        this.countDontAct = 0;
    }

    @Override
    public void update() {
        super.update();
        if (this.upgradeToDo >= 2 || this.unit.getRemainingBuildTimer() > 0 || JavaBot.knowledge.currentBuildings[Operators.iterHive] == 0) {
            return;
        }
        if (this.countDontAct > 0) {
            --this.countDontAct;
        }
        if (this.state == UnitManager.UPGRADE_STATES.NONE && this.unit.getRemainingUpgradeTime() > 0) {
            this.state = UnitManager.UPGRADE_STATES.EVOLVING;
        }
        if (this.state == UnitManager.UPGRADE_STATES.EVOLVING && this.unit.getRemainingUpgradeTime() == 0) {
            this.state = UnitManager.UPGRADE_STATES.NONE;
            if (this.upgradeToDo == 0) {
                Tech.metabolicBoost = 1;
            }
            if (this.upgradeToDo == 1) {
                Tech.adrenalGlands = 2;
            }
            ++this.upgradeToDo;
        }
        if (this.state == UnitManager.UPGRADE_STATES.NONE && this.countDontAct == 0) {
            if (this.upgradeToDo == 0) {
                if (this.upgradeToDo == 0 && Tech.metabolicBoost == 1) {
                    ++this.upgradeToDo;
                    return;
                }
                if (this.upgradeToDo == 1 && Tech.adrenalGlands == 1) {
                    ++this.upgradeToDo;
                    return;
                }
                if (JavaBot.knowledge.realMinerals >= 100 && JavaBot.knowledge.realGas >= 100) {
                    BwapiCallsManager.upgrade(this.unit.getID(), UpgradeType.UpgradeTypes.Metabolic_Boost.ordinal());
                    this.countDontAct = 20;
                }
            } else if (this.upgradeToDo == 1 && JavaBot.knowledge.currentBuildings[Operators.iterHive] > 0 && JavaBot.knowledge.realMinerals >= 200 && JavaBot.knowledge.realGas >= 200) {
                BwapiCallsManager.upgrade(this.unit.getID(), UpgradeType.UpgradeTypes.Adrenal_Glands.ordinal());
                this.countDontAct = 20;
            }
        }
    }

    @Override
    public void drawDebug() {
        if (this.unit.getRemainingUpgradeTime() > 0) {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 8, "Spawning Pool : " + this.unit.getRemainingUpgradeTime(), false);
        } else {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 8, "Spawning Pool", false);
        }
    }
}

