/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import javabot.JavaBot;
import javabot.managers.BwapiCallsManager;
import javabot.managers.ControlTower;
import javabot.managers.EnemyBuildingManager;
import javabot.managers.EnemyUnitManager;
import javabot.managers.UnitManager;
import javabot.model.Unit;
import javabot.operators.Operators;
import javabot.types.UnitType;

public class MutaliskManager
extends UnitManager {
    public boolean occupied = false;
    boolean dodging = false;

    public MutaliskManager(Unit u) {
        super(u);
        this.explore = true;
    }

    @Override
    public void update() {
        super.update();
        this.safeMarge = (120 - this.hp) * 3;
        if (this.unit.isIdle() && this.occupied) {
            this.occupied = false;
        }
        ControlTower.mutalisks.add(this);
        if (JavaBot.knowledge.requestedUnits[Operators.iterGuardians] > 0 && (JavaBot.knowledge.requestedUnits[Operators.iterDevourers] == 0 || JavaBot.strategy.nbGuardiansTotal < JavaBot.strategy.nbDevourersTotal * 3) && JavaBot.knowledge.timerMorphMutalisk == 0 && JavaBot.strategy.nbGuardiansTotal < JavaBot.strategy.idealNbGuardians) {
            if (JavaBot.knowledge.realMinerals >= 50 && JavaBot.knowledge.realGas >= 100) {
                if (BwapiCallsManager.morph(this.unit.getID(), UnitType.UnitTypes.Zerg_Guardian.ordinal())) {
                    JavaBot.knowledge.timerMorphMutalisk = 5;
                    this.countDontAct = 5;
                    JavaBot.repartition.reduceCombatUnits(50, 100);
                }
            } else {
                JavaBot.requestsManager.requestRessources(50, 100);
            }
        }
        if (this.countDontAct == 0 && JavaBot.knowledge.requestedUnits[Operators.iterDevourers] > 0 && JavaBot.knowledge.timerMorphMutalisk == 0 && JavaBot.strategy.nbDevourersTotal < JavaBot.strategy.idealNbDevourers) {
            if (JavaBot.knowledge.realMinerals >= 150 && JavaBot.knowledge.realGas >= 50) {
                if (BwapiCallsManager.morph(this.unit.getID(), UnitType.UnitTypes.Zerg_Devourer.ordinal())) {
                    JavaBot.knowledge.timerMorphMutalisk = 5;
                    this.countDontAct = 5;
                    JavaBot.repartition.reduceCombatUnits(150, 50);
                }
            } else {
                JavaBot.requestsManager.requestRessources(150, 50);
            }
        }
        if (this.unit.isIdle() && this.countDontAct == 0) {
            this.attackRandomMutalisk();
        }
        if (this.countDontAct <= 1) {
            this.dodgeEnemies();
        }
    }

    private void attackRandomMutalisk() {
        if (Math.random() < 0.6 && JavaBot.enemyBuildingsManager.size() > 0) {
            int iterUnit = (int)(Math.random() * (double)JavaBot.enemyBuildingsManager.size());
            if (iterUnit >= JavaBot.enemyBuildingsManager.size()) {
                --iterUnit;
            }
            if (iterUnit < 0) {
                iterUnit = 0;
            }
            EnemyBuildingManager unitToAttack = JavaBot.enemyBuildingsManager.get(iterUnit);
            if (BwapiCallsManager.attack(this.unit.getID(), unitToAttack.posX, unitToAttack.posY)) {
                this.countDontAct = 1;
            }
        } else if (Math.random() < 0.6 && JavaBot.enemyUnitsManager.size() > 0) {
            int iterUnit = (int)(Math.random() * (double)JavaBot.enemyUnitsManager.size());
            if (iterUnit >= JavaBot.enemyUnitsManager.size()) {
                --iterUnit;
            }
            if (iterUnit < 0) {
                iterUnit = 0;
            }
            EnemyUnitManager unitToAttack = JavaBot.enemyUnitsManager.get(iterUnit);
            if (BwapiCallsManager.attack(this.unit.getID(), unitToAttack.posX, unitToAttack.posY)) {
                this.countDontAct = 1;
            }
        } else if (Math.random() < 0.6 && ControlTower.posX != -1 && Operators.distance(this.posX, this.posY, ControlTower.posX, ControlTower.posY) > ControlTower.radius + 100) {
            if (BwapiCallsManager.attack(this.unit.getID(), ControlTower.posX + (int)(Math.random() * 100.0) - 50, ControlTower.posY + (int)(Math.random() * 100.0) - 50)) {
                this.countDontAct = 1;
            }
        } else {
            int randX = (int)(Math.random() * ((double)this.bwapi.getMap().getWidth() * 32.0));
            int randY = (int)(Math.random() * ((double)this.bwapi.getMap().getHeight() * 32.0));
            if (BwapiCallsManager.attack(this.unit.getID(), randX, randY)) {
                this.countDontAct = 1;
            }
        }
    }

    public void dodgeEnemies() {
        int posYtoGo;
        int posXtoGo;
        int dy;
        int dx;
        for (EnemyUnitManager enemyUnitManager : JavaBot.enemyUnitsAirManager) {
            if (Operators.distance(this.posX, this.posY, enemyUnitManager.posX, enemyUnitManager.posY) >= enemyUnitManager.range + 2 * this.safeMarge - 300) continue;
            dx = this.posX - enemyUnitManager.posX;
            dy = this.posY - enemyUnitManager.posY;
            if (dx > 110) {
                dx = 110;
            }
            if (dx < -110) {
                dx = -110;
            }
            if (dy > 110) {
                dy = 110;
            }
            if (dy < -110) {
                dy = -110;
            }
            posXtoGo = this.posX + dx;
            posYtoGo = this.posY + dy;
            if (!BwapiCallsManager.move(this.unit.getID(), posXtoGo, posYtoGo)) break;
            this.countDontAct = 8;
            break;
        }
        if (this.countDontAct == 0) {
            for (EnemyBuildingManager enemyBuildingManager : JavaBot.enemyBuildingsAirManager) {
                if (Operators.distance(this.posX, this.posY, enemyBuildingManager.posX, enemyBuildingManager.posY) >= enemyBuildingManager.range + this.safeMarge) continue;
                dx = this.posX - enemyBuildingManager.posX;
                dy = this.posY - enemyBuildingManager.posY;
                if (dx > 70) {
                    dx = 70;
                }
                if (dx < -70) {
                    dx = -70;
                }
                if (dy > 70) {
                    dy = 70;
                }
                if (dy < -70) {
                    dy = -70;
                }
                posXtoGo = this.posX + dx;
                posYtoGo = this.posY + dy;
                if (!BwapiCallsManager.move(this.unit.getID(), posXtoGo, posYtoGo)) break;
                this.countDontAct = 8;
                break;
            }
        }
    }

    @Override
    public void drawDebug() {
        if (this.unit.isMoving()) {
            this.bwapi.drawLine(this.posX, this.posY, this.unit.getTargetX(), this.unit.getTargetY(), 117, false);
        }
    }
}

