/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import javabot.JavaBot;
import javabot.managers.BwapiCallsManager;
import javabot.managers.ControlTower;
import javabot.managers.EnemyBuildingManager;
import javabot.managers.EnemyUnitManager;
import javabot.managers.UnitManager;
import javabot.model.Unit;
import javabot.operators.Operators;

public class GuardianManager
extends UnitManager {
    public int timeRecharge = 0;
    public boolean occupied = false;
    public boolean explore = false;
    public int locationRadius = 423;
    public int dodgeRadius = 295;
    public int timerIdle = 0;
    Guardian_STATES state = Guardian_STATES.IDLE;

    public GuardianManager(Unit u) {
        super(u);
    }

    @Override
    public void update() {
        super.update();
        this.safeMarge = (150 - this.hp) / 2;
        ControlTower.guardians.add(this);
        this.timeRecharge = this.unit.getGroundWeaponCooldown();
        this.timerIdle = this.unit.isIdle() ? ++this.timerIdle : 0;
        if (this.timerIdle >= 8) {
            this.timerIdle = 0;
            if (Math.random() < 0.4 && ControlTower.posX != -1 && Operators.distance(this.posX, this.posY, ControlTower.posX, ControlTower.posY) > ControlTower.radius) {
                BwapiCallsManager.attack(this.unit.getID(), ControlTower.posX, ControlTower.posY);
            } else if (Math.random() < 0.6 && JavaBot.enemyUnitsGroundManager.size() > 0) {
                int iterUnit = (int)(Math.random() * (double)JavaBot.enemyUnitsGroundManager.size());
                if (iterUnit < 0) {
                    iterUnit = 0;
                }
                if (iterUnit >= JavaBot.enemyUnitsGroundManager.size()) {
                    --iterUnit;
                }
                EnemyUnitManager unitToAttack = JavaBot.enemyUnitsGroundManager.get(iterUnit);
                BwapiCallsManager.attack(this.unit.getID(), unitToAttack.posX, unitToAttack.posY);
            } else if (Math.random() < 0.95 && JavaBot.enemyBuildingsManager.size() > 0) {
                int iterBuilding = (int)(Math.random() * (double)JavaBot.enemyBuildingsManager.size());
                if (iterBuilding < 0) {
                    iterBuilding = 0;
                }
                if (iterBuilding >= JavaBot.enemyBuildingsManager.size()) {
                    --iterBuilding;
                }
                EnemyBuildingManager buildingToAttack = JavaBot.enemyBuildingsManager.get(iterBuilding);
                BwapiCallsManager.attack(this.unit.getID(), buildingToAttack.posX, buildingToAttack.posY);
            } else {
                int randX = (int)(Math.random() * ((double)this.bwapi.getMap().getWidth() * 32.0));
                int randY = (int)(Math.random() * ((double)this.bwapi.getMap().getHeight() * 32.0));
                BwapiCallsManager.attack(this.unit.getID(), randX, randY);
            }
        }
        if (this.countDontAct == 0) {
            this.dodgeEnemies();
        }
    }

    private void dodgeEnemies() {
        int posYtoGo;
        int posXtoGo;
        int dy;
        int dx;
        for (EnemyUnitManager enemyUnitManager : JavaBot.enemyUnitsAirManager) {
            if (!enemyUnitManager.isAir && this.timeRecharge == 0 || Operators.distance(this.posX, this.posY, enemyUnitManager.posX, enemyUnitManager.posY) >= enemyUnitManager.range + this.safeMarge) continue;
            dx = this.posX - enemyUnitManager.posX;
            dy = this.posY - enemyUnitManager.posY;
            if (dx > 50) {
                dx = 50;
            }
            if (dx < -50) {
                dx = -50;
            }
            if (dy > 50) {
                dy = 50;
            }
            if (dy < -50) {
                dy = -50;
            }
            posXtoGo = this.posX + dx;
            posYtoGo = this.posY + dy;
            if (!BwapiCallsManager.move(this.unit.getID(), posXtoGo, posYtoGo)) break;
            this.countDontAct = 8;
            break;
        }
        if (this.countDontAct == 0) {
            for (EnemyBuildingManager enemyBuildingManager : JavaBot.enemyBuildingsAirManager) {
                if (Operators.distance(this.posX, this.posY, enemyBuildingManager.posX, enemyBuildingManager.posY) >= enemyBuildingManager.range + this.safeMarge) continue;
                dx = this.posX - enemyBuildingManager.posX;
                dy = this.posY - enemyBuildingManager.posY;
                if (dx > 50) {
                    dx = 50;
                }
                if (dx < -50) {
                    dx = -50;
                }
                if (dy > 50) {
                    dy = 50;
                }
                if (dy < -50) {
                    dy = -50;
                }
                posXtoGo = this.posX + dx;
                posYtoGo = this.posY + dy;
                if (!BwapiCallsManager.move(this.unit.getID(), posXtoGo, posYtoGo)) break;
                this.countDontAct = 8;
                break;
            }
        }
    }

    @Override
    public void drawDebug() {
    }

    public static enum Guardian_STATES {
        IDLE,
        ATTACK,
        STOP,
        RETREAT;

    }
}

