/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import javabot.JavaBot;
import javabot.knowledge.Tech;
import javabot.managers.BuildingManager;
import javabot.managers.BwapiCallsManager;
import javabot.model.Unit;
import javabot.operators.Operators;
import javabot.types.UpgradeType;

public class EvoChamberManager
extends BuildingManager {
    public int nbLair = 0;
    public int nbHive = 0;
    public int upgradeTime = 0;
    public int carapaceLvl = 0;
    public int attackLvl = 0;
    public int missileLvl = 0;
    public UPGRADE_STATE state = UPGRADE_STATE.NONE;

    public EvoChamberManager(Unit u) {
        super(u);
    }

    @Override
    public void update() {
        super.update();
        if (this.state == UPGRADE_STATE.FINISHED || this.unit.getRemainingBuildTimer() > 0) {
            return;
        }
        this.upgradeTime = this.unit.getRemainingUpgradeTime();
        this.nbLair = JavaBot.knowledge.currentBuildings[Operators.iterLair];
        this.nbHive = JavaBot.knowledge.currentBuildings[Operators.iterHive];
        switch (this.state) {
            case NONE: {
                this.updateNone();
                break;
            }
            case TRY_CRAPACE: {
                this.updateTryCarapace();
                break;
            }
            case EVOLVING_CRAPACE: {
                this.updateEvolveCarapace();
                break;
            }
            case TRY_MISSILE: {
                this.updateTryMissile();
                break;
            }
            case EVOLVING_MISSILE: {
                this.updateEvolveMissile();
                break;
            }
            case TRY_ATTACK: {
                this.updateTryAttack();
                break;
            }
            case EVOLVING_ATTACK: {
                this.updateEvolveAttack();
                break;
            }
        }
    }

    private void updateEvolveCarapace() {
        Tech.blockGroundDefenseUpgrade = 5;
        if (this.upgradeTime == 0) {
            this.state = UPGRADE_STATE.NONE;
            ++Tech.groundDefenseLvl;
            Tech.blockGroundDefenseUpgrade = 0;
        }
    }

    private void updateTryCarapace() {
        int requiredMinerals = 0;
        int requiredGas = 0;
        if (this.upgradeTime > 0) {
            this.state = UPGRADE_STATE.EVOLVING_CRAPACE;
            return;
        }
        switch (Tech.groundDefenseLvl) {
            case 0: {
                requiredMinerals = 150;
                requiredGas = 150;
                break;
            }
            case 1: {
                requiredMinerals = 225;
                requiredGas = 225;
                break;
            }
            case 2: {
                requiredMinerals = 300;
                requiredGas = 300;
                break;
            }
            case 3: {
                this.state = UPGRADE_STATE.TRY_MISSILE;
                return;
            }
        }
        if (JavaBot.knowledge.realMinerals >= requiredMinerals && JavaBot.knowledge.realGas >= requiredGas) {
            BwapiCallsManager.upgrade(this.unit.getID(), UpgradeType.UpgradeTypes.Zerg_Carapace.ordinal());
        }
    }

    private void updateEvolveMissile() {
        Tech.blockGroundMissileUpgrade = 5;
        if (this.upgradeTime == 0) {
            this.state = UPGRADE_STATE.NONE;
            ++Tech.groundMissileLvl;
            Tech.blockGroundMissileUpgrade = 0;
        }
    }

    private void updateTryMissile() {
        int requiredMinerals = 0;
        int requiredGas = 0;
        if (this.upgradeTime > 0) {
            this.state = UPGRADE_STATE.EVOLVING_MISSILE;
            return;
        }
        switch (Tech.groundMissileLvl) {
            case 0: {
                requiredMinerals = 100;
                requiredGas = 100;
                break;
            }
            case 1: {
                requiredMinerals = 150;
                requiredGas = 150;
                break;
            }
            case 2: {
                requiredMinerals = 200;
                requiredGas = 200;
                break;
            }
            case 3: {
                this.state = UPGRADE_STATE.TRY_ATTACK;
                return;
            }
        }
        if (JavaBot.knowledge.realMinerals >= requiredMinerals && JavaBot.knowledge.realGas >= requiredGas) {
            BwapiCallsManager.upgrade(this.unit.getID(), UpgradeType.UpgradeTypes.Zerg_Missile_Attacks.ordinal());
        }
    }

    private void updateEvolveAttack() {
        Tech.blockGroundAttackUpgrade = 5;
        if (this.upgradeTime == 0) {
            this.state = UPGRADE_STATE.NONE;
            ++Tech.groundAttackLvl;
            Tech.blockGroundAttackUpgrade = 0;
        }
    }

    private void updateTryAttack() {
        int requiredMinerals = 0;
        int requiredGas = 0;
        if (this.upgradeTime > 0) {
            this.state = UPGRADE_STATE.EVOLVING_ATTACK;
            return;
        }
        switch (Tech.groundAttackLvl) {
            case 0: {
                requiredMinerals = 100;
                requiredGas = 100;
                break;
            }
            case 1: {
                requiredMinerals = 150;
                requiredGas = 150;
                break;
            }
            case 2: {
                requiredMinerals = 200;
                requiredGas = 200;
                break;
            }
            case 3: {
                this.state = UPGRADE_STATE.FINISHED;
                return;
            }
        }
        if (JavaBot.knowledge.realMinerals >= requiredMinerals && JavaBot.knowledge.realGas >= requiredGas) {
            BwapiCallsManager.upgrade(this.unit.getID(), UpgradeType.UpgradeTypes.Zerg_Melee_Attacks.ordinal());
        }
    }

    private void updateNone() {
        this.carapaceLvl = Tech.groundDefenseLvl;
        this.attackLvl = Tech.groundAttackLvl;
        this.missileLvl = Tech.groundMissileLvl;
        if (this.carapaceLvl == 0 && Tech.blockGroundDefenseUpgrade == 0) {
            this.state = UPGRADE_STATE.TRY_CRAPACE;
        } else if (this.missileLvl == 0 && Tech.blockGroundMissileUpgrade == 0) {
            this.state = UPGRADE_STATE.TRY_MISSILE;
        } else if (this.attackLvl == 0 && Tech.blockGroundAttackUpgrade == 0) {
            this.state = UPGRADE_STATE.TRY_ATTACK;
        } else if (this.carapaceLvl == 1 && Tech.blockGroundDefenseUpgrade == 0 && this.nbLair + this.nbHive >= 1) {
            this.state = UPGRADE_STATE.TRY_CRAPACE;
        } else if (this.missileLvl == 1 && Tech.blockGroundMissileUpgrade == 0 && this.nbLair + this.nbHive >= 1) {
            this.state = UPGRADE_STATE.TRY_MISSILE;
        } else if (this.attackLvl == 1 && Tech.blockGroundAttackUpgrade == 0 && this.nbLair + this.nbHive >= 1) {
            this.state = UPGRADE_STATE.TRY_ATTACK;
        } else if (this.carapaceLvl == 2 && Tech.blockGroundDefenseUpgrade == 0 && this.nbHive >= 1) {
            this.state = UPGRADE_STATE.TRY_CRAPACE;
        } else if (this.missileLvl == 2 && Tech.blockGroundMissileUpgrade == 0 && this.nbHive >= 1) {
            this.state = UPGRADE_STATE.TRY_MISSILE;
        } else if (this.attackLvl == 2 && Tech.blockGroundAttackUpgrade == 0 && this.nbHive >= 1) {
            this.state = UPGRADE_STATE.TRY_ATTACK;
        }
    }

    @Override
    public void drawDebug() {
        this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 8, "Evo Chamber " + (Object)((Object)this.state) + " " + this.unit.getRemainingUpgradeTime() + " " + this.unit.getRemainingResearchTime(), false);
    }

    public static enum UPGRADE_STATE {
        NONE,
        EVOLVING_ATTACK,
        EVOLVING_CRAPACE,
        EVOLVING_MISSILE,
        TRY_ATTACK,
        TRY_CRAPACE,
        TRY_MISSILE,
        FINISHED;

    }
}

