/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import javabot.JNIBWAPI;
import javabot.JavaBot;
import javabot.managers.UnitManager;
import javabot.model.Unit;
import javabot.operators.Operators;

public class EnemyUnitManager {
    public Unit unit;
    public int posX;
    public int posY;
    public int typeID;
    JNIBWAPI bwapi;
    public boolean inRangeDetector;
    public boolean killed;
    public boolean isDangerousAir = false;
    public boolean isDangerousGround = false;
    public int isBroodlinged = 0;
    public int range;
    public int broodlingLevel;
    boolean dead;
    public boolean isAir;
    public boolean isDetector;
    public UnitManager killer;
    public int valZ;
    public int valH;
    public int valQ;
    public int valM;
    public int valG;
    public int valD;

    public EnemyUnitManager(Unit u) {
        this.unit = u;
        this.typeID = u.getTypeID();
        this.bwapi = JavaBot.bwapi;
        this.posX = this.unit.getX();
        this.posY = this.unit.getY();
        this.inRangeDetector = false;
        this.killed = false;
        this.isBroodlinged = 0;
        this.range = 0;
        this.broodlingLevel = Operators.broodlingLevel(this.typeID);
        this.isDangerousAir = Operators.isDangerousAir(this.typeID);
        this.isDangerousGround = Operators.isDangerousGround(this.typeID);
        this.isDetector = Operators.isDetector(this.typeID);
        this.range = Operators.getRange(this.typeID);
        this.isAir = Operators.isAir(this.typeID);
        this.dead = false;
        this.killer = null;
        JavaBot.armyComposition.setAdaptComposition(this);
    }

    public void update() {
        if (JavaBot.newAdapt) {
            JavaBot.armyComposition.add(this.valZ, this.valH, this.valQ, this.valM, this.valG, this.valD, 0, 0, 0, 0);
        }
        this.typeID = this.unit.getTypeID();
        this.posX = this.unit.getX();
        this.posY = this.unit.getY();
        if (this.isAir) {
            JavaBot.enemyUnitsAirTargetManager.add(this);
        } else {
            JavaBot.enemyUnitsGroundTargetManager.add(this);
        }
        if (this.isDangerousAir) {
            JavaBot.enemyUnitsAirManager.add(this);
        }
        if (this.isDangerousGround) {
            JavaBot.enemyUnitsGroundManager.add(this);
        }
        if (this.isDetector) {
            JavaBot.enemyUnitsDetectorManager.add(this);
        }
        if (this.broodlingLevel > 0) {
            JavaBot.enemyUnitsBroodlingManager.add(this);
        }
        if (this.isBroodlinged > 0) {
            --this.isBroodlinged;
        }
        if (!this.unit.isExists() || !this.bwapi.isVisible(this.unit.getTileX(), this.unit.getTileY())) {
            this.dead = true;
            JavaBot.enemyUnitsManagerMap.remove(this.unit.getID());
        }
        if (!this.dead) {
            JavaBot.enemyUnitsManagerExisting.add(this);
        }
    }

    public void drawDebug() {
        this.bwapi.drawCircle(this.posX, this.posY, 2, 135, true, false);
        this.bwapi.drawCircle(this.posX, this.posY, this.range, 111, false, false);
    }
}

