/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import javabot.JNIBWAPI;
import javabot.JavaBot;
import javabot.knowledge.TileGraph;
import javabot.managers.BaseManager;
import javabot.model.Unit;
import javabot.operators.Operators;
import javabot.types.UnitType;

public class EnemyBuildingManager {
    public Unit unit;
    public int posX;
    public int posY;
    public int typeID;
    JNIBWAPI bwapi;
    int range;
    boolean dead;
    BaseManager base;
    public int timerDestroy;
    public boolean isDangerousAir = false;
    public boolean isDangerousGround = false;
    public boolean isDetector = false;
    public boolean destroy = false;
    public int timerDestroyCreep;

    public EnemyBuildingManager(Unit u) {
        this.unit = u;
        this.typeID = u.getTypeID();
        this.timerDestroyCreep = 0;
        if (this.typeID == UnitType.UnitTypes.Zerg_Creep_Colony.ordinal()) {
            this.destroy = true;
            this.timerDestroyCreep = 1000;
        }
        this.bwapi = JavaBot.bwapi;
        this.posX = this.unit.getX();
        this.posY = this.unit.getY();
        this.dead = false;
        this.timerDestroy = 20;
        this.isDangerousAir = Operators.isDangerousAir(this.typeID);
        this.isDangerousGround = Operators.isDangerousGround(this.typeID);
        this.isDetector = Operators.isDetector(this.typeID);
        this.range = Operators.getRange(this.typeID);
        int distMax = Integer.MAX_VALUE;
        BaseManager bestBase = null;
        for (BaseManager manager : JavaBot.bases) {
            int dist = (manager.posX - this.posX) * (manager.posX - this.posX) + (manager.posY - this.posY) * (manager.posY - this.posY);
            if (dist >= distMax) continue;
            distMax = dist;
            bestBase = manager;
        }
        this.base = bestBase;
    }

    public void update() {
        this.posX = this.unit.getX();
        this.posY = this.unit.getY();
        --this.timerDestroyCreep;
        if (this.timerDestroy <= 0) {
            this.dead = true;
        }
        if (this.unit.isLifted()) {
            JavaBot.enemyBuildingsAirTargetManager.add(this);
        }
        if (this.isDangerousAir) {
            JavaBot.enemyBuildingsAirManager.add(this);
        }
        if (this.isDangerousGround) {
            JavaBot.enemyBuildingsGroundManager.add(this);
        }
        if (this.isDetector) {
            JavaBot.enemyBuildingsDetectorManager.add(this);
        }
        if (this.bwapi.isVisible(this.posX / 32, this.posY / 32) && this.bwapi.isVisible(1 + this.posX / 32, this.posY / 32) && this.bwapi.isVisible(this.posX / 32, 1 + this.posY / 32) && this.bwapi.isVisible(1 + this.posX / 32, 1 + this.posY / 32)) {
            --this.timerDestroy;
            if (this.timerDestroy <= 0) {
                this.dead = true;
            }
        }
        if (!this.dead) {
            JavaBot.enemyBuildingsManagerExisting.add(this);
        }
    }

    public void fillGraph() {
        TileGraph.fillBuilding(this.unit);
    }

    public void drawDebug() {
        if (this.isDangerousAir) {
            this.bwapi.drawCircle(this.unit.getX(), this.unit.getY(), 3, 111, true, false);
        }
        this.bwapi.drawCircle(this.unit.getX(), this.unit.getY(), this.range, 111, false, false);
    }
}

