/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import javabot.JavaBot;
import javabot.knowledge.TileGraph;
import javabot.managers.BaseManager;
import javabot.managers.UnitManager;
import javabot.model.Unit;
import javabot.operators.Operators;

public class BuildingManager
extends UnitManager {
    public BuildingManager(Unit u) {
        super(u);
        int distMax = 999999;
        BaseManager bestBase = null;
        for (BaseManager manager : JavaBot.bases) {
            int dist = (manager.posX - this.posX) * (manager.posX - this.posX) + (manager.posY - this.posY) * (manager.posY - this.posY);
            if (dist >= distMax) continue;
            distMax = dist;
            bestBase = manager;
        }
        this.base = bestBase;
        this.isABuilding = true;
    }

    @Override
    public void update() {
        super.update();
        TileGraph.fillBuilding(this.unit);
        if (this.base != null) {
            if (!this.dead && !this.base.buildings.contains(this.unit)) {
                this.base.buildings.add(this.unit);
            }
        } else {
            int distMax = 999999;
            BaseManager bestBase = null;
            for (BaseManager manager : JavaBot.bases) {
                int dist = (manager.posX - this.posX) * (manager.posX - this.posX) + (manager.posY - this.posY) * (manager.posY - this.posY);
                if (dist >= distMax) continue;
                distMax = dist;
                bestBase = manager;
            }
            this.base = bestBase;
        }
        if (!this.dead) {
            JavaBot.buildingsExisting.add(this);
        }
    }

    @Override
    public void drawDebug() {
        if (this.unit.isConstructing()) {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 8, "BUILDING " + Operators.stringFromType(this.typeID), false);
        } else {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 8, "BUILDING " + Operators.stringFromType(this.typeID), false);
        }
    }
}

